/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.factory;

import java.util.function.Function;
import java.util.stream.Stream;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.factory.impl.BindableDiagramFactory;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.kie.workbench.common.stunner.core.util.UUID;

public abstract class AbstractDMNDiagramFactory<M extends Metadata, D extends Diagram<Graph, M>>
extends BindableDiagramFactory<M, D> {
    private static final Class<DMNDiagram> DIAGRAM_TYPE = DMNDiagram.class;
    private Function<Graph, Node<Definition<DMNDiagram>, ?>> diagramProvider = graph -> GraphUtils.getFirstNode((Graph)graph, DIAGRAM_TYPE);

    protected abstract D doBuild(String var1, M var2, Graph<DefinitionSet, ?> var3);

    public D build(String name, M metadata, Graph<DefinitionSet, ?> graph) {
        D diagram = this.doBuild(name, metadata, graph);
        Node<Definition<DMNDiagram>, ?> diagramNode = this.diagramProvider.apply(graph);
        if (null == diagramNode) {
            throw new IllegalStateException("A DMNDiagram is expected to be present on DMN Diagram graphs.");
        }
        this.updateProperties(diagramNode, metadata);
        this.updateDefaultNameSpaces(diagramNode);
        this.updateName(diagramNode, name);
        return diagram;
    }

    private void updateProperties(Node<Definition<DMNDiagram>, ?> diagramNode, M metadata) {
        metadata.setCanvasRootUUID(diagramNode.getUUID());
    }

    private void updateDefaultNameSpaces(Node<Definition<DMNDiagram>, ?> diagramNode) {
        DMNDiagram dmnDiagram = (DMNDiagram)((Definition)diagramNode.getContent()).getDefinition();
        Definitions dmnDefinitions = dmnDiagram.getDefinitions();
        Stream.of(DMNModelInstrumentedBase.Namespace.values()).filter(namespace -> !dmnDefinitions.getNsContext().containsValue(namespace.getUri())).forEach(namespace -> {
            if (!namespace.getPrefix().equalsIgnoreCase(DMNModelInstrumentedBase.Namespace.DEFAULT.getPrefix())) {
                dmnDefinitions.getNsContext().put(namespace.getPrefix(), namespace.getUri());
            }
        });
        String defaultNamespace = !StringUtils.isEmpty((String)dmnDefinitions.getNamespace().getValue()) ? dmnDefinitions.getNamespace().getValue() : DMNModelInstrumentedBase.Namespace.DEFAULT.getUri() + UUID.uuid();
        dmnDefinitions.setNamespace(new Text(defaultNamespace));
        dmnDefinitions.getNsContext().putIfAbsent(DMNModelInstrumentedBase.Namespace.DEFAULT.getPrefix(), defaultNamespace);
    }

    private void updateName(Node<Definition<DMNDiagram>, ?> diagramNode, String name) {
        DMNDiagram dmnDiagram = (DMNDiagram)((Definition)diagramNode.getContent()).getDefinition();
        Definitions dmnDefinitions = dmnDiagram.getDefinitions();
        Name dmnName = dmnDefinitions.getName();
        if (StringUtils.isEmpty((String)dmnName.getValue())) {
            dmnName.setValue(name);
        }
    }
}

