/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.rules;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;
import org.kie.workbench.common.stunner.core.graph.impl.GraphImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStore;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStoreImpl;
import org.kie.workbench.common.stunner.core.rule.Rule;
import org.kie.workbench.common.stunner.core.rule.RuleEvaluationContext;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.context.GraphConnectionContext;
import org.kie.workbench.common.stunner.core.rule.context.impl.StatelessGraphEvaluationState;
import org.kie.workbench.common.stunner.core.rule.ext.RuleExtension;
import org.kie.workbench.common.stunner.core.rule.ext.RuleExtensionHandler;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class BaseGraphRuleTest<T extends RuleExtensionHandler> {
    @Mock
    protected RuleExtension rule;
    @Mock
    protected GraphConnectionContext context;
    @Mock
    protected EdgeImpl connector;
    @Mock
    protected ViewConnector connectorView;
    @Mock
    private TreeWalkTraverseProcessor walker;
    protected GraphImpl graph = new GraphImpl("uuid", (GraphNodeStore)new GraphNodeStoreImpl());
    protected T check;

    @Before
    public void setup() {
        this.check = (RuleExtensionHandler)Mockito.spy(this.getRule());
        StatelessGraphEvaluationState evaluationState = new StatelessGraphEvaluationState((Graph)this.graph);
        Mockito.when((Object)this.context.getState()).thenReturn((Object)evaluationState);
        Mockito.when((Object)this.context.getConnector()).thenReturn((Object)this.connector);
        Mockito.when((Object)this.connector.getContent()).thenReturn((Object)this.connectorView);
        Mockito.when((Object)this.connectorView.getDefinition()).thenReturn((Object)new Definition());
    }

    protected abstract T getRule();

    protected abstract Class getExpectedExtensionType();

    protected abstract Class getExpectedContextType();

    @Test
    public void assertExtensionType() {
        Assert.assertEquals((Object)this.getExpectedExtensionType(), (Object)this.check.getExtensionType());
    }

    @Test
    public void assertContextType() {
        Assert.assertEquals((Object)this.getExpectedContextType(), (Object)this.check.getContextType());
    }

    @Test
    public void checkRuleAcceptsAnnotatedConnectorType() {
        Mockito.when((Object)this.rule.getTypeArguments()).thenReturn((Object)new Class[]{Definition.class});
        Assert.assertTrue((boolean)this.check.accepts((Rule)this.rule, (RuleEvaluationContext)this.context));
    }

    @Test
    public void checkRuleDoesNotAcceptDifferentAnnotatedConnectorType() {
        Mockito.when((Object)this.rule.getTypeArguments()).thenReturn((Object)new Class[]{String.class});
        Assert.assertFalse((boolean)this.check.accepts((Rule)this.rule, (RuleEvaluationContext)this.context));
    }

    @Test
    public void checkNoViolationsWhenNoExistingConnections() {
        NodeImpl node1 = new NodeImpl("node1");
        NodeImpl node2 = new NodeImpl("node2");
        this.graph.addNode((Node)node1);
        this.graph.addNode((Node)node2);
        Mockito.when((Object)this.context.getSource()).thenReturn(Optional.of(node1));
        Mockito.when((Object)this.context.getTarget()).thenReturn(Optional.of(node2));
        Mockito.when((Object)this.context.getConnector()).thenReturn((Object)this.connector);
        RuleViolations result = this.check.evaluate((Rule)this.rule, (RuleEvaluationContext)this.context);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.violations().iterator().hasNext());
    }

    protected static class Definition {
        protected Definition() {
        }
    }
}

