/*
* Copyright 2016 Red Hat, Inc. and/or its affiliates.
*  
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*  
*    http://www.apache.org/licenses/LICENSE-2.0
*  
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package org.kie.workbench.common.dmn.api.definition.adapter.binding;

import javax.annotation.Generated;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import javax.inject.Inject;

import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableDefinitionSetAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableDefinitionSetAdapterImpl;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.DefinitionSetAdapterBindings;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionSetAdapterWrapper;
import org.kie.workbench.common.stunner.core.i18n.StunnerTranslationService;

@Generated("org.kie.workbench.common.stunner.core.processors.definitionset.BindableDefinitionSetAdapterGenerator")
@ApplicationScoped
public class DMNDefinitionSetDefinitionSetAdapterImpl extends DefinitionSetAdapterWrapper<Object, BindableDefinitionSetAdapter<Object>> {

    @Inject
    public DMNDefinitionSetDefinitionSetAdapterImpl(StunnerTranslationService translationService) {
        super(BindableDefinitionSetAdapterImpl.create(translationService));
    }

    @PostConstruct
    public void init() {
        adapter.setBindings(org.kie.workbench.common.dmn.api.DMNDefinitionSet.class, new DefinitionSetAdapterBindings() .setGraphFactory(org.kie.workbench.common.dmn.api.factory.DMNGraphFactory.class).setDefinitionIds(new HashSet<>(Arrays.asList("org.kie.workbench.common.dmn.api.definition.model.DMNDiagram","org.kie.workbench.common.dmn.api.definition.model.InputData","org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource","org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel","org.kie.workbench.common.dmn.api.definition.model.Decision","org.kie.workbench.common.dmn.api.definition.model.TextAnnotation","org.kie.workbench.common.dmn.api.definition.model.Association","org.kie.workbench.common.dmn.api.definition.model.InformationRequirement","org.kie.workbench.common.dmn.api.definition.model.KnowledgeRequirement","org.kie.workbench.common.dmn.api.definition.model.AuthorityRequirement","org.kie.workbench.common.dmn.api.definition.model.LiteralExpression","org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocument","org.kie.workbench.common.dmn.api.definition.model.LiteralExpressionPMMLDocumentModel","org.kie.workbench.common.dmn.api.definition.model.ImportedValues","org.kie.workbench.common.dmn.api.definition.model.UnaryTests","org.kie.workbench.common.dmn.api.definition.model.InformationItem","org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary","org.kie.workbench.common.dmn.api.definition.model.InputClause","org.kie.workbench.common.dmn.api.definition.model.OutputClause","org.kie.workbench.common.dmn.api.definition.NOPDomainObject","org.kie.workbench.common.dmn.api.definition.model.DecisionService"))).setQualifier(new org.kie.workbench.common.dmn.api.qualifiers.DMNEditor() {
                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return org.kie.workbench.common.dmn.api.qualifiers.DMNEditor.class;
                }}));
    }

}
