/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.model.OutputClauseLiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;

public class OutputClauseLiteralExpressionTest {
    private static final String TEXT = "TEXT";
    private static final String CLAUSE_ID = "CLAUSE-ID";
    private static final String DESCRIPTION = "DESCRIPTION";
    private OutputClauseLiteralExpression outputClauseLiteralExpression;

    @Before
    public void setup() {
        this.outputClauseLiteralExpression = new OutputClauseLiteralExpression();
    }

    @Test
    public void testGetHasTypeRefs() {
        List actualHasTypeRefs = this.outputClauseLiteralExpression.getHasTypeRefs();
        List<OutputClauseLiteralExpression> expectedHasTypeRefs = Collections.singletonList(this.outputClauseLiteralExpression);
        Assert.assertEquals(expectedHasTypeRefs, (Object)actualHasTypeRefs);
    }

    @Test
    public void testCopy() {
        OutputClauseLiteralExpression source = new OutputClauseLiteralExpression(new Id(CLAUSE_ID), new Description(DESCRIPTION), BuiltInType.BOOLEAN.asQName(), new Text(TEXT), null);
        OutputClauseLiteralExpression target = source.copy();
        Assert.assertNotNull((Object)target);
        Assert.assertNotEquals((Object)CLAUSE_ID, (Object)target.getId());
        Assert.assertEquals((Object)DESCRIPTION, (Object)target.getDescription().getValue());
        Assert.assertEquals((Object)BuiltInType.BOOLEAN.asQName(), (Object)target.getTypeRef());
        Assert.assertEquals((Object)TEXT, (Object)target.getText().getValue());
        Assert.assertNull((Object)target.getImportedValues());
    }
}

