/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.TextAnnotation;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.forms.adf.definitions.DynamicReadOnly;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.powermock.api.mockito.PowerMockito;

@RunWith(value=MockitoJUnitRunner.class)
public class TextAnnotationTest {
    private TextAnnotation textAnnotation;
    private static final String[] READONLY_FIELDS = new String[]{"Description", "Text", "TextFormat"};

    @Before
    public void setup() {
        this.textAnnotation = (TextAnnotation)Mockito.spy((Object)new TextAnnotation());
    }

    @Test
    public void testGetReadOnlyNotSet() {
        this.textAnnotation.setAllowOnlyVisualChange(false);
        this.checkIfItIsNotSet("something");
    }

    @Test
    public void testGetReadOnlyWithReadOnlyValuesAndAllowOnlyVisualChangesNotSet() {
        this.textAnnotation.setAllowOnlyVisualChange(false);
        for (String readonlyField : READONLY_FIELDS) {
            this.checkIfItIsNotSet(readonlyField);
        }
    }

    private void checkIfItIsNotSet(String property) {
        DynamicReadOnly.ReadOnly actual = this.textAnnotation.getReadOnly(property);
        Assert.assertEquals((Object)DynamicReadOnly.ReadOnly.NOT_SET, (Object)actual);
    }

    @Test
    public void testGetReadOnlyWithReadOnlyValues() {
        this.textAnnotation.setAllowOnlyVisualChange(true);
        for (String readonlyField : READONLY_FIELDS) {
            this.checkIfIsReadOnly(readonlyField);
        }
    }

    private void checkIfIsReadOnly(String property) {
        DynamicReadOnly.ReadOnly actual = this.textAnnotation.getReadOnly(property);
        Assert.assertEquals((Object)DynamicReadOnly.ReadOnly.TRUE, (Object)actual);
    }

    @Test
    public void testGetReadOnlyWithNotReadOnlyValues() {
        this.textAnnotation.setAllowOnlyVisualChange(true);
        this.checkIfItIsNotReadOnly("Font");
        this.checkIfItIsNotReadOnly("Something");
    }

    @Test
    public void testGetContentDefinitionId() {
        String contentDefinitionId = "the id";
        Id id = (Id)PowerMockito.mock(Id.class);
        ((TextAnnotation)Mockito.doReturn((Object)id).when((Object)this.textAnnotation)).getId();
        Mockito.when((Object)id.getValue()).thenReturn((Object)"the id");
        String currentId = this.textAnnotation.getContentDefinitionId();
        Assert.assertEquals((Object)"the id", (Object)currentId);
    }

    private void checkIfItIsNotReadOnly(String property) {
        DynamicReadOnly.ReadOnly actual = this.textAnnotation.getReadOnly(property);
        Assert.assertEquals((Object)DynamicReadOnly.ReadOnly.FALSE, (Object)actual);
    }
}

