/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.rules;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.rules.BaseGraphRuleTest;
import org.kie.workbench.common.dmn.api.rules.SingleConnectorPerTypeGraphRule;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.context.GraphConnectionContext;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class SingleConnectorPerTypeGraphRuleTest
extends BaseGraphRuleTest<SingleConnectorPerTypeGraphRule> {
    @Override
    protected SingleConnectorPerTypeGraphRule getRule() {
        return new SingleConnectorPerTypeGraphRule();
    }

    @Override
    protected Class getExpectedExtensionType() {
        return SingleConnectorPerTypeGraphRule.class;
    }

    @Override
    protected Class getExpectedContextType() {
        return GraphConnectionContext.class;
    }

    @Test
    public void checkMissingConnectionNodesDoesNotTriggerCheck() {
        Mockito.when((Object)this.context.getSource()).thenReturn(Optional.empty());
        Mockito.when((Object)this.context.getTarget()).thenReturn(Optional.empty());
        Mockito.when((Object)this.context.getConnector()).thenReturn((Object)this.connector);
        RuleViolations result = ((SingleConnectorPerTypeGraphRule)this.check).evaluate(this.rule, this.context);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.violations().iterator().hasNext());
        ((SingleConnectorPerTypeGraphRule)Mockito.verify((Object)this.check, (VerificationMode)Mockito.never())).isConnectionAlreadyFormed((Node)Mockito.any(Node.class), (Node)Mockito.any(Node.class), (Edge)Mockito.any(Edge.class));
    }

    @Test
    public void checkMissingConnectionTargetNodeDoesNotTriggerCheck() {
        Node source = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.context.getSource()).thenReturn(Optional.of(source));
        Mockito.when((Object)this.context.getTarget()).thenReturn(Optional.empty());
        Mockito.when((Object)this.context.getConnector()).thenReturn((Object)this.connector);
        RuleViolations result = ((SingleConnectorPerTypeGraphRule)this.check).evaluate(this.rule, this.context);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.violations().iterator().hasNext());
        ((SingleConnectorPerTypeGraphRule)Mockito.verify((Object)this.check, (VerificationMode)Mockito.never())).isConnectionAlreadyFormed((Node)Mockito.any(Node.class), (Node)Mockito.any(Node.class), (Edge)Mockito.any(Edge.class));
    }

    @Test
    public void checkCompleteConnectionDefinitionTriggersCheck() {
        Node source = (Node)Mockito.mock(Node.class);
        Node target = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.context.getSource()).thenReturn(Optional.of(source));
        Mockito.when((Object)this.context.getTarget()).thenReturn(Optional.of(target));
        Mockito.when((Object)this.context.getConnector()).thenReturn((Object)this.connector);
        RuleViolations result = ((SingleConnectorPerTypeGraphRule)this.check).evaluate(this.rule, this.context);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.violations().iterator().hasNext());
        ((SingleConnectorPerTypeGraphRule)Mockito.verify((Object)this.check)).isConnectionAlreadyFormed((Node)Mockito.any(Node.class), (Node)Mockito.any(Node.class), (Edge)Mockito.any(Edge.class));
    }

    @Test
    public void checkHasExistingConnection() {
        NodeImpl node1 = new NodeImpl("node1");
        NodeImpl node2 = new NodeImpl("node2");
        EdgeImpl existingConnector = new EdgeImpl("edge1");
        ViewConnector existingConnectorView = (ViewConnector)Mockito.mock(ViewConnector.class);
        existingConnector.setContent((Object)existingConnectorView);
        Mockito.when((Object)existingConnectorView.getDefinition()).thenReturn((Object)new BaseGraphRuleTest.Definition());
        node1.getOutEdges().add(existingConnector);
        node2.getInEdges().add(existingConnector);
        existingConnector.setSourceNode((Node)node1);
        existingConnector.setTargetNode((Node)node2);
        this.graph.addNode((Node)node1);
        this.graph.addNode((Node)node2);
        Mockito.when((Object)this.context.getSource()).thenReturn(Optional.of(node1));
        Mockito.when((Object)this.context.getTarget()).thenReturn(Optional.of(node2));
        Mockito.when((Object)this.context.getConnector()).thenReturn((Object)this.connector);
        RuleViolations result = ((SingleConnectorPerTypeGraphRule)this.check).evaluate(this.rule, this.context);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.violations().iterator().hasNext());
        RuleViolation violation = (RuleViolation)result.violations().iterator().next();
        Assert.assertNotNull((Object)violation);
        Assert.assertTrue((boolean)violation.getArguments().isPresent());
        Assert.assertEquals((long)1L, (long)((Object[])violation.getArguments().get()).length);
        Assert.assertEquals((Object)"Connection would violate single connection per type requirement.", (Object)((Object[])violation.getArguments().get())[0]);
    }
}

