/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.ConstraintType;
import org.kie.workbench.common.dmn.api.definition.model.InputClauseUnaryTests;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class InputClauseUnaryTestsTest {
    private static final String TEXT = "TEXT";
    private static final String UNARY_ID = "UNARY_ID";

    @Test
    public void testDefaultConstraintTypeProperty() {
        InputClauseUnaryTests inputClause = new InputClauseUnaryTests();
        Assert.assertEquals((Object)"", (Object)inputClause.getConstraintTypeProperty().getValue());
    }

    @Test
    public void ensureThatConstraintTypePropertyIsSetToExpression() {
        this.ensureThatConstraintTypePropertyIsSet(ConstraintType.EXPRESSION);
    }

    @Test
    public void ensureThatConstraintTypePropertyIsSetToRange() {
        this.ensureThatConstraintTypePropertyIsSet(ConstraintType.RANGE);
    }

    @Test
    public void ensureThatConstraintTypePropertyIsSetToEnumeration() {
        this.ensureThatConstraintTypePropertyIsSet(ConstraintType.ENUMERATION);
    }

    private void ensureThatConstraintTypePropertyIsSet(ConstraintType constraintType) {
        InputClauseUnaryTests inputClause = new InputClauseUnaryTests(new Id("id"), new Text(""), constraintType);
        Assert.assertEquals((Object)constraintType.value(), (Object)inputClause.getConstraintTypeProperty().getValue());
    }

    @Test
    public void ensureThatConstraintTypeIsSetToExpression() {
        this.ensureThatConstraintTypeIsSet(ConstraintType.EXPRESSION);
    }

    @Test
    public void ensureThatConstraintTypeIsSetToRange() {
        this.ensureThatConstraintTypeIsSet(ConstraintType.RANGE);
    }

    @Test
    public void ensureThatConstraintTypeIsSetToEnumeration() {
        this.ensureThatConstraintTypeIsSet(ConstraintType.ENUMERATION);
    }

    @Test
    public void ensureThatConstraintTypeIsSetToNone() {
        this.ensureThatConstraintTypeIsSet(ConstraintType.NONE);
    }

    @Test
    public void ensureThatConstraintTypeIsSetToNull() {
        this.ensureThatConstraintTypeIsSet(ConstraintType.NONE);
    }

    private void ensureThatConstraintTypeIsSet(ConstraintType constraintType) {
        InputClauseUnaryTests inputClause = new InputClauseUnaryTests(new Id("id"), new Text(""), constraintType);
        Assert.assertEquals((Object)constraintType, (Object)inputClause.getConstraintType());
    }

    @Test
    public void testCopy() {
        InputClauseUnaryTests source = new InputClauseUnaryTests(new Id(UNARY_ID), new Text(TEXT), ConstraintType.ENUMERATION);
        InputClauseUnaryTests target = source.copy();
        Assert.assertNotNull((Object)target);
        Assert.assertNotEquals((Object)UNARY_ID, (Object)target.getId());
        Assert.assertEquals((Object)TEXT, (Object)target.getText().getValue());
        Assert.assertEquals((Object)ConstraintType.ENUMERATION, (Object)target.getConstraintType());
    }
}

