/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.rules;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.rules.AcyclicDirectedGraphRule;
import org.kie.workbench.common.dmn.api.rules.BaseGraphRuleTest;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.RuleViolations;
import org.kie.workbench.common.stunner.core.rule.context.GraphConnectionContext;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class AcyclicDirectedGraphRuleTest
extends BaseGraphRuleTest<AcyclicDirectedGraphRule> {
    @Mock
    private TreeWalkTraverseProcessor walker;

    @Override
    protected AcyclicDirectedGraphRule getRule() {
        return new AcyclicDirectedGraphRule();
    }

    @Override
    protected Class getExpectedExtensionType() {
        return AcyclicDirectedGraphRule.class;
    }

    @Override
    protected Class getExpectedContextType() {
        return GraphConnectionContext.class;
    }

    @Test
    public void checkMissingConnectionNodesDoesNotTriggerGraphWalk() {
        Mockito.when((Object)this.context.getSource()).thenReturn(Optional.empty());
        Mockito.when((Object)this.context.getTarget()).thenReturn(Optional.empty());
        Mockito.when((Object)this.context.getConnector()).thenReturn((Object)this.connector);
        Mockito.when((Object)((AcyclicDirectedGraphRule)this.check).getTreeWalker((Node)Mockito.any(Node.class), (Node)Mockito.any(Node.class), (Edge)Mockito.any(Edge.class))).thenReturn((Object)this.walker);
        RuleViolations result = ((AcyclicDirectedGraphRule)this.check).evaluate(this.rule, this.context);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.violations().iterator().hasNext());
        ((TreeWalkTraverseProcessor)Mockito.verify((Object)this.walker, (VerificationMode)Mockito.never())).traverse((Object)((Graph)Mockito.any(Graph.class)), (Object)((TreeTraverseCallback)Mockito.any(TreeTraverseCallback.class)));
    }

    @Test
    public void checkMissingConnectionTargetNodeDoesNotTriggerGraphWalk() {
        Node source = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.context.getSource()).thenReturn(Optional.of(source));
        Mockito.when((Object)this.context.getTarget()).thenReturn(Optional.empty());
        Mockito.when((Object)this.context.getConnector()).thenReturn((Object)this.connector);
        Mockito.when((Object)((AcyclicDirectedGraphRule)this.check).getTreeWalker((Node)Mockito.any(Node.class), (Node)Mockito.any(Node.class), (Edge)Mockito.any(Edge.class))).thenReturn((Object)this.walker);
        RuleViolations result = ((AcyclicDirectedGraphRule)this.check).evaluate(this.rule, this.context);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.violations().iterator().hasNext());
        ((TreeWalkTraverseProcessor)Mockito.verify((Object)this.walker, (VerificationMode)Mockito.never())).traverse((Object)((Graph)Mockito.any(Graph.class)), (Object)((TreeTraverseCallback)Mockito.any(TreeTraverseCallback.class)));
    }

    @Test
    public void checkCompleteConnectionDefinitionTriggersGraphWalk() {
        Node source = (Node)Mockito.mock(Node.class);
        Node target = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)this.context.getSource()).thenReturn(Optional.of(source));
        Mockito.when((Object)this.context.getTarget()).thenReturn(Optional.of(target));
        Mockito.when((Object)this.context.getConnector()).thenReturn((Object)this.connector);
        Mockito.when((Object)((AcyclicDirectedGraphRule)this.check).getTreeWalker((Node)Mockito.any(Node.class), (Node)Mockito.any(Node.class), (Edge)Mockito.any(Edge.class))).thenReturn((Object)this.walker);
        RuleViolations result = ((AcyclicDirectedGraphRule)this.check).evaluate(this.rule, this.context);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.violations().iterator().hasNext());
        ((TreeWalkTraverseProcessor)Mockito.verify((Object)this.walker)).traverse((Object)((Graph)Mockito.eq((Object)this.graph)), (Object)((TreeTraverseCallback)Mockito.any(TreeTraverseCallback.class)));
    }

    @Test
    public void checkCyclicalConnection() {
        NodeImpl node1 = new NodeImpl("node1");
        NodeImpl node2 = new NodeImpl("node2");
        EdgeImpl c1 = new EdgeImpl("edge1");
        node1.getOutEdges().add(c1);
        node2.getInEdges().add(c1);
        c1.setSourceNode((Node)node1);
        c1.setTargetNode((Node)node2);
        this.graph.addNode((Node)node1);
        this.graph.addNode((Node)node2);
        Mockito.when((Object)this.context.getSource()).thenReturn(Optional.of(node2));
        Mockito.when((Object)this.context.getTarget()).thenReturn(Optional.of(node1));
        Mockito.when((Object)this.context.getConnector()).thenReturn((Object)this.connector);
        RuleViolations result = ((AcyclicDirectedGraphRule)this.check).evaluate(this.rule, this.context);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.violations().iterator().hasNext());
        RuleViolation violation = (RuleViolation)result.violations().iterator().next();
        Assert.assertNotNull((Object)violation);
        Assert.assertTrue((boolean)violation.getArguments().isPresent());
        Assert.assertEquals((long)1L, (long)((Object[])violation.getArguments().get()).length);
        Assert.assertEquals((Object)"Connection would violate Directed Acrylic Graph consistency.", (Object)((Object[])violation.getArguments().get())[0]);
    }
}

