/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.definition.model;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasTypeRef;
import org.kie.workbench.common.dmn.api.definition.model.ConstraintType;
import org.kie.workbench.common.dmn.api.definition.model.ImportedValues;
import org.kie.workbench.common.dmn.api.definition.model.InputClause;
import org.kie.workbench.common.dmn.api.definition.model.InputClauseLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.InputClauseUnaryTests;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.powermock.api.mockito.PowerMockito;

@RunWith(value=MockitoJUnitRunner.class)
public class InputClauseTest {
    private static final String UNARY_ID = "UNARY-ID";
    private static final String INPUT_ID = "INPUT-ID";
    private static final String TEXT = "TEXT";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String CLAUSE_ID = "CLAUSE-ID";
    private InputClause inputClause;

    @Before
    public void setup() {
        this.inputClause = (InputClause)Mockito.spy((Object)new InputClause());
    }

    @Test
    public void testGetHasTypeRefs() {
        InputClauseLiteralExpression literalExpression = (InputClauseLiteralExpression)Mockito.mock(InputClauseLiteralExpression.class);
        HasTypeRef hasTypeRef1 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        HasTypeRef hasTypeRef2 = (HasTypeRef)Mockito.mock(HasTypeRef.class);
        ((InputClause)Mockito.doReturn((Object)literalExpression).when((Object)this.inputClause)).getInputExpression();
        PowerMockito.when((Object)literalExpression.getHasTypeRefs()).thenReturn(Arrays.asList(hasTypeRef1, hasTypeRef2));
        List actualHasTypeRefs = this.inputClause.getHasTypeRefs();
        List<HasTypeRef> expectedHasTypeRefs = Arrays.asList(hasTypeRef1, hasTypeRef2);
        Assert.assertEquals(expectedHasTypeRefs, (Object)actualHasTypeRefs);
    }

    @Test
    public void testCopy() {
        InputClause source = new InputClause(new Id(INPUT_ID), new Description(DESCRIPTION), this.buildInputClauseLiteralExpression(), this.buildInputClauseUnaryTests());
        InputClause target = source.copy();
        Assert.assertNotNull((Object)target);
        Assert.assertNotEquals((Object)INPUT_ID, (Object)target.getId().getValue());
        Assert.assertEquals((Object)DESCRIPTION, (Object)target.getDescription().getValue());
        Assert.assertNotNull((Object)target.getInputExpression());
        Assert.assertNotEquals((Object)CLAUSE_ID, (Object)target.getInputExpression().getId());
        Assert.assertEquals((Object)TEXT, (Object)target.getInputExpression().getText().getValue());
        Assert.assertEquals((Object)DESCRIPTION, (Object)target.getInputExpression().getDescription().getValue());
        Assert.assertEquals((Object)BuiltInType.BOOLEAN.asQName(), (Object)target.getInputExpression().getTypeRef());
        Assert.assertNotNull((Object)target.getInputValues());
        Assert.assertNotEquals((Object)UNARY_ID, (Object)target.getInputValues().getId());
        Assert.assertEquals((Object)TEXT, (Object)target.getInputValues().getText().getValue());
        Assert.assertEquals((Object)ConstraintType.ENUMERATION, (Object)target.getInputValues().getConstraintType());
    }

    private InputClauseUnaryTests buildInputClauseUnaryTests() {
        return new InputClauseUnaryTests(new Id(UNARY_ID), new Text(TEXT), ConstraintType.ENUMERATION);
    }

    private InputClauseLiteralExpression buildInputClauseLiteralExpression() {
        return new InputClauseLiteralExpression(new Id(CLAUSE_ID), new Description(DESCRIPTION), BuiltInType.BOOLEAN.asQName(), new Text(TEXT), new ImportedValues());
    }
}

