/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.api.graph;

import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;
import org.kie.workbench.common.stunner.core.graph.impl.GraphImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStore;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStoreImpl;
import org.kie.workbench.common.stunner.core.util.UUID;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata;
import org.kie.workbench.common.stunner.project.diagram.impl.ProjectDiagramImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNDiagramUtilsTest {
    private static final String NAME = "name";
    @Mock
    private Definition definition;
    @Mock
    private DMNDiagram dmnDiagram;
    @Mock
    private Definitions definitions;
    @Mock
    private ProjectMetadata metadata;
    @Mock
    private Bounds bounds;
    @Mock
    private Node node;
    private ProjectDiagramImpl diagram;
    private GraphImpl<DefinitionSet> graph;
    private String namespace = "://namespace";
    private DMNDiagramUtils utils;

    @Before
    public void setup() {
        this.utils = new DMNDiagramUtils();
        this.graph = new GraphImpl(UUID.uuid(), (GraphNodeStore)new GraphNodeStoreImpl());
        this.diagram = new ProjectDiagramImpl(NAME, this.graph, this.metadata);
        this.graph.addNode(this.node);
        Mockito.when((Object)this.node.getContent()).thenReturn((Object)this.definition);
    }

    @Test
    public void testGetNodes() {
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        Mockito.when((Object)this.definition.getDefinition()).thenReturn((Object)drgElement);
        List actualNodes = this.utils.getDRGElements((Diagram)this.diagram);
        List<DRGElement> expectedNodes = Collections.singletonList(drgElement);
        Assert.assertEquals(expectedNodes, (Object)actualNodes);
    }

    @Test
    public void testGetNamespaceByDiagram() {
        Mockito.when((Object)this.definition.getDefinition()).thenReturn((Object)this.dmnDiagram);
        Mockito.when((Object)this.dmnDiagram.getDefinitions()).thenReturn((Object)this.definitions);
        Mockito.when((Object)this.definitions.getNamespace()).thenReturn((Object)new Text(this.namespace));
        String actualNamespace = this.utils.getNamespace((Diagram)this.diagram);
        Assert.assertEquals((Object)this.namespace, (Object)actualNamespace);
    }

    @Test
    public void testGetDefinitionsWithRootNode() {
        DMNDiagram definition = new DMNDiagram();
        this.graph.addNode(this.newNode(definition));
        Definitions definitions = this.utils.getDefinitions((Diagram)this.diagram);
        Assert.assertNotNull((Object)definitions);
        Assert.assertEquals((Object)definition.getDefinitions(), (Object)definitions);
    }

    @Test
    public void testGetDefinitionsWithMultipleRootNodes() {
        Decision definition1 = new Decision();
        DMNDiagram definition2 = new DMNDiagram();
        this.graph.addNode(this.newNode(definition1));
        this.graph.addNode(this.newNode(definition2));
        Definitions definitions = this.utils.getDefinitions((Diagram)this.diagram);
        Assert.assertNotNull((Object)definitions);
        Assert.assertEquals((Object)definition2.getDefinitions(), (Object)definitions);
    }

    @Test
    public void testGetDefinitionsWithConnectedNodes() {
        Decision definition1 = new Decision();
        DMNDiagram definition2 = new DMNDiagram();
        Node<View, Edge> node1 = this.newNode(definition1);
        Node<View, Edge> node2 = this.newNode(definition2);
        EdgeImpl edge = new EdgeImpl(UUID.uuid());
        node1.getInEdges().add(edge);
        node2.getOutEdges().add(edge);
        edge.setSourceNode(node2);
        edge.setTargetNode(node1);
        this.graph.addNode(node1);
        this.graph.addNode(node2);
        Definitions definitions = this.utils.getDefinitions((Diagram)this.diagram);
        Assert.assertNotNull((Object)definitions);
        Assert.assertEquals((Object)definition2.getDefinitions(), (Object)definitions);
    }

    @Test
    public void testGetDefinitionsWithNoNodes() {
        Assert.assertNull((Object)this.utils.getDefinitions((Diagram)this.diagram));
    }

    private Node<View, Edge> newNode(Object definition) {
        NodeImpl node = new NodeImpl(UUID.uuid());
        ViewImpl content = new ViewImpl(definition, this.bounds);
        node.setContent((Object)content);
        return node;
    }
}

