/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1.dd;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.v1_1.Decision;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.PointUtils;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.util.UUID;

public class PointUtilsTest {
    @Test
    public void testConvertToAbsoluteBoundsWhenChild() {
        NodeImpl parent = new NodeImpl(UUID.uuid());
        ViewImpl parentView = new ViewImpl((Object)new Decision(), Bounds.create((double)100.0, (double)200.0, (double)1000.0, (double)2000.0));
        parent.setContent((Object)parentView);
        NodeImpl child = new NodeImpl(UUID.uuid());
        ViewImpl childView = new ViewImpl((Object)new Decision(), Bounds.create((double)10.0, (double)20.0, (double)50.0, (double)60.0));
        child.setContent((Object)childView);
        EdgeImpl edge = new EdgeImpl(UUID.uuid());
        edge.setContent((Object)new Child());
        edge.setSourceNode((Node)parent);
        edge.setTargetNode((Node)child);
        parent.getOutEdges().add(edge);
        child.getInEdges().add(edge);
        PointUtils.convertToAbsoluteBounds((Node)child);
        Bound ulBound = ((View)child.getContent()).getBounds().getUpperLeft();
        Bound lrBound = ((View)child.getContent()).getBounds().getLowerRight();
        Assertions.assertThat((Double)ulBound.getX()).isEqualTo(110.0);
        Assertions.assertThat((Double)ulBound.getY()).isEqualTo(220.0);
        Assertions.assertThat((Double)lrBound.getX()).isEqualTo(150.0);
        Assertions.assertThat((Double)lrBound.getY()).isEqualTo(260.0);
    }

    @Test
    public void testConvertToAbsoluteBoundsWhenNotChild() {
        NodeImpl node = new NodeImpl(UUID.uuid());
        ViewImpl nodeView = new ViewImpl((Object)new Decision(), Bounds.create((double)10.0, (double)20.0, (double)50.0, (double)60.0));
        node.setContent((Object)nodeView);
        PointUtils.convertToAbsoluteBounds((Node)node);
        Bound ulBound = ((View)node.getContent()).getBounds().getUpperLeft();
        Bound lrBound = ((View)node.getContent()).getBounds().getLowerRight();
        Assertions.assertThat((Double)ulBound.getX()).isEqualTo(10.0);
        Assertions.assertThat((Double)ulBound.getY()).isEqualTo(20.0);
        Assertions.assertThat((Double)lrBound.getX()).isEqualTo(50.0);
        Assertions.assertThat((Double)lrBound.getY()).isEqualTo(60.0);
    }

    @Test
    public void testConvertToRelativeBoundsWhenChild() {
        NodeImpl parent = new NodeImpl(UUID.uuid());
        ViewImpl parentView = new ViewImpl((Object)new Decision(), Bounds.create((double)100.0, (double)200.0, (double)1000.0, (double)2000.0));
        parent.setContent((Object)parentView);
        NodeImpl child = new NodeImpl(UUID.uuid());
        ViewImpl childView = new ViewImpl((Object)new Decision(), Bounds.create((double)110.0, (double)220.0, (double)150.0, (double)260.0));
        child.setContent((Object)childView);
        EdgeImpl edge = new EdgeImpl(UUID.uuid());
        edge.setContent((Object)new Child());
        edge.setSourceNode((Node)parent);
        edge.setTargetNode((Node)child);
        parent.getOutEdges().add(edge);
        child.getInEdges().add(edge);
        PointUtils.convertToRelativeBounds((Node)child);
        Bound ulBound = ((View)child.getContent()).getBounds().getUpperLeft();
        Bound lrBound = ((View)child.getContent()).getBounds().getLowerRight();
        Assertions.assertThat((Double)ulBound.getX()).isEqualTo(10.0);
        Assertions.assertThat((Double)ulBound.getY()).isEqualTo(20.0);
        Assertions.assertThat((Double)lrBound.getX()).isEqualTo(50.0);
        Assertions.assertThat((Double)lrBound.getY()).isEqualTo(60.0);
    }

    @Test
    public void testConvertToRelativeBoundsWhenNotChild() {
        NodeImpl node = new NodeImpl(UUID.uuid());
        ViewImpl nodeView = new ViewImpl((Object)new Decision(), Bounds.create((double)10.0, (double)20.0, (double)50.0, (double)60.0));
        node.setContent((Object)nodeView);
        PointUtils.convertToRelativeBounds((Node)node);
        Bound ulBound = ((View)node.getContent()).getBounds().getUpperLeft();
        Bound lrBound = ((View)node.getContent()).getBounds().getLowerRight();
        Assertions.assertThat((Double)ulBound.getX()).isEqualTo(10.0);
        Assertions.assertThat((Double)ulBound.getY()).isEqualTo(20.0);
        Assertions.assertThat((Double)lrBound.getX()).isEqualTo(50.0);
        Assertions.assertThat((Double)lrBound.getY()).isEqualTo(60.0);
    }
}

