/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.common;

import java.nio.file.NoSuchFileException;
import org.guvnor.common.services.project.model.Package;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.backend.editors.common.DMNDiagramHelper;
import org.kie.workbench.common.dmn.backend.editors.common.DMNIncludeModelFactory;
import org.kie.workbench.common.dmn.backend.editors.types.exceptions.DMNIncludeModelCouldNotBeCreatedException;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNIncludedModelFactoryTest {
    @Mock
    private DMNDiagramHelper dmnDiagramHelper;
    @Mock
    private KieModuleService moduleService;
    @Mock
    private Path path;
    private DMNIncludeModelFactory factory;

    @Before
    public void setup() {
        this.factory = (DMNIncludeModelFactory)Mockito.spy((Object)new DMNIncludeModelFactory(this.dmnDiagramHelper, this.moduleService));
    }

    @Test
    public void testCreate() throws Exception {
        Package aPackage = (Package)Mockito.mock(Package.class);
        String packageName = "com.kie.dmn";
        String fileName = "file.dmn";
        String uri = "/src/main/java/com/kie/dmn/file.dmn";
        String namespace = "://namespace";
        Mockito.when((Object)aPackage.getPackageName()).thenReturn((Object)"com.kie.dmn");
        Mockito.when((Object)this.path.getFileName()).thenReturn((Object)"file.dmn");
        Mockito.when((Object)this.path.toURI()).thenReturn((Object)"/src/main/java/com/kie/dmn/file.dmn");
        Mockito.when((Object)this.moduleService.resolvePackage(this.path)).thenReturn((Object)aPackage);
        Mockito.when((Object)this.dmnDiagramHelper.getNamespace(this.path)).thenReturn((Object)"://namespace");
        DMNIncludedModel dmnIncludedModel = this.factory.create(this.path);
        Assert.assertEquals((Object)"com.kie.dmn", (Object)dmnIncludedModel.getModelPackage());
        Assert.assertEquals((Object)"file.dmn", (Object)dmnIncludedModel.getModelName());
        Assert.assertEquals((Object)"/src/main/java/com/kie/dmn/file.dmn", (Object)dmnIncludedModel.getPath());
        Assert.assertEquals((Object)"://namespace", (Object)dmnIncludedModel.getNamespace());
    }

    @Test(expected=DMNIncludeModelCouldNotBeCreatedException.class)
    public void testCreateWhenGetNamespaceRaisesAnError() throws Exception {
        ((DMNDiagramHelper)Mockito.doThrow(NoSuchFileException.class).when((Object)this.dmnDiagramHelper)).getNamespace(this.path);
        this.factory.create(this.path);
    }
}

