/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.types.query;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.backend.editors.types.query.DMNValueFileExtensionIndexTerm;
import org.kie.workbench.common.dmn.backend.editors.types.query.DMNValueRepositoryRootIndexTerm;
import org.kie.workbench.common.dmn.backend.editors.types.query.FindAllDmnAssetsQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.FileDetailsResponseBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.mockito.Mock;
import org.mockito.Mockito;

public class FindAllDmnAssetsQueryTest {
    private FindAllDmnAssetsQueryFake query;
    @Mock
    private FileDetailsResponseBuilder responseBuilder;

    @Before
    public void setup() {
        this.query = (FindAllDmnAssetsQueryFake)((Object)Mockito.spy((Object)((Object)new FindAllDmnAssetsQueryFake(this.responseBuilder))));
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((Object)FindAllDmnAssetsQuery.NAME, (Object)this.query.getName());
    }

    @Test
    public void testToQuery() {
        HashSet<ValueIndexTerm> terms = new HashSet<ValueIndexTerm>();
        Query expectedResult = (Query)Mockito.mock(Query.class);
        ((FindAllDmnAssetsQueryFake)((Object)Mockito.doNothing().when((Object)this.query))).checkNotNullAndNotEmpty(terms);
        ((FindAllDmnAssetsQueryFake)((Object)Mockito.doReturn((Object)expectedResult).when((Object)this.query))).buildFromMultipleTerms(terms);
        Query actualResult = this.query.toQuery(terms);
        ((FindAllDmnAssetsQueryFake)((Object)Mockito.verify((Object)((Object)this.query)))).checkNotNullAndNotEmpty(terms);
        Assert.assertEquals((Object)expectedResult, (Object)actualResult);
    }

    @Test
    public void testGetSortOrder() {
        Sort expected = new Sort(new SortField("filenamesorted", SortField.Type.STRING));
        Sort actual = this.query.getSortOrder();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetResponseBuilder() {
        Assert.assertEquals((Object)this.responseBuilder, (Object)this.query.getResponseBuilder());
    }

    @Test
    public void testValidateTerms() {
        HashSet<ValueIndexTerm> queryTerms = new HashSet<ValueIndexTerm>();
        String[] requiredTermNames = new String[]{};
        Predicate<ValueIndexTerm> fileExtensionIndexTermPredicate = t -> true;
        Predicate<ValueIndexTerm> repositoryRootIndexTermPredicate = t -> true;
        ((FindAllDmnAssetsQueryFake)((Object)Mockito.doReturn((Object)requiredTermNames).when((Object)this.query))).requiredTermNames();
        ((FindAllDmnAssetsQueryFake)((Object)Mockito.doReturn(fileExtensionIndexTermPredicate).when((Object)this.query))).repositoryRootIndexTermPredicate();
        ((FindAllDmnAssetsQueryFake)((Object)Mockito.doReturn(repositoryRootIndexTermPredicate).when((Object)this.query))).fileExtensionIndexTermPredicate();
        this.query.validateTerms(queryTerms);
        ((FindAllDmnAssetsQueryFake)((Object)Mockito.verify((Object)((Object)this.query)))).checkTermsSize(2, queryTerms);
        ((FindAllDmnAssetsQueryFake)((Object)Mockito.verify((Object)((Object)this.query)))).checkTerms(queryTerms, FindAllDmnAssetsQuery.NAME, requiredTermNames, fileExtensionIndexTermPredicate, repositoryRootIndexTermPredicate);
    }

    @Test
    public void testFileExtensionIndexTermPredicateWhenItReturnsTrue() {
        Assert.assertTrue((boolean)this.query.fileExtensionIndexTermPredicate().test(new DMNValueFileExtensionIndexTerm()));
    }

    @Test
    public void testFileExtensionIndexTermPredicateWhenItReturnsFalse() {
        Assert.assertFalse((boolean)this.query.fileExtensionIndexTermPredicate().test(new DMNValueRepositoryRootIndexTerm("")));
    }

    @Test
    public void testRepositoryRootIndexTermPredicateWhenItReturnsTrue() {
        Assert.assertTrue((boolean)this.query.repositoryRootIndexTermPredicate().test(new DMNValueRepositoryRootIndexTerm("")));
    }

    @Test
    public void testRepositoryRootIndexTermPredicateWhenItReturnsFalse() {
        Assert.assertFalse((boolean)this.query.repositoryRootIndexTermPredicate().test(new DMNValueFileExtensionIndexTerm()));
    }

    @Test
    public void testRequiredTermNames() {
        String[] expected = new String[]{"libraryRepositoryRoot", "libraryFileName"};
        String[] actual = this.query.requiredTermNames();
        Assert.assertEquals((long)expected.length, (long)actual.length);
        Assert.assertEquals((Object)expected[0], (Object)actual[0]);
        Assert.assertEquals((Object)expected[1], (Object)actual[1]);
    }

    class FindAllDmnAssetsQueryFake
    extends FindAllDmnAssetsQuery {
        FindAllDmnAssetsQueryFake(FileDetailsResponseBuilder responseBuilder) {
            super(responseBuilder);
        }

        protected void checkTermsSize(int expected, Set<ValueIndexTerm> terms) {
        }

        protected void checkNotNullAndNotEmpty(Set<ValueIndexTerm> terms) {
        }

        protected Query buildFromMultipleTerms(Set<ValueIndexTerm> terms) {
            return null;
        }
    }
}

