/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.namespace.QName;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.kie.dmn.api.marshalling.DMNMarshaller;
import org.kie.dmn.model.api.DRGElement;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.Import;
import org.kie.dmn.model.api.ItemDefinition;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.backend.common.DMNMarshallerImportsHelper;
import org.kie.workbench.common.dmn.backend.common.DMNPathsHelperImpl;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class DMNMarshallerImportsHelperImpl
implements DMNMarshallerImportsHelper {
    private final DMNPathsHelperImpl pathsHelper;
    private final WorkspaceProjectService projectService;
    private final IOService ioService;
    private DMNMarshaller marshaller;

    public DMNMarshallerImportsHelperImpl() {
        this(null, null, null);
    }

    @Inject
    public DMNMarshallerImportsHelperImpl(DMNPathsHelperImpl pathsHelper, WorkspaceProjectService projectService, @Named(value="ioStrategy") IOService ioService) {
        this.pathsHelper = pathsHelper;
        this.projectService = projectService;
        this.ioService = ioService;
    }

    public void init(DMNMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    @Override
    public Map<Import, Definitions> getImportDefinitions(Metadata metadata, List<Import> imports) {
        HashMap<Import, Definitions> importDefinitions = new HashMap<Import, Definitions>();
        if (imports.size() > 0) {
            for (Definitions definitions : this.getOtherDMNDiagramsDefinitions(metadata)) {
                this.findImportByDefinitions(definitions, imports).ifPresent(anImport -> importDefinitions.put((Import)anImport, definitions));
            }
        }
        return importDefinitions;
    }

    @Override
    public List<DRGElement> getImportedDRGElements(Map<Import, Definitions> importDefinitions) {
        ArrayList<DRGElement> importedNodes = new ArrayList<DRGElement>();
        importDefinitions.forEach((anImport, definitions) -> importedNodes.addAll(this.getDrgElementsWithNamespace((Definitions)definitions, (Import)anImport)));
        return importedNodes;
    }

    @Override
    public List<ItemDefinition> getImportedItemDefinitions(Map<Import, Definitions> importDefinitions) {
        ArrayList<ItemDefinition> itemDefinitions = new ArrayList<ItemDefinition>();
        importDefinitions.forEach((anImport, definitions) -> itemDefinitions.addAll(this.getItemDefinitionsWithNamespace((Definitions)definitions, (Import)anImport)));
        return itemDefinitions;
    }

    List<ItemDefinition> getItemDefinitionsWithNamespace(Definitions definitions, Import anImport) {
        List itemDefinitions = definitions.getItemDefinition();
        String namespace = anImport.getName();
        return this.setItemDefinitionsNamespace(itemDefinitions, namespace);
    }

    private List<ItemDefinition> setItemDefinitionsNamespace(List<ItemDefinition> itemDefinitions, String namespace) {
        return itemDefinitions.stream().map(itemDefinition -> this.setItemDefinitionNamespace((ItemDefinition)itemDefinition, namespace)).collect(Collectors.toList());
    }

    private ItemDefinition setItemDefinitionNamespace(ItemDefinition itemDefinition, String namespace) {
        String nameWithNamespace = namespace + "." + itemDefinition.getName();
        List itemComponents = itemDefinition.getItemComponent();
        if (itemDefinition.getTypeRef() != null && !this.isBuiltInType(itemDefinition.getTypeRef())) {
            itemDefinition.setTypeRef(this.makeQNameWithNamespace(itemDefinition.getTypeRef(), namespace));
        }
        itemDefinition.setName(nameWithNamespace);
        this.setItemDefinitionsNamespace(itemComponents, namespace);
        return itemDefinition;
    }

    private boolean isBuiltInType(QName typeRef) {
        return Arrays.stream(BuiltInType.values()).anyMatch(builtInType -> {
            String builtInTypeName = builtInType.getName();
            String typeRefName = typeRef.getLocalPart();
            return Objects.equals(builtInTypeName, typeRefName);
        });
    }

    private QName makeQNameWithNamespace(QName qName, String namespace) {
        String namespaceURI = qName.getNamespaceURI();
        String localPart = namespace + "." + qName.getLocalPart();
        String prefix = qName.getPrefix();
        return new QName(namespaceURI, localPart, prefix);
    }

    List<DRGElement> getDrgElementsWithNamespace(Definitions definitions, Import anImport) {
        return definitions.getDrgElement().stream().map(drgElement -> this.drgElementWithNamespace((DRGElement)drgElement, anImport)).collect(Collectors.toList());
    }

    private DRGElement drgElementWithNamespace(DRGElement drgElement, Import anImport) {
        String namespace = anImport.getName();
        drgElement.setId(namespace + ":" + drgElement.getId());
        drgElement.setName(namespace + "." + drgElement.getName());
        return drgElement;
    }

    private Optional<Import> findImportByDefinitions(Definitions definitions, List<Import> imports) {
        return imports.stream().filter(anImport -> Objects.equals(anImport.getNamespace(), definitions.getNamespace())).findAny();
    }

    List<Definitions> getOtherDMNDiagramsDefinitions(Metadata metadata) {
        List<org.uberfire.backend.vfs.Path> diagramPaths = this.pathsHelper.getDiagramsPaths(this.getProject(metadata));
        return diagramPaths.stream().filter(path -> !Objects.equals(metadata.getPath(), path)).map(path -> this.loadPath((org.uberfire.backend.vfs.Path)path).map(arg_0 -> ((DMNMarshaller)this.marshaller).unmarshal(arg_0)).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    Optional<InputStreamReader> loadPath(org.uberfire.backend.vfs.Path path) {
        InputStreamReader mutableInputStream = null;
        try {
            byte[] bytes = this.ioService.readAllBytes(this.convertPath(path));
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            mutableInputStream = new InputStreamReader(inputStream);
            return Optional.of(mutableInputStream);
        }
        catch (Exception e) {
            this.closeInputStreamReader(mutableInputStream);
            return Optional.empty();
        }
    }

    void closeInputStreamReader(InputStreamReader mutableInputStream) {
        if (mutableInputStream != null) {
            try {
                mutableInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private WorkspaceProject getProject(Metadata metadata) {
        try {
            return this.projectService.resolveProject(metadata.getPath());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    Path convertPath(org.uberfire.backend.vfs.Path path) {
        return Paths.convert((org.uberfire.backend.vfs.Path)path);
    }
}

