/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.included;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModelsService;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedNode;
import org.kie.workbench.common.dmn.backend.common.DMNPathsHelperImpl;
import org.kie.workbench.common.dmn.backend.editors.common.DMNIncludeModelFactory;
import org.kie.workbench.common.dmn.backend.editors.common.DMNIncludedNodesFilter;
import org.kie.workbench.common.dmn.backend.editors.types.exceptions.DMNIncludeModelCouldNotBeCreatedException;
import org.uberfire.backend.vfs.Path;

@Service
public class DMNIncludedModelsServiceImpl
implements DMNIncludedModelsService {
    private static Logger LOGGER = Logger.getLogger(DMNIncludedModelsServiceImpl.class.getName());
    private final DMNPathsHelperImpl pathsHelper;
    private final DMNIncludeModelFactory includeModelFactory;
    private final DMNIncludedNodesFilter includedNodesFilter;

    @Inject
    public DMNIncludedModelsServiceImpl(DMNPathsHelperImpl pathsHelper, DMNIncludeModelFactory includeModelFactory, DMNIncludedNodesFilter includedNodesFilter) {
        this.pathsHelper = pathsHelper;
        this.includeModelFactory = includeModelFactory;
        this.includedNodesFilter = includedNodesFilter;
    }

    public List<DMNIncludedModel> loadModels(WorkspaceProject workspaceProject) {
        return this.getPaths(workspaceProject).stream().map(this.getPathDMNIncludeModelFunction()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<DMNIncludedNode> loadNodesFromImports(WorkspaceProject workspaceProject, List<DMNIncludedModel> includedModels) {
        return this.getPaths(workspaceProject).stream().map(path -> this.includedNodesFilter.getNodesFromImports((Path)path, includedModels)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Function<Path, DMNIncludedModel> getPathDMNIncludeModelFunction() {
        return path -> {
            try {
                return this.includeModelFactory.create((Path)path);
            }
            catch (DMNIncludeModelCouldNotBeCreatedException e) {
                LOGGER.warning("The 'DMNIncludedModel' could not be created for " + path.toURI());
                return null;
            }
        };
    }

    private List<Path> getPaths(WorkspaceProject workspaceProject) {
        return this.pathsHelper.getDiagramsPaths(workspaceProject);
    }
}

