/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.v1_1.DRGElement;
import org.kie.workbench.common.dmn.api.definition.v1_1.Definitions;
import org.kie.workbench.common.dmn.api.definition.v1_1.Import;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.backend.definition.v1_1.HrefBuilder;
import org.mockito.Mockito;

public class HrefBuilderTest {
    @Test
    public void testGetHref() {
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        Id id = (Id)Mockito.mock(Id.class);
        String stringId = "someId";
        String expected = "#someId";
        Mockito.when((Object)id.getValue()).thenReturn((Object)"someId");
        Mockito.when((Object)drgElement.getId()).thenReturn((Object)id);
        String actual = HrefBuilder.getHref((DRGElement)drgElement);
        Assert.assertEquals((Object)"#someId", (Object)actual);
    }

    @Test
    public void testGetHrefForImported() {
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        Id id = (Id)Mockito.mock(Id.class);
        String uuid = "_someUuid";
        String importName = "USER_TYPED_NAME";
        String uri = "https://github.com/kiegroup/dmn/something";
        String stringId = "USER_TYPED_NAME:_someUuid";
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        ArrayList<Import> imports = new ArrayList<Import>();
        Import importModel = (Import)Mockito.mock(Import.class);
        Name importModelName = (Name)Mockito.mock(Name.class);
        imports.add(importModel);
        Mockito.when((Object)drgElement.getParent()).thenReturn((Object)definitions);
        Mockito.when((Object)importModelName.getValue()).thenReturn((Object)"USER_TYPED_NAME");
        Mockito.when((Object)importModel.getNamespace()).thenReturn((Object)"https://github.com/kiegroup/dmn/something");
        Mockito.when((Object)definitions.getImport()).thenReturn(imports);
        Mockito.when((Object)importModel.getName()).thenReturn((Object)importModelName);
        Mockito.when((Object)id.getValue()).thenReturn((Object)"USER_TYPED_NAME:_someUuid");
        Mockito.when((Object)drgElement.getId()).thenReturn((Object)id);
        String actual = HrefBuilder.getHref((DRGElement)drgElement);
        Assert.assertEquals((Object)"https://github.com/kiegroup/dmn/something#_someUuid", (Object)actual);
    }
}

