/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.Arrays;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.kie.dmn.model.api.DRGElement;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.ItemDefinition;
import org.kie.dmn.model.v1_2.TImport;
import org.kie.workbench.common.dmn.api.definition.v1_1.Import;
import org.kie.workbench.common.dmn.backend.definition.v1_1.ImportConverter;
import org.mockito.Mockito;

public class ImportConverterTest {
    @Test
    public void testWbFromDMN() {
        TImport dmn = new TImport();
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        String key = "drools";
        String value = "http://www.drools.org/kie/dmn/1.1";
        dmn.getNsContext().put("drools", "http://www.drools.org/kie/dmn/1.1");
        Mockito.when((Object)definitions.getDrgElement()).thenReturn(Arrays.asList((DRGElement)Mockito.mock(DRGElement.class), (DRGElement)Mockito.mock(DRGElement.class)));
        Mockito.when((Object)definitions.getItemDefinition()).thenReturn(Arrays.asList((ItemDefinition)Mockito.mock(ItemDefinition.class), (ItemDefinition)Mockito.mock(ItemDefinition.class), (ItemDefinition)Mockito.mock(ItemDefinition.class)));
        Import anImport = ImportConverter.wbFromDMN((org.kie.dmn.model.api.Import)dmn, (Definitions)definitions);
        Map nsContext = anImport.getNsContext();
        Assert.assertEquals((long)1L, (long)nsContext.size());
        Assert.assertEquals((Object)"http://www.drools.org/kie/dmn/1.1", nsContext.get("drools"));
        Assert.assertEquals((long)2L, (long)anImport.getDrgElementsCount());
        Assert.assertEquals((long)3L, (long)anImport.getItemDefinitionsCount());
    }

    @Test
    public void testDmnFromWb() {
        Import wb = new Import();
        String key = "drools";
        String value = "http://www.drools.org/kie/dmn/1.1";
        wb.getNsContext().put("drools", "http://www.drools.org/kie/dmn/1.1");
        org.kie.dmn.model.api.Import anImport = ImportConverter.dmnFromWb((Import)wb);
        Map nsContext = anImport.getNsContext();
        Assert.assertEquals((long)1L, (long)nsContext.size());
        Assert.assertEquals((Object)"http://www.drools.org/kie/dmn/1.1", nsContext.get("drools"));
    }
}

