/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.model.api.Expression;
import org.kie.dmn.model.v1_2.TList;
import org.kie.dmn.model.v1_2.TLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.backend.definition.v1_1.ListPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.ComponentWidths;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ListPropertyConverterTest {
    private static final String LIST_UUID = "l-uuid";
    private static final String LIST_DESCRIPTION = "l-description";
    private static final String LIST_QNAME_LOCALPART = "l-local";
    private static final String EXPRESSION_UUID = "uuid";
    @Mock
    private BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer;
    @Mock
    private Consumer<ComponentWidths> componentWidthsConsumer;
    @Captor
    private ArgumentCaptor<HasComponentWidths> hasComponentWidthsCaptor;
    @Captor
    private ArgumentCaptor<ComponentWidths> componentWidthsCaptor;

    @Test
    public void testWBFromDMN() {
        TList dmn = new TList();
        TLiteralExpression literalExpression = new TLiteralExpression();
        literalExpression.setId(EXPRESSION_UUID);
        dmn.setId(LIST_UUID);
        dmn.setDescription(LIST_DESCRIPTION);
        dmn.setTypeRef(new javax.xml.namespace.QName(LIST_QNAME_LOCALPART));
        dmn.getExpression().add(literalExpression);
        org.kie.workbench.common.dmn.api.definition.v1_1.List wb = ListPropertyConverter.wbFromDMN((org.kie.dmn.model.api.List)dmn, this.hasComponentWidthsConsumer);
        Assertions.assertThat((Object)wb).isNotNull();
        Assertions.assertThat((Object)wb.getId()).isNotNull();
        Assertions.assertThat((String)wb.getId().getValue()).isEqualTo((Object)LIST_UUID);
        Assertions.assertThat((Object)wb.getDescription()).isNotNull();
        Assertions.assertThat((String)wb.getDescription().getValue()).isEqualTo((Object)LIST_DESCRIPTION);
        Assertions.assertThat((Object)wb.getTypeRef()).isNotNull();
        Assertions.assertThat((String)wb.getTypeRef().getLocalPart()).isEqualTo((Object)LIST_QNAME_LOCALPART);
        Assertions.assertThat((List)wb.getExpression()).isNotNull();
        Assertions.assertThat((int)wb.getExpression().size()).isEqualTo(1);
        Assertions.assertThat((String)((org.kie.workbench.common.dmn.api.definition.v1_1.Expression)wb.getExpression().get(0)).getId().getValue()).isEqualTo((Object)EXPRESSION_UUID);
        ((BiConsumer)Mockito.verify(this.hasComponentWidthsConsumer)).accept(Matchers.eq((Object)EXPRESSION_UUID), this.hasComponentWidthsCaptor.capture());
        HasComponentWidths hasComponentWidths = (HasComponentWidths)this.hasComponentWidthsCaptor.getValue();
        Assertions.assertThat((Object)hasComponentWidths).isNotNull();
        Assertions.assertThat((Object)hasComponentWidths).isEqualTo(wb.getExpression().get(0));
    }

    @Test
    public void testDMNFromWB() {
        org.kie.workbench.common.dmn.api.definition.v1_1.List wb = new org.kie.workbench.common.dmn.api.definition.v1_1.List();
        LiteralExpression literalExpression = new LiteralExpression();
        literalExpression.getComponentWidths().set(0, 200.0);
        literalExpression.getId().setValue(EXPRESSION_UUID);
        wb.getId().setValue(LIST_UUID);
        wb.getDescription().setValue(LIST_DESCRIPTION);
        wb.setTypeRef(new QName("", LIST_QNAME_LOCALPART));
        wb.getExpression().add(literalExpression);
        org.kie.dmn.model.api.List dmn = ListPropertyConverter.dmnFromWB((org.kie.workbench.common.dmn.api.definition.v1_1.List)wb, this.componentWidthsConsumer);
        Assertions.assertThat((Object)dmn).isNotNull();
        Assertions.assertThat((String)dmn.getId()).isNotNull();
        Assertions.assertThat((String)dmn.getId()).isEqualTo((Object)LIST_UUID);
        Assertions.assertThat((String)dmn.getDescription()).isNotNull();
        Assertions.assertThat((String)dmn.getDescription()).isEqualTo((Object)LIST_DESCRIPTION);
        Assertions.assertThat((Object)dmn.getTypeRef()).isNotNull();
        Assertions.assertThat((String)dmn.getTypeRef().getLocalPart()).isEqualTo((Object)LIST_QNAME_LOCALPART);
        Assertions.assertThat((List)dmn.getExpression()).isNotNull();
        Assertions.assertThat((int)dmn.getExpression().size()).isEqualTo(1);
        Assertions.assertThat((String)((Expression)dmn.getExpression().get(0)).getId()).isEqualTo((Object)EXPRESSION_UUID);
        ((Consumer)Mockito.verify(this.componentWidthsConsumer)).accept(this.componentWidthsCaptor.capture());
        ComponentWidths componentWidths = (ComponentWidths)this.componentWidthsCaptor.getValue();
        Assertions.assertThat((Object)componentWidths).isNotNull();
        Assertions.assertThat((String)componentWidths.getDmnElementRef().getLocalPart()).isEqualTo((Object)EXPRESSION_UUID);
        Assertions.assertThat((int)componentWidths.getWidths().size()).isEqualTo(literalExpression.getRequiredComponentWidthCount());
        Assertions.assertThat((Double)((Double)componentWidths.getWidths().get(0))).isEqualTo(200.0);
    }
}

