/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1.dd;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.xml.QNameMap;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.v1_2.TDefinitions;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.ComponentWidths;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.ComponentWidthsConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.ComponentsWidthsExtension;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.DMNDIExtensionsRegister;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNDIExtensionsRegisterTest {
    @Mock
    private XStream xStream;
    @Mock
    private QNameMap qmap;
    @Captor
    private ArgumentCaptor<Converter> converterCaptor;
    @Captor
    private ArgumentCaptor<QName> qNameCaptor;
    private DMNDIExtensionsRegister register;

    @Before
    public void setup() {
        this.register = new DMNDIExtensionsRegister();
    }

    @Test
    public void testRegisterExtensionConverters() {
        this.register.registerExtensionConverters(this.xStream);
        ((XStream)Mockito.verify((Object)this.xStream)).processAnnotations((Class)Matchers.eq(ComponentsWidthsExtension.class));
        ((XStream)Mockito.verify((Object)this.xStream)).processAnnotations((Class)Matchers.eq(ComponentWidths.class));
        ((XStream)Mockito.verify((Object)this.xStream)).alias((String)Matchers.eq((Object)"width"), (Class)Matchers.eq(Double.class));
        ((XStream)Mockito.verify((Object)this.xStream)).registerConverter((Converter)this.converterCaptor.capture());
        Assertions.assertThat((Object)this.converterCaptor.getValue()).isInstanceOf(ComponentWidthsConverter.class);
    }

    @Test
    public void testBeforeMarshal() {
        DMNModelInstrumentedBase base = (DMNModelInstrumentedBase)Mockito.mock(TDefinitions.class);
        Mockito.when((Object)base.getPrefixForNamespaceURI(Matchers.anyString())).thenReturn(Optional.empty());
        this.register.beforeMarshal((Object)base, this.qmap);
        ((QNameMap)Mockito.verify((Object)this.qmap)).registerMapping((QName)this.qNameCaptor.capture(), (String)Matchers.eq((Object)"ComponentsWidthsExtension"));
        QName qName1 = (QName)this.qNameCaptor.getValue();
        Assertions.assertThat((String)qName1.getNamespaceURI()).isEqualTo((Object)DMNModelInstrumentedBase.Namespace.KIE.getUri());
        Assertions.assertThat((String)qName1.getLocalPart()).isEqualTo((Object)"ComponentsWidthsExtension");
        Assertions.assertThat((String)qName1.getPrefix()).isEqualTo((Object)DMNModelInstrumentedBase.Namespace.KIE.getPrefix());
        ((QNameMap)Mockito.verify((Object)this.qmap)).registerMapping((QName)this.qNameCaptor.capture(), (String)Matchers.eq((Object)"ComponentWidths"));
        QName qName2 = (QName)this.qNameCaptor.getValue();
        Assertions.assertThat((String)qName2.getNamespaceURI()).isEqualTo((Object)DMNModelInstrumentedBase.Namespace.KIE.getUri());
        Assertions.assertThat((String)qName2.getLocalPart()).isEqualTo((Object)"ComponentWidths");
        Assertions.assertThat((String)qName2.getPrefix()).isEqualTo((Object)DMNModelInstrumentedBase.Namespace.KIE.getPrefix());
        ((QNameMap)Mockito.verify((Object)this.qmap)).registerMapping((QName)this.qNameCaptor.capture(), (String)Matchers.eq((Object)"width"));
        QName qName3 = (QName)this.qNameCaptor.getValue();
        Assertions.assertThat((String)qName3.getNamespaceURI()).isEqualTo((Object)DMNModelInstrumentedBase.Namespace.KIE.getUri());
        Assertions.assertThat((String)qName3.getLocalPart()).isEqualTo((Object)"width");
        Assertions.assertThat((String)qName3.getPrefix()).isEqualTo((Object)DMNModelInstrumentedBase.Namespace.KIE.getPrefix());
    }
}

