/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.common;

import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import org.guvnor.common.services.project.model.Package;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.DRGElement;
import org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.backend.editors.common.DMNDiagramHelper;
import org.kie.workbench.common.dmn.backend.editors.common.DMNIncludedModelFactory;
import org.kie.workbench.common.dmn.backend.editors.types.exceptions.DMNIncludeModelCouldNotBeCreatedException;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNIncludedModelFactoryTest {
    @Mock
    private DMNDiagramHelper dmnDiagramHelper;
    @Mock
    private KieModuleService moduleService;
    @Mock
    private Path path;
    @Mock
    private Diagram<Graph, Metadata> diagram;
    private DMNIncludedModelFactory factory;

    @Before
    public void setup() {
        this.factory = (DMNIncludedModelFactory)Mockito.spy((Object)new DMNIncludedModelFactory(this.dmnDiagramHelper, this.moduleService));
    }

    @Test
    public void testCreate() throws Exception {
        Package aPackage = (Package)Mockito.mock(Package.class);
        String packageName = "com.kie.dmn";
        String fileName = "file.dmn";
        String uri = "/src/main/java/com/kie/dmn/file.dmn";
        String namespace = "://namespace";
        Integer expectedDrgElementsCount = 2;
        Integer expectedItemDefinitionsCount = 3;
        Mockito.when((Object)aPackage.getPackageName()).thenReturn((Object)"com.kie.dmn");
        Mockito.when((Object)this.path.getFileName()).thenReturn((Object)"file.dmn");
        Mockito.when((Object)this.path.toURI()).thenReturn((Object)"/src/main/java/com/kie/dmn/file.dmn");
        Mockito.when((Object)this.moduleService.resolvePackage(this.path)).thenReturn((Object)aPackage);
        Mockito.when((Object)this.dmnDiagramHelper.getDiagramByPath(this.path)).thenReturn(this.diagram);
        Mockito.when((Object)this.dmnDiagramHelper.getNamespace(this.diagram)).thenReturn((Object)"://namespace");
        Mockito.when((Object)this.dmnDiagramHelper.getNodes(this.diagram)).thenReturn(Arrays.asList((DRGElement)Mockito.mock(DRGElement.class), (DRGElement)Mockito.mock(DRGElement.class)));
        Mockito.when((Object)this.dmnDiagramHelper.getItemDefinitions(this.diagram)).thenReturn(Arrays.asList((ItemDefinition)Mockito.mock(ItemDefinition.class), (ItemDefinition)Mockito.mock(ItemDefinition.class), (ItemDefinition)Mockito.mock(ItemDefinition.class)));
        DMNIncludedModel dmnIncludedModel = this.factory.create(this.path);
        Assert.assertEquals((Object)"com.kie.dmn", (Object)dmnIncludedModel.getModelPackage());
        Assert.assertEquals((Object)"file.dmn", (Object)dmnIncludedModel.getModelName());
        Assert.assertEquals((Object)"/src/main/java/com/kie/dmn/file.dmn", (Object)dmnIncludedModel.getPath());
        Assert.assertEquals((Object)"://namespace", (Object)dmnIncludedModel.getNamespace());
        Assert.assertEquals((Object)expectedDrgElementsCount, (Object)dmnIncludedModel.getDrgElementsCount());
        Assert.assertEquals((Object)expectedItemDefinitionsCount, (Object)dmnIncludedModel.getItemDefinitionsCount());
    }

    @Test(expected=DMNIncludeModelCouldNotBeCreatedException.class)
    public void testCreateWhenGetNamespaceRaisesAnError() throws Exception {
        ((DMNDiagramHelper)Mockito.doThrow(NoSuchFileException.class).when((Object)this.dmnDiagramHelper)).getDiagramByPath(this.path);
        this.factory.create(this.path);
    }
}

