/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.DRGElement;
import org.kie.workbench.common.dmn.api.definition.v1_1.Decision;
import org.kie.workbench.common.dmn.api.definition.v1_1.InputData;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedNode;
import org.kie.workbench.common.dmn.backend.editors.common.DMNDiagramHelper;
import org.kie.workbench.common.dmn.backend.editors.common.DMNIncludedNodeFactory;
import org.kie.workbench.common.dmn.backend.editors.common.DMNIncludedNodesFilter;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNIncludedNodesFilterTest {
    @Mock
    private DMNDiagramHelper diagramHelper;
    @Mock
    private DMNIncludedNodeFactory factory;
    @Mock
    private Diagram<Graph, Metadata> diagram;
    private DMNIncludedNodesFilter filter;

    @Before
    public void setup() {
        this.filter = new DMNIncludedNodesFilter(this.diagramHelper, this.factory);
    }

    @Test
    public void testGetNodesFromImports() {
        Path path = (Path)Mockito.mock(Path.class);
        DMNIncludedModel includedModel1 = (DMNIncludedModel)Mockito.mock(DMNIncludedModel.class);
        DMNIncludedModel includedModel2 = (DMNIncludedModel)Mockito.mock(DMNIncludedModel.class);
        DMNIncludedModel includedModel3 = (DMNIncludedModel)Mockito.mock(DMNIncludedModel.class);
        List<DMNIncludedModel> imports = Arrays.asList(includedModel1, includedModel2, includedModel3);
        DMNIncludedNode dmnNode1 = (DMNIncludedNode)Mockito.mock(DMNIncludedNode.class);
        DMNIncludedNode dmnNode2 = (DMNIncludedNode)Mockito.mock(DMNIncludedNode.class);
        Decision node1 = new Decision();
        InputData node2 = new InputData();
        List<DRGElement> diagramNodes = Arrays.asList(node1, node2);
        Mockito.when((Object)includedModel1.getNamespace()).thenReturn((Object)"://namespace1");
        Mockito.when((Object)includedModel2.getNamespace()).thenReturn((Object)"://namespace2");
        Mockito.when((Object)includedModel3.getNamespace()).thenReturn((Object)"://namespace3");
        Mockito.when((Object)this.diagramHelper.getDiagramByPath(path)).thenReturn(this.diagram);
        Mockito.when((Object)this.diagramHelper.getNodes(this.diagram)).thenReturn(diagramNodes);
        Mockito.when((Object)this.diagramHelper.getNamespace(this.diagram)).thenReturn((Object)"://namespace1");
        Mockito.when((Object)this.factory.makeDMNIncludeModel(path, includedModel1, (DRGElement)node1)).thenReturn((Object)dmnNode1);
        Mockito.when((Object)this.factory.makeDMNIncludeModel(path, includedModel1, (DRGElement)node2)).thenReturn((Object)dmnNode2);
        List actualNodes = this.filter.getNodesFromImports(path, imports);
        List<DMNIncludedNode> expectedNodes = Arrays.asList(dmnNode1, dmnNode2);
        Assert.assertEquals(expectedNodes, (Object)actualNodes);
    }

    @Test
    public void testGetNodesFromImportsWhenPathDoesNotRepresentsAnImportedDiagram() {
        Path path = (Path)Mockito.mock(Path.class);
        DMNIncludedModel includedModel1 = (DMNIncludedModel)Mockito.mock(DMNIncludedModel.class);
        DMNIncludedModel includedModel2 = (DMNIncludedModel)Mockito.mock(DMNIncludedModel.class);
        DMNIncludedModel includedModel3 = (DMNIncludedModel)Mockito.mock(DMNIncludedModel.class);
        List<DMNIncludedModel> imports = Arrays.asList(includedModel1, includedModel2, includedModel3);
        Mockito.when((Object)includedModel1.getNamespace()).thenReturn((Object)"://namespace1");
        Mockito.when((Object)includedModel2.getNamespace()).thenReturn((Object)"://namespace2");
        Mockito.when((Object)includedModel3.getNamespace()).thenReturn((Object)"://namespace3");
        Mockito.when((Object)this.diagramHelper.getDiagramByPath(path)).thenReturn(this.diagram);
        Mockito.when((Object)this.diagramHelper.getNamespace(this.diagram)).thenReturn((Object)"://namespace4");
        List actualNodes = this.filter.getNodesFromImports(path, imports);
        List expectedNodes = Collections.emptyList();
        Assert.assertEquals(expectedNodes, (Object)actualNodes);
    }
}

