/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.namespace.QName;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.kie.dmn.api.marshalling.DMNMarshaller;
import org.kie.dmn.model.api.DRGElement;
import org.kie.dmn.model.api.Decision;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.Import;
import org.kie.dmn.model.api.InformationItem;
import org.kie.dmn.model.api.InputData;
import org.kie.dmn.model.api.Invocable;
import org.kie.dmn.model.api.ItemDefinition;
import org.kie.dmn.model.v1_2.TInformationItem;
import org.kie.workbench.common.dmn.api.editors.types.BuiltInTypeUtils;
import org.kie.workbench.common.dmn.backend.common.DMNMarshallerImportsHelper;
import org.kie.workbench.common.dmn.backend.common.DMNPathsHelperImpl;
import org.kie.workbench.common.dmn.backend.definition.v1_1.ImportedItemDefinitionConverter;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class DMNMarshallerImportsHelperImpl
implements DMNMarshallerImportsHelper {
    private final DMNPathsHelperImpl pathsHelper;
    private final WorkspaceProjectService projectService;
    private final IOService ioService;
    private final DMNMarshaller marshaller;

    public DMNMarshallerImportsHelperImpl() {
        this(null, null, null, null);
    }

    @Inject
    public DMNMarshallerImportsHelperImpl(DMNPathsHelperImpl pathsHelper, WorkspaceProjectService projectService, DMNMarshaller marshaller, @Named(value="ioStrategy") IOService ioService) {
        this.pathsHelper = pathsHelper;
        this.projectService = projectService;
        this.marshaller = marshaller;
        this.ioService = ioService;
    }

    @Override
    public Map<Import, Definitions> getImportDefinitions(Metadata metadata, List<Import> imports) {
        HashMap<Import, Definitions> importDefinitions = new HashMap<Import, Definitions>();
        if (imports.size() > 0) {
            for (Definitions definitions : this.getOtherDMNDiagramsDefinitions(metadata)) {
                this.findImportByDefinitions(definitions, imports).ifPresent(anImport -> importDefinitions.put((Import)anImport, definitions));
            }
        }
        return importDefinitions;
    }

    @Override
    public List<DRGElement> getImportedDRGElements(Map<Import, Definitions> importDefinitions) {
        ArrayList<DRGElement> importedNodes = new ArrayList<DRGElement>();
        importDefinitions.forEach((anImport, definitions) -> importedNodes.addAll(this.getDrgElementsWithNamespace((Definitions)definitions, (Import)anImport)));
        return importedNodes;
    }

    @Override
    public List<ItemDefinition> getImportedItemDefinitions(Map<Import, Definitions> importDefinitions) {
        ArrayList<ItemDefinition> itemDefinitions = new ArrayList<ItemDefinition>();
        importDefinitions.forEach((anImport, definitions) -> itemDefinitions.addAll(this.getItemDefinitionsWithNamespace((Definitions)definitions, (Import)anImport)));
        return itemDefinitions;
    }

    @Override
    public List<ItemDefinition> getImportedItemDefinitionsByNamespace(WorkspaceProject workspaceProject, String modelName, String namespace) {
        return this.findDefinitionsByNamespace(workspaceProject, namespace).map(Definitions::getItemDefinition).orElse(Collections.emptyList());
    }

    private Optional<Definitions> findDefinitionsByNamespace(WorkspaceProject workspaceProject, String namespace) {
        return this.pathsHelper.getDiagramsPaths(workspaceProject).stream().map(path -> this.loadPath((org.uberfire.backend.vfs.Path)path).map(arg_0 -> ((DMNMarshaller)this.marshaller).unmarshal(arg_0)).orElse(null)).filter(Objects::nonNull).filter(definitions -> Objects.equals(definitions.getNamespace(), namespace)).findAny();
    }

    List<ItemDefinition> getItemDefinitionsWithNamespace(Definitions definitions, Import anImport) {
        List itemDefinitions = definitions.getItemDefinition();
        String prefix = anImport.getName();
        return itemDefinitions.stream().map(itemDefinition -> ImportedItemDefinitionConverter.withNamespace(itemDefinition, prefix)).collect(Collectors.toList());
    }

    List<DRGElement> getDrgElementsWithNamespace(Definitions definitions, Import anImport) {
        return definitions.getDrgElement().stream().map(drgElement -> this.drgElementWithNamespace((DRGElement)drgElement, anImport)).collect(Collectors.toList());
    }

    private DRGElement drgElementWithNamespace(DRGElement drgElement, Import anImport) {
        String namespace = anImport.getName();
        drgElement.setId(namespace + ":" + drgElement.getId());
        drgElement.setName(namespace + "." + drgElement.getName());
        this.updateInformationItem(namespace, drgElement);
        return drgElement;
    }

    private void updateInformationItem(String namespace, DRGElement drgElement) {
        this.getInformationItem(drgElement).ifPresent(informationItem -> {
            TInformationItem tInformationItem = new TInformationItem();
            QName qName = informationItem.getTypeRef();
            if (qName != null && !BuiltInTypeUtils.isBuiltInType((String)qName.getLocalPart())) {
                tInformationItem.setTypeRef(new QName(qName.getNamespaceURI(), namespace + "." + qName.getLocalPart(), qName.getPrefix()));
            }
            this.setInformationItem(drgElement, (InformationItem)tInformationItem);
        });
    }

    private Optional<InformationItem> getInformationItem(DRGElement drgElement) {
        if (drgElement instanceof Decision) {
            return Optional.of(((Decision)drgElement).getVariable());
        }
        if (drgElement instanceof InputData) {
            return Optional.of(((InputData)drgElement).getVariable());
        }
        if (drgElement instanceof Invocable) {
            return Optional.of(((Invocable)drgElement).getVariable());
        }
        return Optional.empty();
    }

    private void setInformationItem(DRGElement drgElement, InformationItem informationItem) {
        if (drgElement instanceof Decision) {
            ((Decision)drgElement).setVariable(informationItem);
        }
        if (drgElement instanceof InputData) {
            ((InputData)drgElement).setVariable(informationItem);
        }
        if (drgElement instanceof Invocable) {
            ((Invocable)drgElement).setVariable(informationItem);
        }
    }

    private Optional<Import> findImportByDefinitions(Definitions definitions, List<Import> imports) {
        return imports.stream().filter(anImport -> Objects.equals(anImport.getNamespace(), definitions.getNamespace())).findAny();
    }

    List<Definitions> getOtherDMNDiagramsDefinitions(Metadata metadata) {
        List<org.uberfire.backend.vfs.Path> diagramPaths = this.pathsHelper.getDiagramsPaths(this.getProject(metadata));
        return diagramPaths.stream().filter(path -> !Objects.equals(metadata.getPath(), path)).map(path -> this.loadPath((org.uberfire.backend.vfs.Path)path).map(arg_0 -> ((DMNMarshaller)this.marshaller).unmarshal(arg_0)).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    Optional<InputStreamReader> loadPath(org.uberfire.backend.vfs.Path path) {
        InputStreamReader mutableInputStream = null;
        try {
            byte[] bytes = this.ioService.readAllBytes(this.convertPath(path));
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            mutableInputStream = new InputStreamReader(inputStream);
            return Optional.of(mutableInputStream);
        }
        catch (Exception e) {
            this.closeInputStreamReader(mutableInputStream);
            return Optional.empty();
        }
    }

    void closeInputStreamReader(InputStreamReader mutableInputStream) {
        if (mutableInputStream != null) {
            try {
                mutableInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private WorkspaceProject getProject(Metadata metadata) {
        try {
            return this.projectService.resolveProject(metadata.getPath());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    Path convertPath(org.uberfire.backend.vfs.Path path) {
        return Paths.convert((org.uberfire.backend.vfs.Path)path);
    }
}

