/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.kie.dmn.model.api.DMNElementReference;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.InformationItem;
import org.kie.dmn.model.v1_2.TDMNElementReference;
import org.kie.dmn.model.v1_2.TDecisionService;
import org.kie.dmn.model.v1_2.TInformationItem;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.v1_1.DRGElement;
import org.kie.workbench.common.dmn.api.definition.v1_1.Decision;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionService;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.v1_1.InputData;
import org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeRequirement;
import org.kie.workbench.common.dmn.api.property.background.BackgroundSet;
import org.kie.workbench.common.dmn.api.property.dimensions.DecisionServiceRectangleDimensionsSet;
import org.kie.workbench.common.dmn.api.property.dmn.DecisionServiceDividerLineY;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.font.FontSet;
import org.kie.workbench.common.dmn.backend.definition.v1_1.DMNElementReferenceConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.DescriptionPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.InformationItemPrimaryPropertyConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.NodeConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.ComponentWidths;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class DecisionServiceConverter
implements NodeConverter<org.kie.dmn.model.api.DecisionService, DecisionService> {
    private FactoryManager factoryManager;

    public DecisionServiceConverter(FactoryManager factoryManager) {
        this.factoryManager = factoryManager;
    }

    @Override
    public Node<View<DecisionService>, ?> nodeFromDMN(org.kie.dmn.model.api.DecisionService dmn, BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer) {
        Node node = this.factoryManager.newElement(dmn.getId(), DecisionService.class).asNode();
        Id id = new Id(dmn.getId());
        Description description = DescriptionPropertyConverter.wbFromDMN(dmn.getDescription());
        Name name = new Name(dmn.getName());
        InformationItemPrimary informationItem = InformationItemPrimaryPropertyConverter.wbFromDMN(dmn.getVariable());
        List outputDecision = dmn.getOutputDecision().stream().map(DMNElementReferenceConverter::wbFromDMN).collect(Collectors.toList());
        List encapsulatedDecision = dmn.getEncapsulatedDecision().stream().map(DMNElementReferenceConverter::wbFromDMN).collect(Collectors.toList());
        List inputDecision = dmn.getInputDecision().stream().map(DMNElementReferenceConverter::wbFromDMN).collect(Collectors.toList());
        List inputData = dmn.getInputData().stream().map(DMNElementReferenceConverter::wbFromDMN).collect(Collectors.toList());
        DecisionService decisionService = new DecisionService(id, description, name, informationItem, outputDecision, encapsulatedDecision, inputDecision, inputData, new BackgroundSet(), new FontSet(), new DecisionServiceRectangleDimensionsSet(), new DecisionServiceDividerLineY());
        ((View)node.getContent()).setDefinition((Object)decisionService);
        if (informationItem != null) {
            informationItem.setParent((org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase)decisionService);
        }
        return node;
    }

    @Override
    public org.kie.dmn.model.api.DecisionService dmnFromNode(Node<View<DecisionService>, ?> node, Consumer<ComponentWidths> componentWidthsConsumer) {
        DecisionService source = (DecisionService)((View)node.getContent()).getDefinition();
        TDecisionService ds = new TDecisionService();
        ds.setId(source.getId().getValue());
        ds.setDescription(DescriptionPropertyConverter.dmnFromWB(source.getDescription()));
        ds.setName(source.getName().getValue());
        TInformationItem variable = InformationItemPrimaryPropertyConverter.dmnFromWB(source.getVariable());
        if (variable != null) {
            variable.setParent((DMNModelInstrumentedBase)ds);
        }
        ds.setVariable((InformationItem)variable);
        List<DMNElementReference> existing_outputDecision = source.getOutputDecision().stream().map(DMNElementReferenceConverter::dmnFromWB).collect(Collectors.toList());
        List<DMNElementReference> existing_encapsulatedDecision = source.getEncapsulatedDecision().stream().map(DMNElementReferenceConverter::dmnFromWB).collect(Collectors.toList());
        List<DMNElementReference> existing_inputDecision = source.getInputDecision().stream().map(DMNElementReferenceConverter::dmnFromWB).collect(Collectors.toList());
        List<DMNElementReference> existing_inputData = source.getInputData().stream().map(DMNElementReferenceConverter::dmnFromWB).collect(Collectors.toList());
        ArrayList<DMNElementReference> candidate_outputDecision = new ArrayList<DMNElementReference>();
        ArrayList<DMNElementReference> candidate_encapsulatedDecision = new ArrayList<DMNElementReference>();
        ArrayList<DMNElementReference> candidate_inputDecision = new ArrayList<DMNElementReference>();
        ArrayList<DMNElementReference> candidate_inputData = new ArrayList<DMNElementReference>();
        ArrayList<InputData> reqInputs = new ArrayList<InputData>();
        ArrayList<Decision> reqDecisions = new ArrayList<Decision>();
        List outEdges = node.getOutEdges();
        for (Edge e : outEdges) {
            if (e.getContent() instanceof Child) {
                Node targetNode = e.getTargetNode();
                View targetNodeView = (View)targetNode.getContent();
                if (!(targetNodeView.getDefinition() instanceof DRGElement)) continue;
                DRGElement drgElement = (DRGElement)targetNodeView.getDefinition();
                if (drgElement instanceof Decision) {
                    Decision decision = (Decision)drgElement;
                    TDMNElementReference ri = new TDMNElementReference();
                    ri.setHref("#" + decision.getId().getValue());
                    if (DecisionServiceConverter.isOutputDecision((View)targetNode.getContent(), (View<DecisionService>)((View)node.getContent()))) {
                        candidate_outputDecision.add((DMNElementReference)ri);
                    } else {
                        candidate_encapsulatedDecision.add((DMNElementReference)ri);
                    }
                    this.inspectDecisionForDSReqs(targetNode, reqInputs, reqDecisions);
                    continue;
                }
                throw new UnsupportedOperationException("wrong model definition: a DecisionService is expected to encapsulate only Decision");
            }
            if (e.getContent() instanceof View && ((View)e.getContent()).getDefinition() instanceof KnowledgeRequirement) continue;
            throw new UnsupportedOperationException("wrong model definition.");
        }
        reqInputs.stream().sorted(Comparator.comparing(x -> x.getName().getValue())).map(x -> {
            TDMNElementReference ri = new TDMNElementReference();
            ri.setHref("#" + x.getId().getValue());
            return ri;
        }).forEach(candidate_inputData::add);
        reqDecisions.stream().sorted(Comparator.comparing(x -> x.getName().getValue())).map(x -> {
            TDMNElementReference ri = new TDMNElementReference();
            ri.setHref("#" + x.getId().getValue());
            return ri;
        }).forEach(candidate_inputDecision::add);
        for (DMNElementReference er : candidate_outputDecision) {
            candidate_inputDecision.removeIf(x -> x.getHref().equals(er.getHref()));
        }
        for (DMNElementReference er : candidate_encapsulatedDecision) {
            candidate_inputDecision.removeIf(x -> x.getHref().equals(er.getHref()));
        }
        this.reconcileExistingAndCandidate(ds.getInputData(), existing_inputData, candidate_inputData);
        this.reconcileExistingAndCandidate(ds.getInputDecision(), existing_inputDecision, candidate_inputDecision);
        this.reconcileExistingAndCandidate(ds.getEncapsulatedDecision(), existing_encapsulatedDecision, candidate_encapsulatedDecision);
        this.reconcileExistingAndCandidate(ds.getOutputDecision(), existing_outputDecision, candidate_outputDecision);
        return ds;
    }

    private void reconcileExistingAndCandidate(List<DMNElementReference> targetList, List<DMNElementReference> existingList, List<DMNElementReference> candidateList) {
        ArrayList<DMNElementReference> existing = new ArrayList<DMNElementReference>(existingList);
        ArrayList<DMNElementReference> candidate = new ArrayList<DMNElementReference>(candidateList);
        for (DMNElementReference e : existing) {
            boolean existingIsAlsoCandidate = candidate.removeIf(er -> er.getHref().equals(e.getHref()));
            if (!existingIsAlsoCandidate) continue;
            targetList.add(e);
        }
        for (DMNElementReference c : candidate) {
            targetList.add(c);
        }
    }

    private void inspectDecisionForDSReqs(Node<View<?>, ?> targetNode, List<InputData> reqInputs, List<Decision> reqDecisions) {
        List inEdges = targetNode.getInEdges();
        for (Edge e : inEdges) {
            View view;
            Node sourceNode = e.getSourceNode();
            if (!(sourceNode.getContent() instanceof View) || !((view = (View)sourceNode.getContent()).getDefinition() instanceof DRGElement)) continue;
            DRGElement drgElement = (DRGElement)view.getDefinition();
            if (drgElement instanceof Decision) {
                reqDecisions.add((Decision)drgElement);
                continue;
            }
            if (!(drgElement instanceof InputData)) continue;
            reqInputs.add((InputData)drgElement);
        }
    }

    private static boolean isOutputDecision(View<?> childView, View<DecisionService> decisionServiceView) {
        double decisionServiceViewLineY;
        double decisionServiceViewY;
        double childViewY = childView.getBounds().getUpperLeft().getY();
        return childViewY < (decisionServiceViewY = decisionServiceView.getBounds().getUpperLeft().getY().doubleValue()) + (decisionServiceViewLineY = ((DecisionService)decisionServiceView.getDefinition()).getDividerLineY().getValue().doubleValue());
    }
}

