/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.model.api.InformationItem;
import org.kie.dmn.model.api.InputData;
import org.kie.dmn.model.v1_2.TInformationItem;
import org.kie.dmn.model.v1_2.TInputData;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItemPrimary;
import org.kie.workbench.common.dmn.backend.definition.v1_1.InputDataConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.ComponentWidths;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.util.UUID;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class InputDataConverterTest {
    private static final String INPUT_DATA_UUID = "id-uuid";
    private static final String INPUT_DATA_NAME = "id-name";
    private static final String INPUT_DATA_DESCRIPTION = "id-description";
    @Mock
    private BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer;
    @Mock
    private Consumer<ComponentWidths> componentWidthsConsumer;
    @Mock
    private FactoryManager factoryManager;
    @Mock
    private Element element;
    private InputDataConverter converter;

    @Before
    public void setup() {
        this.converter = new InputDataConverter(this.factoryManager);
    }

    @Test
    public void testWBFromDMN() {
        NodeImpl factoryNode = new NodeImpl(UUID.uuid());
        ViewImpl view = new ViewImpl((Object)new org.kie.workbench.common.dmn.api.definition.v1_1.InputData(), Bounds.create());
        factoryNode.setContent((Object)view);
        Mockito.when((Object)this.factoryManager.newElement(Matchers.anyString(), (Class)Matchers.eq(org.kie.workbench.common.dmn.api.definition.v1_1.InputData.class))).thenReturn((Object)this.element);
        Mockito.when((Object)this.element.asNode()).thenReturn((Object)factoryNode);
        TInputData dmn = new TInputData();
        TInformationItem informationItem = new TInformationItem();
        dmn.setId(INPUT_DATA_UUID);
        dmn.setName(INPUT_DATA_NAME);
        dmn.setDescription(INPUT_DATA_DESCRIPTION);
        dmn.setVariable((InformationItem)informationItem);
        Node node = this.converter.nodeFromDMN((InputData)dmn, this.hasComponentWidthsConsumer);
        org.kie.workbench.common.dmn.api.definition.v1_1.InputData wb = (org.kie.workbench.common.dmn.api.definition.v1_1.InputData)((View)node.getContent()).getDefinition();
        Assertions.assertThat((Object)wb).isNotNull();
        Assertions.assertThat((Object)wb.getId()).isNotNull();
        Assertions.assertThat((String)wb.getId().getValue()).isEqualTo((Object)INPUT_DATA_UUID);
        Assertions.assertThat((Object)wb.getName()).isNotNull();
        Assertions.assertThat((String)wb.getName().getValue()).isEqualTo((Object)INPUT_DATA_NAME);
        Assertions.assertThat((Object)wb.getDescription()).isNotNull();
        Assertions.assertThat((String)wb.getDescription().getValue()).isEqualTo((Object)INPUT_DATA_DESCRIPTION);
        Assertions.assertThat((Object)wb.getVariable()).isNotNull();
        Assertions.assertThat((String)wb.getVariable().getName().getValue()).isEqualTo((Object)INPUT_DATA_NAME);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.hasComponentWidthsConsumer});
    }

    @Test
    public void testDMNFromWB() {
        org.kie.workbench.common.dmn.api.definition.v1_1.InputData wb = new org.kie.workbench.common.dmn.api.definition.v1_1.InputData();
        InformationItemPrimary informationItem = new InformationItemPrimary();
        wb.getId().setValue(INPUT_DATA_UUID);
        wb.getName().setValue(INPUT_DATA_NAME);
        wb.getDescription().setValue(INPUT_DATA_DESCRIPTION);
        wb.setVariable(informationItem);
        NodeImpl node = new NodeImpl(UUID.uuid());
        ViewImpl view = new ViewImpl((Object)wb, Bounds.create());
        node.setContent((Object)view);
        InputData dmn = this.converter.dmnFromNode((Node)node, this.componentWidthsConsumer);
        Assertions.assertThat((Object)dmn).isNotNull();
        Assertions.assertThat((String)dmn.getId()).isNotNull();
        Assertions.assertThat((String)dmn.getId()).isEqualTo((Object)INPUT_DATA_UUID);
        Assertions.assertThat((String)dmn.getName()).isNotNull();
        Assertions.assertThat((String)dmn.getName()).isEqualTo((Object)INPUT_DATA_NAME);
        Assertions.assertThat((String)dmn.getDescription()).isNotNull();
        Assertions.assertThat((String)dmn.getDescription()).isEqualTo((Object)INPUT_DATA_DESCRIPTION);
        Assertions.assertThat((Object)dmn.getVariable()).isNotNull();
        Assertions.assertThat((String)dmn.getVariable().getName()).isEqualTo((Object)INPUT_DATA_NAME);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.componentWidthsConsumer});
    }
}

