/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.model.api.ItemDefinition;
import org.kie.dmn.model.api.UnaryTests;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.backend.definition.v1_1.ItemDefinitionPropertyConverter;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ItemDefinitionPropertyConverterTest {
    @Test
    public void testWbFromDMNWhenDMNIsNull() {
        Assert.assertNull((Object)ItemDefinitionPropertyConverter.wbFromDMN(null));
    }

    @Test
    public void testWbFromDMNWhenDMNIsNotNull() {
        ItemDefinition dmn = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        String id = "id";
        String name = "name";
        Id expectedId = new Id("id");
        Name expectedName = new Name("name");
        String expectedTypeLanguage = "typeLanguage";
        boolean expectedIsCollection = true;
        String description = "description";
        boolean expectedAllowOnlyVisualChange = false;
        String qNameNamespaceURI = "qName namespaceURI";
        String qNameLocalPart = "qName local part";
        String qNamePrefix = "qName prefix";
        Description expectedDescription = new Description("description");
        javax.xml.namespace.QName expectedTypeRef = new javax.xml.namespace.QName("qName namespaceURI", "qName local part", "qName prefix");
        Mockito.when((Object)dmn.getId()).thenReturn((Object)"id");
        Mockito.when((Object)dmn.getName()).thenReturn((Object)"name");
        Mockito.when((Object)dmn.getTypeLanguage()).thenReturn((Object)"typeLanguage");
        Mockito.when((Object)dmn.isIsCollection()).thenReturn((Object)true);
        Mockito.when((Object)dmn.getDescription()).thenReturn((Object)"description");
        Mockito.when((Object)dmn.getTypeRef()).thenReturn((Object)expectedTypeRef);
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition actualItemDefinition = ItemDefinitionPropertyConverter.wbFromDMN((ItemDefinition)dmn);
        Id actualId = actualItemDefinition.getId();
        Name actualName = actualItemDefinition.getName();
        String actualTypeLanguage = actualItemDefinition.getTypeLanguage();
        boolean actualIsCollection = actualItemDefinition.isIsCollection();
        Description actualDescription = actualItemDefinition.getDescription();
        QName actualTypeRef = actualItemDefinition.getTypeRef();
        boolean actualAllowOnlyVisualChange = actualItemDefinition.isAllowOnlyVisualChange();
        Assert.assertEquals((Object)expectedId, (Object)actualId);
        Assert.assertEquals((Object)expectedName, (Object)actualName);
        Assert.assertEquals((Object)"typeLanguage", (Object)actualTypeLanguage);
        Assert.assertEquals((Object)true, (Object)actualIsCollection);
        Assert.assertEquals((Object)expectedDescription, (Object)actualDescription);
        Assert.assertEquals((Object)false, (Object)actualAllowOnlyVisualChange);
        Assert.assertEquals((Object)expectedTypeRef.getLocalPart(), (Object)actualTypeRef.getLocalPart());
        Assert.assertEquals((Object)expectedTypeRef.getPrefix(), (Object)actualTypeRef.getPrefix());
        Assert.assertEquals((Object)expectedTypeRef.getNamespaceURI(), (Object)actualTypeRef.getNamespaceURI());
    }

    @Test
    public void testSetItemComponent() {
        String id = "id";
        String name = "name";
        String typeLanguage = "typeLanguage";
        boolean isCollection = true;
        boolean isOnlyVisualChanges = false;
        String description = "description";
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition expectedWbChild = new org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition(new Id("id"), new Description("description"), new Name("name"), null, null, null, "typeLanguage", Boolean.valueOf(true), Boolean.valueOf(false));
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition wb = new org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition();
        ItemDefinition dmn = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        ItemDefinition dmnChild = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Mockito.when((Object)dmnChild.getId()).thenReturn((Object)"id");
        Mockito.when((Object)dmnChild.getName()).thenReturn((Object)"name");
        Mockito.when((Object)dmnChild.getTypeLanguage()).thenReturn((Object)"typeLanguage");
        Mockito.when((Object)dmnChild.isIsCollection()).thenReturn((Object)true);
        Mockito.when((Object)dmnChild.getDescription()).thenReturn((Object)"description");
        Mockito.when((Object)dmnChild.getTypeRef()).thenReturn(null);
        Mockito.when((Object)dmn.getItemComponent()).thenReturn(Collections.singletonList(dmnChild));
        ItemDefinitionPropertyConverter.setItemComponent((org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)wb, (ItemDefinition)dmn);
        List<org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition> expectedItemDefinitions = Collections.singletonList(expectedWbChild);
        List actualItemDefinitions = wb.getItemComponent();
        Assert.assertEquals(expectedItemDefinitions, (Object)actualItemDefinitions);
        Assert.assertEquals((Object)wb, (Object)((org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)actualItemDefinitions.get(0)).getParent());
    }

    @Test
    public void testSetUnaryTestsWhenUnaryTestsIsNotNull() {
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition wb = (org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)Mockito.mock(org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition.class);
        ArgumentCaptor argument = ArgumentCaptor.forClass(org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests.class);
        ItemDefinition dmn = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        UnaryTests dmnAllowedValues = (UnaryTests)Mockito.mock(UnaryTests.class);
        Mockito.when((Object)dmn.getAllowedValues()).thenReturn((Object)dmnAllowedValues);
        ItemDefinitionPropertyConverter.setUnaryTests((org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)wb, (ItemDefinition)dmn);
        ((org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)Mockito.verify((Object)wb)).setAllowedValues((org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests)argument.capture());
        Assert.assertEquals((Object)wb, (Object)((org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests)argument.getValue()).getParent());
    }

    @Test
    public void testSetUnaryTestsWhenUnaryTestsIsNull() {
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition wb = (org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)Mockito.mock(org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition.class);
        org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests wbAllowedValues = (org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests)Mockito.mock(org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests.class);
        ItemDefinition dmn = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Object dmnAllowedValues = null;
        Mockito.when((Object)dmn.getAllowedValues()).thenReturn(dmnAllowedValues);
        ItemDefinitionPropertyConverter.setUnaryTests((org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)wb, (ItemDefinition)dmn);
        ((org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)Mockito.verify((Object)wb, (VerificationMode)Mockito.never())).setAllowedValues(wbAllowedValues);
        ((org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests)Mockito.verify((Object)wbAllowedValues, (VerificationMode)Mockito.never())).setParent((DMNModelInstrumentedBase)wb);
    }

    @Test
    public void testWbDescriptionFromDMN() {
        String description = "description";
        Description expectedDescription = new Description("description");
        ItemDefinition dmn = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Mockito.when((Object)dmn.getDescription()).thenReturn((Object)"description");
        Description actualDescription = ItemDefinitionPropertyConverter.wbDescriptionFromDMN((ItemDefinition)dmn);
        Assert.assertEquals((Object)expectedDescription, (Object)actualDescription);
    }

    @Test
    public void testWbTypeRefFromDMNWhenQNameIsUndefined() {
        ItemDefinition dmn = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Object dmnQName = null;
        Mockito.when((Object)dmn.getTypeRef()).thenReturn(dmnQName);
        QName actualQName = ItemDefinitionPropertyConverter.wbTypeRefFromDMN((ItemDefinition)dmn);
        Assert.assertNull((Object)actualQName);
    }

    @Test
    public void testWbTypeRefFromDMNWhenQNameIsNotUndefined() {
        String qNameLocalPart = "string";
        String qNamePrefix = "qName prefix";
        ItemDefinition dmn = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        javax.xml.namespace.QName dmnQName = (javax.xml.namespace.QName)Mockito.mock(javax.xml.namespace.QName.class);
        QName expectedQName = BuiltInType.STRING.asQName();
        Mockito.when((Object)dmn.getTypeRef()).thenReturn((Object)dmnQName);
        Mockito.when((Object)dmnQName.getLocalPart()).thenReturn((Object)"string");
        Mockito.when((Object)dmnQName.getPrefix()).thenReturn((Object)"qName prefix");
        QName actualQName = ItemDefinitionPropertyConverter.wbTypeRefFromDMN((ItemDefinition)dmn);
        Assert.assertEquals((Object)actualQName, (Object)expectedQName);
    }

    @Test
    public void testWbChildFromDMNWhenWbChildIsNotNull() {
        String id = "id";
        String name = "name";
        String typeLanguage = "typeLanguage";
        boolean isCollection = true;
        boolean isOnlyVisualChanges = false;
        String description = "description";
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition expectedWbParent = new org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition();
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition expectedWbChild = new org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition(new Id("id"), new Description("description"), new Name("name"), null, null, null, "typeLanguage", Boolean.valueOf(true), Boolean.valueOf(false));
        ItemDefinition dmnChild = (ItemDefinition)Mockito.mock(ItemDefinition.class);
        Mockito.when((Object)dmnChild.getId()).thenReturn((Object)"id");
        Mockito.when((Object)dmnChild.getName()).thenReturn((Object)"name");
        Mockito.when((Object)dmnChild.getTypeLanguage()).thenReturn((Object)"typeLanguage");
        Mockito.when((Object)dmnChild.isIsCollection()).thenReturn((Object)true);
        Mockito.when((Object)dmnChild.getDescription()).thenReturn((Object)"description");
        Mockito.when((Object)dmnChild.getTypeRef()).thenReturn(null);
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition actualWbChild = ItemDefinitionPropertyConverter.wbChildFromDMN((org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)expectedWbParent, (ItemDefinition)dmnChild);
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition actualParent = (org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)actualWbChild.getParent();
        Assert.assertEquals((Object)expectedWbChild, (Object)actualWbChild);
        Assert.assertEquals((Object)expectedWbParent, (Object)actualParent);
    }

    @Test
    public void testWbChildFromDMNWhenWbChildIsNull() {
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition expectedWbParent = new org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition();
        ItemDefinition dmnChild = null;
        org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition actualWbChild = ItemDefinitionPropertyConverter.wbChildFromDMN((org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition)expectedWbParent, dmnChild);
        Assert.assertNull((Object)actualWbChild);
    }

    @After
    public void validate() {
        Mockito.validateMockitoUsage();
    }
}

