/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.common;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.v1_1.DRGElement;
import org.kie.workbench.common.dmn.api.definition.v1_1.Decision;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedNode;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.backend.editors.common.DMNIncludedNodeFactory;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;

public class DMNIncludedNodeFactoryTest {
    private DMNIncludedNodeFactory factory;

    @Before
    public void setup() {
        this.factory = new DMNIncludedNodeFactory();
    }

    @Test
    public void testMakeDMNIncludeModel() {
        Path path = (Path)Mockito.mock(Path.class);
        DMNIncludedModel includedModel = (DMNIncludedModel)Mockito.mock(DMNIncludedModel.class);
        String drgElementId = "0000-1111-3333-4444";
        String drgElementName = "Can Drive?";
        String expectedFileName = "file.dmn";
        String expectedModelName = "model";
        String expectedImportedElementId = "model:0000-1111-3333-4444";
        String expectedImportedElementName = "model.Can Drive?";
        String expectedImportedItemDefinitionName = "model.tCustomBoolean";
        Decision importedElementId = this.makeDecision("0000-1111-3333-4444", "Can Drive?", "tCustomBoolean");
        Mockito.when((Object)path.getFileName()).thenReturn((Object)"file.dmn");
        Mockito.when((Object)includedModel.getModelName()).thenReturn((Object)"model");
        DMNIncludedNode node = this.factory.makeDMNIncludeModel(path, includedModel, (DRGElement)importedElementId);
        Decision drgElement = (Decision)node.getDrgElement();
        Assert.assertEquals((Object)"model:0000-1111-3333-4444", (Object)drgElement.getId().getValue());
        Assert.assertEquals((Object)"model.Can Drive?", (Object)drgElement.getName().getValue());
        Assert.assertEquals((Object)"model.tCustomBoolean", (Object)drgElement.getVariable().getTypeRef().getLocalPart());
        Assert.assertEquals((Object)"file.dmn", (Object)node.getFileName());
        Assert.assertTrue((boolean)drgElement.isAllowOnlyVisualChange());
    }

    private Decision makeDecision(String id, String name, String type) {
        Decision decision = new Decision();
        decision.setId(new Id(id));
        decision.setName(new Name(name));
        decision.setVariable(this.makeInformationItemPrimary(type));
        return decision;
    }

    private InformationItemPrimary makeInformationItemPrimary(String localPart) {
        InformationItemPrimary informationItemPrimary = new InformationItemPrimary();
        informationItemPrimary.setTypeRef(new QName("", localPart, ""));
        return informationItemPrimary;
    }
}

