/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.validation;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.core.impl.DMNMessageImpl;
import org.kie.dmn.model.api.DMNElement;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.validation.DMNValidator;
import org.kie.workbench.common.dmn.api.DMNDefinitionSet;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.dmn.backend.DMNMarshaller;
import org.kie.workbench.common.dmn.backend.common.DMNMarshallerImportsHelper;
import org.kie.workbench.common.dmn.backend.validation.DMNDomainValidator;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.validation.DomainViolation;
import org.kie.workbench.common.stunner.core.validation.Violation;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNDomainValidatorTest {
    private static final String DMN_XML = "<Some XML/>";
    private static final String IMPORTED_DMN_XML = "<Some other XML/>";
    @Mock
    private DMNMarshaller dmnMarshaller;
    @Mock
    private DMNDiagramUtils dmnDiagramUtils;
    @Mock
    private DMNMarshallerImportsHelper importsHelper;
    @Mock
    private DMNValidator dmnValidator;
    @Mock
    private DMNValidator.ValidatorBuilder dmnValidatorBuilder;
    @Mock
    private Diagram diagram;
    @Mock
    private Metadata metadata;
    @Mock
    private Consumer<Collection<DomainViolation>> resultConsumer;
    @Captor
    private ArgumentCaptor<Collection<DomainViolation>> domainViolationsArgumentCaptor;
    @Captor
    private ArgumentCaptor<StringReader> readerArgumentCaptor;
    private Definitions definitions;
    private List<DMNMessage> validationMessages;
    private DMNDomainValidator domainValidator;

    @Before
    public void setup() throws IOException {
        this.definitions = new Definitions();
        this.validationMessages = new ArrayList<DMNMessage>();
        this.domainValidator = (DMNDomainValidator)Mockito.spy((Object)new DMNDomainValidator(this.dmnMarshaller, this.dmnDiagramUtils, this.importsHelper));
        ((DMNDomainValidator)Mockito.doReturn((Object)this.dmnValidator).when((Object)this.domainValidator)).getDMNValidator();
        this.domainValidator.setupValidator();
        Mockito.when((Object)this.dmnMarshaller.marshall(this.diagram)).thenReturn((Object)DMN_XML);
        Mockito.when((Object)this.dmnDiagramUtils.getDefinitions(this.diagram)).thenReturn((Object)this.definitions);
        Mockito.when((Object)this.dmnValidator.validateUsing((DMNValidator.Validation[])Matchers.anyVararg())).thenReturn((Object)this.dmnValidatorBuilder);
        Mockito.when((Object)this.dmnValidatorBuilder.theseModels(new Reader[]{(Reader)Matchers.any(Reader.class)})).thenReturn(this.validationMessages);
        Mockito.when((Object)this.diagram.getMetadata()).thenReturn((Object)this.metadata);
    }

    @Test
    public void testGetDefinitionSetId() {
        Assertions.assertThat((String)this.domainValidator.getDefinitionSetId()).isEqualTo((Object)DMNDefinitionSet.class.getName());
    }

    @Test
    public void testBasicValidation() throws IOException {
        StringReader stringReader = (StringReader)Mockito.mock(StringReader.class);
        Mockito.when((Object)this.domainValidator.getStringReader(Matchers.anyString())).thenReturn((Object)stringReader);
        this.domainValidator.validate(this.diagram, this.resultConsumer);
        ((DMNMarshaller)Mockito.verify((Object)this.dmnMarshaller)).marshall(this.diagram);
        ((DMNDiagramUtils)Mockito.verify((Object)this.dmnDiagramUtils)).getDefinitions(this.diagram);
        ((DMNValidator)Mockito.verify((Object)this.dmnValidator)).validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        ((DMNDomainValidator)Mockito.verify((Object)this.domainValidator)).getStringReader(DMN_XML);
        ((DMNValidator.ValidatorBuilder)Mockito.verify((Object)this.dmnValidatorBuilder)).theseModels(new Reader[]{(Reader)this.readerArgumentCaptor.capture()});
        Assertions.assertThat((List)this.readerArgumentCaptor.getAllValues()).containsExactly((Object[])new StringReader[]{stringReader});
        ((Consumer)Mockito.verify(this.resultConsumer)).accept(Collections.emptyList());
    }

    @Test
    public void testImportedModelValidation() throws IOException {
        StringReader stringReader1 = (StringReader)Mockito.mock(StringReader.class);
        StringReader stringReader2 = (StringReader)Mockito.mock(StringReader.class);
        Mockito.when((Object)this.domainValidator.getStringReader(Matchers.anyString())).thenReturn((Object)stringReader1, (Object[])new StringReader[]{stringReader2});
        this.definitions.getImport().add(new Import());
        Mockito.when((Object)this.importsHelper.getImportXML((Metadata)Matchers.eq((Object)this.metadata), Matchers.anyList())).thenAnswer(i -> {
            HashMap importedModels = new HashMap();
            List imports = (List)i.getArguments()[1];
            importedModels.put(imports.get(0), IMPORTED_DMN_XML);
            return importedModels;
        });
        this.domainValidator.validate(this.diagram, this.resultConsumer);
        ((DMNMarshaller)Mockito.verify((Object)this.dmnMarshaller)).marshall(this.diagram);
        ((DMNDiagramUtils)Mockito.verify((Object)this.dmnDiagramUtils)).getDefinitions(this.diagram);
        ((DMNValidator)Mockito.verify((Object)this.dmnValidator)).validateUsing(new DMNValidator.Validation[]{DMNValidator.Validation.VALIDATE_MODEL, DMNValidator.Validation.VALIDATE_COMPILATION, DMNValidator.Validation.ANALYZE_DECISION_TABLE});
        ((DMNDomainValidator)Mockito.verify((Object)this.domainValidator)).getStringReader(DMN_XML);
        ((DMNDomainValidator)Mockito.verify((Object)this.domainValidator)).getStringReader(IMPORTED_DMN_XML);
        ((DMNValidator.ValidatorBuilder)Mockito.verify((Object)this.dmnValidatorBuilder)).theseModels(new Reader[]{(Reader)this.readerArgumentCaptor.capture()});
        Assertions.assertThat((List)this.readerArgumentCaptor.getAllValues()).containsExactly((Object[])new StringReader[]{stringReader1, stringReader2});
        ((Consumer)Mockito.verify(this.resultConsumer)).accept(Collections.emptyList());
    }

    @Test
    public void testValidationMessageConversion() {
        String dmnElementUUID = "element-uuid";
        DMNElement dmnElement1 = (DMNElement)Mockito.mock(DMNElement.class);
        DMNElement dmnElement2 = (DMNElement)Mockito.mock(DMNElement.class);
        this.validationMessages.add(this.makeDMNMessage(DMNMessage.Severity.ERROR, "error", null));
        Mockito.when((Object)dmnElement1.getId()).thenReturn((Object)"element-uuid");
        this.validationMessages.add(this.makeDMNMessage(DMNMessage.Severity.WARN, "warn", (DMNModelInstrumentedBase)dmnElement1));
        Mockito.when((Object)dmnElement2.getParent()).thenReturn((Object)dmnElement1);
        this.validationMessages.add(this.makeDMNMessage(DMNMessage.Severity.INFO, "info", (DMNModelInstrumentedBase)dmnElement2));
        this.domainValidator.validate(this.diagram, this.resultConsumer);
        ((Consumer)Mockito.verify(this.resultConsumer)).accept(this.domainViolationsArgumentCaptor.capture());
        Collection domainViolations = (Collection)this.domainViolationsArgumentCaptor.getValue();
        Assertions.assertThat((Iterable)domainViolations).hasSize(3);
        Iterator domainViolationIterator = domainViolations.iterator();
        DomainViolation domainViolation0 = (DomainViolation)domainViolationIterator.next();
        Assertions.assertThat((Comparable)domainViolation0.getViolationType()).isEqualTo((Object)Violation.Type.ERROR);
        Assertions.assertThat((String)domainViolation0.getMessage()).contains(new CharSequence[]{"error"});
        Assertions.assertThat((String)domainViolation0.getUUID()).isEqualTo((Object)"uuid");
        DomainViolation domainViolation1 = (DomainViolation)domainViolationIterator.next();
        Assertions.assertThat((Comparable)domainViolation1.getViolationType()).isEqualTo((Object)Violation.Type.WARNING);
        Assertions.assertThat((String)domainViolation1.getMessage()).contains(new CharSequence[]{"warn"});
        Assertions.assertThat((String)domainViolation1.getUUID()).isEqualTo((Object)"element-uuid");
        DomainViolation domainViolation2 = (DomainViolation)domainViolationIterator.next();
        Assertions.assertThat((Comparable)domainViolation2.getViolationType()).isEqualTo((Object)Violation.Type.INFO);
        Assertions.assertThat((String)domainViolation2.getMessage()).contains(new CharSequence[]{"info"});
        Assertions.assertThat((String)domainViolation2.getUUID()).isEqualTo((Object)"element-uuid");
    }

    private DMNMessage makeDMNMessage(DMNMessage.Severity severity, String text, DMNModelInstrumentedBase source) {
        return new DMNMessageImpl(severity, text, DMNMessageType.KIE_API, source);
    }
}

