/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.common;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.kie.workbench.common.dmn.backend.common.DMNImportTypesHelper;
import org.kie.workbench.common.dmn.backend.common.DMNPathsHelper;
import org.kie.workbench.common.dmn.backend.editors.included.query.AllModelsValueFileExtensionIndexTerm;
import org.kie.workbench.common.dmn.backend.editors.included.query.PMMLValueFileExtensionIndexTerm;
import org.kie.workbench.common.dmn.backend.editors.types.query.DMNValueFileExtensionIndexTerm;
import org.kie.workbench.common.dmn.backend.editors.types.query.DMNValueRepositoryRootIndexTerm;
import org.kie.workbench.common.dmn.backend.editors.types.query.FindAllDmnAssetsQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.RefactoringQueryServiceImpl;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRequest;
import org.uberfire.apache.commons.io.FilenameUtils;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class DMNPathsHelperImpl
implements DMNPathsHelper {
    static final String STANDALONE_URI = "default://master@system/stunner/diagrams";
    static final String STANDALONE_FILE_NAME = "diagrams";
    private final RefactoringQueryServiceImpl refactoringQueryService;
    private final DMNImportTypesHelper importTypesHelper;
    private final IOService ioService;

    public DMNPathsHelperImpl() {
        this(null, null, null);
    }

    @Inject
    public DMNPathsHelperImpl(RefactoringQueryServiceImpl refactoringQueryService, DMNImportTypesHelper importTypesHelper, @Named(value="ioStrategy") IOService ioService) {
        this.refactoringQueryService = refactoringQueryService;
        this.importTypesHelper = importTypesHelper;
        this.ioService = ioService;
    }

    @Override
    public List<org.uberfire.backend.vfs.Path> getModelsPaths(WorkspaceProject workspaceProject) {
        if (workspaceProject != null) {
            return this.getPathsByWorkspaceProject(this.modelsQueryTerms(workspaceProject.getRootPath().toURI()));
        }
        return this.getStandalonePaths(this.allModelsFilter());
    }

    @Override
    public List<org.uberfire.backend.vfs.Path> getDMNModelsPaths(WorkspaceProject workspaceProject) {
        if (workspaceProject != null) {
            return this.getPathsByWorkspaceProject(this.dmnQueryTerms(workspaceProject.getRootPath().toURI()));
        }
        return this.getStandalonePaths(this.dmnModelFilter());
    }

    @Override
    public List<org.uberfire.backend.vfs.Path> getPMMLModelsPaths(WorkspaceProject workspaceProject) {
        if (workspaceProject != null) {
            return this.getPathsByWorkspaceProject(this.pmmlQueryTerms(workspaceProject.getRootPath().toURI()));
        }
        return this.getStandalonePaths(this.pmmlDocumentFilter());
    }

    @Override
    public String getRelativeURI(org.uberfire.backend.vfs.Path dmnModelPath, org.uberfire.backend.vfs.Path includedModelPath) {
        Path nioIncluded;
        if (Objects.isNull(dmnModelPath)) {
            return includedModelPath.getFileName();
        }
        Path nioDMN = this.convertPath(this.normalizePath(dmnModelPath));
        Path nioRelative = nioDMN.relativize(nioIncluded = this.convertPath(this.normalizePath(includedModelPath)));
        String strRelative = FilenameUtils.separatorsToUnix((String)nioRelative.toString());
        if (strRelative.startsWith("../")) {
            return strRelative.substring(3);
        }
        return strRelative;
    }

    private List<org.uberfire.backend.vfs.Path> getPathsByWorkspaceProject(Set<ValueIndexTerm> queryTerms) {
        RefactoringPageRequest request = this.buildRequest(queryTerms);
        return this.refactoringQueryService.query(request).getPageRowList().stream().map(row -> (org.uberfire.backend.vfs.Path)row.getValue()).collect(Collectors.toList());
    }

    private RefactoringPageRequest buildRequest(Set<ValueIndexTerm> queryTerms) {
        return new RefactoringPageRequest(FindAllDmnAssetsQuery.NAME, queryTerms, 0, Integer.valueOf(1000), Boolean.TRUE);
    }

    private Set<ValueIndexTerm> modelsQueryTerms(String rootPath) {
        HashSet<ValueIndexTerm> queryTerms = new HashSet<ValueIndexTerm>();
        queryTerms.add(new DMNValueRepositoryRootIndexTerm(rootPath));
        queryTerms.add(new AllModelsValueFileExtensionIndexTerm());
        return queryTerms;
    }

    private Set<ValueIndexTerm> dmnQueryTerms(String rootPath) {
        HashSet<ValueIndexTerm> queryTerms = new HashSet<ValueIndexTerm>();
        queryTerms.add(new DMNValueRepositoryRootIndexTerm(rootPath));
        queryTerms.add(new DMNValueFileExtensionIndexTerm());
        return queryTerms;
    }

    private Set<ValueIndexTerm> pmmlQueryTerms(String rootPath) {
        HashSet<ValueIndexTerm> queryTerms = new HashSet<ValueIndexTerm>();
        queryTerms.add(new DMNValueRepositoryRootIndexTerm(rootPath));
        queryTerms.add(new PMMLValueFileExtensionIndexTerm());
        return queryTerms;
    }

    private List<org.uberfire.backend.vfs.Path> getStandalonePaths(DirectoryStream.Filter<Path> filter) {
        return StreamSupport.stream(this.getStandaloneModelPaths(filter).spliterator(), false).map(this::convertPath).collect(Collectors.toList());
    }

    DirectoryStream<Path> getStandaloneModelPaths(DirectoryStream.Filter<Path> filter) {
        Path root = this.getStandaloneRootPath();
        return this.ioService.newDirectoryStream(root, filter);
    }

    DirectoryStream.Filter<Path> allModelsFilter() {
        return path -> this.importTypesHelper.isDMN(this.convertPath((Path)path)) || this.importTypesHelper.isPMML(this.convertPath((Path)path));
    }

    DirectoryStream.Filter<Path> dmnModelFilter() {
        return path -> this.importTypesHelper.isDMN(this.convertPath((Path)path));
    }

    DirectoryStream.Filter<Path> pmmlDocumentFilter() {
        return path -> this.importTypesHelper.isPMML(this.convertPath((Path)path));
    }

    Path getStandaloneRootPath() {
        return this.convertPath(this.newPath(STANDALONE_FILE_NAME, STANDALONE_URI));
    }

    org.uberfire.backend.vfs.Path newPath(String fileName, String uri) {
        return PathFactory.newPath((String)fileName, (String)uri);
    }

    Path convertPath(org.uberfire.backend.vfs.Path path) {
        return Paths.convert((org.uberfire.backend.vfs.Path)path);
    }

    org.uberfire.backend.vfs.Path convertPath(Path path) {
        return Paths.convert((Path)path);
    }

    org.uberfire.backend.vfs.Path normalizePath(org.uberfire.backend.vfs.Path path) {
        return Paths.normalizePath((org.uberfire.backend.vfs.Path)path);
    }
}

