/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Scanner;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.filters.StringInputStream;
import org.apache.tools.ant.util.ReaderInputStream;
import org.assertj.core.api.Assertions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.errai.marshalling.server.MappingContextSingleton;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.ast.BusinessKnowledgeModelNode;
import org.kie.dmn.backend.marshalling.v1x.DMNMarshallerFactory;
import org.kie.dmn.core.util.DMNRuntimeUtil;
import org.kie.dmn.core.util.KieHelper;
import org.kie.dmn.model.api.Context;
import org.kie.dmn.model.api.ContextEntry;
import org.kie.dmn.model.api.DRGElement;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.FunctionKind;
import org.kie.dmn.model.api.InputClause;
import org.kie.dmn.model.api.InputData;
import org.kie.dmn.model.api.ItemDefinition;
import org.kie.dmn.model.api.LiteralExpression;
import org.kie.dmn.model.api.OutputClause;
import org.kie.dmn.model.api.dmndi.Bounds;
import org.kie.dmn.model.api.dmndi.Color;
import org.kie.dmn.model.api.dmndi.DMNEdge;
import org.kie.dmn.model.api.dmndi.DMNShape;
import org.kie.dmn.model.api.dmndi.DMNStyle;
import org.kie.dmn.model.api.dmndi.Point;
import org.kie.dmn.model.v1_2.TDecision;
import org.kie.dmn.model.v1_2.TInputData;
import org.kie.dmn.model.v1_2.TItemDefinition;
import org.kie.dmn.model.v1_2.TTextAnnotation;
import org.kie.workbench.common.dmn.api.DMNDefinitionSet;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.model.Association;
import org.kie.workbench.common.dmn.api.definition.model.AuthorityRequirement;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.DMNElement;
import org.kie.workbench.common.dmn.api.definition.model.DMNElementReference;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.Decision;
import org.kie.workbench.common.dmn.api.definition.model.DecisionService;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.model.ImportDMN;
import org.kie.workbench.common.dmn.api.definition.model.ImportPMML;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.api.definition.model.InformationRequirement;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeRequirement;
import org.kie.workbench.common.dmn.api.definition.model.KnowledgeSource;
import org.kie.workbench.common.dmn.api.definition.model.TextAnnotation;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.factory.DMNGraphFactoryImpl;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.backend.DMNMarshaller;
import org.kie.workbench.common.dmn.backend.common.DMNMarshallerImportsHelper;
import org.kie.workbench.common.dmn.backend.definition.v1_1.DecisionConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.InputDataConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.TextAnnotationConverter;
import org.kie.workbench.common.dmn.backend.producers.DMNMarshallerProducer;
import org.kie.workbench.common.stunner.core.backend.StunnerTestingGraphBackendAPI;
import org.kie.workbench.common.stunner.core.backend.service.XMLEncoderDiagramMetadataMarshaller;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.DiagramImpl;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;
import org.kie.workbench.common.stunner.core.graph.processing.index.GraphIndexBuilder;
import org.kie.workbench.common.stunner.core.graph.processing.index.map.MapIndexBuilder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.uuid.UUID;
import org.xml.sax.InputSource;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNMarshallerTest {
    private static final Logger LOG = LoggerFactory.getLogger(DMNMarshallerTest.class);
    private static final String DMN_DEF_SET_ID = BindableAdapterUtils.getDefinitionSetId(DMNDefinitionSet.class);
    @Mock
    private DMNMarshallerImportsHelper dmnMarshallerImportsHelper;
    private StunnerTestingGraphBackendAPI api;

    @Before
    public void setup() throws Exception {
        this.api = StunnerTestingGraphBackendAPI.build(DMNDefinitionSet.class);
        this.api.getFactoryManager().registry().register((Object)new DMNGraphFactoryImpl(this.api.getDefinitionManager(), this.api.getFactoryManager(), this.api.commandManager, this.api.commandFactory, (GraphIndexBuilder)new MapIndexBuilder()));
    }

    @Before
    public void doNotRunTestsOnIbmJdk() {
        String ibmVendorName = "IBM";
        String javaVendorPropertyKey = "java.vendor";
        Assume.assumeFalse((boolean)StringUtils.containsIgnoreCase((String)System.getProperty("java.vendor"), (String)"IBM"));
    }

    @Test
    public void testDynamicMarshallers() {
        MappingContextSingleton.loadDynamicMarshallers();
    }

    @Test
    public void testLoan() throws IOException {
        this.roundTripUnmarshalMarshalThenUnmarshalDMN(this.getClass().getResourceAsStream("/Loan Pre-Qualification.dmn"));
        DMNMarshaller m = this.getDMNMarshaller();
        Graph g = m.unmarshall(DMNMarshallerTest.createMetadata(), this.getClass().getResourceAsStream("/Loan Pre-Qualification.dmn"));
        DiagramImpl diagram = this.createDiagram();
        diagram.setGraph(g);
        String mString = m.marshall((Diagram)diagram);
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", "dmn-testLoan", "1.0"), (Resource[])new Resource[]{ks.getResources().newByteArrayResource(mString.getBytes()).setTargetPath("src/main/resources/Loan Pre-Qualification.dmn")});
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        Assert.assertNotNull((Object)runtime);
        DMNModel model = runtime.getModel("http://www.trisotech.com/definitions/_4e0a7f15-3176-427e-add8-68d30903c84c", "Loan Pre-Qualification");
        DMNContext dmnContext = runtime.newContext();
        dmnContext.set("Credit Score", (Object)new HashMap<String, Object>(){
            {
                this.put("FICO", 400);
            }
        });
        DMNResult dmnResult = runtime.evaluateByName(model, dmnContext, new String[]{"Credit Score Rating"});
        Assert.assertFalse((String)dmnResult.getMessages().toString(), (boolean)dmnResult.hasErrors());
    }

    @Test
    public void test_DecisionTableInputOutputClausesWhenEmpty() throws IOException {
        DMNRuntime runtime = this.roundTripUnmarshalMarshalThenUnmarshalDMN(this.getClass().getResourceAsStream("/qGslQdo2.dmn"));
        Assert.assertNotNull((Object)runtime);
        DMNModel model = runtime.getModel("https://github.com/kiegroup/drools/kie-dmn/_A2C75C01-7EAD-46B8-A499-D85D6C07D273", "_5FE8CBFD-821B-41F6-A6C7-42BE3FC45F2F");
        Assert.assertNotNull((Object)model);
        Assert.assertThat((Object)model.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        DMNContext dmnContext = runtime.newContext();
        dmnContext.set("my number", (Object)-99);
        DMNResult dmnResult = runtime.evaluateAll(model, dmnContext);
        LOG.debug("{}", (Object)dmnResult);
        Assert.assertThat((Object)dmnResult.hasErrors(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("my decision").getEvaluationStatus(), (Matcher)CoreMatchers.is((Object)DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED));
        Assert.assertThat((Object)dmnResult.getDecisionResultByName("my decision").getResult(), (Matcher)CoreMatchers.is((Object)"negative"));
        org.kie.dmn.model.api.DecisionTable dmnDT = (org.kie.dmn.model.api.DecisionTable)model.getDecisionByName("my decision").getDecision().getExpression();
        Assert.assertThat((Object)((InputClause)dmnDT.getInput().get(0)).getInputValues(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)((OutputClause)dmnDT.getOutput().get(0)).getOutputValues(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)((OutputClause)dmnDT.getOutput().get(0)).getDefaultOutputEntry(), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)((OutputClause)dmnDT.getOutput().get(0)).getName(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void test_diamond() throws IOException {
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/diamondDMN12.dmn"), this::checkDiamondGraph);
        DMNMarshaller m = this.getDMNMarshaller();
        Graph g = m.unmarshall(DMNMarshallerTest.createMetadata(), this.getClass().getResourceAsStream("/diamondDMN12.dmn"));
        DiagramImpl diagram = this.createDiagram();
        diagram.setGraph(g);
        String mString = m.marshall((Diagram)diagram);
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", "dmn-test_diamond", "1.0"), (Resource[])new Resource[]{ks.getResources().newByteArrayResource(mString.getBytes()).setTargetPath("src/main/resources/diamond.dmn")});
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        Assert.assertNotNull((Object)runtime);
        DMNModel diamondModel = runtime.getModel("http://www.trisotech.com/definitions/_8afa6c24-55c8-43cf-8a02-fdde7fc5d1f2", "three decisions in a diamond shape");
        DMNContext dmnContext = runtime.newContext();
        dmnContext.set("My Name", (Object)"John Doe");
        DMNResult dmnResult = runtime.evaluateAll(diamondModel, dmnContext);
        Assert.assertFalse((String)dmnResult.getMessages().toString(), (boolean)dmnResult.hasErrors());
        DMNContext result = dmnResult.getContext();
        Assert.assertEquals((Object)"Hello, John Doe.", (Object)result.get("My Decision"));
        org.kie.dmn.api.marshalling.DMNMarshaller dmnMarshaller = DMNMarshallerFactory.newDefaultMarshaller();
        Definitions definitions = dmnMarshaller.unmarshal(mString);
        org.kie.dmn.model.api.dmndi.DMNDiagram ddRoot = (org.kie.dmn.model.api.dmndi.DMNDiagram)definitions.getDMNDI().getDMNDiagram().get(0);
        DMNShape myname = DMNMarshallerTest.findShapeByDMNI(ddRoot, "_4cd17e52-6253-41d6-820d-5824bf5197f3");
        DMNMarshallerTest.assertBounds(500.0, 500.0, 100.0, 50.0, myname.getBounds());
        DMNMarshallerTest.assertColor(255, 255, 255, ((DMNStyle)myname.getStyle()).getFillColor());
        DMNMarshallerTest.assertColor(0, 0, 0, ((DMNStyle)myname.getStyle()).getStrokeColor());
        this.assertDMNStyle("Open Sans", 24.0, 255, 0, 0, (DMNStyle)myname.getStyle());
        DMNShape prefix = DMNMarshallerTest.findShapeByDMNI(ddRoot, "_e920f38a-293c-41b8-adb3-69d0dc184fab");
        DMNMarshallerTest.assertBounds(300.0, 400.0, 100.0, 50.0, prefix.getBounds());
        DMNMarshallerTest.assertColor(0, 253, 25, ((DMNStyle)prefix.getStyle()).getFillColor());
        DMNMarshallerTest.assertColor(253, 0, 0, ((DMNStyle)prefix.getStyle()).getStrokeColor());
        this.assertDMNStyle("Times New Roman", 8.0, 70, 60, 50, (DMNStyle)prefix.getStyle());
        DMNShape postfix = DMNMarshallerTest.findShapeByDMNI(ddRoot, "_f49f9c34-29d5-4e72-91d2-f4f92117c8da");
        DMNMarshallerTest.assertBounds(700.0, 400.0, 100.0, 50.0, postfix.getBounds());
        DMNMarshallerTest.assertColor(247, 255, 0, ((DMNStyle)postfix.getStyle()).getFillColor());
        DMNMarshallerTest.assertColor(0, 51, 255, ((DMNStyle)postfix.getStyle()).getStrokeColor());
        this.assertDMNStyle("Arial", 10.0, 50, 60, 70, (DMNStyle)postfix.getStyle());
        DMNShape mydecision = DMNMarshallerTest.findShapeByDMNI(ddRoot, "_9b061fc3-8109-42e2-9fe4-fc39c90b654e");
        DMNMarshallerTest.assertBounds(487.5, 275.0, 125.0, 75.0, mydecision.getBounds());
        DMNMarshallerTest.assertColor(255, 255, 255, ((DMNStyle)mydecision.getStyle()).getFillColor());
        DMNMarshallerTest.assertColor(0, 0, 0, ((DMNStyle)mydecision.getStyle()).getStrokeColor());
        this.assertDMNStyle("Monospaced", 32.0, 55, 66, 77, (DMNStyle)mydecision.getStyle());
    }

    private void assertDMNStyle(String fontName, double fontSize, int r, int g, int b, DMNStyle style) {
        Assert.assertEquals((Object)fontName, (Object)style.getFontFamily());
        Assert.assertEquals((double)fontSize, (double)style.getFontSize(), (double)0.0);
        DMNMarshallerTest.assertColor(r, g, b, style.getFontColor());
    }

    private static void assertBounds(double x, double y, double width, double height, Bounds bounds) {
        Assert.assertEquals((double)x, (double)bounds.getX(), (double)0.0);
        Assert.assertEquals((double)y, (double)bounds.getY(), (double)0.0);
        Assert.assertEquals((double)width, (double)bounds.getWidth(), (double)0.0);
        Assert.assertEquals((double)height, (double)bounds.getHeight(), (double)0.0);
    }

    private static void assertColor(int r, int g, int b, Color color) {
        Assert.assertEquals((long)r, (long)color.getRed());
        Assert.assertEquals((long)g, (long)color.getGreen());
        Assert.assertEquals((long)b, (long)color.getBlue());
    }

    private static DMNShape findShapeByDMNI(org.kie.dmn.model.api.dmndi.DMNDiagram root, String id) {
        return root.getDMNDiagramElement().stream().filter(DMNShape.class::isInstance).map(DMNShape.class::cast).filter(shape -> shape.getDmnElementRef().getLocalPart().equals(id)).findFirst().orElseThrow(() -> new UnsupportedOperationException("There is no DMNShape with id '" + id + "' in DMNDiagram " + root));
    }

    private static DMNEdge findEdgeByDMNI(org.kie.dmn.model.api.dmndi.DMNDiagram root, String id) {
        return root.getDMNDiagramElement().stream().filter(DMNEdge.class::isInstance).map(DMNEdge.class::cast).filter(shape -> shape.getDmnElementRef().getLocalPart().equals(id)).findFirst().orElseThrow(() -> new UnsupportedOperationException("There is no DMNEdge with id '" + id + "' in DMNDiagram " + root));
    }

    @Test
    public void test_potpourri_drawing() throws IOException {
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/potpourri_drawing.dmn"), this::checkPotpourriGraph);
    }

    @Test
    public void testAssociations() throws IOException {
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/associations.dmn"), this::checkAssociationsGraph);
    }

    @Test
    public void testTextAnnotation() throws Exception {
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/textAnnotation.dmn"), this::checkTextAnnotationGraph);
    }

    @Test
    public void testTextAnnotationWithCDATA() throws Exception {
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/textAnnotationCDATA.dmn"), this::checkTextAnnotationGraph);
    }

    @Test
    public void testDecisionWithContext() throws Exception {
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/DecisionWithContext.dmn"), this::checkDecisionWithContext);
    }

    @Test
    public void testDecisionWithContextWithDefaultResult() throws Exception {
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/DecisionWithContextWithDefaultResult.dmn"), this::checkDecisionWithContextWithDefaultResult);
    }

    @Test
    public void testDecisionWithContextWithoutDefaultResult() throws Exception {
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/DecisionWithContextWithoutDefaultResult.dmn"), this::checkDecisionWithContextWithoutDefaultResult);
    }

    @Test
    public void testEdgewaypoint() throws Exception {
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/edgewaypoint.dmn"), this::checkEdgewaypoint);
    }

    @Test
    public void test_decisionqa() throws IOException {
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/decisionqa.dmn"), this::checkDecisionqa);
    }

    @Test
    public void test_decisionservice_1outputDecision() throws IOException {
        DMNMarshaller m = this.getDMNMarshaller();
        Graph g = m.unmarshall(DMNMarshallerTest.createMetadata(), this.getClass().getResourceAsStream("/DROOLS-3372.dmn"));
        Node nodeDS = g.getNode("_659a06e2-ae80-496c-8783-f790a640bb49");
        Node nodeDecisionPostfix = g.getNode("_3a69915a-30af-4de3-a07f-6be514f53caa");
        this.moveNode(nodeDecisionPostfix, 0, -280);
        this.makeNodeChildOf(nodeDecisionPostfix, nodeDS);
        DiagramImpl diagram = this.createDiagram();
        diagram.setGraph(g);
        String mString = m.marshall((Diagram)diagram);
        LOG.debug("MARSHALLED ROUNDTRIP RESULTING xml:\n{}\n", (Object)mString);
        this.roundTripUnmarshalThenMarshalUnmarshal((InputStream)new ReaderInputStream((Reader)new StringReader(mString)), this::check_decisionservice_1outputDecision);
    }

    private void check_decisionservice_1outputDecision(Graph<?, Node<?, ?>> graph) {
        Node node = graph.getNode("_659a06e2-ae80-496c-8783-f790a640bb49");
        DMNMarshallerTest.assertNodeContentDefinitionIs(node, DecisionService.class);
        DecisionService definition = (DecisionService)((View)node.getContent()).getDefinition();
        Assert.assertEquals((long)0L, (long)definition.getEncapsulatedDecision().size());
        Assert.assertEquals((long)0L, (long)definition.getInputData().size());
        Assert.assertEquals((long)1L, (long)definition.getOutputDecision().size());
        Assert.assertEquals((Object)"#_3a69915a-30af-4de3-a07f-6be514f53caa", (Object)((DMNElementReference)definition.getOutputDecision().get(0)).getHref());
        Assert.assertEquals((long)1L, (long)definition.getInputDecision().size());
        Assert.assertEquals((Object)"#_afce4fb3-9a7c-4791-bbfe-63d4b76bd61a", (Object)((DMNElementReference)definition.getInputDecision().get(0)).getHref());
    }

    @Test
    public void test_decisionservice_1outputDecision1encapsulatedDecision() throws IOException {
        DMNMarshaller m = this.getDMNMarshaller();
        Graph g = m.unmarshall(DMNMarshallerTest.createMetadata(), this.getClass().getResourceAsStream("/DROOLS-3372.dmn"));
        Node nodeDS = g.getNode("_659a06e2-ae80-496c-8783-f790a640bb49");
        Node nodeDecisionPostfix = g.getNode("_3a69915a-30af-4de3-a07f-6be514f53caa");
        Node nodeDecisionPrefix = g.getNode("_afce4fb3-9a7c-4791-bbfe-63d4b76bd61a");
        this.moveNode(nodeDecisionPostfix, 0, -280);
        this.makeNodeChildOf(nodeDecisionPostfix, nodeDS);
        this.moveNode(nodeDecisionPrefix, 0, -170);
        this.makeNodeChildOf(nodeDecisionPrefix, nodeDS);
        DiagramImpl diagram = this.createDiagram();
        diagram.setGraph(g);
        String mString = m.marshall((Diagram)diagram);
        LOG.debug("MARSHALLED ROUNDTRIP RESULTING xml:\n{}\n", (Object)mString);
        this.roundTripUnmarshalThenMarshalUnmarshal((InputStream)new ReaderInputStream((Reader)new StringReader(mString)), this::check_decisionservice_1outputDecision1encapsulatedDecision);
    }

    private void check_decisionservice_1outputDecision1encapsulatedDecision(Graph<?, Node<?, ?>> graph) {
        Node node = graph.getNode("_659a06e2-ae80-496c-8783-f790a640bb49");
        DMNMarshallerTest.assertNodeContentDefinitionIs(node, DecisionService.class);
        DecisionService definition = (DecisionService)((View)node.getContent()).getDefinition();
        Assert.assertEquals((long)1L, (long)definition.getEncapsulatedDecision().size());
        Assert.assertEquals((Object)"#_afce4fb3-9a7c-4791-bbfe-63d4b76bd61a", (Object)((DMNElementReference)definition.getEncapsulatedDecision().get(0)).getHref());
        Assert.assertEquals((long)1L, (long)definition.getInputData().size());
        Assert.assertEquals((Object)"#_dd5b090f-6d52-4bd8-8c7f-0c469983d44e", (Object)((DMNElementReference)definition.getInputData().get(0)).getHref());
        Assert.assertEquals((long)1L, (long)definition.getOutputDecision().size());
        Assert.assertEquals((Object)"#_3a69915a-30af-4de3-a07f-6be514f53caa", (Object)((DMNElementReference)definition.getOutputDecision().get(0)).getHref());
        Assert.assertEquals((long)0L, (long)definition.getInputDecision().size());
    }

    @Test
    public void test_decisionservice2_1outputDecision1encapsulatedDecision() throws IOException {
        DMNMarshaller m = this.getDMNMarshaller();
        Graph g = m.unmarshall(DMNMarshallerTest.createMetadata(), this.getClass().getResourceAsStream("/DROOLS-3372bis.dmn"));
        Node nodeDS = g.getNode("_659a06e2-ae80-496c-8783-f790a640bb49");
        Node nodeDecisionPostfix = g.getNode("_3a69915a-30af-4de3-a07f-6be514f53caa");
        Node nodeDecisionPrefix = g.getNode("_afce4fb3-9a7c-4791-bbfe-63d4b76bd61a");
        this.moveNode(nodeDecisionPostfix, 0, -280);
        this.makeNodeChildOf(nodeDecisionPostfix, nodeDS);
        this.moveNode(nodeDecisionPrefix, 0, -170);
        this.makeNodeChildOf(nodeDecisionPrefix, nodeDS);
        DiagramImpl diagram = this.createDiagram();
        diagram.setGraph(g);
        String mString = m.marshall((Diagram)diagram);
        LOG.debug("MARSHALLED ROUNDTRIP RESULTING xml:\n{}\n", (Object)mString);
        this.roundTripUnmarshalThenMarshalUnmarshal((InputStream)new ReaderInputStream((Reader)new StringReader(mString)), this::check_decisionservice2_1outputDecision1encapsulatedDecision);
    }

    private void check_decisionservice2_1outputDecision1encapsulatedDecision(Graph<?, Node<?, ?>> graph) {
        Node node = graph.getNode("_659a06e2-ae80-496c-8783-f790a640bb49");
        DMNMarshallerTest.assertNodeContentDefinitionIs(node, DecisionService.class);
        DecisionService definition = (DecisionService)((View)node.getContent()).getDefinition();
        Assert.assertEquals((long)3L, (long)definition.getEncapsulatedDecision().size());
        Assert.assertEquals((Object)"#_ca9d65e7-a5fa-4a13-98b7-8404f4601147", (Object)((DMNElementReference)definition.getEncapsulatedDecision().get(0)).getHref());
        Assert.assertEquals((Object)"#_4b02cf97-5f9b-48ee-a4ae-229233238876", (Object)((DMNElementReference)definition.getEncapsulatedDecision().get(1)).getHref());
        Assert.assertEquals((Object)"#_afce4fb3-9a7c-4791-bbfe-63d4b76bd61a", (Object)((DMNElementReference)definition.getEncapsulatedDecision().get(2)).getHref());
        Assert.assertEquals((long)1L, (long)definition.getInputData().size());
        Assert.assertEquals((Object)"#_dd5b090f-6d52-4bd8-8c7f-0c469983d44e", (Object)((DMNElementReference)definition.getInputData().get(0)).getHref());
        Assert.assertEquals((long)3L, (long)definition.getOutputDecision().size());
        Assert.assertEquals((Object)"#_a5d0e474-083f-44ef-b00e-4ddc9a9ebd34", (Object)((DMNElementReference)definition.getOutputDecision().get(0)).getHref());
        Assert.assertEquals((Object)"#_8878539e-1c50-4622-b601-5878c97dc34e", (Object)((DMNElementReference)definition.getOutputDecision().get(1)).getHref());
        Assert.assertEquals((Object)"#_3a69915a-30af-4de3-a07f-6be514f53caa", (Object)((DMNElementReference)definition.getOutputDecision().get(2)).getHref());
        Assert.assertEquals((long)0L, (long)definition.getInputDecision().size());
    }

    @Test
    public void test_decisionservice2_remove_1outputDecision1encapsulatedDecision() throws IOException {
        DMNMarshaller m = this.getDMNMarshaller();
        Graph g = m.unmarshall(DMNMarshallerTest.createMetadata(), this.getClass().getResourceAsStream("/DROOLS-3372bis.dmn"));
        Node nodeDS = g.getNode("_659a06e2-ae80-496c-8783-f790a640bb49");
        Node nodeDecisionPostfix = g.getNode("_3a69915a-30af-4de3-a07f-6be514f53caa");
        Node nodeDecisionPrefix = g.getNode("_afce4fb3-9a7c-4791-bbfe-63d4b76bd61a");
        this.moveNode(nodeDecisionPostfix, 0, -280);
        this.makeNodeChildOf(nodeDecisionPostfix, nodeDS);
        this.moveNode(nodeDecisionPrefix, 0, -170);
        this.makeNodeChildOf(nodeDecisionPrefix, nodeDS);
        DiagramImpl diagram = this.createDiagram();
        Node nodeEncaps1 = g.getNode("_ca9d65e7-a5fa-4a13-98b7-8404f4601147");
        this.moveNode(nodeEncaps1, 0, 400);
        this.removeNodeChildOf(nodeEncaps1, nodeDS);
        Node nodeEncaps2 = g.getNode("_4b02cf97-5f9b-48ee-a4ae-229233238876");
        this.moveNode(nodeEncaps2, 0, 400);
        this.removeNodeChildOf(nodeEncaps2, nodeDS);
        Node nodeHardcoded2 = g.getNode("_8878539e-1c50-4622-b601-5878c97dc34e");
        this.moveNode(nodeHardcoded2, 0, 400);
        this.removeNodeChildOf(nodeHardcoded2, nodeDS);
        diagram.setGraph(g);
        String mString = m.marshall((Diagram)diagram);
        LOG.debug("MARSHALLED ROUNDTRIP RESULTING xml:\n{}\n", (Object)mString);
        this.roundTripUnmarshalThenMarshalUnmarshal((InputStream)new ReaderInputStream((Reader)new StringReader(mString)), this::check_decisionservice2_remove_1outputDecision1encapsulatedDecision);
    }

    private void removeNodeChildOf(Node<?, ?> childNode, Node<?, ?> nodeDS) {
        nodeDS.getOutEdges().removeIf(x -> {
            Edge edge = x;
            return edge.getContent() instanceof Child && edge.getTargetNode().equals(childNode);
        });
        childNode.getInEdges().removeIf(x -> {
            Edge edge = x;
            return edge.getContent() instanceof Child && edge.getSourceNode().equals(nodeDS);
        });
    }

    private void check_decisionservice2_remove_1outputDecision1encapsulatedDecision(Graph<?, Node<?, ?>> graph) {
        Node node = graph.getNode("_659a06e2-ae80-496c-8783-f790a640bb49");
        DMNMarshallerTest.assertNodeContentDefinitionIs(node, DecisionService.class);
        DecisionService definition = (DecisionService)((View)node.getContent()).getDefinition();
        Assert.assertEquals((long)1L, (long)definition.getEncapsulatedDecision().size());
        Assert.assertEquals((Object)"#_afce4fb3-9a7c-4791-bbfe-63d4b76bd61a", (Object)((DMNElementReference)definition.getEncapsulatedDecision().get(0)).getHref());
        Assert.assertEquals((long)1L, (long)definition.getInputData().size());
        Assert.assertEquals((Object)"#_dd5b090f-6d52-4bd8-8c7f-0c469983d44e", (Object)((DMNElementReference)definition.getInputData().get(0)).getHref());
        Assert.assertEquals((long)2L, (long)definition.getOutputDecision().size());
        Assert.assertEquals((Object)"#_a5d0e474-083f-44ef-b00e-4ddc9a9ebd34", (Object)((DMNElementReference)definition.getOutputDecision().get(0)).getHref());
        Assert.assertEquals((Object)"#_3a69915a-30af-4de3-a07f-6be514f53caa", (Object)((DMNElementReference)definition.getOutputDecision().get(1)).getHref());
        Assert.assertEquals((long)1L, (long)definition.getInputDecision().size());
        Assert.assertEquals((Object)"#_ca9d65e7-a5fa-4a13-98b7-8404f4601147", (Object)((DMNElementReference)definition.getInputDecision().get(0)).getHref());
    }

    private void makeNodeChildOf(Node nodeDecisionPostfix, Node nodeDS) {
        EdgeImpl myEdge = new EdgeImpl(UUID.uuid());
        myEdge.setContent((Object)new Child());
        myEdge.setSourceNode(nodeDS);
        myEdge.setTargetNode(nodeDecisionPostfix);
        nodeDS.getOutEdges().add(myEdge);
        nodeDecisionPostfix.getInEdges().add(myEdge);
    }

    private void moveNode(Node<?, ?> nodeDecisionPostfix, int dx, int dy) {
        View content = (View)nodeDecisionPostfix.getContent();
        Bound ul = content.getBounds().getUpperLeft();
        Bound lr = content.getBounds().getLowerRight();
        content.setBounds(org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)(ul.getX() + (double)dx), (double)(ul.getY() + (double)dy), (double)(lr.getX() + (double)dx), (double)(lr.getY() + (double)dy)));
    }

    @Test
    public void test_decisionservice3_evaluate() throws IOException {
        DMNRuntime dmnRuntime = this.roundTripUnmarshalMarshalThenUnmarshalDMN(this.getClass().getResourceAsStream("/DROOLS-3372evaluate.dmn"));
        Assertions.assertThat((List)dmnRuntime.getModels()).hasSize(1);
        DMNModel dmnModel = (DMNModel)dmnRuntime.getModels().get(0);
        DMNContext context = dmnRuntime.newContext();
        context.set("in1", (Object)"asd");
        DMNResult result = dmnRuntime.evaluateAll(dmnModel, context);
        Assertions.assertThat((Object)result.getDecisionResultByName("outInDS").getResult()).isEqualTo((Object)"outInDSasd");
        Assertions.assertThat((Object)result.getDecisionResultByName("out1").getResult()).isEqualTo((Object)"outInDSp1 outInDSin1");
    }

    @Test
    public void test_fontsize_stunner() throws IOException {
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/test-FontSize-stunner.dmn"), this::checkFontsize_stunner);
    }

    private void checkFontsize_stunner(Graph<?, Node<?, ?>> graph) {
        Node node = graph.getNode("_A9D510E0-1942-4945-A945-0213EC6AAEC5");
        DMNMarshallerTest.assertNodeContentDefinitionIs(node, org.kie.workbench.common.dmn.api.definition.model.InputData.class);
        org.kie.workbench.common.dmn.api.definition.model.InputData definition = (org.kie.workbench.common.dmn.api.definition.model.InputData)((View)node.getContent()).getDefinition();
        Assert.assertEquals((Object)21.0, (Object)definition.getFontSet().getFontSize().getValue());
    }

    @Test
    public void test_fontsize_sharedStyle() throws IOException {
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/test-FontSize-sharedStyle.dmn"), this::checkFontsize_sharedStyle);
    }

    private void checkFontsize_sharedStyle(Graph<?, Node<?, ?>> graph) {
        Node node = graph.getNode("_38b74e2e-32f8-42c5-ab51-8a3e927637e0");
        DMNMarshallerTest.assertNodeContentDefinitionIs(node, org.kie.workbench.common.dmn.api.definition.model.InputData.class);
        org.kie.workbench.common.dmn.api.definition.model.InputData definition = (org.kie.workbench.common.dmn.api.definition.model.InputData)((View)node.getContent()).getDefinition();
        Assert.assertEquals((Object)21.0, (Object)definition.getFontSet().getFontSize().getValue());
    }

    private void checkDecisionqa(Graph<?, Node<?, ?>> graph) {
        Node decision = graph.getNode("_7052d0f6-ccee-462b-bd89-76afc3b6f67b");
        DMNMarshallerTest.assertNodeContentDefinitionIs(decision, Decision.class);
        Decision decisionDefinition = (Decision)((View)decision.getContent()).getDefinition();
        Assert.assertEquals((Object)"hardcoded question", (Object)decisionDefinition.getName().getValue());
        Assert.assertEquals((Object)"What is the codename?", (Object)decisionDefinition.getQuestion().getValue());
        Assert.assertEquals((Object)"47.", (Object)decisionDefinition.getAllowedAnswers().getValue());
    }

    private void checkEdgewaypoint(Graph<?, Node<?, ?>> graph) {
        Node decision = graph.getNode("_7647e26b-6c7c-46db-aa34-1a1a2b4d8d79");
        DMNMarshallerTest.assertNodeContentDefinitionIs(decision, Decision.class);
        Decision decisionDefinition = (Decision)((View)decision.getContent()).getDefinition();
        Assert.assertEquals((Object)"my decision", (Object)decisionDefinition.getName().getValue());
        Node inputdata = graph.getNode("_fd528e66-e2a4-4b7f-aae1-c3ca6723d0cb");
        DMNMarshallerTest.assertNodeEdgesTo(inputdata, decision, InformationRequirement.class);
        List outEdges = inputdata.getOutEdges();
        Edge edge = outEdges.stream().filter(e -> e.getTargetNode().equals(decision)).findFirst().get();
        ViewConnector connectionContent = (ViewConnector)edge.getContent();
        Point2D sourceLocation = ((Connection)connectionContent.getSourceConnection().get()).getLocation();
        Assert.assertEquals((double)266.9968013763428, (double)(((View)inputdata.getContent()).getBounds().getUpperLeft().getX() + sourceLocation.getX()), (double)0.1);
        Assert.assertEquals((double)225.99999618530273, (double)(((View)inputdata.getContent()).getBounds().getUpperLeft().getY() + sourceLocation.getY()), (double)0.1);
        Point2D targetLocation = ((Connection)connectionContent.getTargetConnection().get()).getLocation();
        Assert.assertEquals((double)552.2411708831787, (double)(((View)decision.getContent()).getBounds().getUpperLeft().getX() + targetLocation.getX()), (double)0.1);
        Assert.assertEquals((double)226.0, (double)(((View)decision.getContent()).getBounds().getUpperLeft().getY() + targetLocation.getY()), (double)0.1);
        Assert.assertEquals((long)1L, (long)connectionContent.getControlPoints().length);
        Point2D controlPointLocation = connectionContent.getControlPoints()[0].getLocation();
        Assert.assertEquals((double)398.61898612976074, (double)controlPointLocation.getX(), (double)0.1);
        Assert.assertEquals((double)116.99999809265137, (double)controlPointLocation.getY(), (double)0.1);
        Connection sourceConnection = (Connection)connectionContent.getSourceConnection().get();
        Assert.assertTrue((boolean)(sourceConnection instanceof MagnetConnection));
        Assert.assertTrue((boolean)((MagnetConnection)sourceConnection).isAuto());
        Connection targetConnection = (Connection)connectionContent.getTargetConnection().get();
        Assert.assertTrue((boolean)(targetConnection instanceof MagnetConnection));
        Assert.assertTrue((boolean)((MagnetConnection)targetConnection).isAuto());
    }

    private void checkTextAnnotationGraph(Graph<?, Node<?, ?>> graph) {
        Node textAnnotation = graph.getNode("60915990-9E1D-42DF-B7F6-0D28383BE9D1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(textAnnotation, TextAnnotation.class);
        TextAnnotation textAnnotationDefinition = (TextAnnotation)((View)textAnnotation.getContent()).getDefinition();
        Assert.assertEquals((Object)"\u63cf\u8ff0", (Object)textAnnotationDefinition.getDescription().getValue());
        Assert.assertEquals((Object)"<b>This Annotation holds some Long text and also UTF-8 characters</b>", (Object)textAnnotationDefinition.getText().getValue());
        Assert.assertEquals((Object)"text/html", (Object)textAnnotationDefinition.getTextFormat().getValue());
    }

    public void testTreeStructure() throws IOException {
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/treeStructure.dmn"), this::checkTreeStructureGraph);
    }

    public void roundTripUnmarshalThenMarshalUnmarshal(InputStream dmnXmlInputStream, Consumer<Graph<?, Node<?, ?>>> checkGraphConsumer) throws IOException {
        DMNMarshaller m = this.getDMNMarshaller();
        Graph g = m.unmarshall(DMNMarshallerTest.createMetadata(), dmnXmlInputStream);
        checkGraphConsumer.accept(g);
        DiagramImpl diagram = this.createDiagram();
        diagram.setGraph(g);
        String mString = m.marshall((Diagram)diagram);
        LOG.debug(mString);
        Graph g2 = m.unmarshall(DMNMarshallerTest.createMetadata(), (InputStream)new StringInputStream(mString));
        checkGraphConsumer.accept(g2);
    }

    private void checkTreeStructureGraph(Graph<?, Node<?, ?>> graph) {
        Node root = graph.getNode("BBF2B56F-A0AF-4428-AA6A-61A655D72883");
        Node decisionOne = graph.getNode("B7DD0DC9-7FAC-4510-9031-FFEE067CC2F5");
        Node decisionTwo = graph.getNode("DF84B353-A2F6-46B9-B680-EBD98F5084C8");
        Node decisionThree = graph.getNode("1B6EF5EB-CA09-45A5-AB03-21CD70F941AD");
        Node bkmRoot = graph.getNode("AD910446-56AD-49A5-99CE-F7B9C6F74E5E");
        Node bkmOne = graph.getNode("C1D0937E-96F4-4EAF-8A85-45B129F38E9B");
        Node bkmTwo = graph.getNode("47E47E51-4509-4A3B-86E9-D690F397B69C");
        Node annotation = graph.getNode("47C5A244-EF6D-473D-99B6-629F70A49FCC");
        Node knowledgeSource = graph.getNode("CFE44FA9-7309-4F28-81E9-5C1EF455B4C2");
        Node knowledgeSourceInput = graph.getNode("BC0D715A-ADD4-4136-AB3D-226EABC840A2");
        Node decisionOneInput = graph.getNode("CF65CEB9-433F-402F-A485-90AC34E2FE39");
        DMNMarshallerTest.assertNodeEdgesTo(decisionOne, root, InformationRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(decisionTwo, decisionOne, InformationRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(decisionThree, decisionOne, InformationRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(bkmRoot, annotation, Association.class);
        DMNMarshallerTest.assertNodeEdgesTo(bkmRoot, decisionOne, KnowledgeRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(bkmOne, bkmRoot, KnowledgeRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(bkmTwo, bkmRoot, KnowledgeRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(decisionOneInput, decisionOne, InformationRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(knowledgeSource, decisionOne, AuthorityRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(knowledgeSourceInput, knowledgeSource, AuthorityRequirement.class);
    }

    private void checkDecisionWithContext(Graph<?, Node<?, ?>> g) {
        Node decisionNode = g.getNode("_30810b88-8416-4c02-8ed1-8c19b7606243");
        DMNMarshallerTest.assertNodeContentDefinitionIs(decisionNode, Decision.class);
        Node rootNode = DMNMarshaller.findDMNDiagramRoot(g);
        Assert.assertNotNull((Object)rootNode);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, decisionNode);
        Assert.assertEquals((String)"decisionNode parent is Definitions DMN root", (Object)"_153e2b47-3bd2-4db0-828c-db3fce0b3199", (Object)((DMNElement)((Decision)((View)decisionNode.getContent()).getDefinition()).getParent()).getId().getValue());
        org.kie.workbench.common.dmn.api.definition.model.Context context = (org.kie.workbench.common.dmn.api.definition.model.Context)((Decision)((View)decisionNode.getContent()).getDefinition()).getExpression();
        Assert.assertEquals((String)"contextNode's parent is decisionNode", (Object)"_30810b88-8416-4c02-8ed1-8c19b7606243", (Object)((DMNElement)context.getParent()).getId().getValue());
        Expression literalExpression1 = ((org.kie.workbench.common.dmn.api.definition.model.ContextEntry)context.getContextEntry().get(0)).getExpression();
        Assert.assertEquals((String)"literalExpression1's parent-parent is contextNode", (Object)"_0f38d114-5d6e-40dd-aa9c-9f031f9b0571", (Object)((DMNElement)literalExpression1.getParent().getParent()).getId().getValue());
        Expression literalExpression2 = ((org.kie.workbench.common.dmn.api.definition.model.ContextEntry)context.getContextEntry().get(1)).getExpression();
        Assert.assertEquals((String)"literalExpression2's parent-parent is contextNode", (Object)"_0f38d114-5d6e-40dd-aa9c-9f031f9b0571", (Object)((DMNElement)literalExpression2.getParent().getParent()).getId().getValue());
    }

    private void checkDecisionWithContextWithDefaultResult(Graph<?, Node<?, ?>> g) {
        Node decisionNode = g.getNode("_30810b88-8416-4c02-8ed1-8c19b7606243");
        DMNMarshallerTest.assertNodeContentDefinitionIs(decisionNode, Decision.class);
        org.kie.workbench.common.dmn.api.definition.model.Context context = (org.kie.workbench.common.dmn.api.definition.model.Context)((Decision)((View)decisionNode.getContent()).getDefinition()).getExpression();
        InformationItem defaultResultVariable = ((org.kie.workbench.common.dmn.api.definition.model.ContextEntry)context.getContextEntry().get(1)).getVariable();
        Assert.assertNull((String)"Default result variable", (Object)defaultResultVariable);
        Expression defaultResultExpression = ((org.kie.workbench.common.dmn.api.definition.model.ContextEntry)context.getContextEntry().get(1)).getExpression();
        Assert.assertNotNull((String)"Default result expression", (Object)defaultResultExpression);
        Assert.assertEquals((String)"defaultResultExpression's parent-parent is contextNode", (Object)"_0f38d114-5d6e-40dd-aa9c-9f031f9b0571", (Object)((DMNElement)defaultResultExpression.getParent().getParent()).getId().getValue());
    }

    private void checkDecisionWithContextWithoutDefaultResult(Graph<?, Node<?, ?>> g) {
        Node decisionNode = g.getNode("_30810b88-8416-4c02-8ed1-8c19b7606243");
        DMNMarshallerTest.assertNodeContentDefinitionIs(decisionNode, Decision.class);
        org.kie.workbench.common.dmn.api.definition.model.Context context = (org.kie.workbench.common.dmn.api.definition.model.Context)((Decision)((View)decisionNode.getContent()).getDefinition()).getExpression();
        InformationItem defaultResultVariable = ((org.kie.workbench.common.dmn.api.definition.model.ContextEntry)context.getContextEntry().get(1)).getVariable();
        Assert.assertNull((String)"Default result variable", (Object)defaultResultVariable);
        Expression defaultResultExpression = ((org.kie.workbench.common.dmn.api.definition.model.ContextEntry)context.getContextEntry().get(1)).getExpression();
        Assert.assertNull((String)"Default result expression", (Object)defaultResultExpression);
    }

    private void checkDiamondGraph(Graph<?, Node<?, ?>> g) {
        Node idNode = g.getNode("_4cd17e52-6253-41d6-820d-5824bf5197f3");
        DMNMarshallerTest.assertNodeContentDefinitionIs(idNode, org.kie.workbench.common.dmn.api.definition.model.InputData.class);
        DMNMarshallerTest.assertNodeEdgesTo(idNode, g.getNode("_e920f38a-293c-41b8-adb3-69d0dc184fab"), InformationRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(idNode, g.getNode("_f49f9c34-29d5-4e72-91d2-f4f92117c8da"), InformationRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(idNode, g.getNode("_9b061fc3-8109-42e2-9fe4-fc39c90b654e"), InformationRequirement.class);
        Node prefixDecisionNode = g.getNode("_e920f38a-293c-41b8-adb3-69d0dc184fab");
        DMNMarshallerTest.assertNodeContentDefinitionIs(prefixDecisionNode, Decision.class);
        DMNMarshallerTest.assertNodeEdgesTo(prefixDecisionNode, g.getNode("_9b061fc3-8109-42e2-9fe4-fc39c90b654e"), InformationRequirement.class);
        Node postfixDecisionNode = g.getNode("_f49f9c34-29d5-4e72-91d2-f4f92117c8da");
        DMNMarshallerTest.assertNodeContentDefinitionIs(postfixDecisionNode, Decision.class);
        DMNMarshallerTest.assertNodeEdgesTo(postfixDecisionNode, g.getNode("_9b061fc3-8109-42e2-9fe4-fc39c90b654e"), InformationRequirement.class);
        Node myDecisionNode = g.getNode("_9b061fc3-8109-42e2-9fe4-fc39c90b654e");
        DMNMarshallerTest.assertNodeContentDefinitionIs(myDecisionNode, Decision.class);
        Node rootNode = DMNMarshaller.findDMNDiagramRoot(g);
        Assert.assertNotNull((Object)rootNode);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, idNode);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, prefixDecisionNode);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, postfixDecisionNode);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, myDecisionNode);
    }

    private void checkAssociationsGraph(Graph<?, Node<?, ?>> g) {
        Node inputData = g.getNode("BD168F8B-4398-4478-8BEA-E67AA5F90FAF");
        DMNMarshallerTest.assertNodeContentDefinitionIs(inputData, org.kie.workbench.common.dmn.api.definition.model.InputData.class);
        Node decision = g.getNode("A960E2D2-FBC1-4D11-AA33-064F6A0B5CB9");
        DMNMarshallerTest.assertNodeContentDefinitionIs(decision, Decision.class);
        Node knowledgeSource = g.getNode("FB99ED65-BC43-4750-999F-7FE24690845B");
        DMNMarshallerTest.assertNodeContentDefinitionIs(knowledgeSource, KnowledgeSource.class);
        Node bkm = g.getNode("2F07453C-854F-436F-8378-4CFCE63BB124");
        DMNMarshallerTest.assertNodeContentDefinitionIs(bkm, BusinessKnowledgeModel.class);
        Node textAnnotation = g.getNode("7F4B8130-6F3D-4A16-9F6C-01D01DA481D2");
        DMNMarshallerTest.assertNodeContentDefinitionIs(textAnnotation, TextAnnotation.class);
        Edge<?, ?> fromInput = DMNMarshallerTest.assertNodeEdgesTo(inputData, textAnnotation, Association.class);
        Assert.assertEquals((Object)"From Input", (Object)((Association)((View)fromInput.getContent()).getDefinition()).getDescription().getValue());
        Edge<?, ?> fromDecision = DMNMarshallerTest.assertNodeEdgesTo(decision, textAnnotation, Association.class);
        Assert.assertEquals((Object)"From Decision", (Object)((Association)((View)fromDecision.getContent()).getDefinition()).getDescription().getValue());
        Edge<?, ?> fromBkm = DMNMarshallerTest.assertNodeEdgesTo(bkm, textAnnotation, Association.class);
        Assert.assertEquals((Object)"From BKM", (Object)((Association)((View)fromBkm.getContent()).getDefinition()).getDescription().getValue());
        Edge<?, ?> fromKnowledgeSource = DMNMarshallerTest.assertNodeEdgesTo(knowledgeSource, textAnnotation, Association.class);
        Assert.assertEquals((Object)"From Knowledge Source", (Object)((Association)((View)fromKnowledgeSource.getContent()).getDefinition()).getDescription().getValue());
    }

    private void checkPotpourriGraph(Graph<?, Node<?, ?>> g) {
        Node _My_Input_Data = g.getNode("_My_Input_Data");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_My_Input_Data, org.kie.workbench.common.dmn.api.definition.model.InputData.class);
        DMNMarshallerTest.assertNodeEdgesTo(_My_Input_Data, g.getNode("_My_Decision_1"), InformationRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(_My_Input_Data, g.getNode("_KS_of_Input_Data"), AuthorityRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(_My_Input_Data, g.getNode("_Annotation_for_Input_Data"), Association.class);
        Node _Annotation_for_Input_Data = g.getNode("_Annotation_for_Input_Data");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_Annotation_for_Input_Data, TextAnnotation.class);
        Node _KS_of_Input_Data = g.getNode("_KS_of_Input_Data");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_Input_Data, KnowledgeSource.class);
        Node _KS_of_KS_of_InputData = g.getNode("_KS_of_KS_of_InputData");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_KS_of_InputData, KnowledgeSource.class);
        DMNMarshallerTest.assertNodeEdgesTo(_KS_of_KS_of_InputData, g.getNode("_KS_of_Input_Data"), AuthorityRequirement.class);
        Node _KS_of_KS_of_Decision_1 = g.getNode("_KS_of_KS_of_Decision_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_KS_of_Decision_1, KnowledgeSource.class);
        DMNMarshallerTest.assertNodeEdgesTo(_KS_of_KS_of_Decision_1, g.getNode("_KS_of_Decision_1"), AuthorityRequirement.class);
        Node _KS_of_Decision_1 = g.getNode("_KS_of_Decision_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_Decision_1, KnowledgeSource.class);
        DMNMarshallerTest.assertNodeEdgesTo(_KS_of_Decision_1, g.getNode("_My_Decision_1"), AuthorityRequirement.class);
        Node _My_Decision_2 = g.getNode("_My_Decision_2");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_My_Decision_2, Decision.class);
        DMNMarshallerTest.assertNodeEdgesTo(_My_Decision_2, g.getNode("_KS_of_Decision_2"), AuthorityRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(_My_Decision_2, g.getNode("_Annotation_for_Decision_2"), Association.class);
        Node _KS_of_Decision_2 = g.getNode("_KS_of_Decision_2");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_Decision_2, KnowledgeSource.class);
        Node _Annotation_for_Decision_2 = g.getNode("_Annotation_for_Decision_2");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_Annotation_for_Decision_2, TextAnnotation.class);
        Node _Annotation_for_BKM_1 = g.getNode("_Annotation_for_BKM_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_Annotation_for_BKM_1, TextAnnotation.class);
        DMNMarshallerTest.assertNodeEdgesTo(_Annotation_for_BKM_1, g.getNode("_My_BKM_1_of_Decision_1"), Association.class);
        Node _My_BKM_1_of_Decision_1 = g.getNode("_My_BKM_1_of_Decision_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_My_BKM_1_of_Decision_1, BusinessKnowledgeModel.class);
        DMNMarshallerTest.assertNodeEdgesTo(_My_BKM_1_of_Decision_1, g.getNode("_My_Decision_1"), KnowledgeRequirement.class);
        Node _KS_of_BKM_1 = g.getNode("_KS_of_BKM_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_BKM_1, KnowledgeSource.class);
        DMNMarshallerTest.assertNodeEdgesTo(_KS_of_BKM_1, g.getNode("_My_BKM_1_of_Decision_1"), AuthorityRequirement.class);
        Node _KS_of_KS_of_BKM_1 = g.getNode("_KS_of_KS_of_BKM_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_KS_of_BKM_1, KnowledgeSource.class);
        DMNMarshallerTest.assertNodeEdgesTo(_KS_of_KS_of_BKM_1, g.getNode("_KS_of_BKM_1"), AuthorityRequirement.class);
        Node _My_BKM_2_of_BKM_1 = g.getNode("_My_BKM_2_of_BKM_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_My_BKM_2_of_BKM_1, BusinessKnowledgeModel.class);
        DMNMarshallerTest.assertNodeEdgesTo(_My_BKM_2_of_BKM_1, g.getNode("_My_BKM_1_of_Decision_1"), KnowledgeRequirement.class);
        Node _KS_of_BKM_2 = g.getNode("_KS_of_BKM_2");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_BKM_2, KnowledgeSource.class);
        DMNMarshallerTest.assertNodeEdgesTo(_KS_of_BKM_2, g.getNode("_My_BKM_2_of_BKM_1"), AuthorityRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(_KS_of_BKM_2, g.getNode("_Annotation_for_KS_of_BKM_2"), Association.class);
        Node _Annotation_for_KS_of_BKM_2 = g.getNode("_Annotation_for_KS_of_BKM_2");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_Annotation_for_KS_of_BKM_2, TextAnnotation.class);
        Node _My_Decision_1 = g.getNode("_My_Decision_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_My_Decision_1, Decision.class);
        Node rootNode = DMNMarshaller.findDMNDiagramRoot(g);
        Assert.assertNotNull((Object)rootNode);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _My_Input_Data);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _Annotation_for_Input_Data);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_Input_Data);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_KS_of_InputData);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_KS_of_Decision_1);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_Decision_1);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _My_Decision_2);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_Decision_2);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _Annotation_for_Decision_2);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _Annotation_for_BKM_1);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _My_BKM_1_of_Decision_1);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_BKM_1);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_KS_of_BKM_1);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _My_BKM_2_of_BKM_1);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_BKM_2);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _Annotation_for_KS_of_BKM_2);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _My_Decision_1);
    }

    private static void assertRootNodeConnectedTo(Node<?, ?> rootNode, Node<?, ?> to) {
        List outEdges = rootNode.getOutEdges();
        Optional<Edge> optEdge = outEdges.stream().filter(e -> e.getTargetNode().equals(to)).findFirst();
        Assert.assertTrue((boolean)optEdge.isPresent());
        Edge edge = optEdge.get();
        Assert.assertTrue((boolean)(edge.getContent() instanceof Child));
        Assert.assertTrue((boolean)to.getInEdges().contains(edge));
    }

    private static Edge<?, ?> assertNodeEdgesTo(Node<?, ?> from, Node<?, ?> to, Class<?> clazz) {
        List outEdges = from.getOutEdges();
        Optional<Edge> optEdge = outEdges.stream().filter(e -> e.getTargetNode().equals(to)).findFirst();
        Assert.assertTrue((boolean)optEdge.isPresent());
        Edge edge = optEdge.get();
        Assert.assertTrue((boolean)(edge.getContent() instanceof View));
        Assert.assertTrue((boolean)clazz.isInstance(((View)edge.getContent()).getDefinition()));
        Assert.assertTrue((boolean)to.getInEdges().contains(edge));
        ViewConnector connectionContent = (ViewConnector)edge.getContent();
        Assert.assertTrue((boolean)connectionContent.getSourceConnection().isPresent());
        Assert.assertTrue((boolean)connectionContent.getTargetConnection().isPresent());
        return edge;
    }

    private static void assertNodeContentDefinitionIs(Node<?, ?> node, Class<?> clazz) {
        Assert.assertTrue((boolean)(node.getContent() instanceof View));
        Assert.assertTrue((boolean)clazz.isInstance(((View)node.getContent()).getDefinition()));
    }

    @Test
    public void test_Simple_structured_context() throws IOException {
        DMNRuntime runtime = this.roundTripUnmarshalMarshalThenUnmarshalDMN(this.getClass().getResourceAsStream("/Simple_structured_context.dmn"));
        DMNModel dmnModel = (DMNModel)runtime.getModels().get(0);
        DMNContext dmnContext = runtime.newContext();
        dmnContext.set("Input Name", (Object)"John Doe");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, dmnContext);
        Assert.assertFalse((String)dmnResult.getMessages().toString(), (boolean)dmnResult.hasErrors());
        DMNContext result = dmnResult.getContext();
        Assert.assertEquals((Object)"Hello, John Doe!", (Object)result.get("Decision Logic 1"));
    }

    private DMNRuntime roundTripUnmarshalMarshalThenUnmarshalDMN(InputStream dmnXmlInputStream) throws IOException {
        String xml = null;
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(dmnXmlInputStream));){
            xml = buffer.lines().collect(Collectors.joining("\n"));
        }
        catch (Exception e) {
            throw new RuntimeException("test utily method roundTripUnmarshalMarshalThenUnmarshalDMN failed to read XML content.", e);
        }
        LOG.debug("ORIGINAL xml:\n{}\n", (Object)xml);
        DMNRuntime runtime0 = DMNMarshallerTest.dmnRuntimeFromDMNXML(xml);
        Assert.assertEquals((String)"The DMN XML file contains compilation error. If this was intentional use test method roundTripUnmarshalMarshalThenUnmarshalDMNexpectingErrors", (long)0L, (long)((DMNModel)runtime0.getModels().get(0)).getMessages(new DMNMessage.Severity[]{DMNMessage.Severity.ERROR}).size());
        DMNMarshaller m = this.getDMNMarshaller();
        Graph g = m.unmarshall(DMNMarshallerTest.createMetadata(), (InputStream)new ReaderInputStream((Reader)new StringReader(xml)));
        DiagramImpl diagram = this.createDiagram();
        diagram.setGraph(g);
        String mString = m.marshall((Diagram)diagram);
        LOG.debug("MARSHALLED ROUNDTRIP RESULTING xml:\n{}\n", (Object)mString);
        DMNRuntime runtime = DMNMarshallerTest.dmnRuntimeFromDMNXML(mString);
        Assert.assertTrue((((DMNModel)runtime.getModels().get(0)).getMessages(new DMNMessage.Severity[]{DMNMessage.Severity.ERROR}).size() == 0 ? 1 : 0) != 0);
        return runtime;
    }

    private static DMNRuntime dmnRuntimeFromDMNXML(String mString) {
        KieServices ks = KieServices.Factory.get();
        String uuid = UUID.uuid((int)8);
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", uuid, "1.0"), (Resource[])new Resource[]{ks.getResources().newByteArrayResource(mString.getBytes()).setTargetPath("src/main/resources/" + uuid + ".dmn")});
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        Assert.assertNotNull((Object)runtime);
        Assert.assertFalse((boolean)runtime.getModels().isEmpty());
        return runtime;
    }

    private ErrorsAndDMNModelAsSerialized roundTripUnmarshalMarshalThenUnmarshalDMNexpectingErrors(InputStream dmnXmlInputStream) throws IOException {
        String xml = null;
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(dmnXmlInputStream));){
            xml = buffer.lines().collect(Collectors.joining("\n"));
        }
        catch (Exception e) {
            throw new RuntimeException("test utility method roundTripUnmarshalMarshalThenUnmarshalDMN failed to read XML content.", e);
        }
        LOG.debug("ORIGINAL xml:\n{}\n", (Object)xml);
        List<Message> messages0 = DMNMarshallerTest.kieBuilderMessagesUsingDMNXML(xml);
        Assert.assertTrue((String)"The DMN XML content did NOT result in compilation errors and this test method expected errors to be detected. If this was intentional use test method roundTripUnmarshalMarshalThenUnmarshalDMN", (messages0.stream().filter(m -> m.getLevel().equals((Object)Message.Level.ERROR)).count() > 0L ? 1 : 0) != 0);
        DMNMarshaller m2 = this.getDMNMarshaller();
        Graph g = m2.unmarshall(DMNMarshallerTest.createMetadata(), (InputStream)new ReaderInputStream((Reader)new StringReader(xml)));
        DiagramImpl diagram = this.createDiagram();
        diagram.setGraph(g);
        String mString = m2.marshall((Diagram)diagram);
        LOG.debug("MARSHALLED ROUNDTRIP RESULTING xml:\n{}\n", (Object)mString);
        List<Message> result = DMNMarshallerTest.kieBuilderMessagesUsingDMNXML(mString);
        Assert.assertTrue((String)"The DMN XML content did NOT result in compilation errors and this test method expected errors to be detected. If this was intentional use test method roundTripUnmarshalMarshalThenUnmarshalDMN", (messages0.stream().filter(msg -> msg.getLevel().equals((Object)Message.Level.ERROR)).count() > 0L ? 1 : 0) != 0);
        Definitions definitions = DMNMarshallerFactory.newDefaultMarshaller().unmarshal(mString);
        return new ErrorsAndDMNModelAsSerialized(result, definitions);
    }

    private static List<Message> kieBuilderMessagesUsingDMNXML(String mString) {
        KieServices ks = KieServices.Factory.get();
        String uuid = UUID.uuid((int)8);
        KieContainer kieContainer = DMNRuntimeUtil.getKieContainerIgnoringErrors((ReleaseId)ks.newReleaseId("org.kie", uuid, "1.0"), (Resource[])new Resource[]{ks.getResources().newByteArrayResource(mString.getBytes()).setTargetPath("src/main/resources/" + uuid + ".dmn")});
        Results verify = kieContainer.verify();
        List kie_messages = verify.getMessages();
        LOG.debug("{}", (Object)kie_messages);
        return kie_messages;
    }

    @Test
    public void test_relation_literal_expression() throws IOException {
        DMNRuntime runtime = this.roundTripUnmarshalMarshalThenUnmarshalDMN(this.getClass().getResourceAsStream("/hardcoded_relation_and_literal_expression.dmn"));
        DMNModel dmnModel = (DMNModel)runtime.getModels().get(0);
        DMNContext dmnContext = runtime.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, dmnContext);
        Assert.assertFalse((String)dmnResult.getMessages().toString(), (boolean)dmnResult.hasErrors());
        DMNContext result = dmnResult.getContext();
        Object hardCodedRelation = result.get("hardcoded relation");
        Assert.assertNotNull((Object)hardCodedRelation);
        Assert.assertEquals((long)3L, (long)((Collection)hardCodedRelation).size());
        DMNDecisionResult adultResult = dmnResult.getDecisionResultByName("Adults");
        Assert.assertEquals((Object)DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED, (Object)adultResult.getEvaluationStatus());
        Assert.assertEquals((long)1L, (long)((Collection)adultResult.getResult()).size());
    }

    @Test
    public void test_invocation() throws IOException {
        DMNRuntime runtime = this.roundTripUnmarshalMarshalThenUnmarshalDMN(this.getClass().getResourceAsStream("/hardcoded_invokation.dmn"));
        DMNModel dmnModel = (DMNModel)runtime.getModels().get(0);
        DMNContext dmnContext = runtime.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, dmnContext);
        Assert.assertFalse((String)dmnResult.getMessages().toString(), (boolean)dmnResult.hasErrors());
        DMNDecisionResult adultResult = dmnResult.getDecisionResultByName("hardcoded invokation");
        Assert.assertEquals((Object)DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED, (Object)adultResult.getEvaluationStatus());
        Assert.assertEquals((Object)new BigDecimal(11), (Object)adultResult.getResult());
    }

    @Test
    public void test_function_definition_and_invocation() throws IOException {
        DMNRuntime runtime = this.roundTripUnmarshalMarshalThenUnmarshalDMN(this.getClass().getResourceAsStream("/hardcoded_function_definition.dmn"));
        DMNModel dmnModel = (DMNModel)runtime.getModels().get(0);
        DMNContext emptyContext = runtime.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        Assert.assertFalse((String)dmnResult.getMessages().toString(), (boolean)dmnResult.hasErrors());
        DMNDecisionResult adultResult = dmnResult.getDecisionResultByName("hardcoded decision");
        Assert.assertEquals((Object)DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED, (Object)adultResult.getEvaluationStatus());
        Assert.assertEquals((long)47L, (long)((BigDecimal)adultResult.getResult()).intValue());
    }

    @Test
    public void test_function_java_WB_model() throws IOException {
        DMNMarshaller m = this.getDMNMarshaller();
        Graph g = m.unmarshall(DMNMarshallerTest.createMetadata(), this.getClass().getResourceAsStream("/DROOLS-2372.dmn"));
        Stream<Node> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(g.nodes().iterator(), 16), false);
        Optional<Decision> wbDecision = stream.filter(n -> n.getContent() instanceof ViewImpl).map(n -> (ViewImpl)n.getContent()).filter(n -> n.getDefinition() instanceof Decision).map(n -> (Decision)n.getDefinition()).findFirst();
        wbDecision.ifPresent(d -> {
            Assert.assertTrue((boolean)(d.getExpression() instanceof FunctionDefinition));
            FunctionDefinition wbFunction = (FunctionDefinition)d.getExpression();
            Assert.assertEquals((Object)FunctionDefinition.Kind.JAVA, (Object)wbFunction.getKind());
        });
        DMNRuntime runtime = this.roundTripUnmarshalMarshalThenUnmarshalDMN(this.getClass().getResourceAsStream("/DROOLS-2372.dmn"));
        DMNModel dmnModel = (DMNModel)runtime.getModels().get(0);
        BusinessKnowledgeModelNode bkmNode = (BusinessKnowledgeModelNode)dmnModel.getBusinessKnowledgeModels().iterator().next();
        org.kie.dmn.model.api.FunctionDefinition dmnFunction = bkmNode.getBusinessKnowledModel().getEncapsulatedLogic();
        Assert.assertEquals((Object)FunctionKind.JAVA, (Object)dmnFunction.getKind());
    }

    @Test
    public void test_function_definition_and_invoke_in_ctx() throws IOException {
        DMNRuntime runtime = this.roundTripUnmarshalMarshalThenUnmarshalDMN(this.getClass().getResourceAsStream("/function_definition_and_invoke_in_ctx.dmn"));
        DMNModel dmnModel = (DMNModel)runtime.getModels().get(0);
        DMNContext emptyContext = runtime.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        Assert.assertFalse((String)dmnResult.getMessages().toString(), (boolean)dmnResult.hasErrors());
        DMNDecisionResult adultResult = dmnResult.getDecisionResultByName("hardcoded decision");
        Assert.assertEquals((Object)DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED, (Object)adultResult.getEvaluationStatus());
        Assert.assertEquals((long)3L, (long)((BigDecimal)adultResult.getResult()).intValue());
    }

    @Test
    public void test_hardcoded_decision_a_function() throws IOException {
        DMNRuntime runtime = this.roundTripUnmarshalMarshalThenUnmarshalDMN(this.getClass().getResourceAsStream("/hardcoded_decision_a_function.dmn"));
        DMNModel dmnModel = (DMNModel)runtime.getModels().get(0);
        DMNContext emptyContext = runtime.newContext();
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, emptyContext);
        Assert.assertFalse((String)dmnResult.getMessages().toString(), (boolean)dmnResult.hasErrors());
        DMNDecisionResult adultResult = dmnResult.getDecisionResultByName("hardcoded invokation");
        Assert.assertEquals((Object)DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED, (Object)adultResult.getEvaluationStatus());
        Assert.assertEquals((long)3L, (long)((BigDecimal)adultResult.getResult()).intValue());
    }

    @Test
    public void test_decision_table() throws IOException {
        DMNRuntime runtime = this.roundTripUnmarshalMarshalThenUnmarshalDMN(this.getClass().getResourceAsStream("/positive_or_negative.dmn"));
        DMNModel dmnModel = (DMNModel)runtime.getModels().get(0);
        this.checkDecisionTableForPositiveOrNegative(runtime, dmnModel, 47, "positive");
        this.checkDecisionTableForPositiveOrNegative(runtime, dmnModel, -1, "negative");
    }

    private void checkDecisionTableForPositiveOrNegative(DMNRuntime runtime, DMNModel dmnModel, int number, String result) {
        DMNContext context = runtime.newContext();
        context.set("a number", (Object)number);
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, context);
        Assert.assertFalse((String)dmnResult.getMessages().toString(), (boolean)dmnResult.hasErrors());
        DMNDecisionResult adultResult = dmnResult.getDecisionResultByName("positive or negative");
        Assert.assertEquals((Object)DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED, (Object)adultResult.getEvaluationStatus());
        Assert.assertEquals((Object)result, (Object)adultResult.getResult());
    }

    @Test
    public void test_decision_table_UnaryTestsParenthood() throws IOException {
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/positive_or_negative.dmn"), this::checkDecisionRuleInputUnaryTests);
    }

    private void checkDecisionRuleInputUnaryTests(Graph<?, Node<?, ?>> g) {
        Node decisionNode = g.getNode("_f9f209df-1d64-4c27-90e9-3ad42cb47c07");
        DMNMarshallerTest.assertNodeContentDefinitionIs(decisionNode, Decision.class);
        Node rootNode = DMNMarshaller.findDMNDiagramRoot(g);
        Assert.assertNotNull((Object)rootNode);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, decisionNode);
        Assert.assertEquals((String)"decisionNode parent is Definitions DMN root", (Object)"_f330b756-e84e-401d-ac3a-2e72e710d4ed", (Object)((DMNElement)((Decision)((View)decisionNode.getContent()).getDefinition()).getParent()).getId().getValue());
        DecisionTable dtable = (DecisionTable)((Decision)((View)decisionNode.getContent()).getDefinition()).getExpression();
        dtable.getRule().forEach(rule -> rule.getInputEntry().forEach(ie -> Assert.assertEquals((Object)ie.getParent(), (Object)rule)));
        dtable.getRule().forEach(rule -> rule.getOutputEntry().forEach(ie -> Assert.assertEquals((Object)ie.getParent(), (Object)rule)));
        dtable.getRule().forEach(rule -> Assert.assertEquals((Object)rule.getParent(), (Object)dtable));
    }

    @Test
    public void test_wrong_context() throws IOException {
        ErrorsAndDMNModelAsSerialized result = this.roundTripUnmarshalMarshalThenUnmarshalDMNexpectingErrors(this.getClass().getResourceAsStream("/wrong_context.dmn"));
        Assert.assertTrue((boolean)result.hasErrors());
        DMNMessage m0 = (DMNMessage)result.messages.get(0);
        Assert.assertTrue((String)"expected a message identifying the problem on a context entry for 'ciao'", (boolean)m0.getMessage().startsWith("Error compiling FEEL expression '' for name "));
        org.kie.dmn.model.api.Decision d0 = (org.kie.dmn.model.api.Decision)result.definitions.getDrgElement().stream().filter(d -> d.getId().equals("_653b3426-933a-4050-9568-ab2a66b43c36")).findFirst().get();
        Context d0c = (Context)d0.getExpression();
        org.kie.dmn.model.api.Expression contextEntryValue = ((ContextEntry)d0c.getContextEntry().get(0)).getExpression();
        Assert.assertTrue((boolean)(contextEntryValue instanceof LiteralExpression));
        Assert.assertEquals((Object)"", (Object)((LiteralExpression)contextEntryValue).getText());
        DMNMarshaller m = this.getDMNMarshaller();
        Graph g = m.unmarshall(DMNMarshallerTest.createMetadata(), this.getClass().getResourceAsStream("/wrong_context.dmn"));
        Node decisionNode = g.getNode("_653b3426-933a-4050-9568-ab2a66b43c36");
        DMNMarshallerTest.assertNodeContentDefinitionIs(decisionNode, Decision.class);
        View view = (View)decisionNode.getContent();
        org.kie.workbench.common.dmn.api.definition.model.Context expression = (org.kie.workbench.common.dmn.api.definition.model.Context)((Decision)view.getDefinition()).getExpression();
        Assert.assertNotNull((Object)((org.kie.workbench.common.dmn.api.definition.model.ContextEntry)expression.getContextEntry().get(0)).getExpression());
        Assert.assertEquals(org.kie.workbench.common.dmn.api.definition.model.LiteralExpression.class, ((org.kie.workbench.common.dmn.api.definition.model.ContextEntry)expression.getContextEntry().get(0)).getExpression().getClass());
        org.kie.workbench.common.dmn.api.definition.model.LiteralExpression le = (org.kie.workbench.common.dmn.api.definition.model.LiteralExpression)((org.kie.workbench.common.dmn.api.definition.model.ContextEntry)expression.getContextEntry().get(0)).getExpression();
        Assert.assertEquals((Object)"", (Object)le.getText().getValue());
    }

    @Test
    public void test_wrong_decision() throws IOException {
        ErrorsAndDMNModelAsSerialized result = this.roundTripUnmarshalMarshalThenUnmarshalDMNexpectingErrors(this.getClass().getResourceAsStream("/wrong_decision.dmn"));
        Assert.assertTrue((boolean)result.hasErrors());
        DMNMessage m0 = (DMNMessage)result.messages.get(0);
        Assert.assertTrue((String)"expected a message identifying the problem on the literalExpression of 'my decision'", (boolean)m0.getSourceId().equals("_36dd163c-4862-4308-92bf-40a998b24e39"));
        org.kie.dmn.model.api.Decision d0 = (org.kie.dmn.model.api.Decision)result.definitions.getDrgElement().stream().filter(d -> d.getId().equals("_cce32679-9395-444d-a4bf-96af8ee727a0")).findFirst().get();
        org.kie.dmn.model.api.Expression d0le = d0.getExpression();
        Assert.assertTrue((boolean)(d0le instanceof LiteralExpression));
        Assert.assertEquals((Object)"", (Object)((LiteralExpression)d0le).getText());
        DMNMarshaller m = this.getDMNMarshaller();
        Graph g = m.unmarshall(DMNMarshallerTest.createMetadata(), this.getClass().getResourceAsStream("/wrong_decision.dmn"));
        Node decisionNode = g.getNode("_cce32679-9395-444d-a4bf-96af8ee727a0");
        DMNMarshallerTest.assertNodeContentDefinitionIs(decisionNode, Decision.class);
        View view = (View)decisionNode.getContent();
        Expression expression = ((Decision)view.getDefinition()).getExpression();
        Assert.assertNotNull((Object)expression);
        Assert.assertEquals(org.kie.workbench.common.dmn.api.definition.model.LiteralExpression.class, expression.getClass());
        org.kie.workbench.common.dmn.api.definition.model.LiteralExpression le = (org.kie.workbench.common.dmn.api.definition.model.LiteralExpression)expression;
        Assert.assertEquals((Object)"", (Object)le.getText().getValue());
    }

    @Test
    public void testOtherElements() throws IOException, XPathExpressionException {
        String original = new Scanner(this.getClass().getResourceAsStream("/dummy.dmn")).useDelimiter("\\A").next();
        DMNMarshaller marshaller = this.getDMNMarshaller();
        DiagramImpl diagram = this.createDiagram();
        diagram.setGraph(marshaller.unmarshall(DMNMarshallerTest.createMetadata(), this.getClass().getResourceAsStream("/dummy.dmn")));
        String roundtripped = marshaller.marshall((Diagram)diagram);
        LOG.debug(roundtripped);
        XPath xpathOriginal = this.namespaceAwareXPath(new AbstractMap.SimpleEntry<String, String>("semantic", "http://www.omg.org/spec/DMN/20151101/dmn.xsd"), new AbstractMap.SimpleEntry<String, String>("drools", "http://www.drools.org/kie/dmn/1.1"));
        XPath xpathRountripped = this.namespaceAwareXPath(new AbstractMap.SimpleEntry<String, String>("semantic", "http://www.omg.org/spec/DMN/20180521/MODEL/"), new AbstractMap.SimpleEntry<String, String>("drools", "http://www.drools.org/kie/dmn/1.2"));
        this.assertXPathEquals(xpathOriginal, xpathRountripped, "boolean(/semantic:definitions/semantic:extensionElements)", original, roundtripped);
        this.assertXPathEquals(xpathOriginal, xpathRountripped, "boolean(/semantic:definitions/semantic:import)", original, roundtripped);
        this.assertXPathEquals(xpathOriginal, xpathRountripped, "/semantic:definitions/semantic:import/@namespace", original, roundtripped);
        this.assertXPathEquals(xpathOriginal, xpathRountripped, "/semantic:definitions/semantic:import/@importType", original, roundtripped);
        this.assertXPathEquals(xpathOriginal, xpathRountripped, "/semantic:definitions/semantic:import/@locationURI", original, roundtripped);
        this.assertXPathEquals(xpathOriginal, xpathRountripped, "/semantic:definitions/semantic:import/@drools:name", original, roundtripped);
        this.assertXPathEquals(xpathOriginal, xpathRountripped, "/semantic:definitions/semantic:import/@drools:modelName", original, roundtripped);
        this.assertXPathEquals(xpathOriginal, xpathRountripped, "boolean(/semantic:definitions/semantic:knowledgeSource)", original, roundtripped);
        this.assertXPathEquals(xpathOriginal, xpathRountripped, "/semantic:definitions/semantic:knowledgeSource/@name", original, roundtripped);
        this.assertXPathEquals(xpathOriginal, xpathRountripped, "/semantic:definitions/semantic:knowledgeSource/@id", original, roundtripped);
        this.assertXPathEquals(xpathOriginal, xpathRountripped, "boolean(/semantic:definitions/semantic:knowledgeSource/semantic:authorityRequirement)", original, roundtripped);
        this.assertXPathEquals(xpathOriginal, xpathRountripped, "boolean(/semantic:definitions/semantic:knowledgeSource/semantic:requiredInput)", original, roundtripped);
        this.assertXPathEquals(xpathOriginal, xpathRountripped, "/semantic:definitions/semantic:knowledgeSource/semantic:requiredInput/@href", original, roundtripped);
        this.assertXPathEquals(xpathOriginal, xpathRountripped, "boolean(/semantic:definitions/semantic:inputData)", original, roundtripped);
        this.assertXPathEquals(xpathOriginal, xpathRountripped, "/semantic:definitions/semantic:inputData/@id", original, roundtripped);
        this.assertXPathEquals(xpathOriginal, xpathRountripped, "/semantic:definitions/semantic:inputData/@name", original, roundtripped);
        this.assertXPathEquals(xpathOriginal, xpathRountripped, "boolean(/semantic:definitions/semantic:inputData/semantic:variable)", original, roundtripped);
        this.assertXPathEquals(xpathOriginal, xpathRountripped, "/semantic:definitions/semantic:inputData/semantic:variable/@id", original, roundtripped);
        this.assertXPathEquals(xpathOriginal, xpathRountripped, "/semantic:definitions/semantic:inputData/semantic:variable/@name", original, roundtripped);
        String inputDataVariableTypeRefOriginal = xpathOriginal.compile("/semantic:definitions/semantic:inputData/semantic:variable/@typeRef").evaluate(new InputSource(new StringReader(original)));
        String inputDataVariableTypeRefRoundtripped = xpathRountripped.compile("/semantic:definitions/semantic:inputData/semantic:variable/@typeRef").evaluate(new InputSource(new StringReader(roundtripped)));
        Assert.assertEquals((Object)"feel:number", (Object)inputDataVariableTypeRefOriginal);
        Assert.assertEquals((Object)"number", (Object)inputDataVariableTypeRefRoundtripped);
    }

    @Test
    public void testContextEntryDataType() throws Exception {
        DMNMarshaller marshaller = this.getDMNMarshaller();
        org.kie.workbench.common.dmn.api.definition.model.Context context = new org.kie.workbench.common.dmn.api.definition.model.Context();
        context.setTypeRef(BuiltInType.DATE_TIME.asQName());
        org.kie.workbench.common.dmn.api.definition.model.ContextEntry contextEntry = new org.kie.workbench.common.dmn.api.definition.model.ContextEntry();
        org.kie.workbench.common.dmn.api.definition.model.LiteralExpression literalExpression = new org.kie.workbench.common.dmn.api.definition.model.LiteralExpression();
        literalExpression.setTypeRef(BuiltInType.BOOLEAN.asQName());
        literalExpression.getText().setValue("feel");
        contextEntry.setExpression((Expression)literalExpression);
        context.getContextEntry().add(contextEntry);
        Diagram<Graph, Metadata> mockedDiagram = this.newDiagramDecisionWithExpression((Expression)context);
        String marshalledSource = marshaller.marshall(mockedDiagram);
        Graph unmarshalledGraph = marshaller.unmarshall(DMNMarshallerTest.createMetadata(), (InputStream)new StringInputStream(marshalledSource));
        Assertions.assertThat((Iterable)unmarshalledGraph.nodes()).hasSize(2);
        DMNMarshallerTest.checkDecisionExpression(unmarshalledGraph, (Expression)context);
    }

    @Test
    public void testDefaultObjectsAreNotCreated() throws IOException {
        DMNRuntime dmnRuntime = this.roundTripUnmarshalMarshalThenUnmarshalDMN(this.getClass().getResourceAsStream("/DROOLS-2941.dmn"));
        List dmn_messages = ((DMNModel)dmnRuntime.getModels().get(0)).getMessages();
        Assertions.assertThat((List)dmn_messages).isEmpty();
        Assertions.assertThat((List)dmnRuntime.getModels()).hasSize(1);
        DMNModel dmnModel = (DMNModel)dmnRuntime.getModels().get(0);
        DMNContext context = dmnRuntime.newContext();
        DMNResult result = dmnRuntime.evaluateAll(dmnModel, context);
        Assertions.assertThat((Object)result.getDecisionResultByName("A Vowel").getResult()).isEqualTo((Object)"a");
    }

    @Test
    public void testStunnerConstellationButtonCausingPoint2DbeingNull() throws IOException {
        BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer = (uuid, hcw) -> {};
        DiagramImpl diagram = this.createDiagram();
        Graph g = diagram.getGraph();
        Node diagramRoot = DMNMarshaller.findDMNDiagramRoot((Graph)g);
        DMNMarshallerTest.testAugmentWithNSPrefixes(((DMNDiagram)((View)diagramRoot.getContent()).getDefinition()).getDefinitions());
        TInputData dmnInputData = new TInputData();
        dmnInputData.setId("inputDataID");
        dmnInputData.setName(dmnInputData.getId());
        Node inputDataNode = new InputDataConverter(this.api.getFactoryManager()).nodeFromDMN((InputData)dmnInputData, hasComponentWidthsConsumer);
        TDecision dmnDecision = new TDecision();
        dmnDecision.setId("decisionID");
        dmnDecision.setName(dmnDecision.getId());
        Node decisionNode = new DecisionConverter(this.api.getFactoryManager()).nodeFromDMN((org.kie.dmn.model.api.Decision)dmnDecision, hasComponentWidthsConsumer);
        g.addNode(inputDataNode);
        g.addNode(decisionNode);
        View content = (View)decisionNode.getContent();
        content.setBounds(org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)200.0, (double)200.0, (double)300.0, (double)250.0));
        String irID = "irID";
        Edge myEdge = this.api.getFactoryManager().newElement("irID", DMNMarshaller.INFO_REQ_ID).asEdge();
        myEdge.setSourceNode(inputDataNode);
        myEdge.setTargetNode(decisionNode);
        inputDataNode.getOutEdges().add(myEdge);
        decisionNode.getInEdges().add(myEdge);
        ViewConnector connectionContent = (ViewConnector)myEdge.getContent();
        connectionContent.setSourceConnection((Connection)MagnetConnection.Builder.atCenter((Element)inputDataNode).setLocation(null).setAuto(true));
        connectionContent.setTargetConnection((Connection)MagnetConnection.Builder.atCenter((Element)decisionNode).setLocation(null).setAuto(true));
        DMNMarshaller.connectRootWithChild((Node)diagramRoot, (Node)inputDataNode);
        DMNMarshaller.connectRootWithChild((Node)diagramRoot, (Node)decisionNode);
        DMNMarshaller m = this.getDMNMarshaller();
        String output = m.marshall((Diagram)diagram);
        LOG.debug(output);
        Definitions dmnDefinitions = DMNMarshallerFactory.newDefaultMarshaller().unmarshal(output);
        DMNEdge dmndiEdge = DMNMarshallerTest.findEdgeByDMNI((org.kie.dmn.model.api.dmndi.DMNDiagram)dmnDefinitions.getDMNDI().getDMNDiagram().get(0), "irID");
        Assertions.assertThat((List)dmndiEdge.getWaypoint()).hasSize(2);
        Point wpSource = (Point)dmndiEdge.getWaypoint().get(0);
        Assertions.assertThat((double)wpSource.getX()).isEqualByComparingTo((Comparable)Double.valueOf(50.0));
        Assertions.assertThat((double)wpSource.getY()).isEqualByComparingTo((Comparable)Double.valueOf(25.0));
        Point wpTarget = (Point)dmndiEdge.getWaypoint().get(1);
        Assertions.assertThat((double)wpTarget.getX()).isEqualByComparingTo((Comparable)Double.valueOf(250.0));
        Assertions.assertThat((double)wpTarget.getY()).isEqualByComparingTo((Comparable)Double.valueOf(225.0));
    }

    @Test
    public void testAssociationEdgeDMNDI() throws IOException {
        BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer = (uuid, hcw) -> {};
        DiagramImpl diagram = this.createDiagram();
        Graph g = diagram.getGraph();
        Node diagramRoot = DMNMarshaller.findDMNDiagramRoot((Graph)g);
        DMNMarshallerTest.testAugmentWithNSPrefixes(((DMNDiagram)((View)diagramRoot.getContent()).getDefinition()).getDefinitions());
        TInputData dmnInputData = new TInputData();
        dmnInputData.setId("inputDataID");
        dmnInputData.setName(dmnInputData.getId());
        Node inputDataNode = new InputDataConverter(this.api.getFactoryManager()).nodeFromDMN((InputData)dmnInputData, hasComponentWidthsConsumer);
        TTextAnnotation dmnTextAnnotation = new TTextAnnotation();
        dmnTextAnnotation.setId("textAnnotationID");
        Node textAnnotationNode = new TextAnnotationConverter(this.api.getFactoryManager()).nodeFromDMN((org.kie.dmn.model.api.TextAnnotation)dmnTextAnnotation, hasComponentWidthsConsumer);
        g.addNode(inputDataNode);
        g.addNode(textAnnotationNode);
        View content = (View)textAnnotationNode.getContent();
        content.setBounds(org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)200.0, (double)200.0, (double)300.0, (double)250.0));
        String edgeID = "edgeID";
        String associationID = "associationID";
        Edge myEdge = this.api.getFactoryManager().newElement("edgeID", DMNMarshaller.ASSOCIATION_ID).asEdge();
        View edgeView = (View)myEdge.getContent();
        ((Association)edgeView.getDefinition()).setId(new Id("associationID"));
        myEdge.setSourceNode(inputDataNode);
        myEdge.setTargetNode(textAnnotationNode);
        inputDataNode.getOutEdges().add(myEdge);
        textAnnotationNode.getInEdges().add(myEdge);
        ViewConnector connectionContent = (ViewConnector)myEdge.getContent();
        connectionContent.setSourceConnection((Connection)MagnetConnection.Builder.atCenter((Element)inputDataNode));
        connectionContent.setTargetConnection((Connection)MagnetConnection.Builder.atCenter((Element)textAnnotationNode));
        DMNMarshaller.connectRootWithChild((Node)diagramRoot, (Node)inputDataNode);
        DMNMarshaller.connectRootWithChild((Node)diagramRoot, (Node)textAnnotationNode);
        DMNMarshaller m = this.getDMNMarshaller();
        String output = m.marshall((Diagram)diagram);
        LOG.debug(output);
        Definitions dmnDefinitions = DMNMarshallerFactory.newDefaultMarshaller().unmarshal(output);
        Assertions.assertThat((long)((org.kie.dmn.model.api.dmndi.DMNDiagram)dmnDefinitions.getDMNDI().getDMNDiagram().get(0)).getDMNDiagramElement().stream().filter(DMNEdge.class::isInstance).count()).isEqualTo(1L);
        DMNEdge dmndiEdge = DMNMarshallerTest.findEdgeByDMNI((org.kie.dmn.model.api.dmndi.DMNDiagram)dmnDefinitions.getDMNDI().getDMNDiagram().get(0), "associationID");
        Assertions.assertThat((List)dmndiEdge.getWaypoint()).hasSize(2);
    }

    @Test
    public void test_ExpressionComponentWidthPersistence() throws IOException {
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/DROOLS-2262.dmn"), this::checkComponentWidths);
    }

    @Test
    public void testGetImportedDrgElementsByShape() {
        DMNMarshaller marshaller = (DMNMarshaller)Mockito.spy((Object)this.getDMNMarshaller());
        List importedDRGElements = (List)Mockito.mock(List.class);
        Map importDefinitions = (Map)Mockito.mock(Map.class);
        Definitions dmnXml = (Definitions)Mockito.mock(Definitions.class);
        DRGElement ref1 = (DRGElement)Mockito.mock(DRGElement.class);
        DRGElement ref2 = (DRGElement)Mockito.mock(DRGElement.class);
        DRGElement ref3 = (DRGElement)Mockito.mock(DRGElement.class);
        ArrayList<DMNShape> dmnShapes = new ArrayList<DMNShape>();
        DMNShape shape1 = (DMNShape)Mockito.mock(DMNShape.class);
        DMNShape shape2 = (DMNShape)Mockito.mock(DMNShape.class);
        DMNShape shape3 = (DMNShape)Mockito.mock(DMNShape.class);
        dmnShapes.add(shape1);
        dmnShapes.add(shape2);
        dmnShapes.add(shape3);
        ((DMNMarshaller)Mockito.doReturn((Object)"REF1").when((Object)marshaller)).getDmnElementRef(shape1);
        ((DMNMarshaller)Mockito.doReturn((Object)"REF2").when((Object)marshaller)).getDmnElementRef(shape2);
        ((DMNMarshaller)Mockito.doReturn((Object)"REF3").when((Object)marshaller)).getDmnElementRef(shape3);
        Mockito.when((Object)this.dmnMarshallerImportsHelper.getImportedDRGElements(importDefinitions)).thenReturn((Object)importedDRGElements);
        ((DMNMarshaller)Mockito.doNothing().when((Object)marshaller)).updateIDsWithAlias((HashMap)Matchers.any(), (List)Matchers.any());
        ((DMNMarshaller)Mockito.doReturn(Optional.of(ref1)).when((Object)marshaller)).getReference(importedDRGElements, "REF1");
        ((DMNMarshaller)Mockito.doReturn(Optional.of(ref2)).when((Object)marshaller)).getReference(importedDRGElements, "REF2");
        ((DMNMarshaller)Mockito.doReturn(Optional.of(ref3)).when((Object)marshaller)).getReference(importedDRGElements, "REF3");
        List actual = marshaller.getImportedDrgElementsByShape(dmnShapes, importDefinitions, dmnXml);
        Assert.assertEquals((Object)ref1, actual.get(0));
        Assert.assertEquals((Object)ref2, actual.get(1));
        Assert.assertEquals((Object)ref3, actual.get(2));
    }

    @Test
    public void testGetDmnElementRef() {
        DMNMarshaller marshaller = (DMNMarshaller)Mockito.spy((Object)this.getDMNMarshaller());
        String expected = "localPart";
        DMNShape shape = (DMNShape)Mockito.mock(DMNShape.class);
        QName ref = (QName)Mockito.mock(QName.class);
        Mockito.when((Object)ref.getLocalPart()).thenReturn((Object)"localPart");
        Mockito.when((Object)shape.getDmnElementRef()).thenReturn((Object)ref);
        String actual = marshaller.getDmnElementRef(shape);
        Assert.assertEquals((Object)"localPart", (Object)actual);
    }

    @Test
    public void testGetUniqueDMNShapes() {
        DMNMarshaller marshaller = (DMNMarshaller)Mockito.spy((Object)this.getDMNMarshaller());
        org.kie.dmn.model.api.dmndi.DMNDiagram diagram = (org.kie.dmn.model.api.dmndi.DMNDiagram)Mockito.mock(org.kie.dmn.model.api.dmndi.DMNDiagram.class);
        ArrayList<DMNShape> elements = new ArrayList<DMNShape>();
        DMNShape unique1 = (DMNShape)Mockito.mock(DMNShape.class);
        Mockito.when((Object)unique1.getId()).thenReturn((Object)"unique1");
        DMNShape unique2 = (DMNShape)Mockito.mock(DMNShape.class);
        Mockito.when((Object)unique2.getId()).thenReturn((Object)"unique2");
        DMNShape duplicate1 = (DMNShape)Mockito.mock(DMNShape.class);
        Mockito.when((Object)duplicate1.getId()).thenReturn((Object)"duplicate");
        DMNShape duplicate2 = (DMNShape)Mockito.mock(DMNShape.class);
        Mockito.when((Object)duplicate2.getId()).thenReturn((Object)"duplicate");
        elements.add(unique1);
        elements.add(unique2);
        elements.add(duplicate1);
        elements.add(duplicate2);
        Mockito.when((Object)diagram.getDMNDiagramElement()).thenReturn(elements);
        List actual = marshaller.getUniqueDMNShapes(diagram);
        Assert.assertEquals((long)3L, (long)actual.size());
        Assert.assertTrue((boolean)actual.contains(unique1));
        Assert.assertTrue((boolean)actual.contains(unique2));
        Assert.assertTrue((actual.contains(duplicate1) || actual.contains(duplicate2) ? 1 : 0) != 0);
    }

    @Test
    public void testSetAllowOnlyVisualChangeToTrue() {
        this.testSetAllowOnlyVisualChange(true);
    }

    @Test
    public void testSetAllowOnlyVisualChangeToFalse() {
        this.testSetAllowOnlyVisualChange(false);
    }

    private void testSetAllowOnlyVisualChange(boolean expected) {
        DMNMarshaller marshaller = (DMNMarshaller)Mockito.spy((Object)this.getDMNMarshaller());
        List importedDrgElements = (List)Mockito.mock(List.class);
        Node node = (Node)Mockito.mock(Node.class);
        org.kie.workbench.common.dmn.api.definition.model.DRGElement element = (org.kie.workbench.common.dmn.api.definition.model.DRGElement)Mockito.mock(org.kie.workbench.common.dmn.api.definition.model.DRGElement.class);
        ((DMNMarshaller)Mockito.doReturn(Optional.of(element)).when((Object)marshaller)).getDRGElement(node);
        ((DMNMarshaller)Mockito.doReturn((Object)expected).when((Object)marshaller)).isImportedDRGElement(importedDrgElements, element);
        marshaller.setAllowOnlyVisualChange(importedDrgElements, node);
        ((org.kie.workbench.common.dmn.api.definition.model.DRGElement)Mockito.verify((Object)element)).setAllowOnlyVisualChange(expected);
    }

    @Test
    public void testIsImportedDRGElementWithDmnDRGElement() {
        DMNMarshaller marshaller = (DMNMarshaller)Mockito.spy((Object)this.getDMNMarshaller());
        ArrayList<DRGElement> importedDrgElements = new ArrayList<DRGElement>();
        DRGElement imported = (DRGElement)Mockito.mock(DRGElement.class);
        Mockito.when((Object)imported.getId()).thenReturn((Object)"id");
        importedDrgElements.add(imported);
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        Mockito.when((Object)drgElement.getId()).thenReturn((Object)"id");
        boolean actual = marshaller.isImportedDRGElement(importedDrgElements, drgElement);
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testIsImportedDRGElementWithWbDRGElement() {
        DMNMarshaller marshaller = (DMNMarshaller)Mockito.spy((Object)this.getDMNMarshaller());
        ArrayList<DRGElement> importedDrgElements = new ArrayList<DRGElement>();
        DRGElement imported = (DRGElement)Mockito.mock(DRGElement.class);
        Mockito.when((Object)imported.getId()).thenReturn((Object)"id");
        importedDrgElements.add(imported);
        org.kie.workbench.common.dmn.api.definition.model.DRGElement drgElement = (org.kie.workbench.common.dmn.api.definition.model.DRGElement)Mockito.mock(org.kie.workbench.common.dmn.api.definition.model.DRGElement.class);
        Id id = (Id)Mockito.mock(Id.class);
        Mockito.when((Object)id.getValue()).thenReturn((Object)"id");
        Mockito.when((Object)drgElement.getId()).thenReturn((Object)id);
        boolean actual = marshaller.isImportedDRGElement(importedDrgElements, drgElement);
        Assert.assertTrue((boolean)actual);
    }

    @Test
    public void testUpdateIDsWithAlias() {
        DMNMarshaller marshaller = this.getDMNMarshaller();
        HashMap<String, String> indexByUri = new HashMap<String, String>();
        String namespace1 = "https://kiegroup.org/dmn/_red";
        String namespace2 = "https://kiegroup.org/dmn/_blue";
        String namespace3 = "https://kiegroup.org/dmn/_yellow";
        String missingNamespace = "missing_namespace";
        String someWrongAlias = "some wrong alias";
        String include1 = "include1";
        String include2 = "include2";
        String include3 = "include3";
        String id1 = "id1";
        String id2 = "id2";
        String id3 = "id3";
        String id4 = "id4";
        indexByUri.put("https://kiegroup.org/dmn/_red", "include1");
        indexByUri.put("https://kiegroup.org/dmn/_blue", "include2");
        indexByUri.put("https://kiegroup.org/dmn/_yellow", "include3");
        ArrayList<DRGElement> importedDrgElements = new ArrayList<DRGElement>();
        DRGElement element1 = this.createDRGElementWithNamespaceAndId("https://kiegroup.org/dmn/_red", "some wrong alias:id1");
        importedDrgElements.add(element1);
        DRGElement element2 = this.createDRGElementWithNamespaceAndId("https://kiegroup.org/dmn/_blue", "some wrong alias:id2");
        importedDrgElements.add(element2);
        DRGElement element3 = this.createDRGElementWithNamespaceAndId("https://kiegroup.org/dmn/_yellow", "some wrong alias:id3");
        importedDrgElements.add(element3);
        DRGElement element4 = this.createDRGElementWithNamespaceAndId("missing_namespace", "id4");
        importedDrgElements.add(element4);
        marshaller.updateIDsWithAlias(indexByUri, importedDrgElements);
        ((DRGElement)Mockito.verify((Object)element1)).setId("include1:id1");
        ((DRGElement)Mockito.verify((Object)element2)).setId("include2:id2");
        ((DRGElement)Mockito.verify((Object)element3)).setId("include3:id3");
        ((DRGElement)Mockito.verify((Object)element4, (VerificationMode)Mockito.never())).setId((String)Matchers.any());
    }

    private DRGElement createDRGElementWithNamespaceAndId(String namespace, String id) {
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        HashMap<QName, String> additionalAttributes = new HashMap<QName, String>();
        additionalAttributes.put(new QName("Namespace"), namespace);
        Mockito.when((Object)drgElement.getAdditionalAttributes()).thenReturn(additionalAttributes);
        Mockito.when((Object)drgElement.getId()).thenReturn((Object)id);
        return drgElement;
    }

    @Test
    public void testChangeAliasForImportedElement() {
        DMNMarshaller marshaller = this.getDMNMarshaller();
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        String alias = "include1";
        String id = "_01234567";
        Mockito.when((Object)drgElement.getId()).thenReturn((Object)"some another alias:_01234567");
        marshaller.changeAlias("include1", drgElement);
        ((DRGElement)Mockito.verify((Object)drgElement)).setId("include1:_01234567");
    }

    @Test
    public void testChangeAliasForLocalElement() {
        DMNMarshaller marshaller = this.getDMNMarshaller();
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        String alias = "include1";
        String id = "_01234567";
        Mockito.when((Object)drgElement.getId()).thenReturn((Object)"_01234567");
        marshaller.changeAlias("include1", drgElement);
        ((DRGElement)Mockito.verify((Object)drgElement, (VerificationMode)Mockito.never())).setId((String)Matchers.any());
    }

    @Test
    public void testLoadImportedItemDefinitions() {
        org.kie.workbench.common.dmn.api.definition.model.Definitions definitions = (org.kie.workbench.common.dmn.api.definition.model.Definitions)Mockito.mock(org.kie.workbench.common.dmn.api.definition.model.Definitions.class);
        org.kie.workbench.common.dmn.api.definition.model.ItemDefinition itemDefinition1 = (org.kie.workbench.common.dmn.api.definition.model.ItemDefinition)Mockito.mock(org.kie.workbench.common.dmn.api.definition.model.ItemDefinition.class);
        org.kie.workbench.common.dmn.api.definition.model.ItemDefinition itemDefinition2 = (org.kie.workbench.common.dmn.api.definition.model.ItemDefinition)Mockito.mock(org.kie.workbench.common.dmn.api.definition.model.ItemDefinition.class);
        List<org.kie.workbench.common.dmn.api.definition.model.ItemDefinition> expectedItemDefinitions = Arrays.asList(itemDefinition1, itemDefinition2);
        ArrayList actualItemDefinitions = new ArrayList();
        HashMap importDefinitions = new HashMap();
        DMNMarshaller dmnMarshaller = (DMNMarshaller)Mockito.spy((Object)this.getDMNMarshaller());
        ((DMNMarshaller)Mockito.doReturn(expectedItemDefinitions).when((Object)dmnMarshaller)).getWbImportedItemDefinitions(importDefinitions);
        Mockito.when((Object)definitions.getItemDefinition()).thenReturn(actualItemDefinitions);
        dmnMarshaller.loadImportedItemDefinitions(definitions, importDefinitions);
        Assert.assertEquals(expectedItemDefinitions, actualItemDefinitions);
    }

    @Test
    public void testCleanImportedItemDefinitions() {
        org.kie.workbench.common.dmn.api.definition.model.Definitions definitions = (org.kie.workbench.common.dmn.api.definition.model.Definitions)Mockito.mock(org.kie.workbench.common.dmn.api.definition.model.Definitions.class);
        org.kie.workbench.common.dmn.api.definition.model.ItemDefinition itemDefinition1 = (org.kie.workbench.common.dmn.api.definition.model.ItemDefinition)Mockito.mock(org.kie.workbench.common.dmn.api.definition.model.ItemDefinition.class);
        org.kie.workbench.common.dmn.api.definition.model.ItemDefinition itemDefinition2 = (org.kie.workbench.common.dmn.api.definition.model.ItemDefinition)Mockito.mock(org.kie.workbench.common.dmn.api.definition.model.ItemDefinition.class);
        org.kie.workbench.common.dmn.api.definition.model.ItemDefinition itemDefinition3 = (org.kie.workbench.common.dmn.api.definition.model.ItemDefinition)Mockito.mock(org.kie.workbench.common.dmn.api.definition.model.ItemDefinition.class);
        ArrayList<org.kie.workbench.common.dmn.api.definition.model.ItemDefinition> actualItemDefinitions = new ArrayList<org.kie.workbench.common.dmn.api.definition.model.ItemDefinition>(Arrays.asList(itemDefinition1, itemDefinition2, itemDefinition3));
        List<org.kie.workbench.common.dmn.api.definition.model.ItemDefinition> expectedItemDefinitions = Arrays.asList(itemDefinition1, itemDefinition3);
        DMNMarshaller dmnMarshaller = this.getDMNMarshaller();
        Mockito.when((Object)itemDefinition1.isAllowOnlyVisualChange()).thenReturn((Object)false);
        Mockito.when((Object)itemDefinition2.isAllowOnlyVisualChange()).thenReturn((Object)true);
        Mockito.when((Object)itemDefinition3.isAllowOnlyVisualChange()).thenReturn((Object)false);
        Mockito.when((Object)definitions.getItemDefinition()).thenReturn(actualItemDefinitions);
        dmnMarshaller.cleanImportedItemDefinitions(definitions);
        Assert.assertEquals(expectedItemDefinitions, actualItemDefinitions);
    }

    @Test
    public void testGetWbImportedItemDefinitions() {
        ItemDefinition itemDefinition1 = this.makeItemDefinition("model1.tUUID");
        ItemDefinition itemDefinition2 = this.makeItemDefinition("model1.tPerson");
        ItemDefinition itemDefinition3 = this.makeItemDefinition("model2.tNum");
        HashMap importDefinitions = new HashMap();
        Mockito.when((Object)this.dmnMarshallerImportsHelper.getImportedItemDefinitions(importDefinitions)).thenReturn(Arrays.asList(itemDefinition1, itemDefinition2, itemDefinition3));
        List actualItemDefinitions = this.getDMNMarshaller().getWbImportedItemDefinitions(importDefinitions);
        Assert.assertEquals((long)3L, (long)actualItemDefinitions.size());
        Assert.assertEquals((Object)"model1.tUUID", (Object)((org.kie.workbench.common.dmn.api.definition.model.ItemDefinition)actualItemDefinitions.get(0)).getName().getValue());
        Assert.assertEquals((Object)"model1.tPerson", (Object)((org.kie.workbench.common.dmn.api.definition.model.ItemDefinition)actualItemDefinitions.get(1)).getName().getValue());
        Assert.assertEquals((Object)"model2.tNum", (Object)((org.kie.workbench.common.dmn.api.definition.model.ItemDefinition)actualItemDefinitions.get(2)).getName().getValue());
    }

    private ItemDefinition makeItemDefinition(String name) {
        TItemDefinition itemDefinition = new TItemDefinition();
        itemDefinition.setName(name);
        return itemDefinition;
    }

    @Test
    public void testConnectorRightToLeft() throws Exception {
        org.kie.workbench.common.stunner.core.graph.content.Bounds bounds = org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)0.0, (double)0.0, (double)100.0, (double)50.0);
        String decisionNode1UUID = org.kie.workbench.common.stunner.core.util.UUID.uuid();
        String decisionNode2UUID = org.kie.workbench.common.stunner.core.util.UUID.uuid();
        String edgeUUID = org.kie.workbench.common.stunner.core.util.UUID.uuid();
        ViewConnector edgeView = this.marshallAndUnMarshallConnectors(bounds, decisionNode1UUID, decisionNode2UUID, edgeUUID, sc -> {
            Mockito.when((Object)sc.getMagnetIndex()).thenReturn((Object)OptionalInt.of(2));
            Mockito.when((Object)sc.getLocation()).thenReturn((Object)new Point2D(bounds.getWidth(), bounds.getHeight() / 2.0));
        }, tc -> {
            Mockito.when((Object)tc.getMagnetIndex()).thenReturn((Object)OptionalInt.of(4));
            Mockito.when((Object)tc.getLocation()).thenReturn((Object)new Point2D(0.0, bounds.getHeight() / 2.0));
        });
        MagnetConnection sourceConnection = (MagnetConnection)edgeView.getSourceConnection().get();
        Assert.assertEquals((double)bounds.getWidth(), (double)sourceConnection.getLocation().getX(), (double)0.0);
        Assert.assertEquals((double)(bounds.getHeight() / 2.0), (double)sourceConnection.getLocation().getY(), (double)0.0);
        Assert.assertFalse((boolean)sourceConnection.getMagnetIndex().isPresent());
        Assert.assertTrue((boolean)sourceConnection.isAuto());
        MagnetConnection targetConnection = (MagnetConnection)edgeView.getTargetConnection().get();
        Assert.assertEquals((double)0.0, (double)targetConnection.getLocation().getX(), (double)0.0);
        Assert.assertEquals((double)(bounds.getHeight() / 2.0), (double)targetConnection.getLocation().getY(), (double)0.0);
        Assert.assertFalse((boolean)targetConnection.getMagnetIndex().isPresent());
        Assert.assertTrue((boolean)targetConnection.isAuto());
    }

    @Test
    public void testConnectorCentreToCentre() throws Exception {
        org.kie.workbench.common.stunner.core.graph.content.Bounds bounds = org.kie.workbench.common.stunner.core.graph.content.Bounds.create((double)0.0, (double)0.0, (double)100.0, (double)50.0);
        String decisionNode1UUID = org.kie.workbench.common.stunner.core.util.UUID.uuid();
        String decisionNode2UUID = org.kie.workbench.common.stunner.core.util.UUID.uuid();
        String edgeUUID = org.kie.workbench.common.stunner.core.util.UUID.uuid();
        ViewConnector edgeView = this.marshallAndUnMarshallConnectors(bounds, decisionNode1UUID, decisionNode2UUID, edgeUUID, sc -> {}, tc -> {});
        MagnetConnection sourceConnection = (MagnetConnection)edgeView.getSourceConnection().get();
        Assert.assertEquals((double)(bounds.getWidth() / 2.0), (double)sourceConnection.getLocation().getX(), (double)0.0);
        Assert.assertEquals((double)(bounds.getHeight() / 2.0), (double)sourceConnection.getLocation().getY(), (double)0.0);
        Assert.assertTrue((boolean)sourceConnection.getMagnetIndex().isPresent());
        Assert.assertEquals((long)0L, (long)sourceConnection.getMagnetIndex().getAsInt());
        Assert.assertFalse((boolean)sourceConnection.isAuto());
        MagnetConnection targetConnection = (MagnetConnection)edgeView.getTargetConnection().get();
        Assert.assertEquals((double)(bounds.getWidth() / 2.0), (double)targetConnection.getLocation().getX(), (double)0.0);
        Assert.assertEquals((double)(bounds.getHeight() / 2.0), (double)targetConnection.getLocation().getY(), (double)0.0);
        Assert.assertTrue((boolean)targetConnection.getMagnetIndex().isPresent());
        Assert.assertEquals((long)0L, (long)targetConnection.getMagnetIndex().getAsInt());
        Assert.assertFalse((boolean)targetConnection.isAuto());
    }

    @Test
    public void testRemoveDrgElementsWithoutShape() {
        String id1 = "id1";
        String id2 = "id2";
        String id3 = "id3";
        DRGElement e1 = this.createDRGElement("id1");
        DRGElement e2 = this.createDRGElement("id2");
        DRGElement e3 = this.createDRGElement("id3");
        ArrayList<DRGElement> drgElements = new ArrayList<DRGElement>(Arrays.asList(e1, e2, e3));
        DMNShape s1 = this.createDMNShape("id1");
        DMNShape s3 = this.createDMNShape("id3");
        ArrayList<DMNShape> dmnShapes = new ArrayList<DMNShape>(Arrays.asList(s1, s3));
        this.getDMNMarshaller().removeDrgElementsWithoutShape(drgElements, dmnShapes);
        Assert.assertEquals((long)2L, (long)drgElements.size());
        Assert.assertEquals((Object)e1, drgElements.get(0));
        Assert.assertEquals((Object)e3, drgElements.get(1));
    }

    @Test
    public void testRemoveDrgElementsWithoutShapeWhenAllElementsHaveShape() {
        String id1 = "id1";
        String id2 = "id2";
        String id3 = "id3";
        DRGElement e1 = this.createDRGElement("id1");
        DRGElement e2 = this.createDRGElement("id2");
        DRGElement e3 = this.createDRGElement("id3");
        ArrayList<DRGElement> drgElements = new ArrayList<DRGElement>(Arrays.asList(e1, e2, e3));
        DMNShape s1 = this.createDMNShape("id1");
        DMNShape s2 = this.createDMNShape("id2");
        DMNShape s3 = this.createDMNShape("id3");
        ArrayList<DMNShape> dmnShapes = new ArrayList<DMNShape>(Arrays.asList(s1, s2, s3));
        this.getDMNMarshaller().removeDrgElementsWithoutShape(drgElements, dmnShapes);
        Assert.assertEquals((long)3L, (long)drgElements.size());
        Assert.assertEquals((Object)e1, drgElements.get(0));
        Assert.assertEquals((Object)e2, drgElements.get(1));
        Assert.assertEquals((Object)e3, drgElements.get(2));
    }

    @Test
    public void testRemoveDrgElementsWithoutShapeFromDMN11() {
        String id1 = "id1";
        String id2 = "id2";
        String id3 = "id3";
        DRGElement e1 = this.createDRGElement("id1");
        DRGElement e2 = this.createDRGElement("id2");
        DRGElement e3 = this.createDRGElement("id3");
        ArrayList<DRGElement> drgElements = new ArrayList<DRGElement>(Arrays.asList(e1, e2, e3));
        ArrayList dmnShapes = new ArrayList();
        this.getDMNMarshaller().removeDrgElementsWithoutShape(drgElements, dmnShapes);
        Assert.assertEquals((long)3L, (long)drgElements.size());
        Assert.assertEquals((Object)e1, drgElements.get(0));
        Assert.assertEquals((Object)e2, drgElements.get(1));
        Assert.assertEquals((Object)e3, drgElements.get(2));
    }

    private DMNShape createDMNShape(String refId) {
        DMNShape shape = (DMNShape)Mockito.mock(DMNShape.class);
        QName ref = (QName)Mockito.mock(QName.class);
        Mockito.when((Object)shape.getDmnElementRef()).thenReturn((Object)ref);
        Mockito.when((Object)ref.getLocalPart()).thenReturn((Object)refId);
        return shape;
    }

    private DRGElement createDRGElement(String id) {
        DRGElement element = (DRGElement)Mockito.mock(DRGElement.class);
        Mockito.when((Object)element.getId()).thenReturn((Object)id);
        return element;
    }

    @Test
    public void testImportConversion() throws IOException {
        Mockito.when((Object)this.dmnMarshallerImportsHelper.getPMMLDocuments((Metadata)Matchers.any(Metadata.class), Matchers.anyList())).thenAnswer(i -> {
            HashMap pmmlDocuments = new HashMap();
            List imports = (List)i.getArguments()[1];
            imports.forEach(imp -> {
                PMMLDocumentMetadata cfr_ignored_0 = (PMMLDocumentMetadata)pmmlDocuments.put(imp, Mockito.mock(PMMLDocumentMetadata.class));
            });
            return pmmlDocuments;
        });
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/imports.dmn"), this::checkImports);
    }

    private void checkImports(Graph<?, Node<?, ?>> graph) {
        Assert.assertNotNull(graph);
        DMNDiagramUtils utils = new DMNDiagramUtils();
        Diagram mockDiagram = (Diagram)Mockito.mock(Diagram.class);
        Mockito.when((Object)mockDiagram.getGraph()).thenReturn(graph);
        org.kie.workbench.common.dmn.api.definition.model.Definitions definitions = utils.getDefinitions(mockDiagram);
        List imports = definitions.getImport();
        Assert.assertTrue((boolean)(imports.get(0) instanceof ImportDMN));
        Assert.assertTrue((boolean)(imports.get(1) instanceof ImportPMML));
        ImportDMN dmnImport = (ImportDMN)imports.get(0);
        Assert.assertEquals((Object)"dmn-import", (Object)dmnImport.getName().getValue());
        Assert.assertEquals((Object)"https://kiegroup.org/dmn/_46EB0D0D-7241-4629-A38E-0377AA5B32D1", (Object)dmnImport.getNamespace());
        Assert.assertEquals((Object)DMNImportTypes.DMN.getDefaultNamespace(), (Object)dmnImport.getImportType());
        ImportPMML pmmlImport = (ImportPMML)imports.get(1);
        Assert.assertEquals((Object)"pmml-import", (Object)pmmlImport.getName().getValue());
        Assert.assertEquals((Object)"pmml-import", (Object)pmmlImport.getNamespace());
        Assert.assertEquals((Object)DMNImportTypes.PMML.getDefaultNamespace(), (Object)pmmlImport.getImportType());
    }

    private ViewConnector marshallAndUnMarshallConnectors(org.kie.workbench.common.stunner.core.graph.content.Bounds bounds, String decisionNode1UUID, String decisionNode2UUID, String edgeUUID, Consumer<MagnetConnection> sourceMagnetConsumer, Consumer<MagnetConnection> targetMagnetConsumer) throws Exception {
        DMNMarshaller marshaller = this.getDMNMarshaller();
        Diagram<Graph, Metadata> mockedDiagram = this.connectTwoNodes(bounds, decisionNode1UUID, decisionNode2UUID, edgeUUID, sourceMagnetConsumer, targetMagnetConsumer);
        String marshalledSource = marshaller.marshall(mockedDiagram);
        Graph unmarshalledGraph = marshaller.unmarshall(DMNMarshallerTest.createMetadata(), (InputStream)new StringInputStream(marshalledSource));
        Assert.assertNotNull((Object)unmarshalledGraph);
        Node decision1Node = unmarshalledGraph.getNode(decisionNode1UUID);
        Node decision2Node = unmarshalledGraph.getNode(decisionNode2UUID);
        Assert.assertNotNull((Object)decision1Node);
        Assert.assertNotNull((Object)decision2Node);
        Assert.assertEquals((long)1L, (long)decision1Node.getOutEdges().size());
        Assert.assertEquals((long)2L, (long)decision2Node.getInEdges().size());
        Edge decision1NodeOutEdge = (Edge)decision1Node.getOutEdges().get(0);
        Edge decision2NodeInEdge = (Edge)decision2Node.getInEdges().get(0);
        Assert.assertEquals((Object)decision1NodeOutEdge, (Object)decision2NodeInEdge);
        ViewConnector edgeView = (ViewConnector)decision1NodeOutEdge.getContent();
        Assert.assertTrue((boolean)edgeView.getSourceConnection().isPresent());
        Assert.assertTrue((boolean)edgeView.getTargetConnection().isPresent());
        return edgeView;
    }

    private Diagram<Graph, Metadata> connectTwoNodes(org.kie.workbench.common.stunner.core.graph.content.Bounds bounds, String decisionNode1UUID, String decisionNode2UUID, String edgeUUID, Consumer<MagnetConnection> sourceMagnetConsumer, Consumer<MagnetConnection> targetMagnetConsumer) {
        DiagramImpl diagram = this.createDiagram();
        Graph graph = (Graph)Mockito.mock(Graph.class);
        Node diagramNode = (Node)Mockito.mock(Node.class);
        View diagramView = (View)Mockito.mock(View.class);
        DMNDiagram dmnDiagram = new DMNDiagram();
        Mockito.when((Object)diagramNode.getContent()).thenReturn((Object)diagramView);
        Mockito.when((Object)diagramView.getDefinition()).thenReturn((Object)dmnDiagram);
        Node decisionNode1 = (Node)Mockito.mock(Node.class);
        View decisionView1 = (View)Mockito.mock(View.class);
        Decision decision1 = new Decision();
        decision1.getId().setValue(decisionNode1UUID);
        Mockito.when((Object)decisionNode1.getContent()).thenReturn((Object)decisionView1);
        Mockito.when((Object)decisionView1.getDefinition()).thenReturn((Object)decision1);
        Mockito.when((Object)decisionView1.getBounds()).thenReturn((Object)bounds);
        Node decisionNode2 = (Node)Mockito.mock(Node.class);
        View decisionView2 = (View)Mockito.mock(View.class);
        Decision decision2 = new Decision();
        decision2.getId().setValue(decisionNode2UUID);
        Mockito.when((Object)decisionNode2.getContent()).thenReturn((Object)decisionView2);
        Mockito.when((Object)decisionView2.getDefinition()).thenReturn((Object)decision2);
        Mockito.when((Object)decisionView2.getBounds()).thenReturn((Object)bounds);
        Edge edge = (Edge)Mockito.mock(Edge.class);
        ViewConnector edgeView = (ViewConnector)Mockito.mock(ViewConnector.class);
        Mockito.when((Object)edge.getUUID()).thenReturn((Object)edgeUUID);
        Mockito.when((Object)edge.getContent()).thenReturn((Object)edgeView);
        MagnetConnection edgeSourceConnection = (MagnetConnection)Mockito.mock(MagnetConnection.class);
        MagnetConnection edgeTargetConnection = (MagnetConnection)Mockito.mock(MagnetConnection.class);
        Mockito.when((Object)edgeView.getSourceConnection()).thenReturn(Optional.of(edgeSourceConnection));
        Mockito.when((Object)edgeView.getTargetConnection()).thenReturn(Optional.of(edgeTargetConnection));
        Mockito.when((Object)edgeView.getControlPoints()).thenReturn((Object)new ControlPoint[0]);
        Mockito.when((Object)decisionNode1.getOutEdges()).thenReturn(Collections.singletonList(edge));
        Mockito.when((Object)decisionNode2.getInEdges()).thenReturn(Collections.singletonList(edge));
        Mockito.when((Object)edge.getSourceNode()).thenReturn((Object)decisionNode1);
        Mockito.when((Object)edge.getTargetNode()).thenReturn((Object)decisionNode2);
        sourceMagnetConsumer.accept(edgeSourceConnection);
        targetMagnetConsumer.accept(edgeTargetConnection);
        ((Graph)Mockito.doReturn(Arrays.asList(diagramNode, decisionNode1, decisionNode2)).when((Object)graph)).nodes();
        diagram.setGraph(graph);
        return diagram;
    }

    private void checkComponentWidths(Graph<?, Node<?, ?>> graph) {
        Node node = graph.getNode("_37883BDC-DB54-4925-B539-A0F19B1DDE41");
        Assertions.assertThat((Object)node).isNotNull();
        DMNMarshallerTest.assertNodeContentDefinitionIs(node, Decision.class);
        Decision definition = (Decision)((View)node.getContent()).getDefinition();
        Assertions.assertThat((Object)definition.getExpression()).isNotNull();
        Expression expression = definition.getExpression();
        List componentWidths = expression.getComponentWidths();
        Assertions.assertThat((int)componentWidths.size()).isEqualTo(expression.getRequiredComponentWidthCount());
        Assertions.assertThat((Double)((Double)componentWidths.get(0))).isEqualTo(50.0);
        Assertions.assertThat((Double)((Double)componentWidths.get(1))).isEqualTo(150.0);
        Assertions.assertThat((Double)((Double)componentWidths.get(2))).isEqualTo(200.0);
        Assertions.assertThat((Double)((Double)componentWidths.get(3))).isEqualTo(250.0);
    }

    private static void testAugmentWithNSPrefixes(org.kie.workbench.common.dmn.api.definition.model.Definitions definitions) {
        for (DMNModelInstrumentedBase.Namespace nsp : DMNModelInstrumentedBase.Namespace.values()) {
            definitions.getNsContext().put(nsp.getPrefix(), nsp.getUri());
        }
    }

    private Diagram<Graph, Metadata> newDiagramDecisionWithExpression(Expression expression) {
        DiagramImpl diagram = this.createDiagram();
        Graph graph = (Graph)Mockito.mock(Graph.class);
        Node diagramNode = (Node)Mockito.mock(Node.class);
        View diagramView = (View)Mockito.mock(View.class);
        DMNDiagram dmnDiagram = new DMNDiagram();
        ((Node)Mockito.doReturn((Object)diagramView).when((Object)diagramNode)).getContent();
        ((View)Mockito.doReturn((Object)dmnDiagram).when((Object)diagramView)).getDefinition();
        Node decisionNode = (Node)Mockito.mock(Node.class);
        View decisionView = (View)Mockito.mock(View.class);
        Decision decision = new Decision();
        ((Node)Mockito.doReturn((Object)decisionView).when((Object)decisionNode)).getContent();
        ((View)Mockito.doReturn((Object)decision).when((Object)decisionView)).getDefinition();
        decision.setExpression(expression);
        ((Graph)Mockito.doReturn(Arrays.asList(diagramNode, decisionNode)).when((Object)graph)).nodes();
        diagram.setGraph(graph);
        return diagram;
    }

    private static void checkDecisionExpression(Graph<?, Node<View, ?>> unmarshalledGraph, Expression expression) {
        Node<View, ?> decisionNode = DMNMarshallerTest.nodeOfDefinition(unmarshalledGraph.nodes().iterator(), Decision.class);
        Expression decisionNodeExpression = ((Decision)((View)decisionNode.getContent()).getDefinition()).getExpression();
        decisionNodeExpression.getComponentWidths();
        ((org.kie.workbench.common.dmn.api.definition.model.ContextEntry)((org.kie.workbench.common.dmn.api.definition.model.Context)decisionNodeExpression).getContextEntry().get(0)).getExpression().getComponentWidths();
        Assertions.assertThat((Object)decisionNodeExpression).isEqualTo((Object)expression);
    }

    private static Node<View, ?> nodeOfDefinition(Iterator<Node<View, ?>> nodesIterator, Class aClass) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(nodesIterator, 256), false).filter(node -> aClass.isInstance(((View)node.getContent()).getDefinition())).findFirst().get();
    }

    @SafeVarargs
    private final XPath namespaceAwareXPath(final Map.Entry<String, String> ... pfxAndURI) {
        XPath result = XPathFactory.newInstance().newXPath();
        result.setNamespaceContext(new NamespaceContext(){
            final Map<String, String> pfxToURI = new HashMap<String, String>(){
                {
                    for (Map.Entry pair : pfxAndURI) {
                        this.put(pair.getKey(), pair.getValue());
                    }
                }
            };
            final Map<String, String> URItoPfx = new HashMap<String, String>(){
                {
                    for (Map.Entry pair : pfxAndURI) {
                        this.put(pair.getValue(), pair.getKey());
                    }
                }
            };

            @Override
            public String getNamespaceURI(String prefix) {
                return this.pfxToURI.get(prefix);
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return this.URItoPfx.get(namespaceURI);
            }

            public Iterator getPrefixes(String namespaceURI) {
                return this.pfxToURI.keySet().iterator();
            }
        });
        return result;
    }

    private DMNMarshaller getDMNMarshaller() {
        return new DMNMarshaller(new XMLEncoderDiagramMetadataMarshaller(), this.api.getFactoryManager(), this.dmnMarshallerImportsHelper, this.getMarshaller());
    }

    private org.kie.dmn.api.marshalling.DMNMarshaller getMarshaller() {
        return new DMNMarshallerProducer().get();
    }

    private void assertXPathEquals(XPath xpathOriginal, XPath xpathRoundtrip, String xpathExpression, String expectedXml, String actualXml) throws XPathExpressionException {
        InputSource expected = new InputSource(new StringReader(expectedXml));
        InputSource actual = new InputSource(new StringReader(actualXml));
        Assert.assertEquals((Object)xpathOriginal.compile(xpathExpression).evaluate(expected), (Object)xpathRoundtrip.compile(xpathExpression).evaluate(actual));
    }

    private DiagramImpl createDiagram() {
        return (DiagramImpl)this.api.getFactoryManager().newDiagram("dmnDiagram", DMN_DEF_SET_ID, DMNMarshallerTest.createMetadata());
    }

    private static Metadata createMetadata() {
        return (Metadata)Mockito.mock(Metadata.class);
    }

    private static class ErrorsAndDMNModelAsSerialized {
        final List<Message> messages;
        final Definitions definitions;

        public ErrorsAndDMNModelAsSerialized(List<Message> messages, Definitions definitions) {
            this.messages = Collections.unmodifiableList(messages);
            this.definitions = definitions;
        }

        public boolean hasErrors() {
            return this.messages.stream().filter(m -> m.getLevel().equals((Object)Message.Level.ERROR)).count() > 0L;
        }
    }
}

