/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1.dd;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.ExternalLink;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.ExternalLinksConverter;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ExternalLinksConverterTest {
    @Mock
    private XStream xStream;
    private ExternalLinksConverter converter;
    private final String TEST_URL = "http://www.kiegroup.org/foo.pdf";
    private final String TEST_NAME = "Something";

    @Before
    public void setup() {
        this.converter = (ExternalLinksConverter)Mockito.spy((Object)new ExternalLinksConverter(this.xStream));
        ((ExternalLinksConverter)Mockito.doNothing().when((Object)this.converter)).superAssignAttributes((HierarchicalStreamReader)Matchers.any(), Matchers.any());
        ((ExternalLinksConverter)Mockito.doNothing().when((Object)this.converter)).superWriteAttributes((HierarchicalStreamWriter)Matchers.any(), Matchers.any());
    }

    @Test
    public void testAssignAttributes() {
        ExternalLink externalLink = (ExternalLink)Mockito.mock(ExternalLink.class);
        HierarchicalStreamReader reader = (HierarchicalStreamReader)Mockito.mock(HierarchicalStreamReader.class);
        Mockito.when((Object)reader.getAttribute("name")).thenReturn((Object)"Something");
        Mockito.when((Object)reader.getAttribute("url")).thenReturn((Object)"http://www.kiegroup.org/foo.pdf");
        this.converter.assignAttributes(reader, (Object)externalLink);
        ((ExternalLink)Mockito.verify((Object)externalLink)).setName("Something");
        ((ExternalLink)Mockito.verify((Object)externalLink)).setUrl("http://www.kiegroup.org/foo.pdf");
    }

    @Test
    public void testWriteAttributes() {
        HierarchicalStreamWriter writer = (HierarchicalStreamWriter)Mockito.mock(HierarchicalStreamWriter.class);
        ExternalLink externalLink = new ExternalLink();
        externalLink.setUrl("http://www.kiegroup.org/foo.pdf");
        externalLink.setName("Something");
        this.converter.writeAttributes(writer, (Object)externalLink);
        ((HierarchicalStreamWriter)Mockito.verify((Object)writer)).addAttribute("url", "http://www.kiegroup.org/foo.pdf");
        ((HierarchicalStreamWriter)Mockito.verify((Object)writer)).addAttribute("name", "Something");
    }
}

