/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.common;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.namespace.QName;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.kie.dmn.api.marshalling.DMNMarshaller;
import org.kie.dmn.model.api.DRGElement;
import org.kie.dmn.model.api.Decision;
import org.kie.dmn.model.api.Definitions;
import org.kie.dmn.model.api.Import;
import org.kie.dmn.model.api.InformationItem;
import org.kie.dmn.model.api.InputData;
import org.kie.dmn.model.api.Invocable;
import org.kie.dmn.model.api.ItemDefinition;
import org.kie.dmn.model.v1_2.TInformationItem;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.editors.types.BuiltInTypeUtils;
import org.kie.workbench.common.dmn.api.marshalling.DMNPathsHelper;
import org.kie.workbench.common.dmn.backend.common.DMNIOHelper;
import org.kie.workbench.common.dmn.backend.common.DMNMarshallerImportsHelperStandalone;
import org.kie.workbench.common.dmn.backend.definition.v1_1.ImportedItemDefinitionConverter;
import org.kie.workbench.common.dmn.backend.editors.common.PMMLIncludedDocumentFactory;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class DMNMarshallerImportsHelperStandaloneImpl
implements DMNMarshallerImportsHelperStandalone {
    private final DMNPathsHelper pathsHelper;
    private final WorkspaceProjectService projectService;
    private final IOService ioService;
    private final DMNMarshaller marshaller;
    private final DMNIOHelper dmnIOHelper;
    public static final QName NAMESPACE = new QName("Namespace");
    private final PMMLIncludedDocumentFactory pmmlDocumentFactory;

    public DMNMarshallerImportsHelperStandaloneImpl() {
        this(null, null, null, null, null, null);
    }

    @Inject
    public DMNMarshallerImportsHelperStandaloneImpl(DMNPathsHelper pathsHelper, WorkspaceProjectService projectService, DMNMarshaller marshaller, DMNIOHelper dmnIOHelper, PMMLIncludedDocumentFactory pmmlDocumentFactory, @Named(value="ioStrategy") IOService ioService) {
        this.pathsHelper = pathsHelper;
        this.projectService = projectService;
        this.marshaller = marshaller;
        this.dmnIOHelper = dmnIOHelper;
        this.pmmlDocumentFactory = pmmlDocumentFactory;
        this.ioService = ioService;
    }

    public Map<Import, Definitions> getImportDefinitions(Metadata metadata, List<Import> imports) {
        HashMap<Import, Definitions> importDefinitions = new HashMap<Import, Definitions>();
        if (imports.size() > 0) {
            for (Definitions definitions : this.getOtherDMNDiagramsDefinitions(metadata)) {
                this.findImportByDefinitions(definitions, imports).ifPresent(anImport -> importDefinitions.put((Import)anImport, definitions));
            }
        }
        return importDefinitions;
    }

    public Map<Import, PMMLDocumentMetadata> getPMMLDocuments(Metadata metadata, List<Import> imports) {
        HashMap<Import, PMMLDocumentMetadata> pmmlDocuments = new HashMap<Import, PMMLDocumentMetadata>();
        if (imports.size() > 0) {
            for (org.uberfire.backend.vfs.Path pmmlDocumentPath : this.getPMMLDocumentPaths(metadata)) {
                this.findImportByPMMLDocument(metadata.getPath(), pmmlDocumentPath, imports).ifPresent(anImport -> pmmlDocuments.put((Import)anImport, this.pmmlDocumentFactory.getDocumentByPath(pmmlDocumentPath)));
            }
        }
        return pmmlDocuments;
    }

    public Map<Import, String> getImportXML(Metadata metadata, List<Import> imports) {
        HashMap<Import, String> importXML = new HashMap<Import, String>();
        if (imports.size() > 0) {
            for (String xml : this.getOtherDMNDiagramsXML(metadata)) {
                StringReader sr = this.toStringReader(xml);
                Throwable throwable = null;
                try {
                    Definitions definitions = this.marshaller.unmarshal((Reader)sr);
                    this.findImportByDefinitions(definitions, imports).ifPresent(anImport -> importXML.put((Import)anImport, xml));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (sr == null) continue;
                    if (throwable != null) {
                        try {
                            sr.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    sr.close();
                }
            }
        }
        return importXML;
    }

    public org.uberfire.backend.vfs.Path getDMNModelPath(Metadata metadata, String modelNamespace, String modelName) {
        WorkspaceProject workspaceProject = this.getProject(metadata);
        for (org.uberfire.backend.vfs.Path dmnModelPath : this.pathsHelper.getDMNModelsPaths(workspaceProject)) {
            Optional<Definitions> definitions = this.getDefinitionsByPath(dmnModelPath);
            if (!definitions.map(d -> Objects.equals(d.getNamespace(), modelNamespace) && Objects.equals(d.getName(), modelName)).orElse(false).booleanValue()) continue;
            return dmnModelPath;
        }
        throw new IllegalStateException("A path for the DMN model with namespace [" + modelNamespace + "] could not be found.");
    }

    public List<DRGElement> getImportedDRGElements(Map<Import, Definitions> importDefinitions) {
        ArrayList<DRGElement> importedNodes = new ArrayList<DRGElement>();
        importDefinitions.forEach((anImport, definitions) -> importedNodes.addAll(this.getDrgElementsWithNamespace((Definitions)definitions, (Import)anImport)));
        return importedNodes;
    }

    public List<ItemDefinition> getImportedItemDefinitions(Map<Import, Definitions> importDefinitions) {
        ArrayList<ItemDefinition> itemDefinitions = new ArrayList<ItemDefinition>();
        importDefinitions.forEach((anImport, definitions) -> itemDefinitions.addAll(this.getItemDefinitionsWithNamespace((Definitions)definitions, (Import)anImport)));
        return itemDefinitions;
    }

    public List<ItemDefinition> getImportedItemDefinitionsByNamespace(WorkspaceProject workspaceProject, String modelName, String namespace) {
        return this.findDefinitionsByNamespace(workspaceProject, namespace).map(Definitions::getItemDefinition).orElse(Collections.emptyList());
    }

    private Optional<Definitions> findDefinitionsByNamespace(WorkspaceProject workspaceProject, String namespace) {
        return this.pathsHelper.getDMNModelsPaths(workspaceProject).stream().map(path -> this.getDefinitionsByPath((org.uberfire.backend.vfs.Path)path).orElse(null)).filter(Objects::nonNull).filter(definitions -> Objects.equals(definitions.getNamespace(), namespace)).findAny();
    }

    List<ItemDefinition> getItemDefinitionsWithNamespace(Definitions definitions, Import anImport) {
        List itemDefinitions = definitions.getItemDefinition();
        String prefix = anImport.getName();
        return itemDefinitions.stream().map(itemDefinition -> ImportedItemDefinitionConverter.withNamespace(itemDefinition, prefix)).collect(Collectors.toList());
    }

    List<DRGElement> getDrgElementsWithNamespace(Definitions definitions, Import anImport) {
        return definitions.getDrgElement().stream().map(drgElement -> this.drgElementWithNamespace((DRGElement)drgElement, anImport)).collect(Collectors.toList());
    }

    private DRGElement drgElementWithNamespace(DRGElement drgElement, Import anImport) {
        String namespace = anImport.getName();
        drgElement.getAdditionalAttributes().put(NAMESPACE, anImport.getNamespace());
        drgElement.setId(namespace + ":" + drgElement.getId());
        drgElement.setName(namespace + "." + drgElement.getName());
        this.updateInformationItem(namespace, drgElement);
        return drgElement;
    }

    private void updateInformationItem(String namespace, DRGElement drgElement) {
        this.getInformationItem(drgElement).ifPresent(informationItem -> {
            TInformationItem tInformationItem = new TInformationItem();
            QName qName = informationItem.getTypeRef();
            if (qName != null && !BuiltInTypeUtils.isBuiltInType((String)qName.getLocalPart())) {
                tInformationItem.setTypeRef(new QName(qName.getNamespaceURI(), namespace + "." + qName.getLocalPart(), qName.getPrefix()));
            }
            this.setInformationItem(drgElement, (InformationItem)tInformationItem);
        });
    }

    private Optional<InformationItem> getInformationItem(DRGElement drgElement) {
        if (drgElement instanceof Decision) {
            return Optional.of(((Decision)drgElement).getVariable());
        }
        if (drgElement instanceof InputData) {
            return Optional.of(((InputData)drgElement).getVariable());
        }
        if (drgElement instanceof Invocable) {
            return Optional.of(((Invocable)drgElement).getVariable());
        }
        return Optional.empty();
    }

    private void setInformationItem(DRGElement drgElement, InformationItem informationItem) {
        if (drgElement instanceof Decision) {
            ((Decision)drgElement).setVariable(informationItem);
        }
        if (drgElement instanceof InputData) {
            ((InputData)drgElement).setVariable(informationItem);
        }
        if (drgElement instanceof Invocable) {
            ((Invocable)drgElement).setVariable(informationItem);
        }
    }

    private Optional<Import> findImportByDefinitions(Definitions definitions, List<Import> imports) {
        return imports.stream().filter(anImport -> Objects.equals(anImport.getNamespace(), definitions.getNamespace())).findAny();
    }

    private Optional<Import> findImportByPMMLDocument(org.uberfire.backend.vfs.Path dmnModelPath, org.uberfire.backend.vfs.Path includedModelPath, List<Import> imports) {
        return imports.stream().filter(anImport -> Objects.equals(anImport.getLocationURI(), this.pathsHelper.getRelativeURI(dmnModelPath, includedModelPath))).findAny();
    }

    List<Definitions> getOtherDMNDiagramsDefinitions(Metadata metadata) {
        List diagramPaths = this.pathsHelper.getDMNModelsPaths(this.getProject(metadata));
        return diagramPaths.stream().filter(path -> !Objects.equals(metadata.getPath(), path)).map(path -> this.loadPath((org.uberfire.backend.vfs.Path)path).orElse(null)).filter(Objects::nonNull).map(this::toDefinitions).filter(Objects::nonNull).collect(Collectors.toList());
    }

    /*
     * Exception decompiling
     */
    private Definitions toDefinitions(InputStream inputStream) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    List<org.uberfire.backend.vfs.Path> getPMMLDocumentPaths(Metadata metadata) {
        return this.pathsHelper.getPMMLModelsPaths(this.getProject(metadata));
    }

    InputStreamReader toInputStreamReader(InputStream inputStream) {
        return new InputStreamReader(inputStream);
    }

    Optional<Definitions> getDefinitionsByPath(org.uberfire.backend.vfs.Path dmnModelPath) {
        return this.loadPath(dmnModelPath).map(this::toInputStreamReader).map(arg_0 -> ((DMNMarshaller)this.marshaller).unmarshal(arg_0));
    }

    StringReader toStringReader(String xml) {
        return new StringReader(xml);
    }

    private List<String> getOtherDMNDiagramsXML(Metadata metadata) {
        List diagramPaths = this.pathsHelper.getDMNModelsPaths(this.getProject(metadata));
        return diagramPaths.stream().filter(path -> !Objects.equals(metadata.getPath(), path)).map(path -> this.loadPath((org.uberfire.backend.vfs.Path)path).orElse(null)).filter(Objects::nonNull).map(this.dmnIOHelper::isAsString).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Optional<InputStream> loadPath(org.uberfire.backend.vfs.Path path) {
        try {
            return Optional.ofNullable(this.ioService.newInputStream(this.convertPath(path), new OpenOption[0]));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private WorkspaceProject getProject(Metadata metadata) {
        try {
            return this.projectService.resolveProject(metadata.getPath());
        }
        catch (Exception e) {
            return null;
        }
    }

    Path convertPath(org.uberfire.backend.vfs.Path path) {
        return Paths.convert((org.uberfire.backend.vfs.Path)path);
    }
}

