/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.model.api.FunctionDefinition;
import org.kie.dmn.model.api.InformationItem;
import org.kie.dmn.model.v1_2.TBusinessKnowledgeModel;
import org.kie.dmn.model.v1_2.TFunctionDefinition;
import org.kie.dmn.model.v1_2.TInformationItem;
import org.kie.dmn.model.v1_2.TLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.HasComponentWidths;
import org.kie.workbench.common.dmn.api.definition.model.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.model.Expression;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.backend.definition.v1_1.BusinessKnowledgeModelConverter;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.ComponentWidths;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.util.UUID;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class BusinessKnowledgeModelConverterTest {
    private static final String DECISION_UUID = "d-uuid";
    private static final String DECISION_NAME = "d-name";
    private static final String DECISION_DESCRIPTION = "d-description";
    private static final String FUNCTION_DEFINITION_UUID = "fd-uuid";
    private static final String EXPRESSION_UUID = "uuid";
    @Mock
    private BiConsumer<String, HasComponentWidths> hasComponentWidthsConsumer;
    @Mock
    private Consumer<ComponentWidths> componentWidthsConsumer;
    @Mock
    private FactoryManager factoryManager;
    @Mock
    private Element element;
    @Captor
    private ArgumentCaptor<HasComponentWidths> hasComponentWidthsCaptor;
    @Captor
    private ArgumentCaptor<ComponentWidths> componentWidthsCaptor;
    private BusinessKnowledgeModelConverter converter;

    @Before
    public void setup() {
        this.converter = new BusinessKnowledgeModelConverter(this.factoryManager);
    }

    @Test
    public void testWBFromDMN() {
        NodeImpl factoryNode = new NodeImpl(UUID.uuid());
        ViewImpl view = new ViewImpl((Object)new BusinessKnowledgeModel(), Bounds.create());
        factoryNode.setContent((Object)view);
        Mockito.when((Object)this.factoryManager.newElement(Matchers.anyString(), (String)Matchers.eq((Object)BindableAdapterUtils.getDefinitionId(BusinessKnowledgeModel.class)))).thenReturn((Object)this.element);
        Mockito.when((Object)this.element.asNode()).thenReturn((Object)factoryNode);
        TBusinessKnowledgeModel dmn = new TBusinessKnowledgeModel();
        TLiteralExpression literalExpression = new TLiteralExpression();
        TInformationItem informationItem = new TInformationItem();
        TFunctionDefinition functionDefinition = new TFunctionDefinition();
        literalExpression.setId(EXPRESSION_UUID);
        functionDefinition.setExpression((org.kie.dmn.model.api.Expression)literalExpression);
        functionDefinition.setId(FUNCTION_DEFINITION_UUID);
        dmn.setId(DECISION_UUID);
        dmn.setName(DECISION_NAME);
        dmn.setDescription(DECISION_DESCRIPTION);
        dmn.setVariable((InformationItem)informationItem);
        dmn.setEncapsulatedLogic((FunctionDefinition)functionDefinition);
        Node node = this.converter.nodeFromDMN((org.kie.dmn.model.api.BusinessKnowledgeModel)dmn, this.hasComponentWidthsConsumer);
        BusinessKnowledgeModel wb = (BusinessKnowledgeModel)((View)node.getContent()).getDefinition();
        Assertions.assertThat((Object)wb).isNotNull();
        Assertions.assertThat((Object)wb.getId()).isNotNull();
        Assertions.assertThat((String)wb.getId().getValue()).isEqualTo(DECISION_UUID);
        Assertions.assertThat((Object)wb.getName()).isNotNull();
        Assertions.assertThat((String)wb.getName().getValue()).isEqualTo(DECISION_NAME);
        Assertions.assertThat((Object)wb.getDescription()).isNotNull();
        Assertions.assertThat((String)wb.getDescription().getValue()).isEqualTo(DECISION_DESCRIPTION);
        Assertions.assertThat((Object)wb.getVariable()).isNotNull();
        Assertions.assertThat((String)wb.getVariable().getName().getValue()).isEqualTo(DECISION_NAME);
        Assertions.assertThat((Object)wb.getEncapsulatedLogic()).isNotNull();
        Assertions.assertThat((Object)wb.getEncapsulatedLogic().getExpression()).isNotNull();
        Assertions.assertThat((String)wb.getEncapsulatedLogic().getExpression().getId().getValue()).isEqualTo(EXPRESSION_UUID);
        ((BiConsumer)Mockito.verify(this.hasComponentWidthsConsumer)).accept(Matchers.eq((Object)EXPRESSION_UUID), this.hasComponentWidthsCaptor.capture());
        HasComponentWidths hasComponentWidths0 = (HasComponentWidths)this.hasComponentWidthsCaptor.getValue();
        Assertions.assertThat((Object)hasComponentWidths0).isNotNull();
        Assertions.assertThat((Object)hasComponentWidths0).isEqualTo((Object)wb.getEncapsulatedLogic().getExpression());
        ((BiConsumer)Mockito.verify(this.hasComponentWidthsConsumer)).accept(Matchers.eq((Object)FUNCTION_DEFINITION_UUID), this.hasComponentWidthsCaptor.capture());
        HasComponentWidths hasComponentWidths1 = (HasComponentWidths)this.hasComponentWidthsCaptor.getValue();
        Assertions.assertThat((Object)hasComponentWidths1).isNotNull();
        Assertions.assertThat((Object)hasComponentWidths1).isEqualTo((Object)wb.getEncapsulatedLogic());
    }

    @Test
    public void testDMNFromWB() {
        BusinessKnowledgeModel wb = new BusinessKnowledgeModel();
        LiteralExpression literalExpression = new LiteralExpression();
        InformationItemPrimary informationItem = new InformationItemPrimary();
        org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition functionDefinition = new org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition();
        literalExpression.getComponentWidths().set(0, 200.0);
        literalExpression.getId().setValue(EXPRESSION_UUID);
        functionDefinition.getComponentWidths().set(0, 200.0);
        functionDefinition.setExpression((Expression)literalExpression);
        functionDefinition.getId().setValue(FUNCTION_DEFINITION_UUID);
        wb.getId().setValue(DECISION_UUID);
        wb.getName().setValue(DECISION_NAME);
        wb.getDescription().setValue(DECISION_DESCRIPTION);
        wb.setVariable(informationItem);
        wb.setEncapsulatedLogic(functionDefinition);
        NodeImpl node = new NodeImpl(UUID.uuid());
        ViewImpl view = new ViewImpl((Object)wb, Bounds.create());
        node.setContent((Object)view);
        org.kie.dmn.model.api.BusinessKnowledgeModel dmn = this.converter.dmnFromNode((Node)node, this.componentWidthsConsumer);
        Assertions.assertThat((Object)dmn).isNotNull();
        Assertions.assertThat((String)dmn.getId()).isNotNull();
        Assertions.assertThat((String)dmn.getId()).isEqualTo(DECISION_UUID);
        Assertions.assertThat((String)dmn.getName()).isNotNull();
        Assertions.assertThat((String)dmn.getName()).isEqualTo(DECISION_NAME);
        Assertions.assertThat((String)dmn.getDescription()).isNotNull();
        Assertions.assertThat((String)dmn.getDescription()).isEqualTo(DECISION_DESCRIPTION);
        Assertions.assertThat((Object)dmn.getVariable()).isNotNull();
        Assertions.assertThat((String)dmn.getVariable().getName()).isEqualTo(DECISION_NAME);
        Assertions.assertThat((Object)dmn.getEncapsulatedLogic()).isNotNull();
        Assertions.assertThat((Object)dmn.getEncapsulatedLogic().getExpression()).isNotNull();
        Assertions.assertThat((String)dmn.getEncapsulatedLogic().getExpression().getId()).isEqualTo(EXPRESSION_UUID);
        ((Consumer)Mockito.verify(this.componentWidthsConsumer, (VerificationMode)Mockito.times((int)2))).accept(this.componentWidthsCaptor.capture());
        List componentWidths = this.componentWidthsCaptor.getAllValues();
        Assertions.assertThat((List)componentWidths).isNotNull();
        Assertions.assertThat((List)componentWidths).hasSize(2);
        ComponentWidths componentWidths0 = (ComponentWidths)componentWidths.get(0);
        Assertions.assertThat((String)componentWidths0.getDmnElementRef().getLocalPart()).isEqualTo(EXPRESSION_UUID);
        Assertions.assertThat((int)componentWidths0.getWidths().size()).isEqualTo(literalExpression.getRequiredComponentWidthCount());
        Assertions.assertThat((Double)((Double)componentWidths0.getWidths().get(0))).isEqualTo(200.0);
        ComponentWidths componentWidths1 = (ComponentWidths)componentWidths.get(1);
        Assertions.assertThat((String)componentWidths1.getDmnElementRef().getLocalPart()).isEqualTo(FUNCTION_DEFINITION_UUID);
        Assertions.assertThat((int)componentWidths1.getWidths().size()).isEqualTo(functionDefinition.getRequiredComponentWidthCount());
        Assertions.assertThat((Double)((Double)componentWidths1.getWidths().get(0))).isEqualTo(200.0);
    }
}

