/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import javax.xml.namespace.QName;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.model.api.ImportedValues;
import org.kie.dmn.model.api.LiteralExpression;
import org.kie.dmn.model.v1_2.TImportedValues;
import org.kie.dmn.model.v1_2.TLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.IsLiteralExpression;

public abstract class BaseLiteralExpressionPropertyConverterTest<T extends IsLiteralExpression> {
    private static final String UUID = "uuid";
    private static final String TEXT = "text";
    private static final String DESCRIPTION = "description";
    private static final String LOCAL = "local";
    private static final String IMPORTED_ELEMENT = "imported-element";

    @Test
    public void testWBFromDMN() {
        TLiteralExpression dmn = new TLiteralExpression();
        QName typeRef = new QName(DMNModelInstrumentedBase.Namespace.KIE.getUri(), LOCAL, DMNModelInstrumentedBase.Namespace.KIE.getPrefix());
        TImportedValues importedValues = new TImportedValues();
        importedValues.setImportedElement(IMPORTED_ELEMENT);
        dmn.setId(UUID);
        dmn.setDescription(DESCRIPTION);
        dmn.setTypeRef(typeRef);
        dmn.setText(TEXT);
        dmn.setImportedValues((ImportedValues)importedValues);
        T wb = this.convertWBFromDMN((LiteralExpression)dmn);
        Assertions.assertThat((String)wb.getId().getValue()).isEqualTo(UUID);
        Assertions.assertThat((String)wb.getDescription().getValue()).isEqualTo(DESCRIPTION);
        Assertions.assertThat((String)wb.getTypeRef().getNamespaceURI()).isEqualTo(DMNModelInstrumentedBase.Namespace.KIE.getUri());
        Assertions.assertThat((String)wb.getTypeRef().getLocalPart()).isEqualTo(LOCAL);
        Assertions.assertThat((String)wb.getTypeRef().getPrefix()).isEqualTo(DMNModelInstrumentedBase.Namespace.KIE.getPrefix());
        Assertions.assertThat((String)wb.getText().getValue()).isEqualTo(TEXT);
        Assertions.assertThat((String)wb.getImportedValues().getImportedElement()).isEqualTo(IMPORTED_ELEMENT);
        Assertions.assertThat((Object)wb.getImportedValues().getParent()).isEqualTo(wb);
    }

    protected abstract T convertWBFromDMN(LiteralExpression var1);
}

