/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.tools.ant.filters.StringInputStream;
import org.jboss.errai.marshalling.server.MappingContextSingleton;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.core.util.KieHelper;
import org.kie.workbench.common.dmn.api.DMNDefinitionSet;
import org.kie.workbench.common.dmn.api.definition.v1_1.Association;
import org.kie.workbench.common.dmn.api.definition.v1_1.AuthorityRequirement;
import org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.v1_1.Decision;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationRequirement;
import org.kie.workbench.common.dmn.api.definition.v1_1.InputData;
import org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeRequirement;
import org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource;
import org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation;
import org.kie.workbench.common.dmn.backend.DMNMarshaller;
import org.kie.workbench.common.stunner.backend.ApplicationFactoryManager;
import org.kie.workbench.common.stunner.backend.definition.factory.TestScopeModelFactory;
import org.kie.workbench.common.stunner.backend.service.XMLEncoderDiagramMetadataMarshaller;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.annotation.RuntimeDefinitionAdapter;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.annotation.RuntimeDefinitionSetAdapter;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.annotation.RuntimePropertyAdapter;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.annotation.RuntimePropertySetAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.AdapterManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.DiagramImpl;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.diagram.MetadataImpl;
import org.kie.workbench.common.stunner.core.factory.graph.EdgeFactory;
import org.kie.workbench.common.stunner.core.factory.graph.GraphFactory;
import org.kie.workbench.common.stunner.core.factory.graph.NodeFactory;
import org.kie.workbench.common.stunner.core.factory.impl.EdgeFactoryImpl;
import org.kie.workbench.common.stunner.core.factory.impl.GraphFactoryImpl;
import org.kie.workbench.common.stunner.core.factory.impl.NodeFactoryImpl;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandManager;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandManagerImpl;
import org.kie.workbench.common.stunner.core.graph.command.impl.GraphCommandFactory;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.registry.definition.AdapterRegistry;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNMarshallerTest {
    private static final String DMN_DEF_SET_ID = BindableAdapterUtils.getDefinitionSetId(DMNDefinitionSet.class);
    @Mock
    DefinitionManager definitionManager;
    @Mock
    AdapterManager adapterManager;
    @Mock
    AdapterRegistry adapterRegistry;
    @Mock
    BeanManager beanManager;
    @Mock
    RuleManager rulesManager;
    @Mock
    ApplicationFactoryManager applicationFactoryManager;
    EdgeFactory<Object> connectionEdgeFactory;
    NodeFactory<Object> viewNodeFactory;
    DefinitionUtils definitionUtils;
    GraphCommandManager commandManager;
    GraphCommandFactory commandFactory;
    GraphFactory dmnGraphFactory;
    TestScopeModelFactory testScopeModelFactory;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.definitionManager.adapters()).thenReturn((Object)this.adapterManager);
        Mockito.when((Object)this.adapterManager.registry()).thenReturn((Object)this.adapterRegistry);
        this.definitionUtils = new DefinitionUtils(this.definitionManager, (FactoryManager)this.applicationFactoryManager);
        this.testScopeModelFactory = new TestScopeModelFactory((Object)new DMNDefinitionSet.DMNDefinitionSetBuilder().build());
        RuntimeDefinitionAdapter definitionAdapter = new RuntimeDefinitionAdapter(this.definitionUtils);
        RuntimeDefinitionSetAdapter definitionSetAdapter = new RuntimeDefinitionSetAdapter(definitionAdapter);
        RuntimePropertySetAdapter propertySetAdapter = new RuntimePropertySetAdapter();
        RuntimePropertyAdapter propertyAdapter = new RuntimePropertyAdapter();
        Mockito.when((Object)this.adapterManager.forDefinitionSet()).thenReturn((Object)definitionSetAdapter);
        Mockito.when((Object)this.adapterManager.forDefinition()).thenReturn((Object)definitionAdapter);
        Mockito.when((Object)this.adapterManager.forPropertySet()).thenReturn((Object)propertySetAdapter);
        Mockito.when((Object)this.adapterManager.forProperty()).thenReturn((Object)propertyAdapter);
        Mockito.when((Object)this.adapterRegistry.getDefinitionSetAdapter((Class)Matchers.any(Class.class))).thenReturn((Object)definitionSetAdapter);
        Mockito.when((Object)this.adapterRegistry.getDefinitionAdapter((Class)Matchers.any(Class.class))).thenReturn((Object)definitionAdapter);
        Mockito.when((Object)this.adapterRegistry.getPropertySetAdapter((Class)Matchers.any(Class.class))).thenReturn((Object)propertySetAdapter);
        Mockito.when((Object)this.adapterRegistry.getPropertyAdapter((Class)Matchers.any(Class.class))).thenReturn((Object)propertyAdapter);
        this.commandManager = new GraphCommandManagerImpl(null, null, null);
        this.commandFactory = new GraphCommandFactory();
        this.connectionEdgeFactory = new EdgeFactoryImpl(this.definitionManager);
        this.viewNodeFactory = new NodeFactoryImpl(this.definitionUtils);
        this.dmnGraphFactory = new GraphFactoryImpl(this.definitionManager);
        ((ApplicationFactoryManager)Mockito.doAnswer(invocationOnMock -> {
            String id = (String)invocationOnMock.getArguments()[0];
            return this.testScopeModelFactory.build(id);
        }).when((Object)this.applicationFactoryManager)).newDefinition(Matchers.anyString());
        ((ApplicationFactoryManager)Mockito.doAnswer(invocationOnMock -> {
            Object model;
            String uuid = (String)invocationOnMock.getArguments()[0];
            String id = (String)invocationOnMock.getArguments()[1];
            if (DMNDefinitionSet.class.getName().equals(id)) {
                Graph graph = (Graph)this.dmnGraphFactory.build(uuid, (Object)DMN_DEF_SET_ID);
                DMNDiagram model2 = new DMNDiagram.DMNDiagramBuilder().build();
                Node node = (Node)this.viewNodeFactory.build(uuid, (Object)model2);
                graph.addNode(node);
                return graph;
            }
            Object object = model = this.testScopeModelFactory.accepts(id) ? this.testScopeModelFactory.build(id) : null;
            if (null != model) {
                Class element = RuntimeDefinitionAdapter.getGraphFactory(model.getClass());
                if (element.isAssignableFrom(NodeFactory.class)) {
                    Node node = (Node)this.viewNodeFactory.build(uuid, model);
                    return node;
                }
                if (element.isAssignableFrom(EdgeFactory.class)) {
                    Edge edge = (Edge)this.connectionEdgeFactory.build(uuid, model);
                    return edge;
                }
            }
            return null;
        }).when((Object)this.applicationFactoryManager)).newElement(Matchers.anyString(), Matchers.anyString());
        ((ApplicationFactoryManager)Mockito.doAnswer(invocationOnMock -> {
            Object model;
            String uuid = (String)invocationOnMock.getArguments()[0];
            Class type = (Class)invocationOnMock.getArguments()[1];
            String id = BindableAdapterUtils.getGenericClassName((Class)type);
            if (DMNDefinitionSet.class.equals((Object)type)) {
                Graph graph = (Graph)this.dmnGraphFactory.build(uuid, (Object)DMN_DEF_SET_ID);
                return graph;
            }
            Object object = model = this.testScopeModelFactory.accepts(id) ? this.testScopeModelFactory.build(id) : null;
            if (null != model) {
                Class element = RuntimeDefinitionAdapter.getGraphFactory(model.getClass());
                if (element.isAssignableFrom(NodeFactory.class)) {
                    Node node = (Node)this.viewNodeFactory.build(uuid, model);
                    return node;
                }
                if (element.isAssignableFrom(EdgeFactory.class)) {
                    Edge edge = (Edge)this.connectionEdgeFactory.build(uuid, model);
                    return edge;
                }
            }
            return null;
        }).when((Object)this.applicationFactoryManager)).newElement(Matchers.anyString(), (Class)Matchers.any(Class.class));
        ((ApplicationFactoryManager)Mockito.doAnswer(invocationOnMock -> {
            String uuid = (String)invocationOnMock.getArguments()[0];
            String defSetId = (String)invocationOnMock.getArguments()[1];
            Graph graph = (Graph)this.applicationFactoryManager.newElement(uuid, defSetId);
            DiagramImpl result = new DiagramImpl(uuid, (Metadata)new MetadataImpl.MetadataImplBuilder(defSetId).build());
            result.setGraph(graph);
            return result;
        }).when((Object)this.applicationFactoryManager)).newDiagram(Matchers.anyString(), Matchers.anyString(), (Metadata)Matchers.any(Metadata.class));
        MappingContextSingleton.loadDynamicMarshallers();
    }

    @Test
    public void test_diamond() throws IOException {
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/diamond.dmn"), this::checkDiamongGraph);
        DMNMarshaller m = new DMNMarshaller(new XMLEncoderDiagramMetadataMarshaller(), (FactoryManager)this.applicationFactoryManager);
        Graph g = m.unmarshall(null, this.getClass().getResourceAsStream("/diamond.dmn"));
        DiagramImpl diagram = new DiagramImpl("", null);
        diagram.setGraph(g);
        String mString = m.marshall((Diagram)diagram);
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", "dmn-test_diamond", "1.0"), (Resource[])new Resource[]{ks.getResources().newByteArrayResource(mString.getBytes()).setTargetPath("src/main/resources/diamond.dmn")});
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        Assert.assertNotNull((Object)runtime);
        DMNModel diamondModel = runtime.getModel("http://www.trisotech.com/definitions/_8afa6c24-55c8-43cf-8a02-fdde7fc5d1f2", "three decisions in a diamond shape");
        DMNContext dmnContext = runtime.newContext();
        dmnContext.set("My Name", (Object)"John Doe");
        DMNResult dmnResult = runtime.evaluateAll(diamondModel, dmnContext);
        Assert.assertFalse((String)dmnResult.getMessages().toString(), (boolean)dmnResult.hasErrors());
        DMNContext result = dmnResult.getContext();
        Assert.assertEquals((Object)"Hello, John Doe.", (Object)result.get("My Decision"));
    }

    @Test
    public void test_potpourri_drawing() throws IOException {
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/potpourri_drawing.dmn"), this::checkPotpourryGraph);
    }

    public void roundTripUnmarshalThenMarshalUnmarshal(InputStream dmnXmlInputStream, Consumer<Graph<?, Node<?, ?>>> checkGraphConsumer) throws IOException {
        DMNMarshaller m = new DMNMarshaller(new XMLEncoderDiagramMetadataMarshaller(), (FactoryManager)this.applicationFactoryManager);
        Graph g = m.unmarshall(null, dmnXmlInputStream);
        checkGraphConsumer.accept(g);
        DiagramImpl diagram = new DiagramImpl("", null);
        diagram.setGraph(g);
        String mString = m.marshall((Diagram)diagram);
        System.out.println(mString);
        Graph g2 = m.unmarshall(null, (InputStream)new StringInputStream(mString));
        checkGraphConsumer.accept(g2);
    }

    private void checkDiamongGraph(Graph<?, Node<?, ?>> g) {
        Node idNode = g.getNode("_4cd17e52-6253-41d6-820d-5824bf5197f3");
        DMNMarshallerTest.assertNodeContentDefinitionIs(idNode, InputData.class);
        DMNMarshallerTest.assertNodeEdgesTo(idNode, g.getNode("_e920f38a-293c-41b8-adb3-69d0dc184fab"), InformationRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(idNode, g.getNode("_f49f9c34-29d5-4e72-91d2-f4f92117c8da"), InformationRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(idNode, g.getNode("_9b061fc3-8109-42e2-9fe4-fc39c90b654e"), InformationRequirement.class);
        Node prefixDecisionNode = g.getNode("_e920f38a-293c-41b8-adb3-69d0dc184fab");
        DMNMarshallerTest.assertNodeContentDefinitionIs(prefixDecisionNode, Decision.class);
        DMNMarshallerTest.assertNodeEdgesTo(prefixDecisionNode, g.getNode("_9b061fc3-8109-42e2-9fe4-fc39c90b654e"), InformationRequirement.class);
        Node postfixDecisionNode = g.getNode("_f49f9c34-29d5-4e72-91d2-f4f92117c8da");
        DMNMarshallerTest.assertNodeContentDefinitionIs(postfixDecisionNode, Decision.class);
        DMNMarshallerTest.assertNodeEdgesTo(postfixDecisionNode, g.getNode("_9b061fc3-8109-42e2-9fe4-fc39c90b654e"), InformationRequirement.class);
        Node myDecisionNode = g.getNode("_9b061fc3-8109-42e2-9fe4-fc39c90b654e");
        DMNMarshallerTest.assertNodeContentDefinitionIs(myDecisionNode, Decision.class);
        Node rootNode = DMNMarshaller.findDMNDiagramRoot(g);
        Assert.assertNotNull((Object)rootNode);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, idNode);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, prefixDecisionNode);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, postfixDecisionNode);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, myDecisionNode);
    }

    private void checkPotpourryGraph(Graph<?, Node<?, ?>> g) {
        Node _My_Input_Data = g.getNode("_My_Input_Data");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_My_Input_Data, InputData.class);
        DMNMarshallerTest.assertNodeEdgesTo(_My_Input_Data, g.getNode("_My_Decision_1"), InformationRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(_My_Input_Data, g.getNode("_KS_of_Input_Data"), AuthorityRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(_My_Input_Data, g.getNode("_Annotation_for_Input_Data"), Association.class);
        Node _Annotation_for_Input_Data = g.getNode("_Annotation_for_Input_Data");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_Annotation_for_Input_Data, TextAnnotation.class);
        Node _KS_of_Input_Data = g.getNode("_KS_of_Input_Data");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_Input_Data, KnowledgeSource.class);
        Node _KS_of_KS_of_InputData = g.getNode("_KS_of_KS_of_InputData");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_KS_of_InputData, KnowledgeSource.class);
        DMNMarshallerTest.assertNodeEdgesTo(_KS_of_KS_of_InputData, g.getNode("_KS_of_Input_Data"), AuthorityRequirement.class);
        Node _KS_of_KS_of_Decision_1 = g.getNode("_KS_of_KS_of_Decision_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_KS_of_Decision_1, KnowledgeSource.class);
        DMNMarshallerTest.assertNodeEdgesTo(_KS_of_KS_of_Decision_1, g.getNode("_KS_of_Decision_1"), AuthorityRequirement.class);
        Node _KS_of_Decision_1 = g.getNode("_KS_of_Decision_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_Decision_1, KnowledgeSource.class);
        DMNMarshallerTest.assertNodeEdgesTo(_KS_of_Decision_1, g.getNode("_My_Decision_1"), AuthorityRequirement.class);
        Node _My_Decision_2 = g.getNode("_My_Decision_2");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_My_Decision_2, Decision.class);
        DMNMarshallerTest.assertNodeEdgesTo(_My_Decision_2, g.getNode("_KS_of_Decision_2"), AuthorityRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(_My_Decision_2, g.getNode("_Annotation_for_Decision_2"), Association.class);
        Node _KS_of_Decision_2 = g.getNode("_KS_of_Decision_2");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_Decision_2, KnowledgeSource.class);
        Node _Annotation_for_Decision_2 = g.getNode("_Annotation_for_Decision_2");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_Annotation_for_Decision_2, TextAnnotation.class);
        Node _Annotation_for_BKM_1 = g.getNode("_Annotation_for_BKM_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_Annotation_for_BKM_1, TextAnnotation.class);
        DMNMarshallerTest.assertNodeEdgesTo(_Annotation_for_BKM_1, g.getNode("_My_BKM_1_of_Decision_1"), Association.class);
        Node _My_BKM_1_of_Decision_1 = g.getNode("_My_BKM_1_of_Decision_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_My_BKM_1_of_Decision_1, BusinessKnowledgeModel.class);
        DMNMarshallerTest.assertNodeEdgesTo(_My_BKM_1_of_Decision_1, g.getNode("_My_Decision_1"), KnowledgeRequirement.class);
        Node _KS_of_BKM_1 = g.getNode("_KS_of_BKM_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_BKM_1, KnowledgeSource.class);
        DMNMarshallerTest.assertNodeEdgesTo(_KS_of_BKM_1, g.getNode("_My_BKM_1_of_Decision_1"), AuthorityRequirement.class);
        Node _KS_of_KS_of_BKM_1 = g.getNode("_KS_of_KS_of_BKM_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_KS_of_BKM_1, KnowledgeSource.class);
        DMNMarshallerTest.assertNodeEdgesTo(_KS_of_KS_of_BKM_1, g.getNode("_KS_of_BKM_1"), AuthorityRequirement.class);
        Node _My_BKM_2_of_BKM_1 = g.getNode("_My_BKM_2_of_BKM_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_My_BKM_2_of_BKM_1, BusinessKnowledgeModel.class);
        DMNMarshallerTest.assertNodeEdgesTo(_My_BKM_2_of_BKM_1, g.getNode("_My_BKM_1_of_Decision_1"), KnowledgeRequirement.class);
        Node _KS_of_BKM_2 = g.getNode("_KS_of_BKM_2");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_BKM_2, KnowledgeSource.class);
        DMNMarshallerTest.assertNodeEdgesTo(_KS_of_BKM_2, g.getNode("_My_BKM_2_of_BKM_1"), AuthorityRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(_KS_of_BKM_2, g.getNode("_Annotation_for_KS_of_BKM_2"), Association.class);
        Node _Annotation_for_KS_of_BKM_2 = g.getNode("_Annotation_for_KS_of_BKM_2");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_Annotation_for_KS_of_BKM_2, TextAnnotation.class);
        Node _My_Decision_1 = g.getNode("_My_Decision_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_My_Decision_1, Decision.class);
        Node rootNode = DMNMarshaller.findDMNDiagramRoot(g);
        Assert.assertNotNull((Object)rootNode);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _My_Input_Data);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _Annotation_for_Input_Data);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_Input_Data);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_KS_of_InputData);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_KS_of_Decision_1);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_Decision_1);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _My_Decision_2);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_Decision_2);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _Annotation_for_Decision_2);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _Annotation_for_BKM_1);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _My_BKM_1_of_Decision_1);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_BKM_1);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_KS_of_BKM_1);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _My_BKM_2_of_BKM_1);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_BKM_2);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _Annotation_for_KS_of_BKM_2);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _My_Decision_1);
    }

    private static void assertRootNodeConnectedTo(Node<?, ?> rootNode, Node<?, ?> to) {
        List outEdges = rootNode.getOutEdges();
        Optional<Edge> optEdge = outEdges.stream().filter(e -> e.getTargetNode().equals(to)).findFirst();
        Assert.assertTrue((boolean)optEdge.isPresent());
        Edge edge = optEdge.get();
        Assert.assertTrue((boolean)(edge.getContent() instanceof Child));
        Assert.assertTrue((boolean)to.getInEdges().contains(edge));
    }

    private static Edge<?, ?> assertNodeEdgesTo(Node<?, ?> from, Node<?, ?> to, Class<?> clazz) {
        List outEdges = from.getOutEdges();
        Optional<Edge> optEdge = outEdges.stream().filter(e -> e.getTargetNode().equals(to)).findFirst();
        Assert.assertTrue((boolean)optEdge.isPresent());
        Edge edge = optEdge.get();
        Assert.assertTrue((boolean)(edge.getContent() instanceof View));
        Assert.assertTrue((boolean)clazz.isInstance(((View)edge.getContent()).getDefinition()));
        Assert.assertTrue((boolean)to.getInEdges().contains(edge));
        ViewConnector connectionContent = (ViewConnector)edge.getContent();
        Assert.assertTrue((boolean)connectionContent.getSourceConnection().isPresent());
        Assert.assertTrue((boolean)connectionContent.getTargetConnection().isPresent());
        return edge;
    }

    private static void assertNodeContentDefinitionIs(Node<?, ?> node, Class<?> clazz) {
        Assert.assertTrue((boolean)(node.getContent() instanceof View));
        Assert.assertTrue((boolean)clazz.isInstance(((View)node.getContent()).getDefinition()));
    }
}

