/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.types;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.commons.util.Maps;
import org.kie.soup.project.datamodel.commons.oracle.ModuleDataModelOracleImpl;
import org.kie.soup.project.datamodel.oracle.FieldAccessorsAndMutators;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.soup.project.datamodel.oracle.ModuleDataModelOracle;
import org.kie.workbench.common.dmn.api.editors.types.DataObject;
import org.kie.workbench.common.dmn.api.editors.types.DataObjectProperty;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.backend.editors.types.DataObjectsServiceImpl;
import org.kie.workbench.common.dmn.backend.editors.types.classes.APerson;
import org.kie.workbench.common.dmn.backend.editors.types.classes.BPet;
import org.kie.workbench.common.dmn.backend.editors.types.classes.CFamily;
import org.kie.workbench.common.services.backend.project.ModuleClassLoaderHelper;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class DataObjectsServiceImplTest {
    @Mock
    private DataModelService dataModelService;
    @Mock
    private ModuleClassLoaderHelper moduleClassLoaderHelper;
    @Mock
    private KieModuleService moduleService;
    @Mock
    private WorkspaceProject workspaceProject;
    @Mock
    private Path projectRootPath;
    @Mock
    private KieModule kieModule;
    private ModuleDataModelOracle dataModelOracle;
    private DataObjectsServiceImpl service;

    @Before
    public void setup() {
        this.service = new DataObjectsServiceImpl(this.dataModelService, this.moduleClassLoaderHelper, this.moduleService);
        this.dataModelOracle = new ModuleDataModelOracleImpl();
        this.dataModelOracle.addModulePackageNames(Collections.singletonList(APerson.class.getPackage().getName()));
        Mockito.when((Object)this.workspaceProject.getRootPath()).thenReturn((Object)this.projectRootPath);
        Mockito.when((Object)this.dataModelService.getModuleDataModel(this.projectRootPath)).thenReturn((Object)this.dataModelOracle);
        Mockito.when((Object)this.moduleService.resolveModule(this.projectRootPath)).thenReturn((Object)this.kieModule);
        Mockito.when((Object)this.moduleClassLoaderHelper.getModuleClassLoader(this.kieModule)).thenReturn((Object)Thread.currentThread().getContextClassLoader());
    }

    @Test
    public void testLoadDataObjects_NoProperties() {
        Maps.Builder modelFieldsBuilder = new Maps.Builder();
        modelFieldsBuilder.put((Object)BPet.class.getName(), (Object)new ModelField[]{this.newModelField("this", BPet.class.getName(), BPet.class.getSimpleName())});
        Map modelFields = modelFieldsBuilder.build();
        this.dataModelOracle.addModuleModelFields(modelFields);
        List dataObjects = this.service.loadDataObjects(this.workspaceProject);
        Assertions.assertThat((List)dataObjects).isNotEmpty();
        Assertions.assertThat((List)dataObjects).hasSize(1);
        Assertions.assertThat((String)((DataObject)dataObjects.get(0)).getClassType()).isEqualTo(BPet.class.getName());
        Assertions.assertThat((List)((DataObject)dataObjects.get(0)).getProperties()).isEmpty();
    }

    @Test
    public void testLoadDataObjects_ResolvedJavaPrimitiveProperties() {
        Maps.Builder modelFieldsBuilder = new Maps.Builder();
        modelFieldsBuilder.put((Object)APerson.class.getName(), (Object)new ModelField[]{this.newModelField("this", APerson.class.getName(), APerson.class.getSimpleName()), this.newModelField("booleanField", "boolean", "Boolean"), this.newModelField("byteField", "byte", "Byte"), this.newModelField("charField", "char", "String"), this.newModelField("floatField", "float", "Float"), this.newModelField("intField", "int", "Integer"), this.newModelField("longField", "long", "Long"), this.newModelField("shortField", "short", "Short"), this.newModelField("doubleField", "double", "Double")});
        Map modelFields = modelFieldsBuilder.build();
        this.dataModelOracle.addModuleModelFields(modelFields);
        List dataObjects = this.service.loadDataObjects(this.workspaceProject);
        Assertions.assertThat((List)dataObjects).isNotEmpty();
        Assertions.assertThat((List)dataObjects).hasSize(1);
        Assertions.assertThat((String)((DataObject)dataObjects.get(0)).getClassType()).isEqualTo(APerson.class.getName());
        Assertions.assertThat((List)((DataObject)dataObjects.get(0)).getProperties()).hasSize(8);
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(0)).getProperty()).isEqualTo("booleanField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(0)).getType()).isEqualTo(BuiltInType.BOOLEAN.getName());
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(1)).getProperty()).isEqualTo("byteField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(1)).getType()).isEqualTo(BuiltInType.NUMBER.getName());
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(2)).getProperty()).isEqualTo("charField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(2)).getType()).isEqualTo(BuiltInType.STRING.getName());
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(3)).getProperty()).isEqualTo("floatField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(3)).getType()).isEqualTo(BuiltInType.NUMBER.getName());
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(4)).getProperty()).isEqualTo("intField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(4)).getType()).isEqualTo(BuiltInType.NUMBER.getName());
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(5)).getProperty()).isEqualTo("longField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(5)).getType()).isEqualTo(BuiltInType.NUMBER.getName());
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(6)).getProperty()).isEqualTo("shortField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(6)).getType()).isEqualTo(BuiltInType.NUMBER.getName());
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(7)).getProperty()).isEqualTo("doubleField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(7)).getType()).isEqualTo(BuiltInType.NUMBER.getName());
    }

    @Test
    public void testLoadDataObjects_ResolvedJavaBoxedProperties() {
        Maps.Builder modelFieldsBuilder = new Maps.Builder();
        modelFieldsBuilder.put((Object)APerson.class.getName(), (Object)new ModelField[]{this.newModelField("this", APerson.class.getName(), APerson.class.getSimpleName()), this.newModelField("booleanField", Boolean.class.getName(), "Boolean"), this.newModelField("byteField", Byte.class.getName(), "Byte"), this.newModelField("charField", Character.class.getName(), "String"), this.newModelField("floatField", Float.class.getName(), "Float"), this.newModelField("intField", Integer.class.getName(), "Integer"), this.newModelField("longField", Long.class.getName(), "Long"), this.newModelField("shortField", Short.class.getName(), "Short"), this.newModelField("doubleField", Double.class.getName(), "Double")});
        Map modelFields = modelFieldsBuilder.build();
        this.dataModelOracle.addModuleModelFields(modelFields);
        List dataObjects = this.service.loadDataObjects(this.workspaceProject);
        Assertions.assertThat((List)dataObjects).isNotEmpty();
        Assertions.assertThat((List)dataObjects).hasSize(1);
        Assertions.assertThat((String)((DataObject)dataObjects.get(0)).getClassType()).isEqualTo(APerson.class.getName());
        Assertions.assertThat((List)((DataObject)dataObjects.get(0)).getProperties()).hasSize(8);
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(0)).getProperty()).isEqualTo("booleanField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(0)).getType()).isEqualTo(BuiltInType.BOOLEAN.getName());
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(1)).getProperty()).isEqualTo("byteField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(1)).getType()).isEqualTo(BuiltInType.NUMBER.getName());
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(2)).getProperty()).isEqualTo("charField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(2)).getType()).isEqualTo(BuiltInType.STRING.getName());
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(3)).getProperty()).isEqualTo("floatField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(3)).getType()).isEqualTo(BuiltInType.NUMBER.getName());
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(4)).getProperty()).isEqualTo("intField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(4)).getType()).isEqualTo(BuiltInType.NUMBER.getName());
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(5)).getProperty()).isEqualTo("longField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(5)).getType()).isEqualTo(BuiltInType.NUMBER.getName());
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(6)).getProperty()).isEqualTo("shortField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(6)).getType()).isEqualTo(BuiltInType.NUMBER.getName());
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(7)).getProperty()).isEqualTo("doubleField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(7)).getType()).isEqualTo(BuiltInType.NUMBER.getName());
    }

    @Test
    public void testLoadDataObjects_ResolvedBuiltInTypesProperties() {
        Maps.Builder modelFieldsBuilder = new Maps.Builder();
        modelFieldsBuilder.put((Object)APerson.class.getName(), (Object)new ModelField[]{this.newModelField("this", APerson.class.getName(), APerson.class.getSimpleName()), this.newModelField("stringField", String.class.getName(), "String"), this.newModelField("characterField", Character.class.getName(), "String"), this.newModelField("localDateField", LocalDate.class.getName(), "LocalDate"), this.newModelField("localTimeField", LocalTime.class.getName(), "LocalDate"), this.newModelField("offsetTimeField", OffsetTime.class.getName(), "Date"), this.newModelField("zonedDateTimeField", ZonedDateTime.class.getName(), "Date"), this.newModelField("offsetDateTimeField", OffsetDateTime.class.getName(), "Date"), this.newModelField("localDateTimeField", LocalDateTime.class.getName(), "LocalDate"), this.newModelField("mapField", Map.class.getName(), "Object"), this.newModelField("temporalAccessorField", ChronoLocalDate.class.getName(), "Object"), this.newModelField("listField", List.class.getName(), List.class.getSimpleName()), this.newModelField("localDateField", Date.class.getName(), "LocalDate")});
        Map modelFields = modelFieldsBuilder.build();
        this.dataModelOracle.addModuleModelFields(modelFields);
        Maps.Builder modelFieldsParametersTypeBuilder = new Maps.Builder();
        modelFieldsParametersTypeBuilder.put((Object)(APerson.class.getName() + "#listField"), (Object)String.class.getName());
        Map modelFieldsParameters = modelFieldsParametersTypeBuilder.build();
        this.dataModelOracle.addModuleFieldParametersType(modelFieldsParameters);
        List dataObjects = this.service.loadDataObjects(this.workspaceProject);
        Assertions.assertThat((List)dataObjects).isNotEmpty();
        Assertions.assertThat((List)dataObjects).hasSize(1);
        Assertions.assertThat((String)((DataObject)dataObjects.get(0)).getClassType()).isEqualTo(APerson.class.getName());
        Assertions.assertThat((List)((DataObject)dataObjects.get(0)).getProperties()).hasSize(12);
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(0)).getProperty()).isEqualTo("stringField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(0)).getType()).isEqualTo(BuiltInType.STRING.getName());
        Assertions.assertThat((boolean)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(0)).isList()).isFalse();
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(1)).getProperty()).isEqualTo("characterField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(1)).getType()).isEqualTo(BuiltInType.STRING.getName());
        Assertions.assertThat((boolean)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(1)).isList()).isFalse();
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(2)).getProperty()).isEqualTo("localDateField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(2)).getType()).isEqualTo(BuiltInType.DATE.getName());
        Assertions.assertThat((boolean)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(2)).isList()).isFalse();
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(3)).getProperty()).isEqualTo("localTimeField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(3)).getType()).isEqualTo(BuiltInType.TIME.getName());
        Assertions.assertThat((boolean)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(3)).isList()).isFalse();
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(4)).getProperty()).isEqualTo("offsetTimeField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(4)).getType()).isEqualTo(BuiltInType.TIME.getName());
        Assertions.assertThat((boolean)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(4)).isList()).isFalse();
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(5)).getProperty()).isEqualTo("zonedDateTimeField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(5)).getType()).isEqualTo(BuiltInType.DATE_TIME.getName());
        Assertions.assertThat((boolean)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(5)).isList()).isFalse();
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(6)).getProperty()).isEqualTo("offsetDateTimeField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(6)).getType()).isEqualTo(BuiltInType.DATE_TIME.getName());
        Assertions.assertThat((boolean)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(6)).isList()).isFalse();
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(7)).getProperty()).isEqualTo("localDateTimeField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(7)).getType()).isEqualTo(BuiltInType.DATE_TIME.getName());
        Assertions.assertThat((boolean)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(7)).isList()).isFalse();
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(8)).getProperty()).isEqualTo("mapField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(8)).getType()).isEqualTo(BuiltInType.CONTEXT.getName());
        Assertions.assertThat((boolean)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(8)).isList()).isFalse();
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(9)).getProperty()).isEqualTo("temporalAccessorField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(9)).getType()).isEqualTo(BuiltInType.ANY.getName());
        Assertions.assertThat((boolean)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(9)).isList()).isFalse();
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(10)).getProperty()).isEqualTo("listField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(10)).getType()).isEqualTo(BuiltInType.STRING.getName());
        Assertions.assertThat((boolean)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(10)).isList()).isTrue();
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(11)).getProperty()).isEqualTo("localDateField");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(11)).getType()).isEqualTo(BuiltInType.DATE_TIME.getName());
        Assertions.assertThat((boolean)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(11)).isList()).isFalse();
    }

    @Test
    public void testLoadDataObjects_Lists() {
        Maps.Builder modelFieldsBuilder = new Maps.Builder();
        modelFieldsBuilder.put((Object)APerson.class.getName(), (Object)new ModelField[]{this.newModelField("this", APerson.class.getName(), APerson.class.getSimpleName()), this.newModelField("stringList", List.class.getName(), List.class.getSimpleName()), this.newModelField("characterList", List.class.getName(), List.class.getSimpleName()), this.newModelField("localDateList", List.class.getName(), List.class.getSimpleName()), this.newModelField("localTimeList", List.class.getName(), List.class.getSimpleName()), this.newModelField("offsetTimeList", List.class.getName(), List.class.getSimpleName()), this.newModelField("zonedDateTimeList", List.class.getName(), List.class.getSimpleName()), this.newModelField("offsetDateTimeList", List.class.getName(), List.class.getSimpleName()), this.newModelField("localDateTimeList", List.class.getName(), List.class.getSimpleName()), this.newModelField("mapList", List.class.getName(), List.class.getSimpleName()), this.newModelField("temporalAccessorList", List.class.getName(), List.class.getSimpleName()), this.newModelField("unknownList", List.class.getName(), List.class.getSimpleName())});
        Map modelFields = modelFieldsBuilder.build();
        this.dataModelOracle.addModuleModelFields(modelFields);
        Maps.Builder modelFieldsParametersTypeBuilder = new Maps.Builder();
        modelFieldsParametersTypeBuilder.put((Object)(APerson.class.getName() + "#stringList"), (Object)String.class.getName());
        modelFieldsParametersTypeBuilder.put((Object)(APerson.class.getName() + "#characterList"), (Object)String.class.getName());
        modelFieldsParametersTypeBuilder.put((Object)(APerson.class.getName() + "#localDateList"), (Object)LocalDate.class.getName());
        modelFieldsParametersTypeBuilder.put((Object)(APerson.class.getName() + "#localTimeList"), (Object)LocalTime.class.getName());
        modelFieldsParametersTypeBuilder.put((Object)(APerson.class.getName() + "#offsetTimeList"), (Object)OffsetTime.class.getName());
        modelFieldsParametersTypeBuilder.put((Object)(APerson.class.getName() + "#zonedDateTimeList"), (Object)ZonedDateTime.class.getName());
        modelFieldsParametersTypeBuilder.put((Object)(APerson.class.getName() + "#offsetDateTimeList"), (Object)OffsetDateTime.class.getName());
        modelFieldsParametersTypeBuilder.put((Object)(APerson.class.getName() + "#localDateTimeList"), (Object)LocalDateTime.class.getName());
        modelFieldsParametersTypeBuilder.put((Object)(APerson.class.getName() + "#mapList"), (Object)Map.class.getName());
        modelFieldsParametersTypeBuilder.put((Object)(APerson.class.getName() + "#temporalAccessorList"), (Object)ChronoLocalDate.class.getName());
        Map modelFieldsParameters = modelFieldsParametersTypeBuilder.build();
        this.dataModelOracle.addModuleFieldParametersType(modelFieldsParameters);
        List dataObjects = this.service.loadDataObjects(this.workspaceProject);
        Assertions.assertThat((List)dataObjects).isNotEmpty();
        Assertions.assertThat((List)dataObjects).hasSize(1);
        Assertions.assertThat((String)((DataObject)dataObjects.get(0)).getClassType()).isEqualTo(APerson.class.getName());
        Assertions.assertThat((List)((DataObject)dataObjects.get(0)).getProperties()).hasSize(11);
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(0)).getProperty()).isEqualTo("stringList");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(0)).getType()).isEqualTo(BuiltInType.STRING.getName());
        Assertions.assertThat((boolean)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(0)).isList()).isTrue();
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(1)).getProperty()).isEqualTo("characterList");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(1)).getType()).isEqualTo(BuiltInType.STRING.getName());
        Assertions.assertThat((boolean)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(1)).isList()).isTrue();
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(2)).getProperty()).isEqualTo("localDateList");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(2)).getType()).isEqualTo(BuiltInType.DATE.getName());
        Assertions.assertThat((boolean)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(2)).isList()).isTrue();
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(3)).getProperty()).isEqualTo("localTimeList");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(3)).getType()).isEqualTo(BuiltInType.TIME.getName());
        Assertions.assertThat((boolean)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(3)).isList()).isTrue();
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(4)).getProperty()).isEqualTo("offsetTimeList");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(4)).getType()).isEqualTo(BuiltInType.TIME.getName());
        Assertions.assertThat((boolean)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(4)).isList()).isTrue();
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(5)).getProperty()).isEqualTo("zonedDateTimeList");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(5)).getType()).isEqualTo(BuiltInType.DATE_TIME.getName());
        Assertions.assertThat((boolean)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(5)).isList()).isTrue();
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(6)).getProperty()).isEqualTo("offsetDateTimeList");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(6)).getType()).isEqualTo(BuiltInType.DATE_TIME.getName());
        Assertions.assertThat((boolean)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(6)).isList()).isTrue();
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(7)).getProperty()).isEqualTo("localDateTimeList");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(7)).getType()).isEqualTo(BuiltInType.DATE_TIME.getName());
        Assertions.assertThat((boolean)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(7)).isList()).isTrue();
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(8)).getProperty()).isEqualTo("mapList");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(8)).getType()).isEqualTo(BuiltInType.CONTEXT.getName());
        Assertions.assertThat((boolean)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(8)).isList()).isTrue();
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(9)).getProperty()).isEqualTo("temporalAccessorList");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(9)).getType()).isEqualTo(BuiltInType.ANY.getName());
        Assertions.assertThat((boolean)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(9)).isList()).isTrue();
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(10)).getProperty()).isEqualTo("unknownList");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(10)).getType()).isEqualTo(BuiltInType.ANY.getName());
        Assertions.assertThat((boolean)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(10)).isList()).isTrue();
    }

    @Test
    public void testLoadDataObjects_ResolvedCustomProperty() {
        Maps.Builder modelFieldsBuilder = new Maps.Builder();
        modelFieldsBuilder.put((Object)APerson.class.getName(), (Object)new ModelField[]{this.newModelField("this", APerson.class.getName(), APerson.class.getSimpleName())});
        modelFieldsBuilder.put((Object)CFamily.class.getName(), (Object)new ModelField[]{this.newModelField("this", CFamily.class.getName(), CFamily.class.getSimpleName()), this.newModelField("mother", APerson.class.getName(), APerson.class.getSimpleName())});
        Map modelFields = modelFieldsBuilder.build();
        this.dataModelOracle.addModuleModelFields(modelFields);
        List dataObjects = this.service.loadDataObjects(this.workspaceProject);
        Assertions.assertThat((List)dataObjects).isNotEmpty();
        Assertions.assertThat((List)dataObjects).hasSize(2);
        Assertions.assertThat((String)((DataObject)dataObjects.get(0)).getClassType()).isEqualTo(APerson.class.getName());
        Assertions.assertThat((List)((DataObject)dataObjects.get(0)).getProperties()).isEmpty();
        Assertions.assertThat((String)((DataObject)dataObjects.get(1)).getClassType()).isEqualTo(CFamily.class.getName());
        Assertions.assertThat((List)((DataObject)dataObjects.get(1)).getProperties()).hasSize(1);
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(1)).getProperties().get(0)).getProperty()).isEqualTo("mother");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(1)).getProperties().get(0)).getType()).isEqualTo(APerson.class.getName());
    }

    @Test
    public void testLoadDataObjects_UnknownCustomProperty() {
        Maps.Builder modelFieldsBuilder = new Maps.Builder();
        modelFieldsBuilder.put((Object)CFamily.class.getName(), (Object)new ModelField[]{this.newModelField("this", CFamily.class.getName(), CFamily.class.getSimpleName()), this.newModelField("mother", APerson.class.getName(), APerson.class.getSimpleName())});
        Map modelFields = modelFieldsBuilder.build();
        this.dataModelOracle.addModuleModelFields(modelFields);
        List dataObjects = this.service.loadDataObjects(this.workspaceProject);
        Assertions.assertThat((List)dataObjects).isNotEmpty();
        Assertions.assertThat((List)dataObjects).hasSize(1);
        Assertions.assertThat((String)((DataObject)dataObjects.get(0)).getClassType()).isEqualTo(CFamily.class.getName());
        Assertions.assertThat((List)((DataObject)dataObjects.get(0)).getProperties()).hasSize(1);
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(0)).getProperty()).isEqualTo("mother");
        Assertions.assertThat((String)((DataObjectProperty)((DataObject)dataObjects.get(0)).getProperties().get(0)).getType()).isEqualTo(BuiltInType.ANY.getName());
    }

    @Test
    public void testLoadDataObjects_NoJavaFilesAvailable() {
        List dataObjects = this.service.loadDataObjects(this.workspaceProject);
        Assertions.assertThat((List)dataObjects).isEmpty();
    }

    private ModelField newModelField(String name, String className, String type) {
        return new ModelField(name, className, ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.SELF, FieldAccessorsAndMutators.BOTH, type);
    }
}

