/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.InformationItem;
import org.kie.dmn.model.api.InputData;
import org.kie.dmn.model.v1_2.TInformationItem;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.model.NamedElement;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.backend.definition.v1_1.InformationItemPrimaryPropertyConverter;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class InformationItemPrimaryPropertyConverterTest {
    @Test
    public void testWbFromDMNWhenDMNIsNull() {
        DMNModelInstrumentedBase dmn = null;
        InformationItemPrimary informationItemPrimary = InformationItemPrimaryPropertyConverter.wbFromDMN(dmn, dmn);
        Assert.assertNull((Object)informationItemPrimary);
    }

    @Test
    public void testWbFromDMNWhenDMNIsNotNull() {
        String id = "id";
        Id expectedId = new Id("id");
        String qNameNamespaceURI = "qName namespaceURI";
        String qNameLocalPart = "qName local part";
        String qNamePrefix = "qName prefix";
        QName expectedTypeRef = new QName("qName namespaceURI", "qName local part", "qName prefix");
        javax.xml.namespace.QName qName = (javax.xml.namespace.QName)Mockito.mock(javax.xml.namespace.QName.class);
        InformationItem dmn = (InformationItem)Mockito.mock(InformationItem.class);
        Mockito.when((Object)dmn.getId()).thenReturn((Object)"id");
        Mockito.when((Object)dmn.getTypeRef()).thenReturn((Object)qName);
        Mockito.when((Object)qName.getNamespaceURI()).thenReturn((Object)"qName namespaceURI");
        Mockito.when((Object)qName.getLocalPart()).thenReturn((Object)"qName local part");
        Mockito.when((Object)qName.getPrefix()).thenReturn((Object)"qName prefix");
        InformationItemPrimary informationItemPrimary = InformationItemPrimaryPropertyConverter.wbFromDMN((InformationItem)dmn, (DMNModelInstrumentedBase)dmn);
        Id actualId = informationItemPrimary.getId();
        QName actualTypeRef = informationItemPrimary.getTypeRef();
        Assert.assertEquals((Object)expectedId, (Object)actualId);
        Assert.assertEquals((Object)expectedTypeRef, (Object)actualTypeRef);
    }

    @Test
    public void testDmnFromWBWhenWBIsNull() {
        org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase wb = null;
        TInformationItem informationItem = InformationItemPrimaryPropertyConverter.dmnFromWB(wb, wb);
        Assert.assertNull((Object)informationItem);
    }

    @Test
    public void testDmnFromWBWhenWBIsNotNull() {
        String expectedId = "id";
        String expectedName = "name";
        Id id = new Id("id");
        Name name = new Name("name");
        String qNameNamespaceURI = "qName namespaceURI";
        String qNameLocalPart = "qName local part";
        String qNamePrefix = "qName prefix";
        InformationItemPrimary wb = (InformationItemPrimary)Mockito.mock(InformationItemPrimary.class);
        QName qName = (QName)Mockito.mock(QName.class);
        javax.xml.namespace.QName expectedQName = new javax.xml.namespace.QName("qName namespaceURI", "qName local part", "qName prefix");
        NamedElement parentElement = (NamedElement)Mockito.mock(NamedElement.class);
        Mockito.when((Object)wb.getId()).thenReturn((Object)id);
        Mockito.when((Object)wb.getName()).thenReturn((Object)name);
        Mockito.when((Object)wb.getTypeRef()).thenReturn((Object)qName);
        Mockito.when((Object)wb.getParent()).thenReturn((Object)parentElement);
        Mockito.when((Object)parentElement.getName()).thenReturn((Object)name);
        Mockito.when((Object)qName.getNamespaceURI()).thenReturn((Object)"qName namespaceURI");
        Mockito.when((Object)qName.getLocalPart()).thenReturn((Object)"qName local part");
        Mockito.when((Object)qName.getPrefix()).thenReturn((Object)"qName prefix");
        TInformationItem informationItem = InformationItemPrimaryPropertyConverter.dmnFromWB((InformationItemPrimary)wb, (org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase)wb);
        String actualId = informationItem.getId();
        String actualName = informationItem.getName();
        javax.xml.namespace.QName actualQName = informationItem.getTypeRef();
        Assert.assertEquals((Object)"id", (Object)actualId);
        Assert.assertEquals((Object)"name", (Object)actualName);
        Assert.assertEquals((Object)expectedQName, (Object)actualQName);
    }

    @Test
    public void testDMNGetNameWhenParentDoesNotHaveName() {
        InformationItem parent = (InformationItem)Mockito.mock(InformationItem.class);
        String name = InformationItemPrimaryPropertyConverter.getParentName((DMNModelInstrumentedBase)parent);
        Assert.assertTrue((boolean)name.isEmpty());
    }

    @Test
    public void testDMNGetNameWhenParentHasNullName() {
        InputData parent = (InputData)Mockito.mock(InputData.class);
        Mockito.when((Object)parent.getName()).thenReturn(null);
        String name = InformationItemPrimaryPropertyConverter.getParentName((DMNModelInstrumentedBase)parent);
        Assert.assertTrue((boolean)name.isEmpty());
    }

    @Test
    public void testDMNGetNameWhenParentHasName() {
        InputData parent = (InputData)Mockito.mock(InputData.class);
        String expectedName = "name";
        Mockito.when((Object)parent.getName()).thenReturn((Object)"name");
        String actualName = InformationItemPrimaryPropertyConverter.getParentName((DMNModelInstrumentedBase)parent);
        Assert.assertEquals((Object)"name", (Object)actualName);
    }

    @Test
    public void testWBGetNameWhenParentDoesNotHaveName() {
        InformationItemPrimary parent = (InformationItemPrimary)Mockito.mock(InformationItemPrimary.class);
        String name = InformationItemPrimaryPropertyConverter.getParentName((org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase)parent);
        Assert.assertTrue((boolean)name.isEmpty());
    }

    @Test
    public void testWBGetNameWhenParentHasNullName() {
        org.kie.workbench.common.dmn.api.definition.model.InputData parent = (org.kie.workbench.common.dmn.api.definition.model.InputData)Mockito.mock(org.kie.workbench.common.dmn.api.definition.model.InputData.class);
        Mockito.when((Object)parent.getName()).thenReturn(null);
        String name = InformationItemPrimaryPropertyConverter.getParentName((org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase)parent);
        Assert.assertTrue((boolean)name.isEmpty());
    }

    @Test
    public void testWBGetNameWhenParentHasName() {
        org.kie.workbench.common.dmn.api.definition.model.InputData parent = (org.kie.workbench.common.dmn.api.definition.model.InputData)Mockito.mock(org.kie.workbench.common.dmn.api.definition.model.InputData.class);
        Name parentName = (Name)Mockito.mock(Name.class);
        String expectedName = "name";
        Mockito.when((Object)parent.getName()).thenReturn((Object)parentName);
        Mockito.when((Object)parentName.getValue()).thenReturn((Object)"name");
        String actualName = InformationItemPrimaryPropertyConverter.getParentName((org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase)parent);
        Assert.assertEquals((Object)"name", (Object)actualName);
    }
}

