/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.common;

import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import org.guvnor.common.services.project.model.Package;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.IncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.PMMLModelMetadata;
import org.kie.workbench.common.dmn.api.marshalling.DMNImportTypesHelper;
import org.kie.workbench.common.dmn.api.marshalling.DMNPathsHelper;
import org.kie.workbench.common.dmn.backend.editors.common.DMNDiagramHelper;
import org.kie.workbench.common.dmn.backend.editors.common.IncludedModelFactory;
import org.kie.workbench.common.dmn.backend.editors.common.PMMLIncludedDocumentFactory;
import org.kie.workbench.common.dmn.backend.editors.types.exceptions.DMNIncludeModelCouldNotBeCreatedException;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class IncludedModelFactoryTest {
    private static final String NAMESPACE = "://namespace";
    @Mock
    private DMNImportTypesHelper importTypesHelper;
    @Mock
    private DMNDiagramHelper dmnDiagramHelper;
    @Mock
    private DMNPathsHelper pathsHelper;
    @Mock
    private PMMLIncludedDocumentFactory pmmlDocumentFactory;
    @Mock
    private KieModuleService moduleService;
    @Mock
    private Path dmnModelPath;
    @Mock
    private Path includedModelPath;
    @Mock
    private Diagram<Graph, Metadata> diagram;
    private IncludedModelFactory factory;

    @Before
    public void setup() {
        this.factory = (IncludedModelFactory)Mockito.spy((Object)new IncludedModelFactory(this.dmnDiagramHelper, this.pathsHelper, this.importTypesHelper, this.pmmlDocumentFactory, this.moduleService));
    }

    @Test
    public void testCreateDMN() throws Exception {
        Package aPackage = (Package)Mockito.mock(Package.class);
        String packageName = "com.kie.dmn";
        String fileName = "file.dmn";
        String uri = "/src/main/java/com/kie/dmn/file.dmn";
        Integer expectedDrgElementsCount = 2;
        Integer expectedItemDefinitionsCount = 3;
        Mockito.when((Object)aPackage.getPackageName()).thenReturn((Object)"com.kie.dmn");
        Mockito.when((Object)this.includedModelPath.getFileName()).thenReturn((Object)"file.dmn");
        Mockito.when((Object)this.includedModelPath.toURI()).thenReturn((Object)"/src/main/java/com/kie/dmn/file.dmn");
        Mockito.when((Object)this.moduleService.resolvePackage(this.includedModelPath)).thenReturn((Object)aPackage);
        Mockito.when((Object)this.importTypesHelper.isDMN(this.includedModelPath)).thenReturn((Object)true);
        Mockito.when((Object)this.importTypesHelper.isPMML(this.includedModelPath)).thenReturn((Object)false);
        Mockito.when((Object)this.dmnDiagramHelper.getDiagramByPath(this.includedModelPath)).thenReturn(this.diagram);
        Mockito.when((Object)this.dmnDiagramHelper.getNamespace(this.diagram)).thenReturn((Object)NAMESPACE);
        Mockito.when((Object)this.dmnDiagramHelper.getNodes(this.diagram)).thenReturn(Arrays.asList((DRGElement)Mockito.mock(DRGElement.class), (DRGElement)Mockito.mock(DRGElement.class)));
        Mockito.when((Object)this.dmnDiagramHelper.getItemDefinitions(this.diagram)).thenReturn(Arrays.asList((ItemDefinition)Mockito.mock(ItemDefinition.class), (ItemDefinition)Mockito.mock(ItemDefinition.class), (ItemDefinition)Mockito.mock(ItemDefinition.class)));
        Mockito.when((Object)this.pathsHelper.getRelativeURI(this.dmnModelPath, this.includedModelPath)).thenReturn((Object)"/src/main/java/com/kie/dmn/file.dmn");
        IncludedModel includedModel = this.factory.create(this.dmnModelPath, this.includedModelPath);
        Assert.assertTrue((boolean)(includedModel instanceof DMNIncludedModel));
        DMNIncludedModel dmnIncludedModel = (DMNIncludedModel)includedModel;
        Assert.assertEquals((Object)"com.kie.dmn", (Object)includedModel.getModelPackage());
        Assert.assertEquals((Object)"file.dmn", (Object)includedModel.getModelName());
        Assert.assertEquals((Object)"/src/main/java/com/kie/dmn/file.dmn", (Object)includedModel.getPath());
        Assert.assertEquals((Object)NAMESPACE, (Object)dmnIncludedModel.getNamespace());
        Assert.assertEquals((Object)expectedDrgElementsCount, (Object)dmnIncludedModel.getDrgElementsCount());
        Assert.assertEquals((Object)expectedItemDefinitionsCount, (Object)dmnIncludedModel.getItemDefinitionsCount());
    }

    @Test
    public void testCreatePMML() throws Exception {
        PMMLDocumentMetadata pmmlDocument = (PMMLDocumentMetadata)Mockito.mock(PMMLDocumentMetadata.class);
        Package aPackage = (Package)Mockito.mock(Package.class);
        String packageName = "com.kie.pmml";
        String fileName = "file.pmml";
        String uri = "/src/main/java/com/kie/pmml/file.pmml";
        Integer expectedModelsCount = 2;
        Mockito.when((Object)aPackage.getPackageName()).thenReturn((Object)"com.kie.pmml");
        Mockito.when((Object)this.includedModelPath.getFileName()).thenReturn((Object)"file.pmml");
        Mockito.when((Object)this.includedModelPath.toURI()).thenReturn((Object)"/src/main/java/com/kie/pmml/file.pmml");
        Mockito.when((Object)this.moduleService.resolvePackage(this.includedModelPath)).thenReturn((Object)aPackage);
        Mockito.when((Object)this.importTypesHelper.isDMN(this.includedModelPath)).thenReturn((Object)false);
        Mockito.when((Object)this.importTypesHelper.isPMML(this.includedModelPath)).thenReturn((Object)true);
        Mockito.when((Object)this.pathsHelper.getRelativeURI(this.dmnModelPath, this.includedModelPath)).thenReturn((Object)"/src/main/java/com/kie/pmml/file.pmml");
        Mockito.when((Object)this.pmmlDocumentFactory.getDocumentByPath(this.includedModelPath)).thenReturn((Object)pmmlDocument);
        Mockito.when((Object)pmmlDocument.getModels()).thenReturn(Arrays.asList((PMMLModelMetadata)Mockito.mock(PMMLModelMetadata.class), (PMMLModelMetadata)Mockito.mock(PMMLModelMetadata.class)));
        IncludedModel includedModel = this.factory.create(this.dmnModelPath, this.includedModelPath);
        Assert.assertTrue((boolean)(includedModel instanceof PMMLIncludedModel));
        PMMLIncludedModel pmmlIncludedModel = (PMMLIncludedModel)includedModel;
        Assert.assertEquals((Object)"com.kie.pmml", (Object)includedModel.getModelPackage());
        Assert.assertEquals((Object)"file.pmml", (Object)includedModel.getModelName());
        Assert.assertEquals((Object)"/src/main/java/com/kie/pmml/file.pmml", (Object)includedModel.getPath());
        Assert.assertEquals((Object)expectedModelsCount, (Object)pmmlIncludedModel.getModelCount());
    }

    @Test(expected=DMNIncludeModelCouldNotBeCreatedException.class)
    public void testCreateDMNIncludedModelWhenGetNamespaceRaisesAnError() throws Exception {
        Mockito.when((Object)this.importTypesHelper.isDMN(this.includedModelPath)).thenReturn((Object)true);
        ((DMNDiagramHelper)Mockito.doThrow(NoSuchFileException.class).when((Object)this.dmnDiagramHelper)).getDiagramByPath(this.includedModelPath);
        this.factory.create(this.dmnModelPath, this.includedModelPath);
    }

    @Test(expected=DMNIncludeModelCouldNotBeCreatedException.class)
    public void testCreateUnknownIncludeRaisesAnError() throws Exception {
        Mockito.when((Object)this.importTypesHelper.isDMN(this.includedModelPath)).thenReturn((Object)false);
        Mockito.when((Object)this.importTypesHelper.isPMML(this.includedModelPath)).thenReturn((Object)false);
        this.factory.create(this.dmnModelPath, this.includedModelPath);
    }
}

