/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.Optional;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.Import;

public class HrefBuilder {
    public static String getHref(DRGElement drgElement) {
        String drgElementId = drgElement.getId().getValue();
        return HrefBuilder.getNamespace(drgElement).map(namespace -> namespace + "#" + drgElementId).orElse("#" + drgElementId);
    }

    private static Optional<String> getNamespace(DRGElement drgElement) {
        Optional<String> name = Optional.ofNullable(drgElement.getName().getValue());
        return HrefBuilder.getDefinitions(drgElement).map(definitions -> definitions.getImport().stream().filter(anImport -> {
            String importName = anImport.getName().getValue();
            return name.map(n -> n.startsWith(importName + ".")).orElse(false);
        }).findFirst().map(Import::getNamespace).orElse(null));
    }

    private static Optional<Definitions> getDefinitions(DRGElement drgElement) {
        DMNModelInstrumentedBase parent = drgElement.getParent();
        if (parent instanceof DMNDiagram) {
            DMNDiagram diagram = (DMNDiagram)parent;
            return Optional.ofNullable(diagram.getDefinitions());
        }
        if (parent instanceof Definitions) {
            return Optional.of((Definitions)parent);
        }
        return Optional.empty();
    }
}

