/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.types;

import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.dmn.api.editors.types.DMNSimpleTimeZone;
import org.kie.workbench.common.dmn.api.editors.types.TimeZoneService;

@Service
public class TimeZoneServiceImpl
implements TimeZoneService {
    public List<DMNSimpleTimeZone> getTimeZones() {
        String[] ids = this.getAvailableIds();
        ArrayList<DMNSimpleTimeZone> list = new ArrayList<DMNSimpleTimeZone>(ids.length);
        for (String id : ids) {
            TimeZone timeZone = this.getTimeZone(id);
            DMNSimpleTimeZone simpleTimeZone = new DMNSimpleTimeZone();
            simpleTimeZone.setId(id);
            double offset = this.toHours(timeZone.getRawOffset());
            simpleTimeZone.setOffset(offset);
            simpleTimeZone.setOffsetString(this.formatOffset(offset));
            list.add(simpleTimeZone);
        }
        return list;
    }

    String formatOffset(double offSet) {
        int hours = Math.abs((int)offSet);
        double decimalMinutes = Math.abs(offSet) - (double)hours;
        double minutes = 60.0 * decimalMinutes;
        String sign = offSet < 0.0 ? "-" : "+";
        String formattedHours = String.format("%02d", hours);
        String formattedMinutes = String.format("%02d", (int)minutes);
        return sign + formattedHours + ":" + formattedMinutes;
    }

    double toHours(long milliseconds) {
        return (double)milliseconds / 1000.0 / 60.0 / 60.0;
    }

    TimeZone getTimeZone(String id) {
        return TimeZone.getTimeZone(id);
    }

    String[] getAvailableIds() {
        return TimeZone.getAvailableIDs();
    }
}

