/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.guvnor.common.services.backend.metadata.MetadataServerSideService;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.DMNContentResource;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.marshalling.DMNPathsHelper;
import org.kie.workbench.common.dmn.backend.DMNContentServiceImpl;
import org.kie.workbench.common.dmn.backend.common.DMNIOHelper;
import org.kie.workbench.common.dmn.backend.editors.common.PMMLIncludedDocumentFactory;
import org.kie.workbench.common.services.backend.service.KieServiceOverviewLoader;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.stunner.project.diagram.impl.ProjectMetadataImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNContentServiceImplTest {
    @Mock
    private CommentedOptionFactory commentedOptionFactory;
    @Mock
    private DMNIOHelper dmnIOHelper;
    @Mock
    private DMNPathsHelper pathsHelper;
    @Mock
    private PMMLIncludedDocumentFactory pmmlIncludedDocumentFactory;
    @Mock
    private org.uberfire.backend.vfs.Path path;
    @Mock
    private Path convertedPath;
    @Mock
    private KieModuleService moduleService;
    @Mock
    private KieServiceOverviewLoader overviewLoader;
    @Mock
    private IOService ioService;
    @Mock
    private MetadataServerSideService metadataService;
    @Mock
    private WorkspaceProject workspaceProject;
    private String fileName = "fileName.dmn";
    private DMNContentServiceImpl service;

    @Before
    public void setup() {
        this.service = (DMNContentServiceImpl)Mockito.spy((Object)new DMNContentServiceImpl(this.commentedOptionFactory, this.dmnIOHelper, this.pathsHelper, this.pmmlIncludedDocumentFactory){
            {
                this.moduleService = DMNContentServiceImplTest.this.moduleService;
                this.overviewLoader = DMNContentServiceImplTest.this.overviewLoader;
                this.ioService = DMNContentServiceImplTest.this.ioService;
                this.metadataService = DMNContentServiceImplTest.this.metadataService;
            }
        });
        Mockito.when((Object)this.path.getFileName()).thenReturn((Object)this.fileName);
        ((DMNContentServiceImpl)Mockito.doReturn((Object)this.convertedPath).when((Object)this.service)).convertPath(this.path);
    }

    @Test
    public void testGetContent() {
        String actual = "<xml/>";
        ((DMNContentServiceImpl)Mockito.doReturn((Object)"<xml/>").when((Object)this.service)).getSource(this.path);
        String expected = this.service.getContent(this.path);
        Assert.assertEquals((Object)expected, (Object)"<xml/>");
    }

    @Test
    public void testGetProjectContent() {
        String defSetId = "defSetId";
        String expectedContent = "<xml/>";
        String moduleName = "moduleName";
        Package aPackage = (Package)Mockito.mock(Package.class);
        KieModule kieModule = (KieModule)Mockito.mock(KieModule.class);
        Overview overview = (Overview)Mockito.mock(Overview.class);
        ((DMNContentServiceImpl)Mockito.doReturn((Object)"<xml/>").when((Object)this.service)).getSource(this.path);
        Mockito.when((Object)this.moduleService.resolvePackage(this.path)).thenReturn((Object)aPackage);
        Mockito.when((Object)this.moduleService.resolveModule(this.path)).thenReturn((Object)kieModule);
        Mockito.when((Object)this.overviewLoader.loadOverview(this.path)).thenReturn((Object)overview);
        Mockito.when((Object)kieModule.getModuleName()).thenReturn((Object)"moduleName");
        DMNContentResource contentResource = this.service.getProjectContent(this.path, "defSetId");
        String actualContent = contentResource.getContent();
        ProjectMetadataImpl metadata = (ProjectMetadataImpl)contentResource.getMetadata();
        Assert.assertEquals((Object)"<xml/>", (Object)actualContent);
        Assert.assertEquals((Object)"defSetId", (Object)metadata.getDefinitionSetId());
        Assert.assertEquals((Object)"moduleName", (Object)metadata.getModuleName());
        Assert.assertEquals((Object)aPackage, (Object)metadata.getProjectPackage());
        Assert.assertEquals((Object)overview, (Object)metadata.getOverview());
        Assert.assertEquals((Object)this.fileName, (Object)metadata.getTitle());
        Assert.assertEquals((Object)this.path, (Object)metadata.getPath());
    }

    @Test
    public void saveContent() {
        String content = "<xml/>";
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        String comment = "Commit message.";
        HashMap attributes = new HashMap();
        CommentedOption commentedOption = (CommentedOption)Mockito.mock(CommentedOption.class);
        Mockito.when((Object)this.metadataService.setUpAttributes(this.path, metadata)).thenReturn(attributes);
        Mockito.when((Object)this.commentedOptionFactory.makeCommentedOption("Commit message.")).thenReturn((Object)commentedOption);
        this.service.saveContent(this.path, "<xml/>", metadata, "Commit message.");
        ((IOService)Mockito.verify((Object)this.ioService)).write(this.convertedPath, "<xml/>", attributes, new OpenOption[]{commentedOption});
    }

    @Test
    public void testGetModelsPaths() {
        org.uberfire.backend.vfs.Path path1 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path path2 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        List<org.uberfire.backend.vfs.Path> expectedPaths = Arrays.asList(path1, path2);
        Mockito.when((Object)this.pathsHelper.getModelsPaths(this.workspaceProject)).thenReturn(expectedPaths);
        List actualPaths = this.service.getModelsPaths(this.workspaceProject);
        Assert.assertEquals(expectedPaths, (Object)actualPaths);
    }

    @Test
    public void testGetDMNModelsPaths() {
        org.uberfire.backend.vfs.Path path1 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path path2 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        List<org.uberfire.backend.vfs.Path> expectedPaths = Arrays.asList(path1, path2);
        Mockito.when((Object)this.pathsHelper.getDMNModelsPaths(this.workspaceProject)).thenReturn(expectedPaths);
        List actualPaths = this.service.getDMNModelsPaths(this.workspaceProject);
        Assert.assertEquals(expectedPaths, (Object)actualPaths);
    }

    @Test
    public void testGetPMMLModelsPaths() {
        org.uberfire.backend.vfs.Path path1 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        org.uberfire.backend.vfs.Path path2 = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        List<org.uberfire.backend.vfs.Path> expectedPaths = Arrays.asList(path1, path2);
        Mockito.when((Object)this.pathsHelper.getPMMLModelsPaths(this.workspaceProject)).thenReturn(expectedPaths);
        List actualPaths = this.service.getPMMLModelsPaths(this.workspaceProject);
        Assert.assertEquals(expectedPaths, (Object)actualPaths);
    }

    @Test
    public void constructContent() {
        this.service.constructContent(this.path, null);
        String actual = "<xml/>";
        ((DMNContentServiceImpl)Mockito.doReturn((Object)"<xml/>").when((Object)this.service)).getSource(this.path);
        String expected = this.service.constructContent(this.path, null);
        Assert.assertEquals((Object)expected, (Object)"<xml/>");
    }

    @Test
    public void testGetSource() {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        String expectedSource = "<xml/>";
        Mockito.when((Object)this.ioService.newInputStream(this.convertedPath, new OpenOption[0])).thenReturn((Object)inputStream);
        Mockito.when((Object)this.dmnIOHelper.isAsString(inputStream)).thenReturn((Object)"<xml/>");
        String actualSource = this.service.getSource(this.path);
        Assert.assertEquals((Object)"<xml/>", (Object)actualSource);
    }

    @Test
    public void testLoadPMMLDocumentMetadata() {
        PMMLDocumentMetadata expected = (PMMLDocumentMetadata)Mockito.mock(PMMLDocumentMetadata.class);
        Mockito.when((Object)this.pmmlIncludedDocumentFactory.getDocumentByPath(this.path)).thenReturn((Object)expected);
        PMMLDocumentMetadata actual = this.service.loadPMMLDocumentMetadata(this.path);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

