/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.tools.ant.filters.StringInputStream;
import org.jboss.errai.marshalling.server.MappingContextSingleton;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.backend.marshalling.v1_1.DMNMarshallerFactory;
import org.kie.dmn.core.util.KieHelper;
import org.kie.dmn.model.v1_1.Definitions;
import org.kie.workbench.common.dmn.api.DMNDefinitionSet;
import org.kie.workbench.common.dmn.api.definition.v1_1.Association;
import org.kie.workbench.common.dmn.api.definition.v1_1.AuthorityRequirement;
import org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.v1_1.Decision;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationRequirement;
import org.kie.workbench.common.dmn.api.definition.v1_1.InputData;
import org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeRequirement;
import org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource;
import org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation;
import org.kie.workbench.common.dmn.backend.DMNMarshaller;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.DDExtensionsRegister;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.DMNDiagram;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.DMNShape;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.DMNStyle;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.org.omg.spec.CMMN_20151109_DC.Bounds;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.org.omg.spec.CMMN_20151109_DC.Color;
import org.kie.workbench.common.stunner.backend.ApplicationFactoryManager;
import org.kie.workbench.common.stunner.backend.definition.factory.TestScopeModelFactory;
import org.kie.workbench.common.stunner.backend.service.XMLEncoderDiagramMetadataMarshaller;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.annotation.RuntimeDefinitionAdapter;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.annotation.RuntimeDefinitionSetAdapter;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.annotation.RuntimePropertyAdapter;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.annotation.RuntimePropertySetAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.AdapterManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.DiagramImpl;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.diagram.MetadataImpl;
import org.kie.workbench.common.stunner.core.factory.graph.EdgeFactory;
import org.kie.workbench.common.stunner.core.factory.graph.GraphFactory;
import org.kie.workbench.common.stunner.core.factory.graph.NodeFactory;
import org.kie.workbench.common.stunner.core.factory.impl.EdgeFactoryImpl;
import org.kie.workbench.common.stunner.core.factory.impl.GraphFactoryImpl;
import org.kie.workbench.common.stunner.core.factory.impl.NodeFactoryImpl;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandManager;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandManagerImpl;
import org.kie.workbench.common.stunner.core.graph.command.impl.GraphCommandFactory;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.registry.definition.AdapterRegistry;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.commons.uuid.UUID;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNMarshallerTest {
    private static final String DMN_DEF_SET_ID = BindableAdapterUtils.getDefinitionSetId(DMNDefinitionSet.class);
    @Mock
    DefinitionManager definitionManager;
    @Mock
    AdapterManager adapterManager;
    @Mock
    AdapterRegistry adapterRegistry;
    @Mock
    BeanManager beanManager;
    @Mock
    RuleManager rulesManager;
    @Mock
    ApplicationFactoryManager applicationFactoryManager;
    EdgeFactory<Object> connectionEdgeFactory;
    NodeFactory<Object> viewNodeFactory;
    DefinitionUtils definitionUtils;
    GraphCommandManager commandManager;
    GraphCommandFactory commandFactory;
    GraphFactory dmnGraphFactory;
    TestScopeModelFactory testScopeModelFactory;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.definitionManager.adapters()).thenReturn((Object)this.adapterManager);
        Mockito.when((Object)this.adapterManager.registry()).thenReturn((Object)this.adapterRegistry);
        this.definitionUtils = new DefinitionUtils(this.definitionManager, (FactoryManager)this.applicationFactoryManager);
        this.testScopeModelFactory = new TestScopeModelFactory((Object)new DMNDefinitionSet.DMNDefinitionSetBuilder().build());
        RuntimeDefinitionAdapter definitionAdapter = new RuntimeDefinitionAdapter(this.definitionUtils);
        RuntimeDefinitionSetAdapter definitionSetAdapter = new RuntimeDefinitionSetAdapter(definitionAdapter);
        RuntimePropertySetAdapter propertySetAdapter = new RuntimePropertySetAdapter();
        RuntimePropertyAdapter propertyAdapter = new RuntimePropertyAdapter();
        Mockito.when((Object)this.adapterManager.forDefinitionSet()).thenReturn((Object)definitionSetAdapter);
        Mockito.when((Object)this.adapterManager.forDefinition()).thenReturn((Object)definitionAdapter);
        Mockito.when((Object)this.adapterManager.forPropertySet()).thenReturn((Object)propertySetAdapter);
        Mockito.when((Object)this.adapterManager.forProperty()).thenReturn((Object)propertyAdapter);
        Mockito.when((Object)this.adapterRegistry.getDefinitionSetAdapter((Class)Matchers.any(Class.class))).thenReturn((Object)definitionSetAdapter);
        Mockito.when((Object)this.adapterRegistry.getDefinitionAdapter((Class)Matchers.any(Class.class))).thenReturn((Object)definitionAdapter);
        Mockito.when((Object)this.adapterRegistry.getPropertySetAdapter((Class)Matchers.any(Class.class))).thenReturn((Object)propertySetAdapter);
        Mockito.when((Object)this.adapterRegistry.getPropertyAdapter((Class)Matchers.any(Class.class))).thenReturn((Object)propertyAdapter);
        this.commandManager = new GraphCommandManagerImpl(null, null, null);
        this.commandFactory = new GraphCommandFactory();
        this.connectionEdgeFactory = new EdgeFactoryImpl(this.definitionManager);
        this.viewNodeFactory = new NodeFactoryImpl(this.definitionUtils);
        this.dmnGraphFactory = new GraphFactoryImpl(this.definitionManager);
        ((ApplicationFactoryManager)Mockito.doAnswer(invocationOnMock -> {
            String id = (String)invocationOnMock.getArguments()[0];
            return this.testScopeModelFactory.build(id);
        }).when((Object)this.applicationFactoryManager)).newDefinition(Matchers.anyString());
        ((ApplicationFactoryManager)Mockito.doAnswer(invocationOnMock -> {
            Object model;
            String uuid = (String)invocationOnMock.getArguments()[0];
            String id = (String)invocationOnMock.getArguments()[1];
            if (DMNDefinitionSet.class.getName().equals(id)) {
                Graph graph = (Graph)this.dmnGraphFactory.build(uuid, (Object)DMN_DEF_SET_ID);
                org.kie.workbench.common.dmn.api.definition.v1_1.DMNDiagram model2 = new DMNDiagram.DMNDiagramBuilder().build();
                Node node = (Node)this.viewNodeFactory.build(uuid, (Object)model2);
                graph.addNode(node);
                return graph;
            }
            Object object = model = this.testScopeModelFactory.accepts(id) ? this.testScopeModelFactory.build(id) : null;
            if (null != model) {
                Class element = RuntimeDefinitionAdapter.getGraphFactory(model.getClass());
                if (element.isAssignableFrom(NodeFactory.class)) {
                    Node node = (Node)this.viewNodeFactory.build(uuid, model);
                    return node;
                }
                if (element.isAssignableFrom(EdgeFactory.class)) {
                    Edge edge = (Edge)this.connectionEdgeFactory.build(uuid, model);
                    return edge;
                }
            }
            return null;
        }).when((Object)this.applicationFactoryManager)).newElement(Matchers.anyString(), Matchers.anyString());
        ((ApplicationFactoryManager)Mockito.doAnswer(invocationOnMock -> {
            Object model;
            String uuid = (String)invocationOnMock.getArguments()[0];
            Class type = (Class)invocationOnMock.getArguments()[1];
            String id = BindableAdapterUtils.getGenericClassName((Class)type);
            if (DMNDefinitionSet.class.equals((Object)type)) {
                Graph graph = (Graph)this.dmnGraphFactory.build(uuid, (Object)DMN_DEF_SET_ID);
                return graph;
            }
            Object object = model = this.testScopeModelFactory.accepts(id) ? this.testScopeModelFactory.build(id) : null;
            if (null != model) {
                Class element = RuntimeDefinitionAdapter.getGraphFactory(model.getClass());
                if (element.isAssignableFrom(NodeFactory.class)) {
                    Node node = (Node)this.viewNodeFactory.build(uuid, model);
                    return node;
                }
                if (element.isAssignableFrom(EdgeFactory.class)) {
                    Edge edge = (Edge)this.connectionEdgeFactory.build(uuid, model);
                    return edge;
                }
            }
            return null;
        }).when((Object)this.applicationFactoryManager)).newElement(Matchers.anyString(), (Class)Matchers.any(Class.class));
        ((ApplicationFactoryManager)Mockito.doAnswer(invocationOnMock -> {
            String uuid = (String)invocationOnMock.getArguments()[0];
            String defSetId = (String)invocationOnMock.getArguments()[1];
            Graph graph = (Graph)this.applicationFactoryManager.newElement(uuid, defSetId);
            DiagramImpl result = new DiagramImpl(uuid, (Metadata)new MetadataImpl.MetadataImplBuilder(defSetId).build());
            result.setGraph(graph);
            return result;
        }).when((Object)this.applicationFactoryManager)).newDiagram(Matchers.anyString(), Matchers.anyString(), (Metadata)Matchers.any(Metadata.class));
        MappingContextSingleton.loadDynamicMarshallers();
    }

    @Test
    public void test_diamond() throws IOException {
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/diamond.dmn"), this::checkDiamongGraph);
        DMNMarshaller m = new DMNMarshaller(new XMLEncoderDiagramMetadataMarshaller(), (FactoryManager)this.applicationFactoryManager);
        Graph g = m.unmarshall(null, this.getClass().getResourceAsStream("/diamond.dmn"));
        DiagramImpl diagram = new DiagramImpl("", null);
        diagram.setGraph(g);
        String mString = m.marshall((Diagram)diagram);
        KieServices ks = KieServices.Factory.get();
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", "dmn-test_diamond", "1.0"), (Resource[])new Resource[]{ks.getResources().newByteArrayResource(mString.getBytes()).setTargetPath("src/main/resources/diamond.dmn")});
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        Assert.assertNotNull((Object)runtime);
        DMNModel diamondModel = runtime.getModel("http://www.trisotech.com/definitions/_8afa6c24-55c8-43cf-8a02-fdde7fc5d1f2", "three decisions in a diamond shape");
        DMNContext dmnContext = runtime.newContext();
        dmnContext.set("My Name", (Object)"John Doe");
        DMNResult dmnResult = runtime.evaluateAll(diamondModel, dmnContext);
        Assert.assertFalse((String)dmnResult.getMessages().toString(), (boolean)dmnResult.hasErrors());
        DMNContext result = dmnResult.getContext();
        Assert.assertEquals((Object)"Hello, John Doe.", (Object)result.get("My Decision"));
        org.kie.dmn.api.marshalling.v1_1.DMNMarshaller dmnMarshaller = DMNMarshallerFactory.newMarshallerWithExtensions(Arrays.asList(new DDExtensionsRegister()));
        Definitions definitions = dmnMarshaller.unmarshal(mString);
        Assert.assertNotNull((Object)definitions.getExtensionElements());
        Assert.assertNotNull((Object)definitions.getExtensionElements().getAny());
        Assert.assertEquals((long)1L, (long)definitions.getExtensionElements().getAny().size());
        DMNDiagram ddRoot = (DMNDiagram)definitions.getExtensionElements().getAny().get(0);
        DMNShape myname = this.findShapeByDMNI(ddRoot, "_4cd17e52-6253-41d6-820d-5824bf5197f3");
        DMNMarshallerTest.assertBounds(500.0, 500.0, 100.0, 50.0, myname.getBounds());
        DMNMarshallerTest.assertColor(255, 255, 255, myname.getBgColor());
        DMNMarshallerTest.assertColor(0, 0, 0, myname.getBorderColor());
        Assert.assertEquals((double)0.5, (double)myname.getBorderSize().getValue(), (double)0.0);
        this.assertDMNStyle("Open Sans", 24.0, 1.0, 255, 0, 0, myname.getFontStyle());
        DMNShape prefix = this.findShapeByDMNI(ddRoot, "_e920f38a-293c-41b8-adb3-69d0dc184fab");
        DMNMarshallerTest.assertBounds(300.0, 400.0, 100.0, 50.0, prefix.getBounds());
        DMNMarshallerTest.assertColor(0, 253, 25, prefix.getBgColor());
        DMNMarshallerTest.assertColor(253, 0, 0, prefix.getBorderColor());
        Assert.assertEquals((double)1.0, (double)prefix.getBorderSize().getValue(), (double)0.0);
        this.assertDMNStyle("Times New Roman", 8.0, 2.5, 70, 60, 50, prefix.getFontStyle());
        DMNShape postfix = this.findShapeByDMNI(ddRoot, "_f49f9c34-29d5-4e72-91d2-f4f92117c8da");
        DMNMarshallerTest.assertBounds(700.0, 400.0, 100.0, 50.0, postfix.getBounds());
        DMNMarshallerTest.assertColor(247, 255, 0, postfix.getBgColor());
        DMNMarshallerTest.assertColor(0, 51, 255, postfix.getBorderColor());
        Assert.assertEquals((double)2.0, (double)postfix.getBorderSize().getValue(), (double)0.0);
        this.assertDMNStyle("Arial", 10.0, 1.5, 50, 60, 70, postfix.getFontStyle());
        DMNShape mydecision = this.findShapeByDMNI(ddRoot, "_9b061fc3-8109-42e2-9fe4-fc39c90b654e");
        DMNMarshallerTest.assertBounds(487.5, 275.0, 125.0, 75.0, mydecision.getBounds());
        DMNMarshallerTest.assertColor(255, 255, 255, mydecision.getBgColor());
        DMNMarshallerTest.assertColor(0, 0, 0, mydecision.getBorderColor());
        Assert.assertEquals((double)0.5, (double)mydecision.getBorderSize().getValue(), (double)0.0);
        this.assertDMNStyle("Monospaced", 32.0, 3.5, 55, 66, 77, mydecision.getFontStyle());
    }

    private void assertDMNStyle(String fontName, double fontSize, double fontBorderSize, int r, int g, int b, DMNStyle style) {
        Assert.assertEquals((Object)fontName, (Object)style.getFontName());
        Assert.assertEquals((double)fontSize, (double)style.getFontSize(), (double)0.0);
        Assert.assertEquals((double)fontBorderSize, (double)style.getFontBorderSize(), (double)0.0);
        DMNMarshallerTest.assertColor(r, g, b, style.getFontColor());
    }

    private static void assertBounds(double x, double y, double width, double height, Bounds bounds) {
        Assert.assertEquals((double)x, (double)bounds.getX(), (double)0.0);
        Assert.assertEquals((double)y, (double)bounds.getY(), (double)0.0);
        Assert.assertEquals((double)width, (double)bounds.getWidth(), (double)0.0);
        Assert.assertEquals((double)height, (double)bounds.getHeight(), (double)0.0);
    }

    private static void assertColor(int r, int g, int b, Color color) {
        Assert.assertEquals((long)r, (long)color.getRed());
        Assert.assertEquals((long)g, (long)color.getGreen());
        Assert.assertEquals((long)b, (long)color.getBlue());
    }

    private DMNShape findShapeByDMNI(DMNDiagram root, String id) {
        return root.getAny().stream().filter(shape -> shape.getDmnElementRef().equals(id)).findFirst().get();
    }

    @Test
    public void test_potpourri_drawing() throws IOException {
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/potpourri_drawing.dmn"), this::checkPotpourryGraph);
    }

    @Test
    public void testAssociations() throws IOException {
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/associations.dmn"), this::checkAssociationsGraph);
    }

    @Test
    public void testTextAnnotation() throws Exception {
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/textAnnotation.dmn"), this::checkTextAnnotationGraph);
    }

    @Test
    public void testTextAnnotationWithCDATA() throws Exception {
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/textAnnotationCDATA.dmn"), this::checkTextAnnotationGraph);
    }

    private void checkTextAnnotationGraph(Graph<?, Node<?, ?>> graph) {
        Node textAnnotation = graph.getNode("60915990-9E1D-42DF-B7F6-0D28383BE9D1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(textAnnotation, TextAnnotation.class);
        TextAnnotation textAnnotationDefinition = (TextAnnotation)((View)textAnnotation.getContent()).getDefinition();
        Assert.assertEquals((Object)"\u63cf\u8ff0", (Object)textAnnotationDefinition.getDescription().getValue());
        Assert.assertEquals((Object)"<b>This Annotation holds some Long text and also UTF-8 characters</b>", (Object)textAnnotationDefinition.getText().getValue());
        Assert.assertEquals((Object)"text/html", (Object)textAnnotationDefinition.getTextFormat().getValue());
    }

    public void testTreeStructure() throws IOException {
        this.roundTripUnmarshalThenMarshalUnmarshal(this.getClass().getResourceAsStream("/treeStructure.dmn"), this::checkTreeStructureGraph);
    }

    public void roundTripUnmarshalThenMarshalUnmarshal(InputStream dmnXmlInputStream, Consumer<Graph<?, Node<?, ?>>> checkGraphConsumer) throws IOException {
        DMNMarshaller m = new DMNMarshaller(new XMLEncoderDiagramMetadataMarshaller(), (FactoryManager)this.applicationFactoryManager);
        Graph g = m.unmarshall(null, dmnXmlInputStream);
        checkGraphConsumer.accept(g);
        DiagramImpl diagram = new DiagramImpl("", null);
        diagram.setGraph(g);
        String mString = m.marshall((Diagram)diagram);
        System.out.println(mString);
        Graph g2 = m.unmarshall(null, (InputStream)new StringInputStream(mString));
        checkGraphConsumer.accept(g2);
    }

    private void checkTreeStructureGraph(Graph<?, Node<?, ?>> graph) {
        Node root = graph.getNode("BBF2B56F-A0AF-4428-AA6A-61A655D72883");
        Node decisionOne = graph.getNode("B7DD0DC9-7FAC-4510-9031-FFEE067CC2F5");
        Node decisionTwo = graph.getNode("DF84B353-A2F6-46B9-B680-EBD98F5084C8");
        Node decisionThree = graph.getNode("1B6EF5EB-CA09-45A5-AB03-21CD70F941AD");
        Node bkmRoot = graph.getNode("AD910446-56AD-49A5-99CE-F7B9C6F74E5E");
        Node bkmOne = graph.getNode("C1D0937E-96F4-4EAF-8A85-45B129F38E9B");
        Node bkmTwo = graph.getNode("47E47E51-4509-4A3B-86E9-D690F397B69C");
        Node annotation = graph.getNode("47C5A244-EF6D-473D-99B6-629F70A49FCC");
        Node knowledgeSource = graph.getNode("CFE44FA9-7309-4F28-81E9-5C1EF455B4C2");
        Node knowledgeSourceInput = graph.getNode("BC0D715A-ADD4-4136-AB3D-226EABC840A2");
        Node decisionOneInput = graph.getNode("CF65CEB9-433F-402F-A485-90AC34E2FE39");
        DMNMarshallerTest.assertNodeEdgesTo(decisionOne, root, InformationRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(decisionTwo, decisionOne, InformationRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(decisionThree, decisionOne, InformationRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(bkmRoot, annotation, Association.class);
        DMNMarshallerTest.assertNodeEdgesTo(bkmRoot, decisionOne, KnowledgeRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(bkmOne, bkmRoot, KnowledgeRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(bkmTwo, bkmRoot, KnowledgeRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(decisionOneInput, decisionOne, InformationRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(knowledgeSource, decisionOne, AuthorityRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(knowledgeSourceInput, knowledgeSource, AuthorityRequirement.class);
    }

    private void checkDiamongGraph(Graph<?, Node<?, ?>> g) {
        Node idNode = g.getNode("_4cd17e52-6253-41d6-820d-5824bf5197f3");
        DMNMarshallerTest.assertNodeContentDefinitionIs(idNode, InputData.class);
        DMNMarshallerTest.assertNodeEdgesTo(idNode, g.getNode("_e920f38a-293c-41b8-adb3-69d0dc184fab"), InformationRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(idNode, g.getNode("_f49f9c34-29d5-4e72-91d2-f4f92117c8da"), InformationRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(idNode, g.getNode("_9b061fc3-8109-42e2-9fe4-fc39c90b654e"), InformationRequirement.class);
        Node prefixDecisionNode = g.getNode("_e920f38a-293c-41b8-adb3-69d0dc184fab");
        DMNMarshallerTest.assertNodeContentDefinitionIs(prefixDecisionNode, Decision.class);
        DMNMarshallerTest.assertNodeEdgesTo(prefixDecisionNode, g.getNode("_9b061fc3-8109-42e2-9fe4-fc39c90b654e"), InformationRequirement.class);
        Node postfixDecisionNode = g.getNode("_f49f9c34-29d5-4e72-91d2-f4f92117c8da");
        DMNMarshallerTest.assertNodeContentDefinitionIs(postfixDecisionNode, Decision.class);
        DMNMarshallerTest.assertNodeEdgesTo(postfixDecisionNode, g.getNode("_9b061fc3-8109-42e2-9fe4-fc39c90b654e"), InformationRequirement.class);
        Node myDecisionNode = g.getNode("_9b061fc3-8109-42e2-9fe4-fc39c90b654e");
        DMNMarshallerTest.assertNodeContentDefinitionIs(myDecisionNode, Decision.class);
        Node rootNode = DMNMarshaller.findDMNDiagramRoot(g);
        Assert.assertNotNull((Object)rootNode);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, idNode);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, prefixDecisionNode);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, postfixDecisionNode);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, myDecisionNode);
    }

    private void checkAssociationsGraph(Graph<?, Node<?, ?>> g) {
        Node inputData = g.getNode("BD168F8B-4398-4478-8BEA-E67AA5F90FAF");
        DMNMarshallerTest.assertNodeContentDefinitionIs(inputData, InputData.class);
        Node decision = g.getNode("A960E2D2-FBC1-4D11-AA33-064F6A0B5CB9");
        DMNMarshallerTest.assertNodeContentDefinitionIs(decision, Decision.class);
        Node knowledgeSource = g.getNode("FB99ED65-BC43-4750-999F-7FE24690845B");
        DMNMarshallerTest.assertNodeContentDefinitionIs(knowledgeSource, KnowledgeSource.class);
        Node bkm = g.getNode("2F07453C-854F-436F-8378-4CFCE63BB124");
        DMNMarshallerTest.assertNodeContentDefinitionIs(bkm, BusinessKnowledgeModel.class);
        Node textAnnotation = g.getNode("7F4B8130-6F3D-4A16-9F6C-01D01DA481D2");
        DMNMarshallerTest.assertNodeContentDefinitionIs(textAnnotation, TextAnnotation.class);
        Edge<?, ?> fromInput = DMNMarshallerTest.assertNodeEdgesTo(inputData, textAnnotation, Association.class);
        Assert.assertEquals((Object)"From Input", (Object)((Association)((View)fromInput.getContent()).getDefinition()).getDescription().getValue());
        Edge<?, ?> fromDecision = DMNMarshallerTest.assertNodeEdgesTo(decision, textAnnotation, Association.class);
        Assert.assertEquals((Object)"From Decision", (Object)((Association)((View)fromDecision.getContent()).getDefinition()).getDescription().getValue());
        Edge<?, ?> fromBkm = DMNMarshallerTest.assertNodeEdgesTo(bkm, textAnnotation, Association.class);
        Assert.assertEquals((Object)"From BKM", (Object)((Association)((View)fromBkm.getContent()).getDefinition()).getDescription().getValue());
        Edge<?, ?> fromKnowledgeSource = DMNMarshallerTest.assertNodeEdgesTo(knowledgeSource, textAnnotation, Association.class);
        Assert.assertEquals((Object)"From Knowledge Source", (Object)((Association)((View)fromKnowledgeSource.getContent()).getDefinition()).getDescription().getValue());
    }

    private void checkPotpourryGraph(Graph<?, Node<?, ?>> g) {
        Node _My_Input_Data = g.getNode("_My_Input_Data");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_My_Input_Data, InputData.class);
        DMNMarshallerTest.assertNodeEdgesTo(_My_Input_Data, g.getNode("_My_Decision_1"), InformationRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(_My_Input_Data, g.getNode("_KS_of_Input_Data"), AuthorityRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(_My_Input_Data, g.getNode("_Annotation_for_Input_Data"), Association.class);
        Node _Annotation_for_Input_Data = g.getNode("_Annotation_for_Input_Data");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_Annotation_for_Input_Data, TextAnnotation.class);
        Node _KS_of_Input_Data = g.getNode("_KS_of_Input_Data");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_Input_Data, KnowledgeSource.class);
        Node _KS_of_KS_of_InputData = g.getNode("_KS_of_KS_of_InputData");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_KS_of_InputData, KnowledgeSource.class);
        DMNMarshallerTest.assertNodeEdgesTo(_KS_of_KS_of_InputData, g.getNode("_KS_of_Input_Data"), AuthorityRequirement.class);
        Node _KS_of_KS_of_Decision_1 = g.getNode("_KS_of_KS_of_Decision_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_KS_of_Decision_1, KnowledgeSource.class);
        DMNMarshallerTest.assertNodeEdgesTo(_KS_of_KS_of_Decision_1, g.getNode("_KS_of_Decision_1"), AuthorityRequirement.class);
        Node _KS_of_Decision_1 = g.getNode("_KS_of_Decision_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_Decision_1, KnowledgeSource.class);
        DMNMarshallerTest.assertNodeEdgesTo(_KS_of_Decision_1, g.getNode("_My_Decision_1"), AuthorityRequirement.class);
        Node _My_Decision_2 = g.getNode("_My_Decision_2");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_My_Decision_2, Decision.class);
        DMNMarshallerTest.assertNodeEdgesTo(_My_Decision_2, g.getNode("_KS_of_Decision_2"), AuthorityRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(_My_Decision_2, g.getNode("_Annotation_for_Decision_2"), Association.class);
        Node _KS_of_Decision_2 = g.getNode("_KS_of_Decision_2");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_Decision_2, KnowledgeSource.class);
        Node _Annotation_for_Decision_2 = g.getNode("_Annotation_for_Decision_2");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_Annotation_for_Decision_2, TextAnnotation.class);
        Node _Annotation_for_BKM_1 = g.getNode("_Annotation_for_BKM_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_Annotation_for_BKM_1, TextAnnotation.class);
        DMNMarshallerTest.assertNodeEdgesTo(_Annotation_for_BKM_1, g.getNode("_My_BKM_1_of_Decision_1"), Association.class);
        Node _My_BKM_1_of_Decision_1 = g.getNode("_My_BKM_1_of_Decision_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_My_BKM_1_of_Decision_1, BusinessKnowledgeModel.class);
        DMNMarshallerTest.assertNodeEdgesTo(_My_BKM_1_of_Decision_1, g.getNode("_My_Decision_1"), KnowledgeRequirement.class);
        Node _KS_of_BKM_1 = g.getNode("_KS_of_BKM_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_BKM_1, KnowledgeSource.class);
        DMNMarshallerTest.assertNodeEdgesTo(_KS_of_BKM_1, g.getNode("_My_BKM_1_of_Decision_1"), AuthorityRequirement.class);
        Node _KS_of_KS_of_BKM_1 = g.getNode("_KS_of_KS_of_BKM_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_KS_of_BKM_1, KnowledgeSource.class);
        DMNMarshallerTest.assertNodeEdgesTo(_KS_of_KS_of_BKM_1, g.getNode("_KS_of_BKM_1"), AuthorityRequirement.class);
        Node _My_BKM_2_of_BKM_1 = g.getNode("_My_BKM_2_of_BKM_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_My_BKM_2_of_BKM_1, BusinessKnowledgeModel.class);
        DMNMarshallerTest.assertNodeEdgesTo(_My_BKM_2_of_BKM_1, g.getNode("_My_BKM_1_of_Decision_1"), KnowledgeRequirement.class);
        Node _KS_of_BKM_2 = g.getNode("_KS_of_BKM_2");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_KS_of_BKM_2, KnowledgeSource.class);
        DMNMarshallerTest.assertNodeEdgesTo(_KS_of_BKM_2, g.getNode("_My_BKM_2_of_BKM_1"), AuthorityRequirement.class);
        DMNMarshallerTest.assertNodeEdgesTo(_KS_of_BKM_2, g.getNode("_Annotation_for_KS_of_BKM_2"), Association.class);
        Node _Annotation_for_KS_of_BKM_2 = g.getNode("_Annotation_for_KS_of_BKM_2");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_Annotation_for_KS_of_BKM_2, TextAnnotation.class);
        Node _My_Decision_1 = g.getNode("_My_Decision_1");
        DMNMarshallerTest.assertNodeContentDefinitionIs(_My_Decision_1, Decision.class);
        Node rootNode = DMNMarshaller.findDMNDiagramRoot(g);
        Assert.assertNotNull((Object)rootNode);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _My_Input_Data);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _Annotation_for_Input_Data);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_Input_Data);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_KS_of_InputData);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_KS_of_Decision_1);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_Decision_1);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _My_Decision_2);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_Decision_2);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _Annotation_for_Decision_2);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _Annotation_for_BKM_1);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _My_BKM_1_of_Decision_1);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_BKM_1);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_KS_of_BKM_1);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _My_BKM_2_of_BKM_1);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _KS_of_BKM_2);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _Annotation_for_KS_of_BKM_2);
        DMNMarshallerTest.assertRootNodeConnectedTo(rootNode, _My_Decision_1);
    }

    private static void assertRootNodeConnectedTo(Node<?, ?> rootNode, Node<?, ?> to) {
        List outEdges = rootNode.getOutEdges();
        Optional<Edge> optEdge = outEdges.stream().filter(e -> e.getTargetNode().equals(to)).findFirst();
        Assert.assertTrue((boolean)optEdge.isPresent());
        Edge edge = optEdge.get();
        Assert.assertTrue((boolean)(edge.getContent() instanceof Child));
        Assert.assertTrue((boolean)to.getInEdges().contains(edge));
    }

    private static Edge<?, ?> assertNodeEdgesTo(Node<?, ?> from, Node<?, ?> to, Class<?> clazz) {
        List outEdges = from.getOutEdges();
        Optional<Edge> optEdge = outEdges.stream().filter(e -> e.getTargetNode().equals(to)).findFirst();
        Assert.assertTrue((boolean)optEdge.isPresent());
        Edge edge = optEdge.get();
        Assert.assertTrue((boolean)(edge.getContent() instanceof View));
        Assert.assertTrue((boolean)clazz.isInstance(((View)edge.getContent()).getDefinition()));
        Assert.assertTrue((boolean)to.getInEdges().contains(edge));
        ViewConnector connectionContent = (ViewConnector)edge.getContent();
        Assert.assertTrue((boolean)connectionContent.getSourceConnection().isPresent());
        Assert.assertTrue((boolean)connectionContent.getTargetConnection().isPresent());
        return edge;
    }

    private static void assertNodeContentDefinitionIs(Node<?, ?> node, Class<?> clazz) {
        Assert.assertTrue((boolean)(node.getContent() instanceof View));
        Assert.assertTrue((boolean)clazz.isInstance(((View)node.getContent()).getDefinition()));
    }

    @Test
    public void test_Simple_structured_context() throws IOException {
        DMNRuntime runtime = this.roundTripUnmarshalMarshalThenUnmarshalDMN(this.getClass().getResourceAsStream("/Simple_structured_context.dmn"));
        DMNModel dmnModel = (DMNModel)runtime.getModels().get(0);
        DMNContext dmnContext = runtime.newContext();
        dmnContext.set("Input Name", (Object)"John Doe");
        DMNResult dmnResult = runtime.evaluateAll(dmnModel, dmnContext);
        Assert.assertFalse((String)dmnResult.getMessages().toString(), (boolean)dmnResult.hasErrors());
        DMNContext result = dmnResult.getContext();
        Assert.assertEquals((Object)"Hello, John Doe!", (Object)result.get("Decision Logic 1"));
    }

    private DMNRuntime roundTripUnmarshalMarshalThenUnmarshalDMN(InputStream dmnXmlInputStream) throws IOException {
        DMNMarshaller m = new DMNMarshaller(new XMLEncoderDiagramMetadataMarshaller(), (FactoryManager)this.applicationFactoryManager);
        Graph g = m.unmarshall(null, dmnXmlInputStream);
        DiagramImpl diagram = new DiagramImpl("", null);
        diagram.setGraph(g);
        String mString = m.marshall((Diagram)diagram);
        System.out.println(mString);
        KieServices ks = KieServices.Factory.get();
        String uuid = UUID.uuid((int)8);
        KieContainer kieContainer = KieHelper.getKieContainer((ReleaseId)ks.newReleaseId("org.kie", uuid, "1.0"), (Resource[])new Resource[]{ks.getResources().newByteArrayResource(mString.getBytes()).setTargetPath("src/main/resources/" + uuid + ".dmn")});
        DMNRuntime runtime = (DMNRuntime)kieContainer.newKieSession().getKieRuntime(DMNRuntime.class);
        Assert.assertNotNull((Object)runtime);
        Assert.assertFalse((boolean)runtime.getModels().isEmpty());
        return runtime;
    }
}

