/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.common;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLIncludedModel;
import org.kie.workbench.common.dmn.api.marshalling.DMNPathsHelper;
import org.kie.workbench.common.dmn.backend.editors.common.PMMLIncludedDocumentFactory;
import org.kie.workbench.common.dmn.backend.editors.common.PMMLIncludedDocumentsFilter;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class PMMLIncludedDocumentsFilterTest {
    private static final String NAME = "name";
    private static final String PACKAGE = "package";
    private static final String IMPORT_PATH = "path";
    private static final Integer MODEL_COUNT = 1;
    @Mock
    private DMNPathsHelper pathsHelper;
    @Mock
    private PMMLIncludedDocumentFactory pmmlDocumentFactory;
    @Mock
    private Path dmnModelPath;
    @Mock
    private Path includedModelPath;
    @Mock
    private PMMLDocumentMetadata pmmlDocumentMetadata;
    private List<PMMLIncludedModel> includedModels;
    private PMMLIncludedDocumentsFilter filter;

    @Before
    public void setup() {
        this.filter = new PMMLIncludedDocumentsFilter(this.pathsHelper, this.pmmlDocumentFactory);
        this.includedModels = new ArrayList<PMMLIncludedModel>();
        Mockito.when((Object)this.pmmlDocumentFactory.getDocumentByPath((Path)ArgumentMatchers.eq((Object)this.includedModelPath), (PMMLIncludedModel)ArgumentMatchers.any(PMMLIncludedModel.class))).thenReturn((Object)this.pmmlDocumentMetadata);
    }

    @Test
    public void testGetDocumentFromImportsWithNoImports() {
        Assertions.assertThat((Object)this.filter.getDocumentFromImports(this.dmnModelPath, this.includedModelPath, this.includedModels)).isNull();
    }

    @Test
    public void testGetDocumentFromImportsWithImportsFileIsNotImported() {
        this.includedModels.add(new PMMLIncludedModel(NAME, PACKAGE, IMPORT_PATH, DMNImportTypes.DMN.getDefaultNamespace(), MODEL_COUNT));
        Mockito.when((Object)this.pathsHelper.getRelativeURI(this.dmnModelPath, this.includedModelPath)).thenReturn((Object)"includedModelPath");
        Assertions.assertThat((Object)this.filter.getDocumentFromImports(this.dmnModelPath, this.includedModelPath, this.includedModels)).isNull();
    }

    @Test
    public void testGetDocumentFromImportsWithImportsFileIsImported() {
        this.includedModels.add(new PMMLIncludedModel(NAME, PACKAGE, IMPORT_PATH, DMNImportTypes.DMN.getDefaultNamespace(), MODEL_COUNT));
        Mockito.when((Object)this.pathsHelper.getRelativeURI(this.dmnModelPath, this.includedModelPath)).thenReturn((Object)IMPORT_PATH);
        Assertions.assertThat((Object)this.filter.getDocumentFromImports(this.dmnModelPath, this.includedModelPath, this.includedModels)).isEqualTo((Object)this.pmmlDocumentMetadata);
    }
}

