/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.Import;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.backend.definition.v1_1.HrefBuilder;
import org.mockito.Mockito;

public class HrefBuilderTest {
    @Test
    public void testGetHref() {
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        Name name = (Name)Mockito.mock(Name.class);
        Id id = (Id)Mockito.mock(Id.class);
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        String uuid = "0000-1111-2222";
        Mockito.when((Object)id.getValue()).thenReturn((Object)"0000-1111-2222");
        Mockito.when((Object)name.getValue()).thenReturn((Object)"Decision");
        Mockito.when((Object)drgElement.getId()).thenReturn((Object)id);
        Mockito.when((Object)drgElement.getName()).thenReturn((Object)name);
        Mockito.when((Object)drgElement.getParent()).thenReturn((Object)definitions);
        Mockito.when((Object)definitions.getImport()).thenReturn(Collections.emptyList());
        String actual = HrefBuilder.getHref((DRGElement)drgElement);
        String expected = "#0000-1111-2222";
        Assert.assertEquals((Object)"#0000-1111-2222", (Object)actual);
    }

    @Test
    public void testGetHrefForImportedDRGElement() {
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        Name drgElementName = (Name)Mockito.mock(Name.class);
        Name importName = (Name)Mockito.mock(Name.class);
        Id id = (Id)Mockito.mock(Id.class);
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        Import anImport = (Import)Mockito.mock(Import.class);
        List<Import> imports = Collections.singletonList(anImport);
        String includedModelName = "includedModel";
        Mockito.when((Object)importName.getValue()).thenReturn((Object)"includedModel");
        Mockito.when((Object)anImport.getName()).thenReturn((Object)importName);
        Mockito.when((Object)anImport.getNamespace()).thenReturn((Object)"https://github.com/kiegroup/dmn/something");
        Mockito.when((Object)id.getValue()).thenReturn((Object)"0000-1111-2222");
        Mockito.when((Object)drgElementName.getValue()).thenReturn((Object)"includedModel.Decision");
        Mockito.when((Object)drgElement.getId()).thenReturn((Object)id);
        Mockito.when((Object)drgElement.getName()).thenReturn((Object)drgElementName);
        Mockito.when((Object)drgElement.getParent()).thenReturn((Object)definitions);
        Mockito.when((Object)definitions.getImport()).thenReturn(imports);
        String actual = HrefBuilder.getHref((DRGElement)drgElement);
        String expected = "https://github.com/kiegroup/dmn/something#0000-1111-2222";
        Assert.assertEquals((Object)"https://github.com/kiegroup/dmn/something#0000-1111-2222", (Object)actual);
    }

    @Test
    public void testGetHrefForImportedDRGElementWhenImportHasAnOddName() {
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        Name drgElementName = (Name)Mockito.mock(Name.class);
        Name importName = (Name)Mockito.mock(Name.class);
        Id id = (Id)Mockito.mock(Id.class);
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        Import anImport = (Import)Mockito.mock(Import.class);
        List<Import> imports = Collections.singletonList(anImport);
        String includedModelName = "d.i.v.i.";
        Mockito.when((Object)importName.getValue()).thenReturn((Object)"d.i.v.i.");
        Mockito.when((Object)anImport.getName()).thenReturn((Object)importName);
        Mockito.when((Object)anImport.getNamespace()).thenReturn((Object)"https://github.com/kiegroup/dmn/something");
        Mockito.when((Object)id.getValue()).thenReturn((Object)"0000-1111-2222");
        Mockito.when((Object)drgElementName.getValue()).thenReturn((Object)"d.i.v.i..Decision");
        Mockito.when((Object)drgElement.getId()).thenReturn((Object)id);
        Mockito.when((Object)drgElement.getName()).thenReturn((Object)drgElementName);
        Mockito.when((Object)drgElement.getParent()).thenReturn((Object)definitions);
        Mockito.when((Object)definitions.getImport()).thenReturn(imports);
        String actual = HrefBuilder.getHref((DRGElement)drgElement);
        String expected = "https://github.com/kiegroup/dmn/something#0000-1111-2222";
        Assert.assertEquals((Object)"https://github.com/kiegroup/dmn/something#0000-1111-2222", (Object)actual);
    }
}

