/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.common;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.core.pmml.PMMLInfo;
import org.kie.dmn.core.pmml.PMMLModelInfo;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.PMMLModelMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLParameterMetadata;
import org.kie.workbench.common.dmn.backend.editors.common.PMMLIncludedDocumentFactory;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class PMMLIncludedDocumentFactoryTest {
    private static final String URI = "pmmlFileURI";
    private static final String NAMESPACE = DMNImportTypes.PMML.getDefaultNamespace();
    private static final String DOCUMENT_NAME = "pmmlDocument";
    private static final String MODEL_NAME = "pmmlModel";
    private static final String MODEL_CLASS_NAME = "PmmlModelClassName";
    private static final String MODEL_PACKAGE = "pmmlModelPackage";
    private static final String INPUT_FIELD_PREFIX = "input";
    private static final int INPUT_FIELDS_COUNT = 5;
    @Mock
    private IOService ioService;
    private PMMLIncludedDocumentFactory factory;

    @Before
    public void setup() {
        this.factory = (PMMLIncludedDocumentFactory)Mockito.spy((Object)new PMMLIncludedDocumentFactory(this.ioService));
    }

    @Test
    public void testGetDocumentByPathWithKnownPath() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        PMMLInfo<PMMLModelInfo> pmmlInfo = this.makePMMLInfo();
        Mockito.when((Object)path.toURI()).thenReturn((Object)URI);
        ((PMMLIncludedDocumentFactory)Mockito.doReturn(pmmlInfo).when((Object)this.factory)).loadPMMLInfo(path);
        PMMLDocumentMetadata document = this.factory.getDocumentByPath(path);
        Assertions.assertThat((Object)document).isNotNull();
        Assertions.assertThat((String)document.getPath()).isEqualTo(URI);
        Assertions.assertThat((String)document.getImportType()).isEqualTo(NAMESPACE);
        Assertions.assertThat((List)document.getModels()).hasSize(1);
        PMMLModelMetadata model = (PMMLModelMetadata)document.getModels().get(0);
        Assertions.assertThat((String)model.getName()).isEqualTo(MODEL_NAME);
        Assertions.assertThat((Iterable)model.getInputParameters()).hasSize(5);
        ((IterableAssert)Assertions.assertThat((Iterable)model.getInputParameters()).usingElementComparator(Comparator.comparing(PMMLParameterMetadata::getName, Comparator.naturalOrder()))).containsExactlyInAnyOrder((Object[])this.expectedPMMLParameterMetadata());
    }

    @Test
    public void testGetDocumentByPathWithKnownPathWithIncludedModel() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        PMMLInfo<PMMLModelInfo> pmmlInfo = this.makePMMLInfo();
        PMMLIncludedModel includedModel = this.makePMMLIncludedModel();
        Mockito.when((Object)path.toURI()).thenReturn((Object)URI);
        ((PMMLIncludedDocumentFactory)Mockito.doReturn(pmmlInfo).when((Object)this.factory)).loadPMMLInfo(path);
        PMMLDocumentMetadata document = this.factory.getDocumentByPath(path, includedModel);
        Assertions.assertThat((Object)document).isNotNull();
        Assertions.assertThat((String)document.getPath()).isEqualTo(URI);
        Assertions.assertThat((String)document.getImportType()).isEqualTo(NAMESPACE);
        Assertions.assertThat((String)document.getName()).isEqualTo(DOCUMENT_NAME);
        Assertions.assertThat((List)document.getModels()).hasSize(1);
        PMMLModelMetadata model = (PMMLModelMetadata)document.getModels().get(0);
        Assertions.assertThat((String)model.getName()).isEqualTo(MODEL_NAME);
        Assertions.assertThat((Iterable)model.getInputParameters()).hasSize(5);
        ((IterableAssert)Assertions.assertThat((Iterable)model.getInputParameters()).usingElementComparator(Comparator.comparing(PMMLParameterMetadata::getName, Comparator.naturalOrder()))).containsExactlyInAnyOrder((Object[])this.expectedPMMLParameterMetadata());
    }

    @Test
    public void testGetDocumentByPathWithUnknownPath() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        Mockito.when((Object)path.toURI()).thenReturn((Object)URI);
        Mockito.when((Object)this.ioService.newInputStream((Path)ArgumentMatchers.any(), new OpenOption[0])).thenThrow(new Throwable[]{new NoSuchFileException()});
        PMMLDocumentMetadata document = this.factory.getDocumentByPath(path);
        Assertions.assertThat((Object)document).isNotNull();
        Assertions.assertThat((String)document.getPath()).isEqualTo(URI);
        Assertions.assertThat((String)document.getImportType()).isEqualTo(NAMESPACE);
        Assertions.assertThat((List)document.getModels()).isEmpty();
    }

    @Test
    public void testGetDocumentByPathWithUnknownPathWithIncludedModel() {
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        PMMLIncludedModel includedModel = this.makePMMLIncludedModel();
        Mockito.when((Object)path.toURI()).thenReturn((Object)URI);
        Mockito.when((Object)this.ioService.newInputStream((Path)ArgumentMatchers.any(), new OpenOption[0])).thenThrow(new Throwable[]{new NoSuchFileException()});
        PMMLDocumentMetadata document = this.factory.getDocumentByPath(path, includedModel);
        Assertions.assertThat((Object)document).isNotNull();
        Assertions.assertThat((String)document.getPath()).isEqualTo(URI);
        Assertions.assertThat((String)document.getImportType()).isEqualTo(NAMESPACE);
        Assertions.assertThat((String)document.getName()).isEqualTo(DOCUMENT_NAME);
        Assertions.assertThat((List)document.getModels()).isEmpty();
    }

    private PMMLInfo<PMMLModelInfo> makePMMLInfo() {
        return new PMMLInfo(Collections.singletonList(this.makePMMLModelInfo()), new PMMLInfo.PMMLHeaderInfo(NAMESPACE, Collections.emptyMap()));
    }

    private PMMLModelInfo makePMMLModelInfo() {
        return new PMMLModelInfo(MODEL_NAME, MODEL_CLASS_NAME, this.makePMMLModelInputFieldNames(), Collections.emptyList(), Collections.emptyList());
    }

    private Collection<String> makePMMLModelInputFieldNames() {
        return IntStream.range(0, 5).mapToObj(i -> INPUT_FIELD_PREFIX + i).collect(Collectors.toList());
    }

    private PMMLParameterMetadata[] expectedPMMLParameterMetadata() {
        return IntStream.range(0, 5).mapToObj(i -> new PMMLParameterMetadata(INPUT_FIELD_PREFIX + i)).collect(Collectors.toSet()).toArray(new PMMLParameterMetadata[0]);
    }

    private PMMLIncludedModel makePMMLIncludedModel() {
        return new PMMLIncludedModel(DOCUMENT_NAME, MODEL_PACKAGE, URI, NAMESPACE, Integer.valueOf(1));
    }
}

