/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.editors.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.definition.model.Definitions;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.dmn.backend.editors.common.DMNDiagramHelper;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.service.DiagramService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNDiagramHelperTest {
    @Mock
    private DiagramService diagramService;
    @Mock
    private DMNDiagramUtils dmnDiagramUtils;
    @Mock
    private Diagram<Graph, Metadata> diagram;
    @Mock
    private Path path;
    private DMNDiagramHelper helper;

    @Before
    public void setup() {
        this.helper = new DMNDiagramHelper(this.diagramService, this.dmnDiagramUtils);
    }

    @Test
    public void testGetNodes() {
        DRGElement drgElement = (DRGElement)Mockito.mock(DRGElement.class);
        List<DRGElement> expectedNodes = Collections.singletonList(drgElement);
        Mockito.when((Object)this.dmnDiagramUtils.getDRGElements(this.diagram)).thenReturn(expectedNodes);
        List actualNodes = this.helper.getNodes(this.diagram);
        Assert.assertEquals(expectedNodes, (Object)actualNodes);
    }

    @Test
    public void testGetItemDefinitionsByDiagram() {
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        List<ItemDefinition> expectedItemDefinitions = Arrays.asList((ItemDefinition)Mockito.mock(ItemDefinition.class), (ItemDefinition)Mockito.mock(ItemDefinition.class));
        Mockito.when((Object)definitions.getItemDefinition()).thenReturn(expectedItemDefinitions);
        Mockito.when((Object)this.dmnDiagramUtils.getDefinitions(this.diagram)).thenReturn((Object)definitions);
        List actualItemDefinitions = this.helper.getItemDefinitions(this.diagram);
        Assert.assertEquals(expectedItemDefinitions, (Object)actualItemDefinitions);
    }

    @Test
    public void testGetNamespaceByDiagram() {
        String expectedNamespace = "://namespace";
        Mockito.when((Object)this.dmnDiagramUtils.getNamespace(this.diagram)).thenReturn((Object)"://namespace");
        String actualNamespace = this.helper.getNamespace(this.diagram);
        Assert.assertEquals((Object)"://namespace", (Object)actualNamespace);
    }

    @Test
    public void testGetDiagramByPath() {
        Mockito.when((Object)this.diagramService.getDiagramByPath(this.path)).thenReturn(this.diagram);
        Diagram actualDiagram = this.helper.getDiagramByPath(this.path);
        Assert.assertEquals(this.diagram, (Object)actualDiagram);
    }

    @Test
    public void testGetNamespaceByPath() {
        String expectedNamespace = "://namespace";
        Mockito.when((Object)this.dmnDiagramUtils.getNamespace(this.diagram)).thenReturn((Object)"://namespace");
        Mockito.when((Object)this.diagramService.getDiagramByPath(this.path)).thenReturn(this.diagram);
        String actualNamespace = this.helper.getNamespace(this.path);
        Assert.assertEquals((Object)"://namespace", (Object)actualNamespace);
    }
}

