/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.model.api.DMNElement;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.property.dmn.DMNExternalLink;
import org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinks;
import org.kie.workbench.common.dmn.api.property.dmn.DocumentationLinksHolder;
import org.kie.workbench.common.dmn.backend.definition.v1_1.DMNExternalLinksToExtensionElements;
import org.kie.workbench.common.dmn.backend.definition.v1_1.dd.ExternalLink;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNExternalLinksToExtensionElementsTest {
    @Test
    public void testLoadExternalLinksFromExtensionElements() {
        org.kie.dmn.model.api.DRGElement source = (org.kie.dmn.model.api.DRGElement)Mockito.mock(org.kie.dmn.model.api.DRGElement.class);
        DRGElement target = (DRGElement)Mockito.mock(DRGElement.class);
        DMNElement.ExtensionElements extensionElements = (DMNElement.ExtensionElements)Mockito.mock(DMNElement.ExtensionElements.class);
        ArrayList<ExternalLink> externalLinks = new ArrayList<ExternalLink>();
        String linkDescription1 = "l1";
        String url1 = "url1";
        ExternalLink external1 = this.createExternalLinkMock("l1", "url1");
        externalLinks.add(external1);
        String linkDescription2 = "l2";
        String url2 = "url2";
        ExternalLink external2 = this.createExternalLinkMock("l2", "url2");
        externalLinks.add(external2);
        Mockito.when((Object)extensionElements.getAny()).thenReturn(externalLinks);
        Mockito.when((Object)source.getExtensionElements()).thenReturn((Object)extensionElements);
        DocumentationLinksHolder linksHolder = (DocumentationLinksHolder)Mockito.mock(DocumentationLinksHolder.class);
        DocumentationLinks links = new DocumentationLinks();
        Mockito.when((Object)linksHolder.getValue()).thenReturn((Object)links);
        Mockito.when((Object)target.getLinksHolder()).thenReturn((Object)linksHolder);
        DMNExternalLinksToExtensionElements.loadExternalLinksFromExtensionElements((org.kie.dmn.model.api.DRGElement)source, (DRGElement)target);
        Assert.assertEquals((long)2L, (long)links.getLinks().size());
        this.compare((DMNExternalLink)links.getLinks().get(0), "l1", "url1");
        this.compare((DMNExternalLink)links.getLinks().get(1), "l2", "url2");
    }

    private void compare(DMNExternalLink converted, String description, String url) {
        Assert.assertEquals((Object)url, (Object)converted.getUrl());
        Assert.assertEquals((Object)description, (Object)converted.getDescription());
    }

    private ExternalLink createExternalLinkMock(String description, String url) {
        ExternalLink external = (ExternalLink)Mockito.mock(ExternalLink.class);
        Mockito.when((Object)external.getName()).thenReturn((Object)description);
        Mockito.when((Object)external.getUrl()).thenReturn((Object)url);
        return external;
    }

    @Test
    public void testLoadExternalLinksIntoExtensionElements() {
        DRGElement source = (DRGElement)Mockito.mock(DRGElement.class);
        org.kie.dmn.model.api.DRGElement target = (org.kie.dmn.model.api.DRGElement)Mockito.mock(org.kie.dmn.model.api.DRGElement.class);
        DocumentationLinksHolder linksHolder = (DocumentationLinksHolder)Mockito.mock(DocumentationLinksHolder.class);
        Mockito.when((Object)source.getLinksHolder()).thenReturn((Object)linksHolder);
        DocumentationLinks documentationLinks = new DocumentationLinks();
        String url1 = "url1";
        String description1 = "desc1";
        DMNExternalLink link1 = DMNExternalLinksToExtensionElementsTest.createWBExternalLinkMock("desc1", "url1");
        documentationLinks.addLink(link1);
        String url2 = "url2";
        String description2 = "desc2";
        DMNExternalLink link2 = DMNExternalLinksToExtensionElementsTest.createWBExternalLinkMock("desc2", "url2");
        documentationLinks.addLink(link2);
        Mockito.when((Object)linksHolder.getValue()).thenReturn((Object)documentationLinks);
        DMNElement.ExtensionElements extensionElements = (DMNElement.ExtensionElements)Mockito.mock(DMNElement.ExtensionElements.class);
        Mockito.when((Object)target.getExtensionElements()).thenReturn((Object)extensionElements);
        ArrayList externalLinks = new ArrayList();
        Mockito.when((Object)extensionElements.getAny()).thenReturn(externalLinks);
        DMNExternalLinksToExtensionElements.loadExternalLinksIntoExtensionElements((DRGElement)source, (org.kie.dmn.model.api.DRGElement)target);
        Assert.assertEquals((long)2L, (long)externalLinks.size());
        this.compare((ExternalLink)externalLinks.get(0), "desc1", "url1");
        this.compare((ExternalLink)externalLinks.get(1), "desc2", "url2");
    }

    private void compare(ExternalLink converted, String description, String url) {
        Assert.assertEquals((Object)url, (Object)converted.getUrl());
        Assert.assertEquals((Object)description, (Object)converted.getName());
    }

    private static DMNExternalLink createWBExternalLinkMock(String description, String url) {
        DMNExternalLink external = (DMNExternalLink)Mockito.mock(DMNExternalLink.class);
        Mockito.when((Object)external.getDescription()).thenReturn((Object)description);
        Mockito.when((Object)external.getUrl()).thenReturn((Object)url);
        return external;
    }

    @Test
    public void testGetOrCreateExtensionElements() {
        org.kie.dmn.model.api.DRGElement element = (org.kie.dmn.model.api.DRGElement)Mockito.mock(org.kie.dmn.model.api.DRGElement.class);
        DMNElement.ExtensionElements result = DMNExternalLinksToExtensionElements.getOrCreateExtensionElements((org.kie.dmn.model.api.DRGElement)element);
        Assert.assertNotNull((Object)result);
        DMNElement.ExtensionElements existingElements = (DMNElement.ExtensionElements)Mockito.mock(DMNElement.ExtensionElements.class);
        Mockito.when((Object)element.getExtensionElements()).thenReturn((Object)existingElements);
        DMNElement.ExtensionElements actual = DMNExternalLinksToExtensionElements.getOrCreateExtensionElements((org.kie.dmn.model.api.DRGElement)element);
        Assert.assertEquals((Object)actual, (Object)existingElements);
    }
}

