/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.backend.definition.v1_1;

import javax.xml.namespace.QName;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.dmn.model.v1_2.TImportedValues;
import org.kie.dmn.model.v1_2.TLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.ImportedValues;
import org.kie.workbench.common.dmn.api.definition.model.IsLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Description;
import org.kie.workbench.common.dmn.api.property.dmn.ExpressionLanguage;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.Text;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.backend.definition.v1_1.LiteralExpressionPropertyConverter;

public abstract class BaseLiteralExpressionPropertyConverterTest<T extends IsLiteralExpression> {
    private static final String UUID = "uuid";
    private static final String TEXT = "text";
    private static final String DESCRIPTION = "description";
    private static final String LOCAL = "local";
    private static final String IMPORTED_ELEMENT = "imported-element";
    private static final String EXPRESSION_LANGUAGE = "expression-language";

    @Test
    public void testWBFromDMN() {
        TLiteralExpression dmn = new TLiteralExpression();
        QName typeRef = new QName(DMNModelInstrumentedBase.Namespace.KIE.getUri(), LOCAL, DMNModelInstrumentedBase.Namespace.KIE.getPrefix());
        TImportedValues importedValues = new TImportedValues();
        importedValues.setImportedElement(IMPORTED_ELEMENT);
        dmn.setId(UUID);
        dmn.setDescription(DESCRIPTION);
        dmn.setTypeRef(typeRef);
        dmn.setText(TEXT);
        dmn.setImportedValues((org.kie.dmn.model.api.ImportedValues)importedValues);
        T wb = this.convertWBFromDMN((org.kie.dmn.model.api.LiteralExpression)dmn);
        Assertions.assertThat((String)wb.getId().getValue()).isEqualTo(UUID);
        Assertions.assertThat((String)wb.getDescription().getValue()).isEqualTo(DESCRIPTION);
        Assertions.assertThat((String)wb.getTypeRef().getNamespaceURI()).isEqualTo(DMNModelInstrumentedBase.Namespace.KIE.getUri());
        Assertions.assertThat((String)wb.getTypeRef().getLocalPart()).isEqualTo(LOCAL);
        Assertions.assertThat((String)wb.getTypeRef().getPrefix()).isEqualTo(DMNModelInstrumentedBase.Namespace.KIE.getPrefix());
        Assertions.assertThat((String)wb.getText().getValue()).isEqualTo(TEXT);
        Assertions.assertThat((String)wb.getImportedValues().getImportedElement()).isEqualTo(IMPORTED_ELEMENT);
        Assertions.assertThat((Object)wb.getImportedValues().getParent()).isEqualTo(wb);
    }

    @Test
    public void testDMNFromWB() {
        ImportedValues importedValues = new ImportedValues();
        importedValues.setImportedElement(IMPORTED_ELEMENT);
        LiteralExpression wb = new LiteralExpression(new Id(UUID), new Description(DESCRIPTION), BuiltInType.BOOLEAN.asQName(), new Text(TEXT), importedValues, new ExpressionLanguage(EXPRESSION_LANGUAGE));
        org.kie.dmn.model.api.LiteralExpression dmn = LiteralExpressionPropertyConverter.dmnFromWB((IsLiteralExpression)wb);
        Assertions.assertThat((String)dmn.getId()).isEqualTo(UUID);
        Assertions.assertThat((String)dmn.getDescription()).isEqualTo(DESCRIPTION);
        Assertions.assertThat((String)dmn.getTypeRef().getNamespaceURI()).isEmpty();
        Assertions.assertThat((String)dmn.getTypeRef().getLocalPart()).isEqualTo(BuiltInType.BOOLEAN.getName());
        Assertions.assertThat((String)dmn.getText()).isEqualTo(TEXT);
        Assertions.assertThat((Object)dmn.getImportedValues()).isNotNull();
        Assertions.assertThat((String)dmn.getImportedValues().getImportedElement()).isEqualTo(IMPORTED_ELEMENT);
        Assertions.assertThat((String)dmn.getExpressionLanguage()).isEqualTo(EXPRESSION_LANGUAGE);
    }

    protected abstract T convertWBFromDMN(org.kie.dmn.model.api.LiteralExpression var1);
}

