/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.project.client.handlers;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.project.client.handlers.DMNDiagramNewResourceHandler;
import org.kie.workbench.common.dmn.project.client.type.DMNDiagramResourceType;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.project.client.service.ClientProjectDiagramService;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNDiagramNewResourceHandlerTest {
    @Mock
    private DefinitionManager definitionManager;
    @Mock
    private ClientProjectDiagramService projectDiagramServices;
    @Mock
    private BusyIndicatorView indicatorView;
    @Mock
    private DMNDiagramResourceType projectDiagramResourceType;
    @Mock
    private AuthorizationManager authorizationManager;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private User user;
    @Captor
    private ArgumentCaptor<ResourceRef> refArgumentCaptor;
    private DMNDiagramNewResourceHandler handler;

    @Before
    public void setup() {
        this.handler = new DMNDiagramNewResourceHandler(this.definitionManager, this.projectDiagramServices, this.indicatorView, this.projectDiagramResourceType, this.authorizationManager, this.sessionInfo);
        Mockito.when((Object)this.sessionInfo.getIdentity()).thenReturn((Object)this.user);
    }

    @Test
    public void checkCanCreateWhenFeatureDisabled() {
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Matchers.any(ResourceRef.class), (ResourceAction)Matchers.eq((Object)ResourceAction.READ), (User)Matchers.eq((Object)this.user))).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.handler.canCreate());
        this.assertResourceRef();
    }

    @Test
    public void checkCanCreateWhenFeatureEnabled() {
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Matchers.any(ResourceRef.class), (ResourceAction)Matchers.eq((Object)ResourceAction.READ), (User)Matchers.eq((Object)this.user))).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.handler.canCreate());
        this.assertResourceRef();
    }

    private void assertResourceRef() {
        ((AuthorizationManager)Mockito.verify((Object)this.authorizationManager)).authorize((Resource)this.refArgumentCaptor.capture(), (ResourceAction)Matchers.eq((Object)ResourceAction.READ), (User)Matchers.eq((Object)this.user));
        Assert.assertEquals((Object)"DMNDiagramEditor", (Object)((ResourceRef)this.refArgumentCaptor.getValue()).getIdentifier());
        Assert.assertEquals((Object)ActivityResourceType.EDITOR, (Object)((ResourceRef)this.refArgumentCaptor.getValue()).getResourceType());
    }
}

