/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.project.client.service;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModelsService;
import org.kie.workbench.common.dmn.api.editors.included.PMMLIncludedModel;
import org.kie.workbench.common.dmn.api.editors.types.DMNParseService;
import org.kie.workbench.common.dmn.api.editors.types.DMNValidationService;
import org.kie.workbench.common.dmn.api.editors.types.TimeZoneService;
import org.kie.workbench.common.dmn.project.client.service.DMNClientServicesProxyImpl;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNClientServicesProxyImplTest {
    @Mock
    private CallerMock<DMNIncludedModelsService> includedModelsServiceCaller;
    @Mock
    private CallerMock<DMNParseService> parseServiceCaller;
    @Mock
    private CallerMock<DMNValidationService> validationServiceCaller;
    @Mock
    private CallerMock<TimeZoneService> timeZoneServiceCaller;
    @Mock
    private DMNIncludedModelsService includedModelsService;
    @Mock
    private DMNParseService parseService;
    @Mock
    private DMNValidationService validationService;
    @Mock
    private TimeZoneService timeZoneService;
    @Mock
    private WorkspaceProjectContext projectContext;
    @Mock
    private ServiceCallback serviceCallback;
    @Mock
    private WorkspaceProject workspaceProject;
    @Mock
    private Path dmnModelPath;
    @Captor
    private ArgumentCaptor<ClientRuntimeError> clientRuntimeErrorArgumentCaptor;
    private DMNClientServicesProxyImpl clientServicesProxy;

    @Before
    public void setup() {
        this.clientServicesProxy = (DMNClientServicesProxyImpl)Mockito.spy((Object)new DMNClientServicesProxyImpl(this.projectContext, this.includedModelsServiceCaller, this.parseServiceCaller, this.validationServiceCaller, this.timeZoneServiceCaller));
        Mockito.when((Object)this.includedModelsServiceCaller.call((RemoteCallback)Matchers.any(RemoteCallback.class), (ErrorCallback)Matchers.any(ErrorCallback.class))).thenReturn((Object)this.includedModelsService);
        Mockito.when((Object)this.parseServiceCaller.call((RemoteCallback)Matchers.any(RemoteCallback.class), (ErrorCallback)Matchers.any(ErrorCallback.class))).thenReturn((Object)this.parseService);
        Mockito.when((Object)this.validationServiceCaller.call((RemoteCallback)Matchers.any(RemoteCallback.class), (ErrorCallback)Matchers.any(ErrorCallback.class))).thenReturn((Object)this.validationService);
        Mockito.when((Object)this.timeZoneServiceCaller.call((RemoteCallback)Matchers.any(RemoteCallback.class), (ErrorCallback)Matchers.any(ErrorCallback.class))).thenReturn((Object)this.timeZoneService);
    }

    @Test
    public void testLoadModels() {
        Optional<WorkspaceProject> optionalWorkspaceProject = Optional.of(this.workspaceProject);
        Mockito.when((Object)this.projectContext.getActiveWorkspaceProject()).thenReturn(optionalWorkspaceProject);
        this.clientServicesProxy.loadModels(this.dmnModelPath, this.serviceCallback);
        ((DMNIncludedModelsService)Mockito.verify((Object)this.includedModelsService)).loadModels((Path)Matchers.eq((Object)this.dmnModelPath), (WorkspaceProject)Matchers.eq((Object)this.workspaceProject));
    }

    @Test
    public void testLoadNodesFromImports() {
        Optional<WorkspaceProject> optionalWorkspaceProject = Optional.of(this.workspaceProject);
        DMNIncludedModel includedModel1 = (DMNIncludedModel)Mockito.mock(DMNIncludedModel.class);
        DMNIncludedModel includedModel2 = (DMNIncludedModel)Mockito.mock(DMNIncludedModel.class);
        List<DMNIncludedModel> imports = Arrays.asList(includedModel1, includedModel2);
        Mockito.when((Object)this.projectContext.getActiveWorkspaceProject()).thenReturn(optionalWorkspaceProject);
        this.clientServicesProxy.loadNodesFromImports(imports, this.serviceCallback);
        ((DMNIncludedModelsService)Mockito.verify((Object)this.includedModelsService)).loadNodesFromImports(this.workspaceProject, imports);
    }

    @Test
    public void testLoadPMMLDocumentsFromImports() {
        Optional<WorkspaceProject> optionalWorkspaceProject = Optional.of(this.workspaceProject);
        PMMLIncludedModel includedModel1 = (PMMLIncludedModel)Mockito.mock(PMMLIncludedModel.class);
        PMMLIncludedModel includedModel2 = (PMMLIncludedModel)Mockito.mock(PMMLIncludedModel.class);
        List<PMMLIncludedModel> imports = Arrays.asList(includedModel1, includedModel2);
        Mockito.when((Object)this.projectContext.getActiveWorkspaceProject()).thenReturn(optionalWorkspaceProject);
        this.clientServicesProxy.loadPMMLDocumentsFromImports(this.dmnModelPath, imports, this.serviceCallback);
        ((DMNIncludedModelsService)Mockito.verify((Object)this.includedModelsService)).loadPMMLDocumentsFromImports(this.dmnModelPath, this.workspaceProject, imports);
    }

    @Test
    public void testLoadItemDefinitionsByNamespace() {
        Optional<WorkspaceProject> optionalWorkspaceProject = Optional.of(this.workspaceProject);
        String modelName = "model1";
        String namespace = "://namespace1";
        Mockito.when((Object)this.projectContext.getActiveWorkspaceProject()).thenReturn(optionalWorkspaceProject);
        this.clientServicesProxy.loadItemDefinitionsByNamespace("model1", "://namespace1", this.serviceCallback);
        ((DMNIncludedModelsService)Mockito.verify((Object)this.includedModelsService)).loadItemDefinitionsByNamespace(this.workspaceProject, "model1", "://namespace1");
    }

    @Test
    public void testParseFEELList() {
        String source = "source";
        this.clientServicesProxy.parseFEELList("source", this.serviceCallback);
        ((DMNParseService)Mockito.verify((Object)this.parseService)).parseFEELList((String)Matchers.eq((Object)"source"));
    }

    @Test
    public void testParseRangeValue() {
        String source = "source";
        this.clientServicesProxy.parseRangeValue("source", this.serviceCallback);
        ((DMNParseService)Mockito.verify((Object)this.parseService)).parseRangeValue((String)Matchers.eq((Object)"source"));
    }

    @Test
    public void testIsValidVariableName() {
        String source = "source";
        this.clientServicesProxy.isValidVariableName("source", this.serviceCallback);
        ((DMNValidationService)Mockito.verify((Object)this.validationService)).isValidVariableName((String)Matchers.eq((Object)"source"));
    }

    @Test
    public void testGetTimeZones() {
        this.clientServicesProxy.getTimeZones(this.serviceCallback);
        ((TimeZoneService)Mockito.verify((Object)this.timeZoneService)).getTimeZones();
    }

    @Test
    public void testOnError() {
        ((DMNClientServicesProxyImpl)Mockito.doCallRealMethod().when((Object)this.clientServicesProxy)).onError((ServiceCallback)Matchers.any(ServiceCallback.class));
        boolean error = true;
        Throwable throwable = (Throwable)Mockito.mock(Throwable.class);
        ((DMNClientServicesProxyImpl)Mockito.doNothing().when((Object)this.clientServicesProxy)).warn((String)Matchers.any());
        Assert.assertFalse((boolean)this.clientServicesProxy.onError(this.serviceCallback).error((Object)true, throwable));
        ((ServiceCallback)Mockito.verify((Object)this.serviceCallback)).onError((ClientRuntimeError)this.clientRuntimeErrorArgumentCaptor.capture());
        Assert.assertEquals((Object)throwable, (Object)((ClientRuntimeError)this.clientRuntimeErrorArgumentCaptor.getValue()).getRootCause());
    }

    @Test
    public void testOnSuccess() {
        ((DMNClientServicesProxyImpl)Mockito.doCallRealMethod().when((Object)this.clientServicesProxy)).onSuccess((ServiceCallback)Matchers.any(ServiceCallback.class));
        Object result = new Object();
        this.clientServicesProxy.onSuccess(this.serviceCallback).callback(result);
        ((ServiceCallback)Mockito.verify((Object)this.serviceCallback)).onSuccess(Matchers.eq((Object)result));
    }
}

