/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.project.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.toolbar.DMNPerformAutomaticLayoutCommand;
import org.kie.workbench.common.dmn.project.client.editor.DMNEditorMenuItemsBuilder;
import org.kie.workbench.common.dmn.project.client.editor.DMNEditorMenuSessionItems;
import org.kie.workbench.common.dmn.project.client.session.DMNEditorSessionCommands;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNEditorMenuSessionItemsTest {
    @Mock
    private FileMenuBuilder fileMenuBuilder;
    @Mock
    private DMNEditorMenuItemsBuilder builder;
    @Mock
    private DMNEditorSessionCommands sessionCommands;

    @Test
    public void testPopulateMenu() {
        DMNEditorMenuSessionItems menuItems = (DMNEditorMenuSessionItems)Mockito.spy((Object)new DMNEditorMenuSessionItems(this.builder, this.sessionCommands));
        MenuItem menuItem = (MenuItem)Mockito.mock(MenuItem.class);
        ((DMNEditorMenuSessionItems)Mockito.doNothing().when((Object)menuItems)).superPopulateMenu((FileMenuBuilder)Matchers.any());
        ((DMNEditorMenuSessionItems)Mockito.doReturn((Object)menuItem).when((Object)menuItems)).newPerformAutomaticLayout();
        menuItems.populateMenu(this.fileMenuBuilder);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)menuItems)).addPerformAutomaticLayout((FileMenuBuilder)Matchers.any());
    }

    @Test
    public void testEnableMenu() {
        this.testMenu(true);
    }

    @Test
    public void testDisableMenu() {
        this.testMenu(false);
    }

    private void testMenu(boolean enabled) {
        DMNEditorMenuSessionItems menuItems = (DMNEditorMenuSessionItems)Mockito.spy((Object)new DMNEditorMenuSessionItems(this.builder, this.sessionCommands));
        ((DMNEditorMenuSessionItems)Mockito.doNothing().when((Object)menuItems)).superSetEnabled(enabled);
        menuItems.setEnabled(enabled);
        ((DMNEditorMenuSessionItems)Mockito.verify((Object)menuItems)).setItemEnabled(DMNPerformAutomaticLayoutCommand.class, enabled);
    }
}

